/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;

public interface ModelAnalyzer {
    public void analyze(Element var1, TypeElement var2, WebBeansModel var3, AtomicBoolean var4, Result var5);

    public static class Result
    extends CdiAnalysisResult {
        public Result(CompilationInfo info) {
            super(info);
        }

        public void addNotification(Severity severity, Element element, WebBeansModel model, String message) {
            ErrorDescription description = CdiEditorAnalysisFactory.createNotification(severity, element, model, this.getInfo(), message);
            if (description == null) {
                return;
            }
            this.getProblems().add(description);
        }

        public void addNotification(Severity severity, VariableElement element, ExecutableElement method, WebBeansModel model, String message) {
            ErrorDescription description = CdiEditorAnalysisFactory.createNotification(severity, element, method, model, this.getInfo(), message);
            if (description == null) {
                return;
            }
            this.getProblems().add(description);
        }

        public void addError(Element element, WebBeansModel model, String message) {
            this.addNotification(Severity.ERROR, element, model, message);
        }

        public void addError(VariableElement var, ExecutableElement element, WebBeansModel model, String message) {
            this.addNotification(Severity.ERROR, var, element, model, message);
        }

        @Override
        public void addError(Element subject, String message) {
            ErrorDescription description = CdiEditorAnalysisFactory.createNotification(Severity.ERROR, subject, this.getInfo(), message);
            if (description == null) {
                return;
            }
            this.getProblems().add(description);
        }

        public void requireCdiEnabled(Element element, WebBeansModel model) {
            ElementHandle handle = ElementHandle.create((Element)element);
            Element resolved = handle.resolve(this.getInfo());
            if (resolved == null) {
                return;
            }
            this.requireCdiEnabled(resolved);
        }

        public void requireCdiEnabled(VariableElement element, ExecutableElement method, WebBeansModel model) {
            VariableElement resolved = CdiEditorAnalysisFactory.resolveParameter(element, method, this.getInfo());
            if (resolved == null) {
                return;
            }
            this.requireCdiEnabled(resolved);
        }
    }
}

