/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.field.DelegateFieldAnalizer;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;

public abstract class AbstractDecoratorAnalyzer<T> {
    protected void analyzeDecoratedBeans(DependencyInjectionResult res, VariableElement element, T t, TypeElement decorator, WebBeansModel model, ModelAnalyzer.Result result) {
        Element decorated;
        Set<TypeElement> decoratedBeans = null;
        if (res instanceof DependencyInjectionResult.ApplicableResult) {
            DependencyInjectionResult.ApplicableResult appResult = (DependencyInjectionResult.ApplicableResult)res;
            decoratedBeans = appResult.getTypeElements();
        } else if (res instanceof DependencyInjectionResult.InjectableResult && (decorated = ((DependencyInjectionResult.InjectableResult)res).getElement()) instanceof TypeElement) {
            decoratedBeans = Collections.singleton((TypeElement)decorated);
        }
        if (decoratedBeans == null) {
            return;
        }
        for (TypeElement decorated2 : decoratedBeans) {
            Set<Modifier> modifiers = decorated2.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL)) continue;
            this.addClassError(element, t, decorated2, model, result);
            return;
        }
        if (decoratedBeans.isEmpty()) {
            return;
        }
        Collection<TypeMirror> decoratedTypes = DelegateFieldAnalizer.getDecoratedTypes(decorator, (CompilationInfo)model.getCompilationController());
        for (TypeMirror typeMirror : decoratedTypes) {
            Element decoratedTypeElement = model.getCompilationController().getTypes().asElement(typeMirror);
            if (!(decoratedTypeElement instanceof TypeElement)) continue;
            TypeElement iface = (TypeElement)decoratedTypeElement;
            List<ExecutableElement> methods = ElementFilter.methodsIn(iface.getEnclosedElements());
            for (ExecutableElement method : methods) {
                Element decoratorMethod = model.getCompilationController().getElementUtilities().getImplementationOf(method, decorator);
                if (decoratorMethod == null || decoratorMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                for (TypeElement decorated3 : decoratedBeans) {
                    Element decoratedMethod = model.getCompilationController().getElementUtilities().getImplementationOf(method, decorated3);
                    if (decoratedMethod == null || !decoratedMethod.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    this.addMethodError(element, t, decorated3, decoratedMethod, model, result);
                }
            }
        }
    }

    protected abstract void addMethodError(VariableElement var1, T var2, TypeElement var3, Element var4, WebBeansModel var5, ModelAnalyzer.Result var6);

    protected abstract void addClassError(VariableElement var1, T var2, TypeElement var3, WebBeansModel var4, ModelAnalyzer.Result var5);
}

