/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.AbstractAnalysisTask;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.CtorAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.FieldElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodElementAnalyzer;
import org.netbeans.modules.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.ErrorDescription;

public class CdiAnalysisTask
extends AbstractAnalysisTask {
    private static final Map<ElementKind, ElementAnalyzer> ANALIZERS = new HashMap<ElementKind, ElementAnalyzer>();

    protected CdiAnalysisResult createResult(CompilationInfo info) {
        return new CdiAnalysisResult(info);
    }

    @Override
    List<ErrorDescription> getProblems() {
        return this.getResult().getProblems();
    }

    @Override
    protected void run(CompilationInfo compInfo) {
        EditorAnnotationsHelper helper;
        this.setResult(this.createResult(compInfo));
        List types = compInfo.getTopLevelElements();
        for (TypeElement typeElement : types) {
            if (this.isCancelled()) break;
            this.analyzeType(typeElement, null);
        }
        if ((helper = EditorAnnotationsHelper.getInstance(this.getResult())) == null) {
            return;
        }
        helper.publish(this.getResult());
    }

    private void analyzeType(TypeElement typeElement, TypeElement parent) {
        ElementKind kind = typeElement.getKind();
        ElementAnalyzer analyzer = ANALIZERS.get((Object)kind);
        if (analyzer != null) {
            analyzer.analyze(typeElement, parent, this.getCancel(), this.getResult());
        }
        if (this.isCancelled()) {
            return;
        }
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        List<TypeElement> types = ElementFilter.typesIn(enclosedElements);
        for (TypeElement innerType : types) {
            this.analyzeType(innerType, typeElement);
        }
        HashSet<? extends Element> enclosedSet = new HashSet<Element>(enclosedElements);
        enclosedSet.removeAll(types);
        for (Element element : enclosedSet) {
            this.analyze(typeElement, element);
        }
    }

    private void analyze(TypeElement typeElement, Element element) {
        if (this.isCancelled()) {
            return;
        }
        ElementAnalyzer analyzer = ANALIZERS.get((Object)element.getKind());
        if (analyzer == null) {
            return;
        }
        analyzer.analyze(element, typeElement, this.getCancel(), this.getResult());
    }

    static {
        ANALIZERS.put(ElementKind.CLASS, new ClassElementAnalyzer());
        ANALIZERS.put(ElementKind.FIELD, new FieldElementAnalyzer());
        ANALIZERS.put(ElementKind.METHOD, new MethodElementAnalyzer());
        ANALIZERS.put(ElementKind.CONSTRUCTOR, new CtorAnalyzer());
        ANALIZERS.put(ElementKind.ANNOTATION_TYPE, new AnnotationElementAnalyzer());
    }
}

