/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.analysis.BeansXmlFix;
import org.netbeans.modules.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.web.beans.hints.CDIAnnotation;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CdiAnalysisResult {
    static final String BEANS = "beans";
    private static final String BEANS_XML = "beans.xml";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private CompilationInfo myInfo;
    private List<ErrorDescription> myProblems;
    private boolean isCdiRequired;
    private List<CDIAnnotation> myCollectedAnnotations;

    public CdiAnalysisResult(CompilationInfo info) {
        this.myInfo = info;
        this.myProblems = new LinkedList<ErrorDescription>();
        this.myCollectedAnnotations = new LinkedList<CDIAnnotation>();
    }

    public void addError(Element subject, String message) {
        this.addNotification(Severity.ERROR, subject, message);
    }

    public void addError(Element subject, String message, Fix fix) {
        this.addNotification(Severity.ERROR, subject, message, fix);
    }

    public void addNotification(Severity severity, Element element, String message) {
        this.addNotification(severity, element, message, null);
    }

    public void addNotification(Severity severity, Element element, String message, Fix fix) {
        ErrorDescription description = CdiEditorAnalysisFactory.createNotification(severity, element, this.myInfo, message, fix);
        if (description == null) {
            return;
        }
        this.getProblems().add(description);
    }

    public CompilationInfo getInfo() {
        return this.myInfo;
    }

    public List<ErrorDescription> getProblems() {
        return this.myProblems;
    }

    public void requireCdiEnabled(Element element) {
        if (this.isCdiRequired) {
            return;
        }
        this.isCdiRequired = true;
        FileObject fileObject = this.getInfo().getFileObject();
        if (fileObject == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return;
        }
        if (!this.isCdiEnabled(project)) {
            BeansXmlFix fix = new BeansXmlFix(project);
            this.addError(element, NbBundle.getMessage(CdiAnalysisResult.class, (String)"ERR_RequireWebBeans"), fix);
        }
    }

    public void addAnnotation(CDIAnnotation annotation) {
        this.myCollectedAnnotations.add(annotation);
    }

    public List<CDIAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.myCollectedAnnotations);
    }

    protected boolean isCdiEnabled(Project project) {
        FileObject parent = CdiAnalysisResult.getInf(project, false);
        return parent != null && parent.getFileObject(BEANS_XML) != null;
    }

    static FileObject getInf(Project project, boolean create) {
        FileObject parent = CdiAnalysisResult.getBeansTargetFolder(project, create);
        return parent;
    }

    private static FileObject getBeansTargetFolder(Project project, boolean create) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject webInf = wm.getWebInf();
            if (webInf == null && create) {
                try {
                    webInf = FileUtil.createFolder((FileObject)wm.getDocumentBase(), (String)WEB_INF);
                }
                catch (IOException ex) {
                    Logger.getLogger(CdiAnalysisResult.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            return webInf;
        }
        EjbJar[] ejbs = EjbJar.getEjbJars((Project)project);
        if (ejbs.length > 0) {
            return ejbs[0].getMetaInf();
        }
        Car[] cars = Car.getCars((Project)project);
        if (cars.length > 0) {
            return cars[0].getMetaInf();
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length > 0) {
            FileObject metaInf = sourceGroups[0].getRootFolder().getFileObject(META_INF);
            if (metaInf == null && create) {
                try {
                    metaInf = FileUtil.createFolder((FileObject)sourceGroups[0].getRootFolder(), (String)META_INF);
                }
                catch (IOException e) {
                    Logger.getLogger(CdiAnalysisResult.class.getName()).log(Level.WARNING, null, e);
                }
            }
            return metaInf;
        }
        return null;
    }
}

