/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.AbstractAnalysisTask;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

abstract class CancellableAnalysysTask
implements CancellableTask<CompilationInfo> {
    private FileObject myFileObject;
    private AtomicReference<AbstractAnalysisTask> myTask;

    CancellableAnalysysTask(FileObject javaFile) {
        this.myFileObject = javaFile;
        this.myTask = new AtomicReference();
    }

    public void run(CompilationInfo compInfo) throws Exception {
        if (!WebBeansActionHelper.isEnabled()) {
            return;
        }
        AbstractAnalysisTask task = this.createTask();
        this.myTask.set(task);
        task.run(compInfo);
        HintsController.setErrors((FileObject)this.myFileObject, (String)this.getLayerName(), task.getProblems());
    }

    public void cancel() {
        AbstractAnalysisTask task = this.myTask.get();
        if (task != null) {
            task.stop();
        }
    }

    protected abstract String getLayerName();

    protected abstract AbstractAnalysisTask createTask();

    protected FileObject getFileObject() {
        return this.myFileObject;
    }
}

