/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.web.beans.actions.InterceptorPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class InterceptorGenerator
implements CodeGenerator {
    private static final Logger LOG = Logger.getLogger(InterceptorGenerator.class.getName());
    private static final String INTERCEPTOR = "javax.interceptor.Interceptor";
    private String myBindingName;
    private FileObject myBindingFileObject;

    InterceptorGenerator(String bindingName, FileObject bindingFileObject) {
        this.myBindingName = bindingName;
        this.myBindingFileObject = bindingFileObject;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(InterceptorGenerator.class, (String)"LBL_GenerateInterceptor");
    }

    public void invoke() {
        JButton ok = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)ok, (String)NbBundle.getMessage(InterceptorGenerator.class, (String)"LBL_OK"));
        JButton cancel = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancel, (String)NbBundle.getMessage(InterceptorGenerator.class, (String)"LBL_Cancel"));
        InterceptorPanel panel = new InterceptorPanel(ok, this.myBindingName, this.myBindingFileObject);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(InterceptorGenerator.class, (String)"TITLE_Interceptor", (Object)this.myBindingName), true, new Object[]{ok, cancel}, null, 0, new HelpCtx(InterceptorGenerator.class), null);
        descriptor.setClosingOptions(new Object[]{ok, cancel});
        Object closedOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        FileObject targetFolder = this.myBindingFileObject.getParent();
        if (closedOption == ok && targetFolder != null) {
            this.createInterceptor(panel, targetFolder);
        }
    }

    private void createInterceptor(InterceptorPanel panel, FileObject targetFolder) {
        FileObject templateFileObject = FileUtil.getConfigFile((String)"Templates/Classes/Class.java");
        try {
            DataObject templateDataObject = DataObject.find((FileObject)templateFileObject);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
            DataObject createdDataObject = templateDataObject.createFromTemplate(dataFolder, panel.getInterceptorName(), Collections.emptyMap());
            this.modifyClass(createdDataObject.getPrimaryFile(), this.getType(this.myBindingFileObject, ElementKind.ANNOTATION_TYPE));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    private ElementHandle<TypeElement> getType(FileObject fileObject, final ElementKind kind) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final ArrayList result = new ArrayList(1);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.RESOLVED);
                String typeName = controller.getFileObject().getName();
                List topLevelElements = controller.getTopLevelElements();
                for (TypeElement typeElement : topLevelElements) {
                    if (kind != typeElement.getKind() || !typeName.contentEquals(typeElement.getSimpleName())) continue;
                    result.add(ElementHandle.create((Element)typeElement));
                    return;
                }
            }
        }, true);
        return (ElementHandle)result.get(0);
    }

    private void modifyClass(FileObject fileObject, final ElementHandle<TypeElement> handle) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            ModificationResult result = javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker maker = copy.getTreeMaker();
                    ClassTree tree = InterceptorGenerator.getTopLevelClassTree((CompilationController)copy);
                    Element element = copy.getTrees().getElement(copy.getTrees().getPath(copy.getCompilationUnit(), tree));
                    ModifiersTree modifiers = tree.getModifiers();
                    modifiers = this.addAnnotation(InterceptorGenerator.INTERCEPTOR, maker, modifiers);
                    TypeElement annotation = (TypeElement)handle.resolve((CompilationInfo)copy);
                    if (annotation != null) {
                        modifiers = this.addAnnotation(annotation.getQualifiedName().toString(), maker, modifiers);
                    }
                    copy.rewrite((Tree)tree.getModifiers(), (Tree)modifiers);
                    ElementOpen.open((ClasspathInfo)copy.getClasspathInfo(), (Element)element);
                }

                private ModifiersTree addAnnotation(String annotationFqn, TreeMaker maker, ModifiersTree modifiers) {
                    AnnotationTree newAnnotation = maker.Annotation((Tree)maker.QualIdent(annotationFqn), Collections.emptyList());
                    if (modifiers != null) {
                        modifiers = maker.addModifiersAnnotation(modifiers, newAnnotation);
                    }
                    return modifiers;
                }

                public void cancel() {
                }
            });
            result.commit();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    public static ClassTree getTopLevelClassTree(CompilationController controller) {
        String className = controller.getFileObject().getName();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends Tree> decls = cu.getTypeDecls();
            for (Tree tree : decls) {
                ClassTree classTree;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(className) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                return classTree;
            }
        }
        return null;
    }
}

