/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.versioning.DelegatingVCS;
import org.netbeans.modules.versioning.InitMenuItem;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class VersioningMainMenu
extends AbstractAction
implements DynamicMenuContent {
    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        ArrayList<JComponent> items = new ArrayList<JComponent>(20);
        if (!VersioningManager.isInitialized()) {
            items.add(InitMenuItem.create(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_VersioningMenu")));
            items.add(Utils.createJSeparator());
            items.add(InitMenuItem.create(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_LocalHistory")));
        } else {
            VCSContext ctx = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
            List<VersioningSystem> systems = Arrays.asList(VersioningManager.getInstance().getVersioningSystems());
            VersioningSystem[] vs = VersioningManager.getInstance().getOwners(ctx);
            if (vs.length == 1) {
                if (vs[0].getVCSAnnotator() != null) {
                    List<JComponent> systemItems = VersioningMainMenu.actionsToItems(vs[0].getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu));
                    items.addAll(systemItems);
                }
                items.addAll(VersioningMainMenu.actionsToItems(this.appendAdditionalActions(ctx, vs[0], new Action[0])));
                items.add(Utils.createJSeparator());
            } else if (vs.length > 1) {
                JMenuItem dummy = new JMenuItem("<multiple systems>");
                dummy.setEnabled(false);
                items.add(dummy);
                items.add(Utils.createJSeparator());
            }
            Collections.sort(systems, new ByDisplayNameComparator());
            VersioningSystem localHistory = null;
            for (VersioningSystem system : systems) {
                if (Utils.isLocalHistory(system)) {
                    localHistory = system;
                    continue;
                }
                if ("".equals(Utils.getMenuLabel(system))) continue;
                JMenu menu = this.createVersioningSystemMenu(system, true);
                items.add(menu);
            }
            if (localHistory != null) {
                items.add(Utils.createJSeparator());
                items.add(this.createVersioningSystemMenu(localHistory, false));
            }
        }
        return items.toArray(new JComponent[items.size()]);
    }

    private JMenu createVersioningSystemMenu(final VersioningSystem system, final boolean isRegularVCS) {
        final JMenu menu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)Utils.getMenuLabel(system));
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (menu.getItemCount() != 0) {
                    return;
                }
                VCSContext ctx = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
                VersioningMainMenu.this.constructMenu(menu, system, ctx, isRegularVCS);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    private void constructMenu(JMenu menu, VersioningSystem system, VCSContext ctx, boolean isRegularVCS) {
        Action[] actions = null;
        if (system instanceof DelegatingVCS) {
            actions = ((DelegatingVCS)system).getActions(ctx, VCSAnnotator.ActionDestination.MainMenu);
        } else if (system.getVCSAnnotator() != null) {
            actions = system.getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu);
        }
        if (isRegularVCS) {
            actions = this.appendAdditionalActions(ctx, system, actions);
        }
        if (actions != null && actions.length > 0) {
            List<JComponent> systemItems = VersioningMainMenu.actionsToItems(actions);
            for (JComponent systemItem : systemItems) {
                menu.add(systemItem);
            }
        }
    }

    private static List<JComponent> actionsToItems(Action[] actions) {
        ArrayList<JComponent> items = new ArrayList<JComponent>(actions.length);
        for (Action action : actions) {
            if (action == null) {
                items.add(Utils.createJSeparator());
                continue;
            }
            if (action instanceof DynamicMenuContent) {
                DynamicMenuContent dmc = (DynamicMenuContent)action;
                JComponent[] components = dmc.getMenuPresenters();
                items.addAll(Arrays.asList(components));
                continue;
            }
            JMenuItem item = Utils.toMenuItem(action);
            items.add(item);
        }
        return items;
    }

    private Action[] appendAdditionalActions(VCSContext ctx, VersioningSystem system, Action[] actions) {
        File root;
        if (ctx.getRootFiles().size() == 1 && (root = system.getTopmostManagedAncestor(ctx.getRootFiles().iterator().next())) != null) {
            VersioningSystem vs;
            VersioningSystem versioningSystem = vs = system instanceof DelegatingVCS ? ((DelegatingVCS)system).getDelegate() : system;
            if (VersioningConfig.getDefault().isDisconnected(vs, root)) {
                actions = new Action[]{new ConnectAction(vs, root, null)};
            } else {
                actions = actions == null ? new Action[2] : Arrays.copyOf(actions, actions.length + 2);
                actions[actions.length - 2] = null;
                actions[actions.length - 1] = new DisconnectAction(vs, root);
            }
        }
        return actions;
    }

    private static class DisconnectAction
    extends AbstractAction {
        private final File root;
        private final VersioningSystem vs;

        public DisconnectAction(VersioningSystem vs, File root) {
            super(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_DisconnectAction.name"));
            this.vs = vs;
            this.root = root;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(VersioningMainMenu.class, (String)"MSG_ConnectAction.confirmation.text", (Object[])new Object[]{this.root.getName(), Utils.getDisplayName(this.vs)}), NbBundle.getMessage(VersioningMainMenu.class, (String)"LBL_ConnectAction.confirmation.title"), 2, 3);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                VersioningConfig.getDefault().disconnectRepository(this.vs, this.root);
                VersioningManager.getInstance().versionedRootsChanged();
            }
        }
    }

    static class ConnectAction
    extends AbstractAction {
        private final File root;
        private final VersioningSystem vs;

        public ConnectAction(VersioningSystem vs, File root, String name) {
            super(name == null ? NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_ConnectAction.name") : name);
            this.vs = vs;
            this.root = root;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VersioningConfig.getDefault().connectRepository(this.vs, this.root);
            VersioningManager.getInstance().versionedRootsChanged();
        }
    }

    static final class ByDisplayNameComparator
    implements Comparator<VersioningSystem> {
        ByDisplayNameComparator() {
        }

        @Override
        public int compare(VersioningSystem a, VersioningSystem b) {
            return Utils.getDisplayName(a).compareTo(Utils.getDisplayName(b));
        }
    }
}

