/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import com.sun.javadoc.Tag;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.design.javamodel.FaultModel;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.javamodel.ResultModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class Utils {
    public static boolean isEqualTo(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static void populateModel(final FileObject fileObject, final ServiceModel serviceModel) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Object object = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    if (object != null) {
                        Object object22;
                        Object object3;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map;
                        Object object4;
                        TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebService");
                        if (typeElement != null) {
                            boolean element;
                            object4 = object.getAnnotationMirrors();
                            AnnotationMirror annotationMirror = null;
                            map = object4.iterator();
                            while (map.hasNext()) {
                                AnnotationMirror annotationMirror2 = map.next();
                                if (!compilationController.getTypes().isSameType(typeElement.asType(), annotationMirror2.getAnnotationType())) continue;
                                annotationMirror = annotationMirror2;
                                break;
                            }
                            if (annotationMirror == null) {
                                serviceModel.status = 1;
                                return;
                            }
                            map = annotationMirror.getElementValues();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            boolean bl = false;
                            boolean fileObject2 = false;
                            for (ExecutableElement executableElement : map.keySet()) {
                                if (executableElement.getSimpleName().contentEquals("serviceName")) {
                                    serviceModel.serviceName = (String)map.get(executableElement).getValue();
                                    bl3 = true;
                                    continue;
                                }
                                if (executableElement.getSimpleName().contentEquals("name")) {
                                    serviceModel.name = (String)map.get(executableElement).getValue();
                                    bl2 = true;
                                    continue;
                                }
                                if (executableElement.getSimpleName().contentEquals("portName")) {
                                    serviceModel.portName = (String)map.get(executableElement).getValue();
                                    element = true;
                                    continue;
                                }
                                if (executableElement.getSimpleName().contentEquals("targetNamespace")) {
                                    serviceModel.targetNamespace = (String)map.get(executableElement).getValue();
                                    fileObject2 = true;
                                    continue;
                                }
                                if (executableElement.getSimpleName().contentEquals("endpointInterface")) {
                                    serviceModel.endpointInterface = (String)map.get(executableElement).getValue();
                                    continue;
                                }
                                if (!executableElement.getSimpleName().contentEquals("wsdlLocation")) continue;
                                serviceModel.wsdlLocation = (String)map.get(executableElement).getValue();
                            }
                            if (!bl2) {
                                serviceModel.name = fileObject.getName();
                            }
                            if (!element) {
                                serviceModel.portName = serviceModel.getName() + "Port";
                            }
                            if (!bl3) {
                                serviceModel.serviceName = fileObject.getName() + "Service";
                            }
                            if (!fileObject2) {
                                object3 = object.getQualifiedName().toString();
                                int n = object3.lastIndexOf(".");
                                object22 = n >= 0 ? object3.substring(0, n) : "";
                                String string2 = Utils.getPackageReverseOrder((String)object22);
                                serviceModel.targetNamespace = "http://" + string2 + "/";
                            }
                        }
                        object4 = null;
                        if (serviceModel.endpointInterface != null && (object4 = compilationController.getElements().getTypeElement(serviceModel.endpointInterface)) != null) {
                            object = object4;
                        }
                        boolean bl5 = false;
                        map = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                        block2: for (Element element : object.getEnclosedElements()) {
                            ExecutableElement executableElement;
                            if (element.getKind() != ElementKind.METHOD || !(executableElement = (ExecutableElement)element).getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                            object3 = executableElement.getAnnotationMirrors();
                            if (bl5) {
                                for (Object object22 : object3) {
                                    if (!compilationController.getTypes().isSameType(map.asType(), object22.getAnnotationType())) continue;
                                    arrayList.add(executableElement);
                                    continue block2;
                                }
                                continue;
                            }
                            for (Object object22 : object3) {
                                if (!compilationController.getTypes().isSameType(map.asType(), object22.getAnnotationType())) continue;
                                arrayList.clear();
                                bl5 = true;
                                arrayList.add(executableElement);
                                break;
                            }
                            if (bl5) continue;
                            arrayList.add(executableElement);
                        }
                        ArrayList arrayList2 = new ArrayList();
                        if (arrayList.size() == 0) {
                            serviceModel.operations = arrayList2;
                            serviceModel.status = 2;
                            return;
                        }
                        boolean bl = serviceModel.endpointInterface != null;
                        FileObject fileObject3 = null;
                        if (bl) {
                            String string;
                            Object object5;
                            object3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                            FileObject[] fileObjectArray = object3.getRoots();
                            object22 = fileObjectArray;
                            int n = ((FileObject[])object22).length;
                            for (int i = 0; i < n && (fileObject3 = (object5 = object22[i]).getFileObject(string = serviceModel.endpointInterface.replace('.', '/') + ".java")) == null; ++i) {
                            }
                            if (fileObject3 == null) {
                                object22 = FileOwnerQuery.getOwner((FileObject)fileObject);
                                String string2 = "build/generated/wsimport/service/" + serviceModel.endpointInterface.replace('.', '/') + ".java";
                                fileObject3 = object22.getProjectDirectory().getFileObject(string2);
                                if (fileObject3 == null) {
                                    Utils.invokeWsImport((Project)object22, serviceModel.getName());
                                    fileObject3 = object22.getProjectDirectory().getFileObject(string2);
                                }
                            }
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            MethodModel methodModel = new MethodModel();
                            if (bl && fileObject3 != null) {
                                methodModel.setImplementationClass(fileObject3);
                            } else {
                                methodModel.setImplementationClass(fileObject);
                            }
                            object22 = ElementHandle.create((Element)((Element)arrayList.get(i)));
                            methodModel.setMethodHandle((ElementHandle)object22);
                            Utils.populateOperation(compilationController, (ExecutableElement)arrayList.get(i), (ElementHandle)object22, methodModel, serviceModel.getTargetNamespace());
                            arrayList2.add(methodModel);
                        }
                        serviceModel.operations = arrayList2;
                    } else {
                        serviceModel.status = 2;
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private static void populateOperation(CompilationController compilationController, ExecutableElement executableElement, ElementHandle elementHandle, MethodModel methodModel, String string) {
        ArrayList<String> arrayList;
        Element element;
        Object object;
        Object object2;
        TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.Oneway");
        TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.jws.WebResult");
        List<? extends AnnotationMirror> list = executableElement.getAnnotationMirrors();
        ResultModel resultModel = new ResultModel();
        boolean bl = false;
        boolean bl2 = false;
        for (AnnotationMirror object62 : list) {
            if (compilationController.getTypes().isSameType(typeElement.asType(), object62.getAnnotationType())) {
                object2 = object62.getElementValues();
                for (ExecutableElement executableElement2 : object2.keySet()) {
                    if (executableElement2.getSimpleName().contentEquals("operationName")) {
                        methodModel.operationName = (String)((AnnotationValue)object2.get(executableElement2)).getValue();
                        bl = true;
                        continue;
                    }
                    if (!executableElement2.getSimpleName().contentEquals("action")) continue;
                    methodModel.action = (String)((AnnotationValue)object2.get(executableElement2)).getValue();
                }
                continue;
            }
            if (compilationController.getTypes().isSameType(typeElement3.asType(), object62.getAnnotationType())) {
                object2 = object62.getElementValues();
                for (ExecutableElement executableElement3 : object2.keySet()) {
                    if (executableElement3.getSimpleName().contentEquals("name")) {
                        resultModel.setName((String)((AnnotationValue)object2.get(executableElement3)).getValue());
                        bl2 = true;
                        continue;
                    }
                    if (executableElement3.getSimpleName().contentEquals("partName")) {
                        resultModel.setPartName((String)((AnnotationValue)object2.get(executableElement3)).getValue());
                        continue;
                    }
                    if (!executableElement3.getSimpleName().contentEquals("targetNamespace")) continue;
                    resultModel.setTargetNamespace((String)((AnnotationValue)object2.get(executableElement3)).getValue());
                }
                continue;
            }
            if (!compilationController.getTypes().isSameType(typeElement2.asType(), object62.getAnnotationType())) continue;
            methodModel.oneWay = true;
        }
        methodModel.javaName = executableElement.getSimpleName().toString();
        if (!bl) {
            methodModel.operationName = methodModel.javaName;
        }
        if (!methodModel.isOneWay()) {
            if (!bl2) {
                resultModel.setName("return");
            }
            resultModel.setResultType(((Object)executableElement.getReturnType()).toString());
        }
        methodModel.setResult(resultModel);
        List<? extends TypeMirror> list2 = executableElement.getThrownTypes();
        ArrayList<FaultModel> arrayList2 = new ArrayList<FaultModel>();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            object = (TypeMirror)object2.next();
            FaultModel faultModel = new FaultModel();
            boolean bl3 = false;
            if (object.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement4 = (TypeElement)((DeclaredType)object).asElement();
                element = compilationController.getElements().getTypeElement("javax.xml.ws.WebFault");
                arrayList = typeElement4.getAnnotationMirrors();
                for (Object object3 : arrayList) {
                    if (!compilationController.getTypes().isSameType(element.asType(), object3.getAnnotationType())) continue;
                    Tag[] tagArray = object3.getElementValues();
                    Object object4 = tagArray.keySet().iterator();
                    while (object4.hasNext()) {
                        ExecutableElement executableElement4 = object4.next();
                        if (executableElement4.getSimpleName().contentEquals("name")) {
                            faultModel.setName((String)tagArray.get(executableElement4).getValue());
                            bl3 = true;
                            continue;
                        }
                        if (!executableElement4.getSimpleName().contentEquals("targetNamespace")) continue;
                        faultModel.setTargetNamespace((String)tagArray.get(executableElement4).getValue());
                    }
                }
                faultModel.setFaultType(typeElement4.getQualifiedName().toString());
            } else {
                faultModel.setFaultType(object.toString());
            }
            if (!bl3) {
                String string2 = faultModel.getFaultType();
                int n = string2.lastIndexOf(".");
                faultModel.setName(n >= 0 ? string2.substring(n + 1) : string2);
            }
            arrayList2.add(faultModel);
        }
        methodModel.setFaults(arrayList2);
        object2 = compilationController.getElementUtilities().javaDocFor((Element)executableElement);
        if (object2 != null) {
            Object object3;
            object = new JavadocModel(object2.getRawCommentText());
            Tag[] tagArray = object2.tags("@param");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Tag tag : tagArray) {
                arrayList3.add(tag.text());
            }
            ((JavadocModel)object).setParamJavadoc(arrayList3);
            Tag[] tagArray2 = object2.tags("@return");
            if (tagArray2.length > 0) {
                ((JavadocModel)object).setReturnJavadoc(tagArray2[0].text());
            }
            element = object2.tags("@throws");
            arrayList = new ArrayList<String>();
            for (Object object4 : element) {
                arrayList.add(object4.text());
            }
            ((JavadocModel)object).setThrowsJavadoc(arrayList);
            Tag[] tagArray3 = object2.inlineTags();
            object3 = new ArrayList();
            for (Tag tag : tagArray3) {
                arrayList.add(tag.text());
            }
            ((JavadocModel)object).setInlineJavadoc((List<String>)object3);
            methodModel.setJavadoc((JavadocModel)object);
        }
        object = executableElement.getParameters();
        ArrayList<ParamModel> arrayList4 = new ArrayList<ParamModel>();
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            element = (VariableElement)iterator.next();
            arrayList = new ParamModel("arg" + String.valueOf(n++), element.getSimpleName().toString());
            ((ParamModel)((Object)arrayList)).setImplementationClass(methodModel.getImplementationClass());
            ((ParamModel)((Object)arrayList)).setMethodHandle(elementHandle);
            Utils.populateParam(compilationController, (VariableElement)element, arrayList);
            arrayList4.add((ParamModel)((Object)arrayList));
        }
        methodModel.setParams(arrayList4);
        Utils.setSoapRequest(methodModel, string);
        Utils.setSoapResponse(methodModel, string);
    }

    private static void populateParam(CompilationController compilationController, VariableElement variableElement, ParamModel paramModel) {
        paramModel.setParamType(((Object)variableElement.asType()).toString());
        TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebParam");
        List<? extends AnnotationMirror> list = variableElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            if (!compilationController.getTypes().isSameType(typeElement.asType(), annotationMirror.getAnnotationType())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (executableElement.getSimpleName().contentEquals("name")) {
                    paramModel.name = (String)map.get(executableElement).getValue();
                    continue;
                }
                if (executableElement.getSimpleName().contentEquals("partName")) {
                    paramModel.setPartName((String)map.get(executableElement).getValue());
                    continue;
                }
                if (executableElement.getSimpleName().contentEquals("targetNamespace")) {
                    paramModel.setTargetNamespace((String)map.get(executableElement).getValue());
                    continue;
                }
                if (!executableElement.getSimpleName().contentEquals("mode")) continue;
                paramModel.setMode(WebParam.Mode.valueOf((String)map.get(executableElement).getValue().toString()));
            }
        }
    }

    private static void setSoapRequest(MethodModel methodModel, String string) {
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), sOAPException);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
                String string2 = methodModel.getAction();
                mimeHeaders.addHeader("SOAPAction", string2 == null ? "\"\"" : string2);
                SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                String string3 = sOAPEnvelope.getPrefix();
                if (!"soap".equals(string3)) {
                    sOAPEnvelope.removeAttribute("xmlns:" + string3);
                    sOAPEnvelope.setPrefix("soap");
                }
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                sOAPBody.setPrefix("soap");
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                sOAPEnvelope.removeChild((Node)sOAPHeader);
                Name name = sOAPEnvelope.createName(methodModel.getOperationName());
                SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
                sOAPBodyElement.setPrefix("ns0");
                sOAPBodyElement.addNamespaceDeclaration("ns0", string);
                List<ParamModel> list = methodModel.getParams();
                int n = 0;
                for (ParamModel paramModel : list) {
                    Object object;
                    String string4 = paramModel.getTargetNamespace();
                    Name name2 = null;
                    if (paramModel.getName() == null || paramModel.getName().trim().length() == 0) continue;
                    if (string4 != null && string4.length() > 0) {
                        object = "ns" + String.valueOf(++n);
                        name2 = sOAPEnvelope.createName(paramModel.getName(), (String)object, string4);
                        sOAPBodyElement.addNamespaceDeclaration((String)object, string4);
                    } else {
                        name2 = sOAPEnvelope.createName(paramModel.getName());
                    }
                    object = sOAPBodyElement.addChildElement(name2);
                    String string5 = paramModel.getParamType();
                    if ("javax.xml.namespace.QName".equals(string5)) {
                        object.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                        object.addTextNode("sampleNs:sampleQName");
                        continue;
                    }
                    object.addTextNode(Utils.getSampleValue(string5));
                }
                methodModel.setSoapRequest(sOAPMessage);
            }
            catch (SOAPException sOAPException) {
                ErrorManager.getDefault().notify((Throwable)sOAPException);
            }
        }
    }

    private static void setSoapResponse(MethodModel methodModel, String string) {
        if (methodModel.isOneWay()) {
            return;
        }
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), sOAPException);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                String string2 = sOAPEnvelope.getPrefix();
                if (!"soap".equals(string2)) {
                    sOAPEnvelope.removeAttribute("xmlns:" + string2);
                    sOAPEnvelope.setPrefix("soap");
                }
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                sOAPBody.setPrefix("soap");
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                sOAPEnvelope.removeChild((Node)sOAPHeader);
                Name name = sOAPEnvelope.createName(methodModel.getOperationName() + "Response");
                SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
                sOAPBodyElement.setPrefix("ns0");
                sOAPBodyElement.addNamespaceDeclaration("ns0", string);
                ResultModel resultModel = methodModel.getResult();
                String string3 = resultModel.getTargetNamespace();
                Name name2 = null;
                if (string3 != null && string3.length() > 0) {
                    sOAPBodyElement.addNamespaceDeclaration("ns1", string3);
                    name2 = sOAPEnvelope.createName(resultModel.getName(), "ns1", string3);
                } else {
                    name2 = sOAPEnvelope.createName(resultModel.getName());
                }
                String string4 = resultModel.getResultType();
                if ("javax.xml.namespace.QName".equals(string4)) {
                    SOAPElement sOAPElement = sOAPBodyElement.addChildElement(name2);
                    sOAPElement.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                    sOAPElement.addTextNode("sampleNs:sampleQName");
                } else if (!"void".equals(string4)) {
                    SOAPElement sOAPElement = sOAPBodyElement.addChildElement(name2);
                    sOAPElement.addTextNode(Utils.getSampleValue(string4));
                }
                methodModel.setSoapResponse(sOAPMessage);
            }
            catch (SOAPException sOAPException) {
                ErrorManager.getDefault().notify((Throwable)sOAPException);
            }
        }
    }

    private static String getSampleValue(String string) {
        if ("java.lang.String".equals(string)) {
            return "sample text";
        }
        if ("int".equals(string) || "java.lang.Integer".equals(string) || "java.math.BigInteger".equals(string)) {
            return "99";
        }
        if ("double".equals(string) || "java.lang.Double".equals(string)) {
            return "999.999";
        }
        if ("float".equals(string) || "java.lang.Float".equals(string) || "java.math.BigDecimal".equals(string)) {
            return "99.99";
        }
        if ("long".equals(string) || "java.lang.Long".equals(string)) {
            return "999";
        }
        if ("boolean".equals(string) || "java.lang.Boolean".equals(string)) {
            return "false";
        }
        if ("char".equals(string) || "java.lang.Char".equals(string) || "short".equals(string) || "java.lang.Short".equals(string)) {
            return "65";
        }
        if ("byte[]".equals(string)) {
            return "73616D706C652074657874";
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(string) || "java.util.Date".equals(string) || "java.util.Calendar".equals(string) || "java.util.GregorianCalendar".equals(string)) {
            return "2007-04-19";
        }
        if ("javax.xml.datatype.Duration".equals(string)) {
            return "P2007Y4M";
        }
        if ("java.net.URI".equals(string) || "java.net.URL".equals(string)) {
            return "http://www.netbeans.org/sampleURI";
        }
        return "...";
    }

    public static void setJavadoc(FileObject fileObject, final MethodModel methodModel, final String string) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                List<? extends Tree> list = classTree.getMembers();
                TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                if (typeElement == null) {
                    return;
                }
                MethodTree methodTree = null;
                for (Tree tree : list) {
                    if (Tree.Kind.METHOD != tree.getKind()) continue;
                    MethodTree methodTree2 = (MethodTree)tree;
                    TreePath treePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), methodTree2);
                    ExecutableElement executableElement = (ExecutableElement)workingCopy.getTrees().getElement(treePath);
                    List<? extends AnnotationMirror> list2 = executableElement.getAnnotationMirrors();
                    block1: for (AnnotationMirror annotationMirror : list2) {
                        if (!workingCopy.getTypes().isSameType(typeElement.asType(), annotationMirror.getAnnotationType())) continue;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (ExecutableElement executableElement2 : map.keySet()) {
                            if (!executableElement2.getSimpleName().contentEquals("operationName")) continue;
                            if (!methodModel.getOperationName().equals(map.get(executableElement2).getValue())) break block1;
                            methodTree = methodTree2;
                            break block1;
                        }
                    }
                    if (methodTree != null) break;
                    if (!methodTree2.getName().contentEquals(methodModel.getOperationName())) continue;
                    methodTree = methodTree2;
                    break;
                }
                if (methodTree != null) {
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)0, (int)0, (int)0, (String)string);
                }
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static String getFormatedDocument(SOAPMessage sOAPMessage) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            StreamSource streamSource = new StreamSource(byteArrayInputStream);
            transformer.transform(streamSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void invokeWsImport(Project project, final String string) {
        Service service;
        JaxWsModel jaxWsModel;
        if (project != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null && (service = jaxWsModel.findServiceByName(string)) != null && service.getWsdlUrl() != null) {
            final FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                ((Boolean)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                    public Boolean run() throws IOException {
                        ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-service-clean-" + string, "wsimport-service-" + string}, null);
                        executorTask.waitFinished();
                        return Boolean.TRUE;
                    }
                })).booleanValue();
            }
            catch (MutexException mutexException) {
                ErrorManager.getDefault().log(mutexException.getLocalizedMessage());
            }
        }
    }

    public static String getCurrentJavaName(final MethodModel methodModel) {
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)methodModel.getImplementationClass());
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ElementHandle elementHandle = methodModel.getMethodHandle();
                Element element = elementHandle.resolve((CompilationInfo)workingCopy);
                stringArray[0] = element.getSimpleName().toString();
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return stringArray[0];
    }

    public static String getAttributeValue(FileObject fileObject, final String string, final String string2) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[]{""};
        if (javaSource != null) {
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null && typeElement2 != null) {
                        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                        block0: for (AnnotationMirror annotationMirror : list) {
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (ExecutableElement executableElement : map.keySet()) {
                                String string3;
                                if (!executableElement.getSimpleName().contentEquals(string2) || (string3 = (String)map.get(executableElement).getValue()) == null) continue;
                                stringArray[0] = URLEncoder.encode(string3, "UTF-8");
                                continue block0;
                            }
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return stringArray[0];
    }

    private static String getPackageReverseOrder(String string) {
        String[] stringArray = string.split("\\.");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (i < stringArray.length - 1) {
                stringBuffer.append(".");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

