/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.ValidateablePanel;
import org.netbeans.modules.nativeexecution.jsch.JSchChannelsSupport;
import org.netbeans.modules.nativeexecution.jsch.JSchConnectionTask;
import org.netbeans.modules.nativeexecution.support.Authentication;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ui.AuthenticationSettingsPanel;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ConnectionManager {
    private static final java.util.logging.Logger log = org.netbeans.modules.nativeexecution.support.Logger.getInstance();
    private static final ConcurrentHashMap<ExecutionEnvironment, JSchChannelsSupport> channelsSupport = new ConcurrentHashMap();
    private static List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private static final Object channelsSupportLock = new Object();
    private static HashMap<ExecutionEnvironment, ConnectToAction> connectionActions = new HashMap();
    private static final ConnectionManager instance = new ConnectionManager();
    private static final ConcurrentHashMap<ExecutionEnvironment, JSch> jschPool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ExecutionEnvironment, JSchConnectionTask> connectionTasks = new ConcurrentHashMap();
    private static final boolean UNIT_TEST_MODE = Boolean.getBoolean("nativeexecution.mode.unittest");
    private final AbstractList<ExecutionEnvironment> recentConnections = new ArrayList<ExecutionEnvironment>();
    private static final int RETRY_MAX = 10;

    private ConnectionManager() {
        if (log.isLoggable(Level.FINEST)) {
            JSch.setLogger((Logger)new Logger(){

                public boolean isEnabled(int level) {
                    return true;
                }

                public void log(int level, String message) {
                    log.log(Level.FINEST, "JSCH: {0}", message);
                }
            });
        }
        this.restoreRecentConnectionsList();
    }

    public void addConnectionListener(ConnectionListener listener) {
        connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        connectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionEnvironment> getRecentConnections() {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            return Collections.unmodifiableList(new ArrayList<ExecutionEnvironment>(this.recentConnections));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRecentConnectionsList(ExecutionEnvironment execEnv) {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            this.recentConnections.remove(execEnv);
            this.recentConnections.add(0, execEnv);
            this.storeRecentConnectionsList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeRecentConnectionsList() {
        Preferences prefs = NbPreferences.forModule(ConnectionManager.class);
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            for (int i = 0; i < this.recentConnections.size(); ++i) {
                prefs.put(ConnectionManager.getConnectoinsHistoryKey(i), ExecutionEnvironmentFactory.toUniqueID(this.recentConnections.get(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreRecentConnectionsList() {
        Preferences prefs = NbPreferences.forModule(ConnectionManager.class);
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            String id;
            this.recentConnections.clear();
            int idx = 0;
            while ((id = prefs.get(ConnectionManager.getConnectoinsHistoryKey(idx), null)) != null) {
                this.recentConnections.add(ExecutionEnvironmentFactory.fromUniqueID(id));
                ++idx;
            }
        }
    }

    private static String getConnectoinsHistoryKey(int idx) {
        return ConnectionManager.class.getName() + "_connection.history_" + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRecentConnectionsList() {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            this.recentConnections.clear();
        }
    }

    private void fireConnected(ExecutionEnvironment execEnv) {
        for (ConnectionListener connectionListener : connectionListeners) {
            connectionListener.connected(execEnv);
        }
        this.updateRecentConnectionsList(execEnv);
    }

    private void fireDisconnected(ExecutionEnvironment execEnv) {
        for (ConnectionListener connectionListener : connectionListeners) {
            connectionListener.disconnected(execEnv);
        }
    }

    public boolean isConnectedTo(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal()) {
            return true;
        }
        JSchChannelsSupport support = channelsSupport.get(execEnv);
        return support != null && support.isConnected();
    }

    public void connectTo(ExecutionEnvironment env) throws IOException, CancellationException {
        JSch old;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalThreadStateException("Should never be called from AWT thread");
        }
        if (this.isConnectedTo(env)) {
            return;
        }
        JSch jsch = jschPool.get(env);
        if (jsch == null && (old = jschPool.putIfAbsent(env, jsch = new JSch())) != null) {
            jsch = old;
        }
        if (UNIT_TEST_MODE) {
            IOException ex = null;
            for (int retry = 10; retry > 0; --retry) {
                try {
                    this.initiateConnection(env, jsch);
                    return;
                }
                catch (IOException e) {
                    if (!(e.getCause() instanceof JSchException)) {
                        throw e;
                    }
                    if (!"Auth fail".equals(e.getCause().getMessage())) {
                        throw e;
                    }
                    ex = e;
                    System.out.println("AUTH_FAIL: Connection failed, re-runing test " + retry);
                    continue;
                }
            }
            System.out.println("AUTH_FAIL: Retry limit reached");
            throw ex;
        }
        this.initiateConnection(env, jsch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateConnection(ExecutionEnvironment env, JSch jsch) throws IOException, CancellationException {
        JSchConnectionTask connectionTask;
        ConcurrentHashMap<ExecutionEnvironment, JSchConnectionTask> concurrentHashMap = connectionTasks;
        synchronized (concurrentHashMap) {
            connectionTask = connectionTasks.get(env);
            if (connectionTask == null) {
                connectionTask = new JSchConnectionTask(jsch, env);
                connectionTask.start();
                connectionTasks.put(env, connectionTask);
            }
        }
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)ConnectionManager.loc("ConnectionManager.Connecting", ((Object)env).toString()), (Cancellable)connectionTask);
        ph.start();
        try {
            JSchChannelsSupport cs = connectionTask.getResult();
            if (cs != null) {
                Object object = channelsSupportLock;
                synchronized (object) {
                    channelsSupport.put(env, cs);
                }
            } else {
                JSchConnectionTask.Problem problem = connectionTask.getProblem();
                switch (problem.type) {
                    case CONNECTION_CANCELLED: {
                        throw new CancellationException("Connection cancelled for " + env);
                    }
                }
                throw new IOException(env.getDisplayName() + ": " + problem.type.name(), problem.cause);
            }
            HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
            log.log(Level.FINE, "New connection established: {0} - {1}", new String[]{((Object)env).toString(), hostInfo.getOS().getName()});
            this.fireConnected(env);
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
            connectionTasks.remove(env);
        }
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public synchronized AsynchronousAction getConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
        if (connectionActions.containsKey(execEnv)) {
            return connectionActions.get(execEnv);
        }
        ConnectToAction action = new ConnectToAction(execEnv, onConnect);
        connectionActions.put(execEnv, action);
        return action;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ConnectionManager.class, (String)key, (Object[])params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(ExecutionEnvironment env) throws IOException {
        Object object = channelsSupportLock;
        synchronized (object) {
            if (channelsSupport.containsKey(env)) {
                try {
                    channelsSupport.get(env).reconnect(env);
                }
                catch (JSchException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    public void disconnect(ExecutionEnvironment env) {
        this.disconnectImpl(env);
        PasswordManager.getInstance().onExplicitDisconnect(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectImpl(ExecutionEnvironment env) {
        Object object = channelsSupportLock;
        synchronized (object) {
            if (channelsSupport.containsKey(env)) {
                JSchChannelsSupport cs = channelsSupport.remove(env);
                cs.disconnect();
                this.fireDisconnected(env);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        log.fine("Shutting down Connection Manager");
        Object object = channelsSupportLock;
        synchronized (object) {
            for (JSchChannelsSupport cs : channelsSupport.values()) {
                cs.disconnect();
            }
        }
    }

    public ValidateablePanel getConfigurationPanel(ExecutionEnvironment env) {
        Authentication auth = Authentication.getFor(env);
        AuthenticationSettingsPanel panel = new AuthenticationSettingsPanel(auth, env != null);
        return panel;
    }

    public void forget(ExecutionEnvironment env) {
        if (env == null) {
            return;
        }
        Authentication.getFor(env).remove();
        jschPool.remove(env);
    }

    static {
        ConnectionManagerAccessor.setDefault(new ConnectionManagerAccessorImpl());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.shutdown();
            }
        }));
    }

    private static final class ConnectionManagerAccessorImpl
    extends ConnectionManagerAccessor {
        private ConnectionManagerAccessorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Channel openAndAcquireChannel(ExecutionEnvironment env, String type, boolean waitIfNoAvailable) throws InterruptedException, JSchException, IOException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(env);
                    return cs.acquireChannel(type, waitIfNoAvailable);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeAndReleaseChannel(ExecutionEnvironment env, Channel channel) throws JSchException {
            JSchChannelsSupport cs = null;
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(env)) {
                    cs = (JSchChannelsSupport)channelsSupport.get(env);
                }
            }
            if (cs != null && channel != null) {
                cs.releaseChannel(channel);
            }
        }

        @Override
        public void reconnect(ExecutionEnvironment env) throws IOException {
            instance.reconnect(env);
        }

        @Override
        public void changeAuth(ExecutionEnvironment env, Authentication auth) {
            JSch jsch = (JSch)jschPool.get(env);
            if (jsch != null) {
                try {
                    jsch.removeAllIdentity();
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    String knownHosts = auth.getKnownHostsFile();
                    if (knownHosts != null) {
                        jsch.setKnownHosts(knownHosts);
                    }
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (auth.getType()) {
                    case SSH_KEY: {
                        try {
                            jsch.addIdentity(auth.getSSHKeyFile());
                            break;
                        }
                        catch (JSchException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    private static class ConnectToAction
    extends AbstractAction
    implements AsynchronousAction {
        private static final ConnectionManager cm = ConnectionManager.getInstance();
        private final ExecutionEnvironment env;
        private final Runnable onConnect;

        private ConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
            this.env = execEnv;
            this.onConnect = onConnect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NativeTaskExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectToAction.this.invoke();
                    }
                    catch (Throwable ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }, "Connecting to " + ((Object)this.env).toString());
        }

        @Override
        public synchronized void invoke() throws IOException, CancellationException {
            if (cm.isConnectedTo(this.env)) {
                return;
            }
            cm.connectTo(this.env);
            this.onConnect.run();
        }
    }

    public static class CancellationException
    extends Exception {
        public CancellationException() {
        }

        public CancellationException(String message) {
            super(message);
        }
    }
}

