/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.ProcessInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.spi.ProcessInfoProviderFactory;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AbstractNativeProcess
extends NativeProcess {
    protected static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Integer PID_TIMEOUT = Integer.valueOf(System.getProperty("dlight.nativeexecutor.pidtimeout", "70"));
    protected final NativeProcessInfo info;
    protected final HostInfo hostInfo;
    protected long creation_ts = -1L;
    private final String id;
    private final ExecutionEnvironment execEnv;
    private final Collection<ChangeListener> listeners;
    private final Object stateLock;
    private volatile NativeProcess.State state;
    private volatile int pid = 0;
    private volatile boolean isInterrupted;
    private final AtomicBoolean cancelledFlag = new AtomicBoolean(false);
    private Future<ProcessInfoProvider> infoProviderSearchTask;
    private Future<Integer> waitTask = null;
    private AtomicInteger result = null;
    private InputStream inputStream;
    private InputStream errorStream;
    private OutputStream outputStream;

    public AbstractNativeProcess(NativeProcessInfo info) {
        this.info = info;
        this.isInterrupted = false;
        this.state = NativeProcess.State.INITIAL;
        this.inputStream = new ByteArrayInputStream(new byte[0]);
        this.errorStream = new ByteArrayInputStream(new byte[0]);
        this.outputStream = new ByteArrayOutputStream();
        this.execEnv = info.getExecutionEnvironment();
        String cmd = info.getCommandLineForShell();
        if (cmd == null) {
            cmd = Arrays.toString(info.getCommand().toArray(new String[0]));
        }
        this.id = ((Object)this.execEnv).toString() + ' ' + cmd;
        this.stateLock = "StateLock: " + this.id;
        HostInfo hinfo = null;
        try {
            hinfo = HostInfoUtils.getHostInfo(this.execEnv);
        }
        catch (ConnectionManager.CancellationException ex) {
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.hostInfo = hinfo;
        Collection<ChangeListener> ll = info.getListeners();
        this.listeners = ll == null || ll.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<ChangeListener>(ll));
    }

    public final NativeProcess createAndStart() {
        try {
            if (this.hostInfo == null) {
                throw new IllegalStateException("Unable to create process - no HostInfo available");
            }
            this.setState(NativeProcess.State.STARTING);
            this.create();
            this.setState(NativeProcess.State.RUNNING);
            this.findInfoProvider();
            this.waitTask = NativeTaskExecutorService.submit(new Callable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer call() throws Exception {
                    int exitCode = -1;
                    NativeProcess.State state = null;
                    try {
                        exitCode = AbstractNativeProcess.this.waitResult();
                        AbstractNativeProcess.this.result = new AtomicInteger(exitCode);
                        state = NativeProcess.State.FINISHED;
                    }
                    catch (InterruptedException ex) {
                        AbstractNativeProcess.this.result = new AtomicInteger(exitCode);
                        state = NativeProcess.State.CANCELLED;
                        throw ex;
                    }
                    catch (Throwable th) {
                        AbstractNativeProcess.this.result = new AtomicInteger(exitCode);
                        state = NativeProcess.State.ERROR;
                        Exceptions.printStackTrace((Throwable)th);
                    }
                    finally {
                        if (AbstractNativeProcess.this.cancelledFlag.get()) {
                            AbstractNativeProcess.this.setState(NativeProcess.State.CANCELLED);
                        } else if (state != null) {
                            AbstractNativeProcess.this.setState(state);
                        }
                    }
                    return exitCode;
                }
            }, "Waiting for " + this.id);
        }
        catch (Throwable ex) {
            this.setState(NativeProcess.State.ERROR);
            this.destroy();
            LOG.log(Level.INFO, AbstractNativeProcess.loc("NativeProcess.exceptionOccured.text", ex.getMessage()), ex);
            String msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
            this.errorStream = new ByteArrayInputStream((msg + "\n").getBytes());
        }
        return this;
    }

    protected abstract void create() throws Throwable;

    protected final boolean isInterrupted() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException ex) {
            this.isInterrupted = true;
            Thread.currentThread().interrupt();
        }
        this.isInterrupted |= Thread.currentThread().isInterrupted();
        return this.isInterrupted;
    }

    @Override
    public final ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getPID() throws IOException {
        AbstractNativeProcess abstractNativeProcess = this;
        synchronized (abstractNativeProcess) {
            if (this.pid == 0) {
                if (this.isInterrupted()) {
                    this.destroy();
                    throw new InterruptedIOException();
                }
                throw new IOException("PID of process '" + this.id + "' is not received!");
            }
            return this.pid;
        }
    }

    protected int destroyImpl() {
        return 0;
    }

    protected abstract int waitResult() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NativeProcess.State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public final String toString() {
        return this.id == null ? super.toString() : this.id.trim();
    }

    @Override
    public final void destroy() {
        if (this.cancelledFlag.getAndSet(true)) {
            return;
        }
        final int timeToWait = this.destroyImpl();
        if (this.pid > 0 && this.waitTask != null && !this.waitTask.isDone()) {
            Future<Integer> killTask = null;
            if (timeToWait > 0) {
                Callable<Integer> waitForTermination = new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        try {
                            return (Integer)AbstractNativeProcess.this.waitTask.get(timeToWait, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException ex) {
                            return CommonTasksSupport.sendSignal(AbstractNativeProcess.this.execEnv, AbstractNativeProcess.this.pid, Signal.SIGKILL, null).get();
                        }
                    }
                };
                killTask = NativeTaskExecutorService.submit(waitForTermination, "Waiting " + timeToWait + " seconds for process " + this.id + " to terminate...");
            } else {
                killTask = CommonTasksSupport.sendSignal(this.execEnv, this.pid, Signal.SIGKILL, null);
            }
            if (killTask != null) {
                try {
                    killTask.get();
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int waitFor() throws InterruptedException {
        int exitStatus = -1;
        if (this.waitTask == null) {
            return exitStatus;
        }
        try {
            exitStatus = this.waitTask.get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ex.getCause();
            }
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Thread.interrupted();
        }
        return exitStatus;
    }

    @Override
    public final int exitValue() {
        if (this.waitTask == null || !this.waitTask.isDone()) {
            if (this.result != null) {
                return this.result.get();
            }
            throw new IllegalThreadStateException();
        }
        try {
            return this.waitTask.get();
        }
        catch (InterruptedException ex) {
            return -1;
        }
        catch (ExecutionException ex) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(NativeProcess.State state) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == state) {
                return;
            }
            if (this.state == NativeProcess.State.CANCELLED || this.state == NativeProcess.State.ERROR || this.state == NativeProcess.State.FINISHED) {
                return;
            }
            try {
                if (this.isInterrupted()) {
                    Thread.interrupted();
                }
                if (!this.isInterrupted() && LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(String.format("%s: State changed: %s -> %s", new Object[]{this.toString(), this.state, state}));
                }
                this.state = state;
                if (this.listeners == null) {
                    return;
                }
                NativeProcessChangeEvent event = new NativeProcessChangeEvent(this, state, this.pid);
                for (ChangeListener l : this.listeners) {
                    l.stateChanged(event);
                }
            }
            finally {
                if (this.isInterrupted()) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected final void readPID(InputStream is) throws IOException {
        int c = -1;
        this.pid = 0;
        while (!this.isInterrupted() && (c = is.read()) >= 48 && c <= 57) {
            this.pid = this.pid * 10 + (c - 48);
        }
    }

    @Override
    public ProcessInfo getProcessInfo() {
        ProcessInfoProvider provider = null;
        try {
            provider = this.infoProviderSearchTask.get();
        }
        catch (Throwable ex) {
            LOG.finest(ex.getMessage());
        }
        return provider == null ? new ProcessInfo(){

            @Override
            public long getCreationTimestamp(TimeUnit unit) {
                return unit.convert(AbstractNativeProcess.this.creation_ts, TimeUnit.NANOSECONDS);
            }
        } : provider.getProcessInfo();
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(AbstractNativeProcess.class, (String)key, (Object[])params);
    }

    @Override
    public final InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    protected final void setErrorStream(InputStream error) {
        this.errorStream = error;
    }

    protected final void setOutputStream(OutputStream output) {
        this.outputStream = output;
    }

    protected final void setInputStream(InputStream input) {
        this.inputStream = input;
    }

    private void findInfoProvider() {
        Callable<ProcessInfoProvider> callable = new Callable<ProcessInfoProvider>(){

            @Override
            public ProcessInfoProvider call() throws Exception {
                ProcessInfoProviderFactory factory;
                Collection factories = Lookup.getDefault().lookupAll(ProcessInfoProviderFactory.class);
                ProcessInfoProvider pip = null;
                Iterator i$ = factories.iterator();
                while (i$.hasNext() && (pip = (factory = (ProcessInfoProviderFactory)i$.next()).getProvider(AbstractNativeProcess.this.execEnv, AbstractNativeProcess.this.pid)) == null) {
                }
                return pip;
            }
        };
        this.infoProviderSearchTask = NativeTaskExecutorService.submit(callable, "get info provider for process " + this.pid);
    }
}

