/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.updatecenter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    private static String AUTOUPDATE_TYPES = "Services/AutoupdateType";
    private String AUTOUPDATE_SERVICE_TYPE = "_update_center";
    private static String AUTOUPDATE_SETTINGS_TYPE_EXT = "settings";
    private static String AUTOUPDATE_INSTANCE_TYPE_EXT = "instance";
    private static String AUTOUPDATE_MODULE = "org.netbeans.modules.autoupdate";
    private static String AUTOUPDATE_MODULE_NEW = "org.netbeans.modules.autoupdate.services";
    private CreatedModifiedFiles cmf;
    private String ucUrl;
    private String ucDisplayName;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    private CreatedModifiedFiles regenerate() {
        if (this.cmf == null) {
            this.cmf = new CreatedModifiedFiles(this.getProject());
        }
        boolean newAPI = true;
        try {
            newAPI = this.getModuleInfo().getDependencyVersion(AUTOUPDATE_MODULE_NEW) != null;
        }
        catch (IOException x) {
            Logger.getLogger(DataModel.class.getName()).log(Level.INFO, null, x);
        }
        String extension = newAPI ? AUTOUPDATE_INSTANCE_TYPE_EXT : AUTOUPDATE_SETTINGS_TYPE_EXT;
        FileObject template = newAPI ? null : CreatedModifiedFiles.getTemplate("update_center.xml");
        String serviceTypeName = this.getModuleInfo().getCodeNameBase().replace('.', '_') + this.AUTOUPDATE_SERVICE_TYPE;
        FileSystem layer = LayerHandle.forProject(this.getProject()).layer(false);
        String pathToAutoUpdateType = AUTOUPDATE_TYPES + '/' + serviceTypeName + '.' + extension;
        int sequence = 0;
        if (layer != null) {
            FileObject f;
            do {
                if ((f = layer.findResource(pathToAutoUpdateType)) == null) continue;
                pathToAutoUpdateType = AUTOUPDATE_TYPES + '/' + serviceTypeName + '_' + ++sequence + '.' + extension;
            } while (f != null);
        }
        String codename = null;
        NbModuleProvider mp = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
        Manifest mani = Util.getManifest(mp.getManifestFile());
        if (mani != null) {
            codename = mani.getMainAttributes().getValue("OpenIDE-Module");
        }
        if (codename == null) {
            codename = this.getModuleInfo().getCodeNameBase();
        }
        Map<String, String> substitutionTokens = newAPI ? null : Collections.singletonMap("MODULECODENAME", codename);
        this.cmf.add(this.cmf.createLayerEntry(pathToAutoUpdateType, template, substitutionTokens, null, null));
        if (newAPI) {
            this.cmf.add(this.cmf.createLayerAttribute(pathToAutoUpdateType, "instanceCreate", "methodvalue:org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory.createUpdateProvider"));
            this.cmf.add(this.cmf.createLayerAttribute(pathToAutoUpdateType, "instanceOf", "org.netbeans.spi.autoupdate.UpdateProvider"));
        }
        String url_key_base = this.getModuleInfo().getCodeNameBase().replace('.', '_') + this.AUTOUPDATE_SERVICE_TYPE;
        String url_key = sequence == 0 ? url_key_base : url_key_base + '_' + sequence;
        this.cmf.add(this.cmf.createLayerAttribute(pathToAutoUpdateType, "enabled", Boolean.TRUE));
        ManifestManager mm = ManifestManager.getInstance(Util.getManifest(this.getModuleInfo().getManifestFile()), false);
        String localizingBundle = mm.getLocalizingBundle();
        localizingBundle = localizingBundle.substring(0, localizingBundle.indexOf(46));
        localizingBundle = localizingBundle.replace('/', '.');
        this.cmf.add(this.cmf.createLayerAttribute(pathToAutoUpdateType, "displayName", "bundlevalue:" + localizingBundle + "#" + pathToAutoUpdateType));
        this.cmf.add(this.cmf.createLayerAttribute(pathToAutoUpdateType, "url", "bundlevalue:" + localizingBundle + "#" + url_key));
        this.cmf.add(this.cmf.bundleKeyDefaultBundle(pathToAutoUpdateType, this.ucDisplayName));
        this.cmf.add(this.cmf.bundleKeyDefaultBundle(url_key, this.ucUrl));
        this.cmf.add(this.cmf.addModuleDependency(newAPI ? AUTOUPDATE_MODULE_NEW : AUTOUPDATE_MODULE, null, null, false));
        return this.cmf;
    }

    CreatedModifiedFiles refreshCreatedModifiedFiles() {
        return this.regenerate();
    }

    void setUpdateCenterURL(String url) {
        this.ucUrl = url;
    }

    String getUpdateCenterURL() {
        return this.ucUrl != null ? this.ucUrl : "";
    }

    void setUpdateCenterDisplayName(String name) {
        this.ucDisplayName = name;
    }

    String getUpdateCenterDisplayName() {
        return this.ucDisplayName != null ? this.ucDisplayName : "";
    }
}

