/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.loader;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.NewLoaderIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class FileRecognitionPanel
extends BasicWizardIterator.Panel {
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("([.]?[a-zA-Z0-9_]+){1}([ ,]+[.]?[a-zA-Z0-9_]+)*[ ]*");
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.-])*\\+xml)");
    private static final Pattern MIME_TYPE_PATTERN = Pattern.compile("[\\w.]+(?:[+-][\\w.]+)?/[\\w.]+(?:[+-][\\w.]+)*");
    private NewLoaderIterator.DataModel data;
    private ButtonGroup group;
    private boolean listenersAttached;
    private DocumentListener docList;
    private JLabel lblExtension;
    private JLabel lblMimeType;
    private JLabel lblNamespace;
    private JLabel mimeTypeHint;
    private JRadioButton rbByElement;
    private JRadioButton rbByExtension;
    private JTextField txtExtension;
    private JTextField txtMimeType;
    private JTextField txtNamespace;

    public FileRecognitionPanel(WizardDescriptor setting, NewLoaderIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.group = new ButtonGroup();
        this.group.add(this.rbByElement);
        this.group.add(this.rbByExtension);
        ActionListener list = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileRecognitionPanel.this.txtExtension.setEnabled(FileRecognitionPanel.this.rbByExtension.isSelected());
                FileRecognitionPanel.this.txtNamespace.setEnabled(FileRecognitionPanel.this.rbByElement.isSelected());
                FileRecognitionPanel.this.checkValidity();
            }
        };
        this.docList = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileRecognitionPanel.this.checkValidity();
            }
        };
        this.rbByElement.addActionListener(list);
        this.rbByExtension.addActionListener(list);
        this.putClientProperty("NewFileWizard_Title", FileRecognitionPanel.getMessage("LBL_LoaderWizardTitle"));
    }

    static String checkValidity(AtomicBoolean error, String mimeType, String namespace, String extension, boolean byElement) {
        if (mimeType.isEmpty()) {
            return FileRecognitionPanel.getMessage("MSG_EmptyMIMEType");
        }
        if (!MIME_TYPE_PATTERN.matcher(mimeType).matches()) {
            error.set(true);
            return FileRecognitionPanel.getMessage("MSG_NotValidMimeType");
        }
        if (byElement) {
            if (namespace.isEmpty()) {
                return FileRecognitionPanel.getMessage("MSG_NoNamespace");
            }
            if (!ELEMENT_PATTERN.matcher(mimeType).matches()) {
                error.set(true);
                return FileRecognitionPanel.getMessage("MSG_BadMimeTypeForXML");
            }
        } else {
            if (extension.isEmpty()) {
                return FileRecognitionPanel.getMessage("MSG_NoExtension");
            }
            if (!EXTENSION_PATTERN.matcher(extension).matches()) {
                error.set(true);
                return FileRecognitionPanel.getMessage("MSG_BadExtensionPattern");
            }
        }
        return null;
    }

    private void checkValidity() {
        AtomicBoolean error = new AtomicBoolean();
        String msg = FileRecognitionPanel.checkValidity(error, this.txtMimeType.getText().trim(), this.txtNamespace.getText().trim(), this.txtExtension.getText().trim(), this.rbByElement.isSelected());
        if (msg == null) {
            this.markValid();
        } else if (error.get()) {
            this.setError(msg);
        } else {
            this.setInfo(msg, false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkValidity();
    }

    @Override
    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.txtNamespace.getDocument().addDocumentListener(this.docList);
            this.txtExtension.getDocument().addDocumentListener(this.docList);
            this.txtMimeType.getDocument().addDocumentListener(this.docList);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.txtNamespace.getDocument().removeDocumentListener(this.docList);
            this.txtExtension.getDocument().removeDocumentListener(this.docList);
            this.txtMimeType.getDocument().removeDocumentListener(this.docList);
            this.listenersAttached = false;
        }
    }

    @Override
    protected void storeToDataModel() {
        this.data.setMimeType(this.txtMimeType.getText().trim());
        this.data.setExtensionBased(this.rbByExtension.isSelected());
        if (this.data.isExtensionBased()) {
            this.data.setExtension(this.txtExtension.getText().trim());
            this.data.setNamespace(null);
        } else {
            this.data.setExtension(null);
            this.data.setNamespace(this.txtNamespace.getText().trim());
        }
    }

    @Override
    protected void readFromDataModel() {
        String mime = this.data.getMimeType();
        if (mime == null) {
            mime = "";
        }
        this.txtMimeType.setText(mime);
        if (this.data.isExtensionBased()) {
            this.rbByExtension.setSelected(true);
        } else {
            this.rbByElement.setSelected(true);
        }
        this.txtExtension.setEnabled(this.rbByExtension.isSelected());
        this.txtNamespace.setEnabled(this.rbByElement.isSelected());
        this.txtExtension.setText(this.data.getExtension());
        this.txtNamespace.setText(this.data.getNamespace());
        this.checkValidity();
    }

    @Override
    protected String getPanelName() {
        return FileRecognitionPanel.getMessage("LBL_FileRecognition_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(FileRecognitionPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(FileRecognitionPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblMimeType = new JLabel();
        this.txtMimeType = new JTextField();
        this.rbByExtension = new JRadioButton();
        this.lblExtension = new JLabel();
        this.txtExtension = new JTextField();
        this.rbByElement = new JRadioButton();
        this.lblNamespace = new JLabel();
        this.txtNamespace = new JTextField();
        this.mimeTypeHint = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblMimeType.setLabelFor(this.txtMimeType);
        Mnemonics.setLocalizedText((JLabel)this.lblMimeType, (String)NbBundle.getMessage(FileRecognitionPanel.class, (String)"LBL_MimeType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblMimeType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtMimeType, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.rbByExtension, (String)NbBundle.getMessage(FileRecognitionPanel.class, (String)"LBL_ByExtension"));
        this.rbByExtension.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.rbByExtension, gridBagConstraints);
        this.lblExtension.setLabelFor(this.txtExtension);
        Mnemonics.setLocalizedText((JLabel)this.lblExtension, (String)NbBundle.getMessage(FileRecognitionPanel.class, (String)"LBL_Extension"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtExtension, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.rbByElement, (String)NbBundle.getMessage(FileRecognitionPanel.class, (String)"LBL_ByElement"));
        this.rbByElement.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.rbByElement, gridBagConstraints);
        this.lblNamespace.setLabelFor(this.txtNamespace);
        Mnemonics.setLocalizedText((JLabel)this.lblNamespace, (String)NbBundle.getMessage(FileRecognitionPanel.class, (String)"LBL_Element"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblNamespace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtNamespace, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.mimeTypeHint, (String)"(e.g. \"text/x-myformat\" or \"text/myformat+xml\" for XML)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.mimeTypeHint, gridBagConstraints);
        this.mimeTypeHint.getAccessibleContext().setAccessibleName("MIME Type Hint");
        this.mimeTypeHint.getAccessibleContext().setAccessibleDescription("MIME Type Hint");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_FileRecognitionPanel"));
        this.rbByElement.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_CTL_ByElement"));
        this.rbByExtension.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_CTL_ByExtension"));
        this.txtExtension.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_CTL_Extension"));
        this.txtNamespace.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_CTL_Namespace"));
        this.txtMimeType.getAccessibleContext().setAccessibleDescription(FileRecognitionPanel.getMessage("ACS_CTL_Mimetype"));
    }
}

