/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.codegenerator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ui.wizard.codegenerator.CodeGeneratorPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class NewCodeGeneratorIterator
extends BasicWizardIterator {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String[] HARDCODED_IMPORTS = new String[]{"java.util.Collections", "javax.swing.text.JTextComponent", "java.util.List", "org.openide.util.Lookup", "org.netbeans.spi.editor.codegen.CodeGenerator"};
    private static final String[] PROVIDER_HARDCODED_IMPORTS = new String[]{"org.netbeans.spi.editor.codegen.CodeGeneratorContextProvider", "org.openide.util.Lookup", "org.openide.util.lookup.Lookups", "org.openide.util.lookup.ProxyLookup"};
    private DataModel data;

    private static void createContextProvider(DataModel model, CreatedModifiedFiles cmf) {
        HashMap<String, String> cpReplaceTokens = new HashMap<String, String>();
        String providerFileName = model.getProviderFileName();
        cpReplaceTokens.put("CLASS_NAME", providerFileName);
        TreeSet<String> cpImports = new TreeSet<String>(Arrays.asList(PROVIDER_HARDCODED_IMPORTS));
        StringBuffer cpImportsBuffer = new StringBuffer();
        for (String imprt : cpImports) {
            cpImportsBuffer.append("import " + imprt + ';' + lineSep);
        }
        String cpFileName = model.getProviderFileName();
        cpReplaceTokens.put("CLASS_NAME", cpFileName);
        cpReplaceTokens.put("PACKAGE_NAME", model.getPackageName());
        String cpActionPath = model.getDefaultPackagePath(providerFileName + ".java", false);
        FileObject cpTemplate = CreatedModifiedFiles.getTemplate("contextProvider.java");
        cpReplaceTokens.put("IMPORTS", cpImportsBuffer.toString());
        cmf.add(cmf.createFileWithSubstitutions(cpActionPath, cpTemplate, cpReplaceTokens));
        String cpCategory = "Editors/text/" + model.getMimeType() + "/CodeGeneratorContextProviders";
        String cpDashedPkgName = model.getPackageName().replace('.', '-');
        String cpDashedFqClassName = cpDashedPkgName + '-' + cpFileName;
        String cpInstanceFullPath = cpCategory + "/" + cpDashedFqClassName + ".instance";
        cmf.add(cmf.createLayerEntry(cpInstanceFullPath, null, null, null, null));
    }

    static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles cmf = new CreatedModifiedFiles(model.getProject());
        cmf.add(cmf.addModuleDependency("org.netbeans.modules.editor.lib2"));
        cmf.add(cmf.addModuleDependency("org.openide.util"));
        String fileName = model.getFileName();
        FileObject template = CreatedModifiedFiles.getTemplate("codeGenerator.java");
        assert (template != null);
        String actionPath = model.getDefaultPackagePath(fileName + ".java", false);
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CLASS_NAME", fileName);
        replaceTokens.put("PACKAGE_NAME", model.getPackageName());
        TreeSet<String> imports = new TreeSet<String>(Arrays.asList(HARDCODED_IMPORTS));
        StringBuffer importsBuffer = new StringBuffer();
        for (String imprt : imports) {
            importsBuffer.append("import " + imprt + ';' + lineSep);
        }
        replaceTokens.put("IMPORTS", importsBuffer.toString());
        cmf.add(cmf.createFileWithSubstitutions(actionPath, template, replaceTokens));
        String category = model.getMimeType().contains("/") ? "Editors/" + model.getMimeType() + "/CodeGenerators" : "Editors/text/" + model.getMimeType() + "/CodeGenerators";
        String dashedPkgName = model.getPackageName().replace('.', '-');
        String dashedFqClassName = dashedPkgName + '-' + fileName;
        String instanceFullPath = category + "/" + dashedFqClassName + "$Factory.instance";
        cmf.add(cmf.createLayerEntry(instanceFullPath, null, null, null, null));
        if (model.isContextProviderRequired()) {
            NewCodeGeneratorIterator.createContextProvider(model, cmf);
        }
        model.setCreatedModifiedFiles(cmf);
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new CodeGeneratorPanel(wiz, this.data)};
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewCodeGeneratorIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private CreatedModifiedFiles files;
        private String mimeType;
        private String fileName;
        private String providerFileName;
        private boolean contextProviderRequired;

        public DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        void setFileName(String fileName) {
            this.fileName = fileName;
        }

        void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getProviderFileName() {
            return this.providerFileName;
        }

        public boolean isContextProviderRequired() {
            return this.contextProviderRequired;
        }

        public void setContextProviderRequired(boolean req) {
            this.contextProviderRequired = req;
        }

        public void setProviderFileName(String fileName) {
            this.providerFileName = fileName;
        }
    }
}

