/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PlatformTypes;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.spi.toolchain.CompilerProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class CompilerSetPreferences {
    private static final String csm_version = "1.2";
    private static final String CSM = "csm.";
    private static final String VERSION = "version";
    private static final String NO_SETS = ".noOfSets";
    private static final String SET_NAME = ".setName.";
    private static final String SET_FLAVOR = ".setFlavor.";
    private static final String SET_DIRECTORY = ".setDirectory.";
    private static final String SET_ENCODING = ".setEncoding.";
    private static final String SET_AUTO = ".autoGenerated.";
    private static final String SET_DEFAULT = ".defaultSet";
    private static final String SET_PLATFORM = ".setPlatform.";
    private static final String NO_TOOLS = ".noOfTools.";
    private static final String TOOL_NAME = ".toolName.";
    private static final String TOOL_DISPLAYNAME = ".toolDisplayName.";
    private static final String TOOL_KIND = ".toolKind.";
    private static final String TOOL_PATH = ".toolPath.";
    private static final String TOOL_FLAVOR = ".toolFlavor.";
    private static final String TOOL_SETTINGS = ".toolSettings.";
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    public static final String VERSION_KEY = "csm.version";
    private static CompilerProvider compilerProvider = null;

    private CompilerSetPreferences() {
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(CompilerSetPreferences.class);
    }

    public static void putEnv(ExecutionEnvironment executionEnvironment, int platform) {
        CompilerSetPreferences.getPreferences().putInt(CSM + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment) + SET_PLATFORM, platform);
    }

    public static void storeExecutionEnvironmentList(List<ExecutionEnvironment> liveServers) {
        if (liveServers == null) {
            return;
        }
        try {
            ArrayList<String> keys = new ArrayList<String>();
            for (ExecutionEnvironment env : liveServers) {
                String key = CSM + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + ".";
                keys.add(key);
                log.log(Level.FINE, "CSM.storeExecutionEnvironmentList: host = {0}", env);
            }
            CompilerSetPreferences.getPreferences().remove(VERSION_KEY);
            block3: for (String key : CompilerSetPreferences.getPreferences().keys()) {
                if (!key.startsWith(CSM)) continue;
                for (String start : keys) {
                    if (!key.startsWith(start)) continue;
                    continue block3;
                }
                log.log(Level.FINE, "CSM.storeExecutionEnvironmentList: remove {0}={1}", new Object[]{key, CompilerSetPreferences.getPreferences().get(key, "")});
                CompilerSetPreferences.getPreferences().remove(key);
            }
            CompilerSetPreferences.getPreferences().put(VERSION_KEY, csm_version);
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void clearPersistence(ExecutionEnvironment env) {
        try {
            String aKey = CSM + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + ".";
            for (String key : CompilerSetPreferences.getPreferences().keys()) {
                if (!key.startsWith(aKey)) continue;
                CompilerSetPreferences.getPreferences().remove(key);
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void saveToDisk(CompilerSetManagerImpl manager) {
        log.log(Level.FINE, "CSM.Save to disk {0} size={1}", new Object[]{manager.getExecutionEnvironment(), manager.getCompilerSets().size()});
        if (!manager.getCompilerSets().isEmpty()) {
            CompilerSetPreferences.clearPersistence(manager.getExecutionEnvironment());
            CompilerSetPreferences.getPreferences().put(VERSION_KEY, csm_version);
            String executionEnvironmentKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)manager.getExecutionEnvironment());
            CompilerSetPreferences.getPreferences().putInt(CSM + executionEnvironmentKey + NO_SETS, manager.getCompilerSets().size());
            CompilerSetPreferences.getPreferences().putInt(CSM + executionEnvironmentKey + SET_PLATFORM, manager.getPlatform());
            int setCount = 0;
            for (CompilerSet cs : manager.getCompilerSets()) {
                CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + SET_NAME + setCount, cs.getName());
                CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + SET_FLAVOR + setCount, cs.getCompilerFlavor().toString());
                CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + SET_DIRECTORY + setCount, cs.getDirectory());
                CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + SET_ENCODING + setCount, cs.getEncoding().name());
                CompilerSetPreferences.getPreferences().putBoolean(CSM + executionEnvironmentKey + SET_AUTO + setCount, cs.isAutoGenerated());
                CompilerSetPreferences.getPreferences().putBoolean(CSM + executionEnvironmentKey + SET_DEFAULT + setCount, manager.isDefaultCompilerSet(cs));
                List<Tool> tools = cs.getTools();
                CompilerSetPreferences.getPreferences().putInt(CSM + executionEnvironmentKey + NO_TOOLS + setCount, tools.size());
                int toolCount = 0;
                for (Tool tool : tools) {
                    CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + TOOL_NAME + setCount + '.' + toolCount, tool.getName());
                    CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + TOOL_DISPLAYNAME + '-' + setCount + '.' + toolCount, tool.getDisplayName());
                    CompilerSetPreferences.getPreferences().putInt(CSM + executionEnvironmentKey + TOOL_KIND + setCount + '.' + toolCount, tool.getKind().ordinal());
                    CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + TOOL_PATH + setCount + '.' + toolCount, tool.getPath());
                    CompilerSetPreferences.getPreferences().put(CSM + executionEnvironmentKey + TOOL_FLAVOR + setCount + '.' + toolCount, tool.getFlavor().toString());
                    if (tool instanceof AbstractCompiler) {
                        ((AbstractCompiler)tool).saveSettings(CompilerSetPreferences.getPreferences(), CSM + executionEnvironmentKey + TOOL_SETTINGS + setCount + '.' + toolCount);
                    }
                    ++toolCount;
                }
                ++setCount;
            }
        }
    }

    public static CompilerSetManagerImpl restoreFromDisk(ExecutionEnvironment env) {
        String version = CompilerSetPreferences.getPreferences().get(VERSION_KEY, "1.0");
        if ("1.0".equals(version) && env.isLocal()) {
            return CompilerSetPreferences.restoreFromDisk10();
        }
        String executionEnvironmentKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        int noSets = CompilerSetPreferences.getPreferences().getInt(CSM + executionEnvironmentKey + NO_SETS, -1);
        log.log(Level.FINE, "CSM.Restore from disk {0} size={1}", new Object[]{env, noSets});
        if (noSets < 0) {
            return null;
        }
        int pform = CompilerSetPreferences.getPreferences().getInt(CSM + executionEnvironmentKey + SET_PLATFORM, -1);
        if (pform < 0) {
            if (env.isLocal()) {
                pform = ToolUtils.computeLocalPlatform();
            }
        } else if (env.isLocal() && pform != ToolUtils.computeLocalPlatform()) {
            return null;
        }
        ArrayList<CompilerSet> css = new ArrayList<CompilerSet>();
        for (int setCount = 0; setCount < noSets; ++setCount) {
            Charset charset;
            String setName = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + SET_NAME + setCount, null);
            String setFlavorName = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + SET_FLAVOR + setCount, null);
            CompilerFlavor flavor = null;
            if (setFlavorName != null) {
                flavor = CompilerFlavorImpl.toFlavor(setFlavorName, pform);
            }
            String setDirectory = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + SET_DIRECTORY + setCount, null);
            if (setName == null || setFlavorName == null || flavor == null) continue;
            String setEncoding = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + SET_ENCODING + setCount, null);
            Boolean auto = CompilerSetPreferences.getPreferences().getBoolean(CSM + executionEnvironmentKey + SET_AUTO + setCount, false);
            Boolean isDefault = CompilerSetPreferences.getPreferences().getBoolean(CSM + executionEnvironmentKey + SET_DEFAULT + setCount, false);
            CompilerSetImpl cs = new CompilerSetImpl(flavor, setDirectory, setName);
            cs.setAutoGenerated(auto);
            cs.setAsDefault(isDefault);
            if (setEncoding != null && (charset = Charset.forName(setEncoding)) != null) {
                cs.setEncoding(charset);
            }
            int noTools = CompilerSetPreferences.getPreferences().getInt(CSM + executionEnvironmentKey + NO_TOOLS + setCount, -1);
            for (int toolCount = 0; toolCount < noTools; ++toolCount) {
                String toolName = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + TOOL_NAME + setCount + '.' + toolCount, null);
                String toolDisplayName = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + TOOL_DISPLAYNAME + '-' + setCount + '.' + toolCount, null);
                int toolKind = CompilerSetPreferences.getPreferences().getInt(CSM + executionEnvironmentKey + TOOL_KIND + setCount + '.' + toolCount, -1);
                String toolPath = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + TOOL_PATH + setCount + '.' + toolCount, null);
                String toolFlavorName = CompilerSetPreferences.getPreferences().get(CSM + executionEnvironmentKey + TOOL_FLAVOR + setCount + '.' + toolCount, null);
                CompilerFlavor toolFlavor = null;
                if (toolFlavorName != null) {
                    toolFlavor = CompilerFlavorImpl.toFlavor(toolFlavorName, pform);
                }
                Tool tool = null;
                if (toolFlavor != null) {
                    tool = CompilerSetPreferences.getCompilerProvider().createCompiler(env, toolFlavor, PredefinedToolKind.getTool(toolKind), toolName, toolDisplayName, toolPath);
                }
                if (tool instanceof AbstractCompiler) {
                    ((AbstractCompiler)tool).loadSettings(CompilerSetPreferences.getPreferences(), CSM + executionEnvironmentKey + TOOL_SETTINGS + setCount + '.' + toolCount);
                }
                if (tool == null) continue;
                cs.addTool(tool);
            }
            css.add(cs);
        }
        CompilerSetManagerImpl csm = new CompilerSetManagerImpl(env, css, pform);
        return csm;
    }

    private static CompilerSetManagerImpl restoreFromDisk10() {
        int noSets = CompilerSetPreferences.getPreferences().getInt("csm..noOfSets", -1);
        if (noSets < 0) {
            return null;
        }
        ArrayList<CompilerSet> css = new ArrayList<CompilerSet>();
        CompilerSetPreferences.getPreferences().remove("csm..noOfSets");
        for (int setCount = 0; setCount < noSets; ++setCount) {
            String setName = CompilerSetPreferences.getPreferences().get("csm..setName." + setCount, null);
            CompilerSetPreferences.getPreferences().remove("csm..setName." + setCount);
            String setFlavorName = CompilerSetPreferences.getPreferences().get("csm..setFlavor." + setCount, null);
            CompilerSetPreferences.getPreferences().remove("csm..setFlavor." + setCount);
            CompilerFlavor flavor = null;
            if (setFlavorName != null) {
                flavor = CompilerFlavorImpl.toFlavor(setFlavorName, PlatformTypes.getDefaultPlatform());
            }
            String setDirectory = CompilerSetPreferences.getPreferences().get("csm..setDirectory." + setCount, null);
            CompilerSetPreferences.getPreferences().remove("csm..setDirectory." + setCount);
            if (setName == null || setFlavorName == null || flavor == null) continue;
            Boolean auto = CompilerSetPreferences.getPreferences().getBoolean("csm..autoGenerated." + setCount, false);
            CompilerSetPreferences.getPreferences().remove("csm..autoGenerated." + setCount);
            CompilerSetImpl cs = new CompilerSetImpl(flavor, setDirectory, setName);
            cs.setAutoGenerated(auto);
            int noTools = CompilerSetPreferences.getPreferences().getInt("csm..noOfTools." + setCount, -1);
            CompilerSetPreferences.getPreferences().remove("csm..noOfTools." + setCount);
            for (int toolCount = 0; toolCount < noTools; ++toolCount) {
                String toolName = CompilerSetPreferences.getPreferences().get("csm..toolName." + setCount + '.' + toolCount, null);
                String toolDisplayName = CompilerSetPreferences.getPreferences().get("csm..toolDisplayName.-" + setCount + '.' + toolCount, null);
                int toolKind = CompilerSetPreferences.getPreferences().getInt("csm..toolKind." + setCount + '.' + toolCount, -1);
                String toolPath = CompilerSetPreferences.getPreferences().get("csm..toolPath." + setCount + '.' + toolCount, null);
                String toolFlavorName = CompilerSetPreferences.getPreferences().get("csm..toolFlavor." + setCount + '.' + toolCount, null);
                CompilerSetPreferences.getPreferences().remove("csm..toolName." + setCount + '.' + toolCount);
                CompilerSetPreferences.getPreferences().remove("csm..toolDisplayName.-" + setCount + '.' + toolCount);
                CompilerSetPreferences.getPreferences().remove("csm..toolKind." + setCount + '.' + toolCount);
                CompilerSetPreferences.getPreferences().remove("csm..toolPath." + setCount + '.' + toolCount);
                CompilerSetPreferences.getPreferences().remove("csm..toolFlavor." + setCount + '.' + toolCount);
                CompilerFlavor toolFlavor = null;
                if (toolFlavorName != null) {
                    toolFlavor = CompilerFlavorImpl.toFlavor(toolFlavorName, PlatformTypes.getDefaultPlatform());
                }
                Tool tool = null;
                if (toolFlavor != null) {
                    tool = CompilerSetPreferences.getCompilerProvider().createCompiler(ExecutionEnvironmentFactory.getLocal(), toolFlavor, PredefinedToolKind.getTool(toolKind), toolName, toolDisplayName, toolPath);
                }
                if (tool == null) continue;
                cs.addTool(tool);
            }
            CompilerSetManagerImpl.completeCompilerSet(ExecutionEnvironmentFactory.getLocal(), cs, css);
            css.add(cs);
        }
        CompilerSetManagerImpl csm = new CompilerSetManagerImpl(ExecutionEnvironmentFactory.getLocal(), css, ToolUtils.computeLocalPlatform());
        return csm;
    }

    public static CompilerProvider getCompilerProvider() {
        if (compilerProvider == null) {
            compilerProvider = CompilerProvider.getInstance();
        }
        return compilerProvider;
    }
}

