/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.project.NewJavaFileWizardIterator;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_NewJavaClassPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final NewJavaFileWizardIterator.Type type;
    private SourceGroup[] groups;
    private boolean ignoreRootCombo;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_PleaseWait")});

    public JavaTargetChooserPanelGUI(Project p, SourceGroup[] groups, Component bottomPanel, NewJavaFileWizardIterator.Type type) {
        Component packageEditor;
        this.type = type;
        this.project = p;
        this.groups = groups;
        for (SourceGroup sourceGroup : groups) {
            if (sourceGroup != null) continue;
            throw new NullPointerException();
        }
        this.initComponents();
        if (type == NewJavaFileWizardIterator.Type.PACKAGE) {
            this.packageComboBox.setVisible(false);
            this.packageLabel.setVisible(false);
            Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFolder_Label"));
            Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_Label"));
            this.documentNameTextField.getDocument().addDocumentListener(this);
        } else if (type == NewJavaFileWizardIterator.Type.PKG_INFO) {
            this.documentNameTextField.setEditable(false);
        } else {
            this.packageComboBox.getEditor().addActionListener(this);
            this.documentNameTextField.getDocument().addDocumentListener(this);
        }
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        if ((packageEditor = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(JavaTargetChooserPanelGUI.class).getString("LBL_JavaTargetChooserPanelGUI_Name"));
    }

    @Override
    public void addNotify() {
        Dimension panel2Size = this.jPanel2.getPreferredSize();
        Dimension bottomPanelSize = this.bottomPanelContainer.getPreferredSize();
        Dimension splitterSize = this.targetSeparator.getPreferredSize();
        int vmax = panel2Size.height + bottomPanelSize.height + splitterSize.height + 12;
        if (vmax > JavaTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(JavaTargetChooserPanelGUI.PREF_DIM.width, vmax));
        }
        super.addNotify();
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        String baseName;
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (template != null);
        String displayName = null;
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        SourceGroup preselectedGroup = this.getPreselectedGroup(preselectedFolder);
        this.ignoreRootCombo = true;
        this.rootComboBox.setSelectedItem(preselectedGroup);
        this.ignoreRootCombo = false;
        Object preselectedPackage = this.getPreselectedPackage(preselectedGroup, preselectedFolder, this.packageComboBox.getModel());
        if (this.type == NewJavaFileWizardIterator.Type.PACKAGE) {
            String activeName = baseName = DEFAULT_NEW_PACKAGE_NAME;
            if (preselectedFolder != null) {
                FileObject _tmp;
                int index = 0;
                while ((_tmp = preselectedFolder.getFileObject(activeName, null)) != null) {
                    activeName = baseName + ++index;
                }
            }
            String docName = preselectedPackage == null || preselectedPackage.toString().length() == 0 ? activeName : preselectedPackage.toString() + "." + activeName;
            this.documentNameTextField.setText(docName);
            int docNameLen = docName.length();
            int defPackageNameLen = activeName.length();
            this.documentNameTextField.setSelectionEnd(docNameLen - 1);
            this.documentNameTextField.setSelectionStart(docNameLen - defPackageNameLen);
        } else {
            if (preselectedPackage != null) {
                this.packageComboBox.getEditor().setItem(preselectedPackage);
            }
            if (template != null && this.documentNameTextField.getText().trim().length() == 0) {
                if (this.type == NewJavaFileWizardIterator.Type.PKG_INFO) {
                    this.documentNameTextField.setText(template.getName());
                } else {
                    String activeName = baseName = NEW_CLASS_PREFIX + template.getName();
                    if (preselectedFolder != null) {
                        FileObject _tmp;
                        int index = 0;
                        while ((_tmp = preselectedFolder.getFileObject(activeName, template.getExt())) != null) {
                            activeName = baseName + ++index;
                        }
                    }
                    this.documentNameTextField.setText(activeName);
                    this.documentNameTextField.selectAll();
                }
            }
            this.updatePackages();
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        this.updateText();
    }

    public FileObject getRootFolder() {
        Object selectedItem = this.rootComboBox.getSelectedItem();
        return selectedItem instanceof SourceGroup ? ((SourceGroup)selectedItem).getRootFolder() : null;
    }

    public String getPackageFileName() {
        if (this.type == NewJavaFileWizardIterator.Type.PACKAGE) {
            return "";
        }
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        if (this.type == NewJavaFileWizardIterator.Type.PACKAGE) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_rootComboBox"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_packageComboBox"));
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_JavaTargetChooserPanelGUI"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rootComboBox == e.getSource()) {
            if (!this.ignoreRootCombo && this.type != NewJavaFileWizardIterator.Type.PACKAGE) {
                this.updatePackages();
            }
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages() {
        final Object item = this.rootComboBox.getSelectedItem();
        if (!(item instanceof SourceGroup)) {
            return;
        }
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){

            @Override
            public void run() {
                final ComboBoxModel model = PackageView.createListView((SourceGroup)item);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        model.setSelectedItem(JavaTargetChooserPanelGUI.this.packageComboBox.getEditor().getItem());
                        JavaTargetChooserPanelGUI.this.packageComboBox.setModel(model);
                    }
                });
            }
        });
    }

    private void updateText() {
        String createdFileName;
        Object selectedItem = this.rootComboBox.getSelectedItem();
        if (selectedItem instanceof SourceGroup) {
            SourceGroup g = (SourceGroup)selectedItem;
            FileObject rootFolder = g.getRootFolder();
            String packageName = this.getPackageFileName();
            String documentName = this.documentNameTextField.getText().trim();
            if (this.type == NewJavaFileWizardIterator.Type.PACKAGE) {
                documentName = documentName.replace('.', '/');
            } else if (documentName.length() > 0) {
                documentName = documentName + this.expectedExtension;
            }
            createdFileName = FileUtil.getFileDisplayName((FileObject)rootFolder) + (packageName.startsWith("/") || packageName.startsWith(File.separator) ? "" : "/") + packageName + (packageName.endsWith("/") || packageName.endsWith(File.separator) || packageName.length() == 0 ? "" : "/") + documentName;
        } else {
            createdFileName = "";
        }
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
    }

    private SourceGroup getPreselectedGroup(FileObject folder) {
        for (int i = 0; folder != null && i < this.groups.length; ++i) {
            FileObject root = this.groups[i].getRootFolder();
            if (!root.equals(folder) && !FileUtil.isParentOf((FileObject)root, (FileObject)folder)) continue;
            return this.groups[i];
        }
        return this.groups[0];
    }

    private Object getPreselectedPackage(SourceGroup group, FileObject folder, ListModel model) {
        if (folder == null) {
            return null;
        }
        FileObject root = group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        if (relPath == null) {
            return null;
        }
        String name = relPath.replace('/', '.');
        return name;
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            String name;
            if (value == null) {
                name = "";
                icon = null;
            } else {
                assert (value instanceof SourceGroup);
                SourceGroup g = (SourceGroup)value;
                name = g.getDisplayName();
                icon = g.getIcon(false);
            }
            super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return this;
        }
    }
}

