/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    public String name = "";
    public String qualifier = "";

    public abstract Writer buildCreationWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public abstract Writer buildDeletionWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public void createObject(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        if (schemaWriter == null) {
            this.createOnDatabase(session);
        } else {
            this.buildCreationWriter(session, schemaWriter);
        }
    }

    public void createOnDatabase(AbstractSession session) throws TopLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildCreationWriter(session, new StringWriter()).toString()));
    }

    public void dropFromDatabase(AbstractSession session) throws TopLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildDeletionWriter(session, new StringWriter()).toString()));
    }

    public void dropObject(AbstractSession session, Writer schemaWriter) throws TopLinkException {
        if (schemaWriter == null) {
            this.dropFromDatabase(session);
        } else {
            this.buildDeletionWriter(session, schemaWriter);
        }
    }

    public String getFullName() {
        if (this.getQualifier().equals("")) {
            return this.getName();
        }
        return this.getQualifier() + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getFullName() + ")";
    }
}

