/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ChangeParametersPanel
extends JPanel
implements CustomRefactoringPanel {
    private final CsmObject selectedElement;
    private CsmFunction functionObj;
    private ParamTableModel model;
    private ChangeListener parent;
    private static final String DEFAULT_VALUES_ONLY_IN_DECLARATION = "UseDefaultValueOnlyInFunctionDefinition";
    private static Action editAction = null;
    private String returnType;
    private static final String[] modifierNames = new String[]{"public", "protected", "private", "<default>"};
    static final int PARAM_NAME = 0;
    static final int PARAM_TYPE = 1;
    static final int PARAM_VALUE = 2;
    static final int PARAM_ORIG_INDEX = 3;
    static final int PARAM_USED = 4;
    private static final String[] columnNames = new String[]{ChangeParametersPanel.getString("LBL_ChangeParsColName"), ChangeParametersPanel.getString("LBL_ChangeParsColType"), ChangeParametersPanel.getString("LBL_ChangeParsColDefVal"), ChangeParametersPanel.getString("LBL_ChangeParsColOrigIdx"), ChangeParametersPanel.getString("LBL_ChangeParsParUsed")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_PRIVATE_INDEX = 2;
    private static final int MOD_DEFAULT_INDEX = 3;
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private boolean initialized = false;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JCheckBox defaultsOnlyInFunDeclaration;
    private JPanel eastPanel;
    private JPanel fillPanel;
    private JComboBox modifiersCombo;
    private JLabel modifiersLabel;
    private JPanel modifiersPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JTable paramTable;
    private JLabel paramTitle;
    private JLabel previewChange;
    private JButton removeButton;
    private JScrollPane westPanel;
    private CsmVisibility modifier = CsmVisibility.NONE;

    public Component getComponent() {
        return this;
    }

    public ChangeParametersPanel(CsmObject selectedObj, CsmContext editorContext, ChangeListener parent) {
        this.selectedElement = selectedObj == null ? editorContext.getEnclosingFunction() : selectedObj;
        this.parent = parent;
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
        this.defaultsOnlyInFunDeclaration.setSelected(this.isUseDefaultValueOnlyInFunctionDeclaration());
    }

    public void initialize() {
        CsmFunction fun;
        if (this.initialized) {
            return;
        }
        this.functionObj = fun = ((CsmFunction)CsmRefactoringUtils.getReferencedElement(this.selectedElement)).getDeclaration();
        this.returnType = ((Object)this.functionObj.getReturnType().getCanonicalText()).toString();
        if (CsmKindUtilities.isMethod((CsmObject)this.functionObj)) {
            CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)this.functionObj);
            this.setModifier(method.getVisibility());
        } else {
            this.setModifier(CsmVisibility.NONE);
        }
        this.modifiersCombo.setEnabled(false);
        this.initTableData();
        this.previewChange.setText(this.genDeclarationString());
        this.initialized = true;
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    protected CsmVisibility getModifier() {
        int index = this.modifiersCombo.getSelectedIndex();
        switch (index) {
            case 2: {
                return CsmVisibility.PRIVATE;
            }
            case 3: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PROTECTED;
            }
            case 0: {
                return CsmVisibility.PUBLIC;
            }
        }
        assert (false) : "unexpected index:" + index;
        return CsmVisibility.NONE;
    }

    protected boolean isUseDefaultValueOnlyInFunctionDeclaration() {
        return NbPreferences.forModule(ChangeParametersPanel.class).getBoolean(DEFAULT_VALUES_ONLY_IN_DECLARATION, false);
    }

    private void initComponents() {
        this.modifiersPanel = new JPanel();
        this.modifiersLabel = new JLabel();
        this.modifiersCombo = new JComboBox();
        this.defaultsOnlyInFunDeclaration = new JCheckBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.paramTitle = new JLabel();
        this.previewChange = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setAutoscrolls(true);
        this.setName(ChangeParametersPanel.getString("LBL_TitleChangeParameters"));
        this.setLayout(new GridBagLayout());
        this.modifiersPanel.setLayout(new GridBagLayout());
        this.modifiersLabel.setLabelFor(this.modifiersCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/refactoring/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.modifiersLabel, (String)bundle.getString("LBL_ChangeParsMods"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.modifiersPanel.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersCombo.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.modifiersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.modifiersComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.modifiersPanel.add((Component)this.modifiersCombo, gridBagConstraints);
        this.modifiersCombo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_modifiersCombo"));
        Mnemonics.setLocalizedText((AbstractButton)this.defaultsOnlyInFunDeclaration, (String)NbBundle.getMessage(ChangeParametersPanel.class, (String)"ChangeParametersPanel.defaultsOnlyInFunDeclaration.text"));
        this.defaultsOnlyInFunDeclaration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.defaultsOnlyInFunDeclarationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.modifiersPanel.add((Component)this.defaultsOnlyInFunDeclaration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.modifiersPanel, gridBagConstraints);
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("LBL_ChangeParsAdd"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsAdd"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("LBL_ChangeParsRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsRemove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)bundle.getString("LBL_ChangeParsMoveUp"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsMoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)bundle.getString("LBL_ChangeParsMoveDown"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeParametersPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsMoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, ChangeParametersPanel.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.paramTitle.setHorizontalAlignment(2);
        this.paramTitle.setLabelFor(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.paramTitle, (String)bundle.getString("LBL_ChangeParsParameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.paramTitle, gridBagConstraints);
        this.previewChange.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle(ChangeParametersPanel.class).getString("LBL_ChangeParsPreview")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.previewChange, gridBagConstraints);
    }

    private void modifiersComboActionPerformed(ActionEvent evt) {
        this.previewChange.setText(this.genDeclarationString());
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.acceptEditedValue();
        int[] selectedRows = this.paramTable.getSelectedRows();
        ListSelectionModel selectionModel = this.paramTable.getSelectionModel();
        for (int i = 0; i < selectedRows.length; ++i) {
            boolean b = (Boolean)this.model.getDataVector().get(selectedRows[i] - i).get(4);
            if (!b) {
                String title = ChangeParametersPanel.getString("LBL_ChangeParsCannotDeleteTitle");
                String mes = MessageFormat.format(ChangeParametersPanel.getString("LBL_ChangeParsCannotDelete"), this.model.getDataVector().get(selectedRows[i] - i).get(0));
                int a = JOptionPane.showConfirmDialog(this, mes, title, 0);
                if (a != 0) continue;
                this.model.removeRow(selectedRows[i] - i);
                selectionModel.clearSelection();
                continue;
            }
            this.model.removeRow(selectedRows[i] - i);
            selectionModel.clearSelection();
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.doMove(-1);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.acceptEditedValue();
        int rowCount = this.model.getRowCount();
        this.model.addRow(new Object[]{"par" + rowCount, "int", "0", -1, Boolean.TRUE});
    }

    private void defaultsOnlyInFunDeclarationActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(ChangeParametersPanel.class).putBoolean(DEFAULT_VALUES_ONLY_IN_DECLARATION, this.defaultsOnlyInFunDeclaration.isSelected());
        this.previewChange.setText(this.genDeclarationString());
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    ChangeParametersPanel.this.setButtons(minIndex, maxIndex);
                    boolean enableRemoveBtn = true;
                    for (int i = minIndex; i <= maxIndex && (enableRemoveBtn = ChangeParametersPanel.this.model.isRemovable(i)); ++i) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(enableRemoveBtn);
                } else {
                    ChangeParametersPanel.this.moveDownButton.setEnabled(false);
                    ChangeParametersPanel.this.moveUpButton.setEnabled(false);
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int[] selectedRows = ChangeParametersPanel.this.paramTable.getSelectedRows();
                if (selectedRows.length == 0) {
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                } else {
                    boolean enableRemoveBtn = true;
                    for (int i = 0; i < selectedRows.length && (selectedRows[i] >= ChangeParametersPanel.this.model.getRowCount() || (enableRemoveBtn = ChangeParametersPanel.this.model.isCellEditable(selectedRows[i], 0))); ++i) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(enableRemoveBtn);
                    int min = selectedRows[0];
                    int max = selectedRows[selectedRows.length - 1];
                    ChangeParametersPanel.this.setButtons(min, max);
                }
                ChangeParametersPanel.this.previewChange.setText(ChangeParametersPanel.this.genDeclarationString());
                ChangeParametersPanel.this.parent.stateChanged(null);
            }
        };
    }

    private void initTableData() {
        Collection pars = this.functionObj.getParameters();
        ArrayList<CsmType> typeList = new ArrayList<CsmType>();
        for (CsmParameter par : pars) {
            typeList.add(par.getType());
        }
        LinkedHashSet<CsmFunction> allMethods = new LinkedHashSet<CsmFunction>();
        allMethods.add(this.functionObj);
        if (CsmKindUtilities.isMethod((CsmObject)this.functionObj)) {
            CsmMethod method = (CsmMethod)this.functionObj;
            if (CsmVirtualInfoQuery.getDefault().isVirtual(method)) {
                allMethods.addAll(CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true));
                assert (!allMethods.isEmpty()) : "must be at least start object " + method;
            }
        }
        LinkedHashSet<Object> allFunctions = new LinkedHashSet<Object>();
        for (CsmFunction csmFunction : allMethods) {
            CsmFunctionDefinition definition = csmFunction.getDefinition();
            if (definition != null) {
                allFunctions.add(definition);
                continue;
            }
            allFunctions.add(csmFunction);
        }
        for (CsmFunction csmFunction : allFunctions) {
            int originalIndex = 0;
            CsmFile containingFile = csmFunction.getContainingFile();
            for (CsmParameter par : csmFunction.getParameters()) {
                CsmType desc = par.getType();
                String typeRepresentation = par.isVarArgs() && originalIndex == pars.size() - 1 ? "..." : ChangeParametersPanel.getTypeStringRepresentation(desc);
                Collection<Object> references = Collections.emptySet();
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction)) {
                    references = CsmReferenceRepository.getDefault().getReferences((CsmObject)par, containingFile, CsmReferenceKind.ALL, null);
                }
                Boolean removable = references.size() <= 1;
                if (this.model.getRowCount() <= originalIndex) {
                    Object[] parRep = new Object[]{((Object)par.getName()).toString(), typeRepresentation, "", originalIndex, removable};
                    this.model.addRow(parRep);
                } else {
                    removable = this.model.isRemovable(originalIndex) && removable != false;
                    Vector data = this.model.getDataVector().get(originalIndex);
                    data.set(4, removable);
                }
                ++originalIndex;
            }
        }
    }

    private static String getTypeStringRepresentation(CsmType desc) {
        return ((Object)desc.getCanonicalText()).toString();
    }

    private boolean acceptEditedValue() {
        TableCellEditor tce = this.paramTable.getCellEditor();
        if (tce != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int step) {
        this.acceptEditedValue();
        ListSelectionModel selectionModel = this.paramTable.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        selectionModel.clearSelection();
        this.model.moveRow(min, max, min + step);
        selectionModel.addSelectionInterval(min + step, max + step);
    }

    private void setButtons(int min, int max) {
        int r = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(min > 0);
        this.moveDownButton.setEnabled(max < r);
    }

    private void initRenderer() {
        TableColumnModel tcm = this.paramTable.getColumnModel();
        this.paramTable.removeColumn(tcm.getColumn(3));
        this.paramTable.removeColumn(tcm.getColumn(3));
        Enumeration<TableColumn> columns = this.paramTable.getColumnModel().getColumns();
        TableColumn tc = null;
        while (columns.hasMoreElements()) {
            tc = columns.nextElement();
            tc.setCellRenderer(new ParamRenderer());
        }
    }

    private void setModifier(CsmVisibility visibility) {
        this.modifier = visibility;
        switch (visibility) {
            case NONE: {
                this.modifiersCombo.setSelectedIndex(3);
                break;
            }
            case PRIVATE: {
                this.modifiersCombo.setSelectedIndex(2);
                break;
            }
            case PROTECTED: {
                this.modifiersCombo.setSelectedIndex(1);
                break;
            }
            case PUBLIC: {
                this.modifiersCombo.setSelectedIndex(0);
            }
        }
    }

    public String genDeclarationString() {
        String name;
        String mod = this.modifiersCombo.getSelectedIndex() != 3 ? (String)this.modifiersCombo.getSelectedItem() + ":" : "";
        StringBuilder buf = new StringBuilder(mod);
        boolean defValueInDecl = this.defaultsOnlyInFunDeclaration.isSelected();
        if (CsmKindUtilities.isConstructor((CsmObject)this.functionObj)) {
            buf.append(' ');
            name = CsmRefactoringUtils.getSimpleText((CsmObject)this.functionObj);
        } else {
            buf.append(this.returnType);
            buf.append(' ');
            name = CsmRefactoringUtils.getSimpleText((CsmObject)this.functionObj);
        }
        buf.append(name);
        buf.append('(');
        Vector<Vector> data = this.model.getDataVector();
        List[] parameters = data.toArray(new List[0]);
        for (int i = 0; i < parameters.length; ++i) {
            buf.append(parameters[i].get(1));
            buf.append(' ');
            buf.append(parameters[i].get(0));
            if (defValueInDecl) {
                String defParam = (String)parameters[i].get(2);
                if ((defParam = defParam.trim()) != null && defParam.length() > 0) {
                    buf.append(" /* = ").append(defParam).append(" */");
                }
            }
            if (i >= parameters.length - 1) continue;
            buf.append(',').append(' ');
        }
        buf.append(')');
        return buf.toString();
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPanel.class, (String)key);
    }

    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    private static void autoEdit(JTable tab) {
        if (tab.editCellAt(tab.getSelectedRow(), tab.getSelectedColumn(), null) && tab.getEditorComponent() != null) {
            JTextField field = (JTextField)tab.getEditorComponent();
            field.setCaretPosition(field.getText().length());
            field.requestFocusInWindow();
            field.selectAll();
        }
    }

    class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        Color origBackground;

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean isRemovable = ChangeParametersPanel.this.model.isRemovable(row);
            if (!isSelected) {
                if (!isRemovable) {
                    this.setBackground(UIManager.getColor("Panel.background"));
                } else {
                    this.setBackground(this.origBackground);
                }
            }
            return this;
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ChangeParametersPanel.autoEdit((JTable)ae.getSource());
        }
    }

    static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] data, int rowCount) {
            super(data, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column > 2) {
                return false;
            }
            Integer origIdx = (Integer)this.getDataVector().get(row).get(3);
            return origIdx == -1;
        }

        public boolean isRemovable(int row) {
            return (Boolean)this.getDataVector().get(row).get(4);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if ((column == 0 || column == 1 || column == 2) && aValue instanceof String) {
                aValue = ((String)aValue).toString().trim();
            }
            super.setValueAt(aValue, row, column);
        }
    }
}

