/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionRef;

public final class ModificationResult {
    private final CsmProject project;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    public ModificationResult(CsmProject project) {
        this.project = project;
    }

    public void addDifference(FileObject fo, Difference diff) {
        List<Difference> foDiffs = this.diffs.get(fo);
        if (foDiffs == null) {
            foDiffs = new LinkedList<Difference>();
            this.diffs.put(fo, foDiffs);
        }
        foDiffs.add(diff);
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(FileObject fo) {
        return this.diffs.get(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        try {
            for (Map.Entry<FileObject, List<Difference>> me : this.diffs.entrySet()) {
                this.commit(me.getKey(), me.getValue(), null);
            }
        }
        finally {
            if (this.project != null) {
                this.project.waitParse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(FileObject fo, final List<Difference> differences, Writer out) throws IOException {
        StyledDocument doc;
        EditorCookie ec;
        DataObject dObj = DataObject.find((FileObject)fo);
        EditorCookie editorCookie = ec = dObj != null ? (EditorCookie)dObj.getCookie(EditorCookie.class) : null;
        if (ec != null && out == null && (doc = CsmUtilities.openDocument((EditorCookie)ec)) != null) {
            final IOException[] ioe = new IOException[]{null};
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Difference diff : differences) {
                        if (diff.isExcluded()) continue;
                        try {
                            switch (diff.getKind()) {
                                case INSERT: {
                                    doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                                    break;
                                }
                                case REMOVE: {
                                    doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                    break;
                                }
                                case CHANGE: {
                                    doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                    doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                                }
                            }
                        }
                        catch (BadLocationException ex) {
                            IOException ioex = new IOException();
                            ioex.initCause(ex);
                            ioe[0] = ioex;
                        }
                    }
                }
            };
            if (doc instanceof BaseDocument) {
                doc.putProperty("cnd.refactoring.modification.event", Boolean.TRUE);
                ((BaseDocument)doc).runAtomic(runnable);
                doc.putProperty("cnd.refactoring.modification.event", Boolean.FALSE);
            } else {
                runnable.run();
            }
            if (ioe[0] != null) {
                throw ioe[0];
            }
            return;
        }
        InputStream ins = null;
        ByteArrayOutputStream baos = null;
        Reader in = null;
        try {
            int n;
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
            ins = fo.getInputStream();
            baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)ins, (OutputStream)baos);
            ins.close();
            ins = null;
            byte[] arr = baos.toByteArray();
            int arrLength = this.convertToLF(arr);
            baos.close();
            baos = null;
            in = new InputStreamReader((InputStream)new ByteArrayInputStream(arr, 0, arrLength), encoding);
            if (out == null) {
                out = new OutputStreamWriter(fo.getOutputStream(), encoding);
            }
            int offset = 0;
            for (Difference diff : differences) {
                int n2;
                if (diff.isExcluded()) continue;
                int pos = diff.getStartPosition().getOffset();
                int toread = pos - offset;
                char[] buff = new char[toread];
                int rc = 0;
                while ((n2 = in.read(buff, 0, toread - rc)) > 0 && rc < toread) {
                    out.write(buff, 0, n2);
                    rc += n2;
                    offset += n2;
                }
                switch (diff.getKind()) {
                    case INSERT: {
                        out.write(diff.getNewText());
                        break;
                    }
                    case REMOVE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        in.skip(len);
                        offset += len;
                        break;
                    }
                    case CHANGE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        in.skip(len);
                        offset += len;
                        out.write(diff.getNewText());
                    }
                }
            }
            char[] buff = new char[1024];
            while ((n = in.read(buff)) > 0) {
                out.write(buff, 0, n);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private int convertToLF(byte[] buff) {
        int j = 0;
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] == 13) continue;
            buff[j++] = buff[i];
        }
        return j;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter writer = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), writer);
        return writer.toString();
    }

    public Set<File> getNewFiles() {
        HashSet<File> newFiles = new HashSet<File>();
        for (List<Difference> ds : this.diffs.values()) {
            for (Difference d : ds) {
                if (d.getKind() != Difference.Kind.CREATE) continue;
            }
        }
        return newFiles;
    }

    public static final class Difference {
        final Kind kind;
        final PositionRef startPos;
        final PositionRef endPos;
        final String oldText;
        final String newText;
        final String description;
        private boolean excluded;

        public Difference(Kind kind, PositionRef startPos, PositionRef endPos, String oldText, String newText, String description) {
            this.kind = kind;
            this.startPos = startPos;
            this.endPos = endPos;
            this.oldText = oldText;
            this.newText = newText;
            this.description = description;
            this.excluded = false;
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean b) {
            this.excluded = b;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE,
            CREATE;

        }
    }
}

