/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.codegen.ui.ConstructorPanel;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConstructorGenerator
implements CodeGenerator {
    private JTextComponent component;
    private CsmConstructor constructorHandle;
    private ElementNode.Description constructorDescription;
    private ElementNode.Description fieldsDescription;

    private ConstructorGenerator(JTextComponent component, CsmConstructor constructorHandle, ElementNode.Description constructorDescription, ElementNode.Description fieldsDescription) {
        this.component = component;
        this.constructorHandle = constructorHandle;
        this.constructorDescription = constructorDescription;
        this.fieldsDescription = fieldsDescription;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"GENERATE", "CONSTRUCTOR"});
        if (this.constructorDescription != null || this.fieldsDescription != null) {
            ConstructorPanel panel = new ConstructorPanel(this.constructorDescription, this.fieldsDescription);
            DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_constructor"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            try {
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                if (!(th.getCause() instanceof InterruptedException)) {
                    throw new RuntimeException(th);
                }
                dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
            }
            finally {
                dialog.dispose();
            }
            if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                return;
            }
            if (this.constructorHandle == null) {
                List<CsmConstructor> constrHandles = panel.getInheritedConstructors();
            } else {
                Object constrHandles = null;
            }
            List<CsmField> fieldHandles = panel.getVariablesToInitialize();
        } else {
            Object fieldHandles = null;
            Object constrHandles = null;
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ConstructorGenerator> ret = new ArrayList<ConstructorGenerator>();
            if (!CsmRefactoringUtils.REFACTORING_EXTRA) {
                return ret;
            }
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CsmContext path = (CsmContext)context.lookup(CsmContext.class);
            if (component == null || path == null) {
                return ret;
            }
            CsmClass typeElement = path.getEnclosingClass();
            if (typeElement == null) {
                return ret;
            }
            LinkedHashSet<CsmField> initializedFields = new LinkedHashSet<CsmField>();
            LinkedHashSet<CsmField> uninitializedFields = new LinkedHashSet<CsmField>();
            ArrayList<CsmConstructor> constructors = new ArrayList<CsmConstructor>();
            ArrayList<CsmConstructor> inheritedConstructors = new ArrayList<CsmConstructor>();
            CsmClass superClass = null;
            for (CsmInheritance csmInheritance : typeElement.getBaseClasses()) {
                CsmClass baseClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
                if (baseClass == null) continue;
                superClass = baseClass;
                for (CsmMember member : baseClass.getMembers()) {
                    if (!CsmKindUtilities.isConstructor((CsmObject)member) || !CsmInheritanceUtilities.matchVisibility((CsmMember)member, (CsmVisibility)csmInheritance.getVisibility())) continue;
                    inheritedConstructors.add((CsmConstructor)member);
                }
            }
            GeneratorUtils.scanForFieldsAndConstructors(typeElement, initializedFields, uninitializedFields, constructors);
            CsmConstructor constructorHandle = null;
            ElementNode.Description constructorDescription = null;
            if (inheritedConstructors.size() == 1) {
                constructorHandle = (CsmConstructor)inheritedConstructors.get(0);
            } else if (inheritedConstructors.size() > 1) {
                ArrayList<ElementNode.Description> constructorDescriptions = new ArrayList<ElementNode.Description>();
                for (CsmConstructor constructorElement : inheritedConstructors) {
                    constructorDescriptions.add(ElementNode.Description.create((CsmObject)constructorElement, null, (boolean)true, (boolean)false));
                }
                constructorDescription = ElementNode.Description.create((CsmObject)superClass, constructorDescriptions, (boolean)false, (boolean)false);
            }
            ElementNode.Description fieldsDescription = null;
            if (!uninitializedFields.isEmpty()) {
                ArrayList<ElementNode.Description> fieldDescriptions = new ArrayList<ElementNode.Description>();
                for (CsmField variableElement : uninitializedFields) {
                    fieldDescriptions.add(ElementNode.Description.create((CsmObject)variableElement, null, (boolean)true, (boolean)false));
                }
                fieldsDescription = ElementNode.Description.create((CsmObject)typeElement, fieldDescriptions, (boolean)false, (boolean)false);
            }
            if (constructorHandle != null || constructorDescription != null || fieldsDescription != null) {
                ret.add(new ConstructorGenerator(component, constructorHandle, constructorDescription, fieldsDescription));
            }
            return ret;
        }
    }
}

