/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Timer;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.netbeans.modules.cnd.spi.remote.setup.MirrorPathProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public abstract class RemotePathMap
extends PathMap {
    private static final Map<ExecutionEnvironment, Map<String, RemotePathMap>> fixedPathMaps = new HashMap<ExecutionEnvironment, Map<String, RemotePathMap>>();
    private static final Map<ExecutionEnvironment, Map<String, RemotePathMap>> customPathMaps = new HashMap<ExecutionEnvironment, Map<String, RemotePathMap>>();
    protected final HashMap<String, String> map = new HashMap();
    protected final ExecutionEnvironment execEnv;
    protected volatile String localBase;
    private static final String REMOTE_PATH_MAP = "remote-path-map";
    private static final String DELIMITER = "\n";
    private static final String NO_MAPPING_PREFIX = "///";

    public static RemotePathMap getPathMap(ExecutionEnvironment env) {
        return RemotePathMap.getPathMap(env, ServerList.get((ExecutionEnvironment)env).getSyncFactory().isPathMappingCustomizable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotePathMap getPathMap(ExecutionEnvironment env, boolean customizable) {
        Map<ExecutionEnvironment, Map<String, RemotePathMap>> map;
        Map<ExecutionEnvironment, Map<String, RemotePathMap>> pmtable = customizable ? customPathMaps : fixedPathMaps;
        String syncID = RemotePathMap.getEnvSyncID(env);
        Map<String, RemotePathMap> pathmaps = pmtable.get(env);
        RemotePathMap pathmap = null;
        if (pathmaps == null) {
            map = pmtable;
            synchronized (map) {
                pathmaps = new HashMap<String, RemotePathMap>();
                pmtable.put(env, pathmaps);
            }
        }
        if ((pathmap = pathmaps.get(syncID)) == null) {
            map = pmtable;
            synchronized (map) {
                pathmap = customizable ? new CustomizableRemotePathMap(env) : new FixedRemotePathMap(env);
                pathmap.init();
                pathmaps.put(syncID, pathmap);
            }
        }
        return pathmap;
    }

    protected RemotePathMap(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean loadFromPrefs() {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            String list = RemotePathMap.getPreferences(this.execEnv);
            if (list == null) {
                String pmap = System.getProperty("cnd.remote.pmap");
                if (pmap == null) {
                    return false;
                }
                File file = CndFileUtils.createLocalFile((String)pmap);
                if (file.exists() && file.canRead()) {
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(file));
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                int pos = line.indexOf(32);
                                if (pos <= 0) continue;
                                this.map.put(line.substring(0, pos), line.substring(pos + 1).trim());
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
            } else {
                String[] paths = list.split(DELIMITER);
                for (int i = 0; i < paths.length; i += 2) {
                    if (i + 1 < paths.length) {
                        this.map.put(paths[i], paths[i + 1]);
                        continue;
                    }
                    System.err.println("mapping serialization flaw. Was found: " + list);
                }
            }
            return true;
        }
    }

    public abstract void init();

    public String getRemotePath(String lpath, boolean useDefault) {
        CndUtils.assertNotNull((Object)lpath, (String)"local path should not be null");
        if (lpath == null) {
            return null;
        }
        String ulpath = RemotePathMap.unifySeparators(lpath);
        String rpath = null;
        int max = 0;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String rest;
            String key = RemotePathMap.unifySeparators(entry.getKey());
            if (!ulpath.startsWith(key) || rpath != null && key.length() <= max) continue;
            max = key.length();
            String mpoint = entry.getValue();
            String string = rest = key.length() > lpath.length() ? "" : lpath.substring(key.length()).replace('\\', '/');
            if (!mpoint.endsWith("/")) {
                mpoint = mpoint + '/';
            }
            rpath = mpoint + rest;
        }
        if (rpath != null) {
            return rpath;
        }
        return useDefault ? lpath : null;
    }

    public String getLocalPath(String rpath, boolean useDefault) {
        CndUtils.assertNotNull((Object)rpath, (String)"remote path should not be null");
        if (rpath == null) {
            return null;
        }
        String urpath = RemotePathMap.unifySeparators(rpath);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String rest;
            String value = RemotePathMap.unifySeparators(entry.getValue());
            if (!urpath.startsWith(value)) continue;
            String mpoint = entry.getKey();
            String string = rest = value.length() > rpath.length() ? "" : rpath.substring(value.length());
            if (mpoint.length() > 0 && !mpoint.endsWith("/")) {
                mpoint = mpoint + '/';
            }
            return mpoint + rest;
        }
        if (useDefault) {
            this.initLocalBase();
            return this.localBase + '/' + rpath;
        }
        return null;
    }

    public boolean checkRemotePaths(File[] localFiles, boolean fixMissingPaths) {
        ArrayList<String> localPaths = new ArrayList<String>();
        for (File file : localFiles) {
            if (file.isDirectory()) {
                localPaths.add(file.getAbsolutePath());
                continue;
            }
            localPaths.add(file.getParentFile().getAbsolutePath());
        }
        Collections.sort(localPaths);
        ArrayList<String> invalidLocalPaths = new ArrayList<String>();
        for (String lPath : localPaths) {
            if (this.checkRemotePath(lPath)) continue;
            invalidLocalPaths.add(lPath);
        }
        if (invalidLocalPaths.isEmpty()) {
            return true;
        }
        if (fixMissingPaths) {
            if (EditPathMapDialog.showMe(this.execEnv, invalidLocalPaths)) {
                for (String lPath : invalidLocalPaths) {
                    if (this.checkRemotePath(lPath)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRemotePath(String lpath) {
        block8: {
            CndUtils.assertNotNull((Object)lpath, (String)"local path should not be null");
            if (lpath == null) {
                return false;
            }
            String ulpath = RemotePathMap.unifySeparators(lpath);
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String mpoint = RemotePathMap.unifySeparators(entry.getKey());
                if (!ulpath.startsWith(mpoint)) continue;
                return true;
            }
            for (String mpoint : this.map.keySet()) {
                if (!ulpath.startsWith(RemotePathMap.unifySeparators(mpoint))) continue;
                return true;
            }
            try {
                if (!RemotePathMap.validateMapping(this.execEnv, lpath, CndFileUtils.createLocalFile((String)lpath))) break block8;
                HashMap<String, String> i$ = this.map;
                synchronized (i$) {
                    this.map.put(lpath, lpath);
                }
                return true;
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return false;
    }

    public void addMapping(String localParent, String remoteParent) {
        this.addMappingImpl(localParent, remoteParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMappingImpl(String localParent, String remoteParent) {
        CndUtils.assertNotNull((Object)localParent, (String)"local path shouldn't be null");
        CndUtils.assertNotNull((Object)remoteParent, (String)"remote path shouldn't be null");
        if (localParent == null || remoteParent == null) {
            return;
        }
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            LinkedHashMap<String, String> clone = new LinkedHashMap<String, String>(this.map);
            clone.put(localParent, remoteParent);
            this.updatePathMapImpl(clone);
        }
    }

    public void updatePathMap(Map<String, String> newPathMap) {
        this.updatePathMapImpl(newPathMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePathMapImpl(Map<String, String> newPathMap) {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : newPathMap.entrySet()) {
                String remotePath = RemotePathMap.fixEnding(entry.getValue());
                String path = RemotePathMap.fixEnding(entry.getKey());
                this.map.put(path, remotePath);
                sb.append(RemotePathMap.fixEnding(path));
                sb.append(DELIMITER);
                sb.append(remotePath);
                sb.append(DELIMITER);
            }
            this.setPreferences(sb.toString());
        }
    }

    public Map<String, String> getMap() {
        return (Map)this.map.clone();
    }

    private static String fixEnding(String path) {
        if (path.charAt(path.length() - 1) != '/' && path.charAt(path.length() - 1) != '\\') {
            return path + "/";
        }
        return path;
    }

    private static String unifySeparators(String path) {
        String result = path.replace('\\', '/');
        if (!CndFileUtils.isSystemCaseSensitive()) {
            result = result.toLowerCase();
        }
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public static boolean isSubPath(String path, String pathToValidate) {
        CndUtils.assertNotNull((Object)path, (String)"path should not be null");
        CndUtils.assertNotNull((Object)pathToValidate, (String)"pathToValidate should not be null");
        if (path == null || pathToValidate == null) {
            return false;
        }
        return RemotePathMap.unifySeparators(pathToValidate).startsWith(RemotePathMap.unifySeparators(path));
    }

    private static String getEnvSyncID(ExecutionEnvironment env) {
        return ServerList.get((ExecutionEnvironment)env).getSyncFactory().getID();
    }

    private static String getPreferences(ExecutionEnvironment execEnv) {
        return NbPreferences.forModule(RemotePathMap.class).get(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv) + RemotePathMap.getEnvSyncID(execEnv), null);
    }

    private void setPreferences(String newValue) {
        NbPreferences.forModule(RemotePathMap.class).put(REMOTE_PATH_MAP + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.execEnv) + RemotePathMap.getEnvSyncID(this.execEnv), newValue);
    }

    private static boolean validateMapping(ExecutionEnvironment execEnv, String rpath, File lpath) throws InterruptedException {
        if (!PlatformInfo.getDefault((ExecutionEnvironment)execEnv).isWindows() && !PlatformInfo.getDefault((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).isWindows()) {
            return RemotePathMap.isTheSame(execEnv, rpath, lpath);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV"})
    public static boolean isTheSame(ExecutionEnvironment execEnv, String rpath, File path) throws InterruptedException {
        if (path.exists() && path.isDirectory()) {
            File validationFile = null;
            try {
                validationFile = File.createTempFile("cnd", "tmp", path);
                if (validationFile.exists()) {
                    BufferedWriter out = new BufferedWriter(new FileWriter(validationFile));
                    String validationLine = Double.toString(Math.random());
                    out.write(validationLine);
                    out.close();
                    RemoteCommandSupport rcs = new RemoteCommandSupport(execEnv, "grep", null, validationLine, rpath + "/" + validationFile.getName());
                    if (rcs.run() == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    if (rcs.isCancelled() || rcs.isInterrupted()) {
                        throw new InterruptedException();
                    }
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (validationFile != null && validationFile.exists()) {
                    validationFile.delete();
                }
            }
        }
        return false;
    }

    protected void initLocalBase() {
        if (this.localBase == null) {
            String tmpLocalBase = RemotePathMap.getLocalSyncRoot(this.execEnv);
            if (tmpLocalBase.endsWith("/")) {
                tmpLocalBase = tmpLocalBase.substring(0, tmpLocalBase.length() - 1);
            }
            this.localBase = tmpLocalBase;
        }
    }

    public static String getRemoteSyncRoot(ExecutionEnvironment executionEnvironment) {
        for (MirrorPathProvider mpp : Lookup.getDefault().lookupAll(MirrorPathProvider.class)) {
            String result = mpp.getRemoteMirror(executionEnvironment);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getLocalSyncRoot(ExecutionEnvironment executionEnvironment) {
        for (MirrorPathProvider mpp : Lookup.getDefault().lookupAll(MirrorPathProvider.class)) {
            String result = mpp.getLocalMirror(executionEnvironment);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static final class FixedRemotePathMap
    extends RemotePathMap {
        private volatile String remoteBase;

        private FixedRemotePathMap(ExecutionEnvironment exc) {
            super(exc);
            this.initRemoteBase(false);
        }

        @Override
        public void init() {
            if (this.remoteBase != null) {
                super.addMappingImpl("/", this.remoteBase);
            }
        }

        @Override
        public String getRemotePath(String lpath, boolean useDefault) {
            CndUtils.assertNotNull((Object)lpath, (String)"local path should not be null");
            if (lpath == null) {
                return null;
            }
            this.initRemoteBase(true);
            if (this.remoteBase == null) {
                return useDefault ? lpath : null;
            }
            String remotePath = lpath;
            if (remotePath.startsWith(RemotePathMap.NO_MAPPING_PREFIX)) {
                return remotePath;
            }
            if (!FixedRemotePathMap.isSubPath(this.remoteBase, lpath)) {
                if (lpath != null && Utilities.isWindows() && !"/".equals(lpath)) {
                    lpath = WindowsSupport.getInstance().convertToMSysPath(lpath);
                }
                remotePath = super.getRemotePath(lpath, useDefault);
            }
            return remotePath;
        }

        @Override
        public String getLocalPath(String rpath, boolean useDefault) {
            String res;
            this.initRemoteBase(true);
            if (rpath.startsWith(RemotePathMap.NO_MAPPING_PREFIX)) {
                return rpath;
            }
            if (FixedRemotePathMap.isSubPath(this.remoteBase, rpath)) {
                res = super.getLocalPath(rpath, useDefault);
                if (res != null && Utilities.isWindows() && !"/".equals(res)) {
                    res = WindowsSupport.getInstance().convertFromMSysPath(res);
                }
            } else {
                this.initLocalBase();
                res = this.localBase + '/' + rpath;
            }
            return res;
        }

        private void initRemoteBase(boolean addMapping) {
            if (this.remoteBase == null) {
                this.remoteBase = FixedRemotePathMap.getRemoteSyncRoot(this.execEnv);
                if (addMapping && this.remoteBase != null) {
                    this.addMappingImpl("/", this.remoteBase);
                }
            }
        }

        @Override
        public void addMapping(String localParent, String remoteParent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updatePathMap(Map<String, String> newPathMap) {
            CndUtils.assertTrue((boolean)false, (String)("Should never be called for " + ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }

    private static final class CustomizableRemotePathMap
    extends RemotePathMap {
        private static final int TIMEOUT = Integer.getInteger("remote.path.map.analyzer.timeout", 10000);

        private CustomizableRemotePathMap(ExecutionEnvironment exc) {
            super(exc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() {
            if (!this.loadFromPrefs()) {
                final HostMappingsAnalyzer ham = new HostMappingsAnalyzer(this.execEnv);
                Timer timer = new Timer(TIMEOUT, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ham.cancel();
                    }
                });
                timer.setRepeats(false);
                timer.start();
                Map<String, String> mappings = ham.getMappings();
                HashMap hashMap = this.map;
                synchronized (hashMap) {
                    this.map.putAll(mappings);
                }
            }
        }
    }
}

