/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TriggeredTakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TriggeredTakeSnapshotCustomizer;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TriggeredTakeSnapshotProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPointFactory.class, (String)"TriggeredTakeSnapshotProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPointFactory.class, (String)"TriggeredTakeSnapshotProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPointFactory.class, (String)"TriggeredTakeSnapshotProfilingPointFactory_PpDefaultName");
    public static final String TAKE_SNAPSHOT_PP_TYPE = PP_TYPE;
    public static final String TAKE_SNAPSHOT_PP_DESCR = PP_DESCR;

    @Override
    public String getDescription() {
        return TAKE_SNAPSHOT_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.TakeSnapshotTriggered");
    }

    @Override
    public Icon getDisabledIcon() {
        Icon icon = UIManager.getLookAndFeel().getDisabledIcon(null, Icons.getIcon((String)"ProfilingPointsIcons.TakeSnapshotTriggered"));
        if (icon == null) {
            icon = new ImageIcon(GrayFilter.createDisabledImage(Icons.getImage((String)"ProfilingPointsIcons.TakeSnapshotTriggered")));
        }
        return icon;
    }

    @Override
    public int getScope() {
        return 2;
    }

    @Override
    public String getType() {
        return TAKE_SNAPSHOT_PP_TYPE;
    }

    @Override
    public TriggeredTakeSnapshotProfilingPoint create(Lookup.Provider project) {
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", ProjectUtilities.getDisplayName((Lookup.Provider)project)), project);
        return new TriggeredTakeSnapshotProfilingPoint(name, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return false;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return TriggeredTakeSnapshotProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TriggeredTakeSnapshotCustomizer createCustomizer() {
        return new TriggeredTakeSnapshotCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Lookup.Provider project, Properties properties, int index) {
        String name = properties.getProperty(index + "_" + "p_name", null);
        String enabledStr = properties.getProperty(index + "_" + "p_enabled", null);
        String type = properties.getProperty(index + "_" + "p_snapshot", null);
        String target = properties.getProperty(index + "_" + "p_target", null);
        String file = properties.getProperty(index + "_" + "p_file", null);
        String resetResultsStr = properties.getProperty(index + "_" + "p_reset_results", null);
        TriggeredGlobalProfilingPoint.TriggerCondition condition = TriggeredGlobalProfilingPoint.TriggerCondition.load(project, index, properties);
        if (name == null || enabledStr == null || condition == null || type == null || target == null || file == null || resetResultsStr == null) {
            return null;
        }
        TriggeredTakeSnapshotProfilingPoint profilingPoint = null;
        try {
            profilingPoint = new TriggeredTakeSnapshotProfilingPoint(name, project, this);
            profilingPoint.setEnabled(Boolean.parseBoolean(enabledStr));
            profilingPoint.setSnapshotType(type);
            profilingPoint.setSnapshotTarget(target);
            profilingPoint.setSnapshotFile(file);
            profilingPoint.setResetResults(Boolean.parseBoolean(resetResultsStr));
            profilingPoint.setCondition(condition);
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        return profilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int index, Properties properties) {
        TriggeredTakeSnapshotProfilingPoint takeSnapshot = (TriggeredTakeSnapshotProfilingPoint)profilingPoint;
        properties.put(index + "_" + "p_name", takeSnapshot.getName());
        properties.put(index + "_" + "p_enabled", Boolean.toString(takeSnapshot.isEnabled()));
        properties.put(index + "_" + "p_snapshot", takeSnapshot.getSnapshotType());
        properties.put(index + "_" + "p_target", takeSnapshot.getSnapshotTarget());
        properties.put(index + "_" + "p_file", takeSnapshot.getSnapshotFile() == null ? "" : takeSnapshot.getSnapshotFile());
        properties.put(index + "_" + "p_reset_results", Boolean.toString(takeSnapshot.getResetResults()));
        takeSnapshot.getCondition().store(takeSnapshot.getProject(), index, properties);
    }
}

