/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.TriggeredTakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class TakeSnapshotProfilingPoint
extends CodeProfilingPoint.Single
implements PropertyChangeListener {
    private static final String NO_DATA_AVAILABLE_MSG = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoDataAvailableMsg");
    private static final String NO_DATA_REMOTE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_RemoteUnsupportedMsg");
    private static final String NO_DATA_JDK_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoDataJdkMsg");
    private static final String ONE_HIT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderLocationString");
    private static final String HEADER_MODE_DATA_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderModeDataString");
    private static final String HEADER_MODE_DUMP_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderModeDumpString");
    private static final String HEADER_TARGET_PROJECT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTargetProjectString");
    private static final String HEADER_TARGET_CUSTOM_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTargetCustomString");
    private static final String HEADER_RESET_RESULTS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderResetResultsString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderHitsString");
    private static final String OPEN_SNAPSHOT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_OpenSnapshotString");
    private static final String HIT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HitString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_SnapshotNotAvailableMsg");
    private static final String DATA_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_DataString");
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private static final String ANNOTATION_ENABLED = "takeSnapshotProfilingPoint";
    private static final String ANNOTATION_DISABLED = "takeSnapshotProfilingPointD";
    private Annotation annotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TakeSnapshotProfilingPoint(String name, CodeProfilingPoint.Location location, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, location, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean resetResults) {
        if (this.resetResults == resetResults) {
            return;
        }
        this.resetResults = resetResults;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String snapshotFile) {
        if (snapshotFile == null || !new File(snapshotFile).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(snapshotFile))) {
            return;
        }
        String oldSnapshotFile = this.snapshotFile;
        this.snapshotFile = snapshotFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, oldSnapshotFile, snapshotFile);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String snapshotTarget) {
        if (!snapshotTarget.equals(TARGET_PROJECT_KEY) && !snapshotTarget.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + snapshotTarget);
        }
        if (this.snapshotTarget.equals(snapshotTarget)) {
            return;
        }
        String oldSnapshotTarget = this.snapshotTarget;
        this.snapshotTarget = snapshotTarget;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, oldSnapshotTarget, snapshotTarget);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String snapshotType) {
        if (snapshotType == null || !snapshotType.equals(TYPE_PROFDATA_KEY) && !snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + snapshotType);
        }
        if (this.snapshotType.equals(snapshotType)) {
            return;
        }
        String oldSnapshotType = this.snapshotType;
        this.snapshotType = snapshotType;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, oldSnapshotType, snapshotType);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TakeSnapshotProfilingPoint.this.hasReport()) {
                    TakeSnapshotProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasReport()) {
            if (evt.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport();
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new Annotation();
        }
        return this.annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int size = this.results.size();
                return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        TakeSnapshotCustomizer customizer = (TakeSnapshotCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPLocation(this.getLocation());
        customizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        customizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        customizer.setPPFile(this.getSnapshotFile());
        customizer.setPPResetResults(this.getResetResults());
    }

    @Override
    String getServerHandlerClassName() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            return "org.netbeans.lib.profiler.server.TakeHeapdumpProfilingPointHandler";
        }
        if (this.getResetResults()) {
            return "org.netbeans.lib.profiler.server.TakeSnapshotWithResetProfilingPointHandler";
        }
        return "org.netbeans.lib.profiler.server.TakeSnapshotProfilingPointHandler";
    }

    @Override
    String getServerInfo() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            try {
                return FileUtil.toFile((FileObject)this.getSnapshotDirectory()).getAbsolutePath();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
        return null;
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return ProjectStorage.getSettingsFolder((Lookup.Provider)this.getProject(), (boolean)true);
        }
        File f = new File(this.snapshotFile);
        f.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        TakeSnapshotCustomizer customizer = (TakeSnapshotCustomizer)c;
        this.setName(customizer.getPPName());
        this.setLocation(customizer.getPPLocation());
        this.setSnapshotType(customizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(customizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(customizer.getPPFile());
        this.setResetResults(customizer.getPPResetResults());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        String snapshotFilename;
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            snapshotFilename = runner.getProfilingSessionStatus().remoteProfiling ? NO_DATA_REMOTE_MSG : (!runner.hasSupportedJDKForHeapDump() ? NO_DATA_JDK_MSG : this.takeHeapdumpHit(hitEvent.getTimestamp()));
        } else {
            snapshotFilename = this.takeSnapshotHit();
        }
        Object object = this.resultsSync;
        synchronized (object) {
            this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), snapshotFilename));
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.hasResults();
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private File constructHeapDumpFile(long time) throws IOException {
        String dir = FileUtil.toFile((FileObject)this.getSnapshotDirectory()).getAbsolutePath();
        String heapDumpFileName = dir + File.separatorChar + "heapdump-" + time + "." + "hprof";
        return new File(heapDumpFileName);
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private String takeHeapdumpHit(long time) {
        try {
            File heapdumpFile = this.constructHeapDumpFile(time);
            if (heapdumpFile.exists()) {
                File fixedHeapdumpFile = this.constructHeapDumpFile(Utils.getTimeInMillis(time));
                heapdumpFile.renameTo(fixedHeapdumpFile);
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                return fixedHeapdumpFile.toURI().toURL().toExternalForm();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return NO_DATA_AVAILABLE_MSG;
        }
        return NO_DATA_AVAILABLE_MSG;
    }

    private static LoadedSnapshot takeSnapshot() throws CPUResultsSnapshot.NoDataAvailableException {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String snapshotFilename = null;
        try {
            loadedSnapshot = TakeSnapshotProfilingPoint.takeSnapshot();
        }
        catch (CPUResultsSnapshot.NoDataAvailableException e) {
            // empty catch block
        }
        if (loadedSnapshot != null) {
            try {
                FileObject snapshotDirectory = this.getSnapshotDirectory();
                FileObject profFile = snapshotDirectory.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, profFile);
                snapshotFilename = FileUtil.toFile((FileObject)profFile).toURI().toURL().toExternalForm();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return snapshotFilename == null ? NO_DATA_AVAILABLE_MSG : snapshotFilename;
    }

    private static class Result {
        private final String resultString;
        private final int threadId;
        private final long timestamp;

        public Result(long timestamp, int threadId, String resultString) {
            this.timestamp = timestamp;
            this.threadId = threadId;
            this.resultString = resultString;
        }

        public String getResultString() {
            return this.resultString;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderLocation());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMode());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderTarget());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderResetResults());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (!TakeSnapshotProfilingPoint.this.hasResults()) {
                    dataAreaTextBuilder.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    for (int i = 0; i < TakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(TakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TakeSnapshotProfilingPoint.this.results.get(index);
                String resultString = result.getResultString();
                String snapshotInformation = resultString.startsWith(TakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + resultString + "'>" + OPEN_SNAPSHOT_STRING + "</a>" : resultString;
                return MessageFormat.format(HIT_STRING, index + 1, Utils.formatProfilingPointTimeHiRes(result.getTimestamp()), snapshotInformation);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, TakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, TakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderLocation() {
            CodeProfilingPoint.Location location = TakeSnapshotProfilingPoint.this.getLocation();
            String shortFileName = new File(location.getFile()).getName();
            int lineNumber = location.getLine();
            return MessageFormat.format(HEADER_LOCATION_STRING, shortFileName, lineNumber);
        }

        private String getHeaderMode() {
            return TakeSnapshotProfilingPoint.this.getSnapshotType().equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? HEADER_MODE_DATA_STRING : HEADER_MODE_DUMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + TakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtilities.getDisplayName((Lookup.Provider)TakeSnapshotProfilingPoint.this.getProject()));
        }

        private String getHeaderResetResults() {
            return MessageFormat.format(HEADER_RESET_RESULTS_STRING, TakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? HEADER_TARGET_PROJECT_STRING : MessageFormat.format(HEADER_TARGET_PROJECT_STRING, TakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, TakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    Utils.openLocation(TakeSnapshotProfilingPoint.this.getLocation());
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    File resolvedFile = null;
                    try {
                        resolvedFile = new File(url.toURI());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    File snapshotFile = resolvedFile;
                    if (snapshotFile != null && snapshotFile.exists()) {
                        String type = TakeSnapshotProfilingPoint.this.getSnapshotType();
                        if (type.equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) || type.equals(TakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            ResultsManager.getDefault().openSnapshot(snapshotFile);
                        }
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SNAPSHOT_NOT_AVAILABLE_MSG, 2));
                    }
                }
            };
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(DATA_STRING);
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private Annotation() {
        }

        public String getAnnotationType() {
            return TakeSnapshotProfilingPoint.this.isEnabled() ? TakeSnapshotProfilingPoint.ANNOTATION_ENABLED : TakeSnapshotProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            return TakeSnapshotProfilingPoint.this.getName();
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return TakeSnapshotProfilingPoint.this;
        }
    }
}

