/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPointsProcessor;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointAnnotator;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProfilingPointsManager
extends ProfilingPointsProcessor
implements ChangeListener,
PropertyChangeListener,
ProfilingStateListener {
    private static final String ANOTHER_PP_EDITED_MSG = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_AnotherPpEditedMsg");
    private static final String PP_CUSTOMIZER_CAPTION = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_PpCustomizerCaption");
    private static final String CANNOT_STORE_PP_MSG = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_CannotStorePpMsg");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ProfilingPointsManager.class, (String)"ProfilingPointsManager_OkButtonText");
    public static final String PROPERTY_PROJECTS_CHANGED = "p_projects_changed";
    public static final String PROPERTY_PROFILING_POINTS_CHANGED = "p_profiling_points_changed";
    public static final int SORT_BY_PROJECT = 1;
    public static final int SORT_BY_SCOPE = 2;
    public static final int SORT_BY_NAME = 3;
    public static final int SORT_BY_RESULTS = 4;
    private CustomizerButton customizerButton;
    private List<GlobalProfilingPoint> activeGlobalProfilingPoints = new ArrayList<GlobalProfilingPoint>();
    private Map<Integer, RuntimeProfilingPointMapper> activeCodeProfilingPoints = new HashMap<Integer, RuntimeProfilingPointMapper>();
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ProfilingPointFactory.AVAILABILITY_PROPERTY)) {
                ProfilingPointsManager.this.refreshProfilingPointFactories();
                ProfilingPointsManager.this.firePropertyChanged(ProfilingPointsManager.PROPERTY_PROFILING_POINTS_CHANGED);
            }
        }
    };
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Set<ProfilingPoint> dirtyProfilingPoints = Collections.synchronizedSet(new HashSet());
    private List<ValidityAwarePanel> customizers = new ArrayList<ValidityAwarePanel>();
    private final Collection<Lookup.Provider> openedProjects = new ArrayList<Lookup.Provider>();
    private List<ProfilingPoint> profilingPoints = new ArrayList<ProfilingPoint>();
    private ProfilingPointFactory[] profilingPointFactories = new ProfilingPointFactory[0];
    private boolean profilingInProgress = false;
    private boolean profilingSessionInProgress = false;
    private int nextUniqueRPPIdentificator;
    private Map<File, FileWatch> profilingPointsFiles = new HashMap<File, FileWatch>();
    private boolean ignoreStoreProfilingPoints = false;
    private boolean processesProfilingPoints;
    private final Object pointsLock = new Object();
    private RuntimeProfilingPoint[] points = null;

    public ProfilingPointsManager() {
        this.refreshProfilingPointFactories();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilingPointsManager.this.processOpenedProjectsChanged();
                Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)ProfilingPointsManager.this);
                ProjectUtilities.addOpenProjectsListener((ChangeListener)ProfilingPointsManager.this);
            }
        });
    }

    public static ProfilingPointsManager getDefault() {
        return (ProfilingPointsManager)Lookup.getDefault().lookup(ProfilingPointsManager.class);
    }

    public List<ProfilingPoint> getCompatibleProfilingPoints(Lookup.Provider project, ProfilingSettings profilingSettings, boolean sorted) {
        List<ProfilingPoint> projectProfilingPoints = sorted ? this.getSortedProfilingPoints(project, 1, false) : this.getProfilingPoints(project, ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies(), false);
        ArrayList<ProfilingPoint> compatibleProfilingPoints = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : projectProfilingPoints) {
            if (!profilingPoint.supportsProfilingSettings(profilingSettings)) continue;
            compatibleProfilingPoints.add(profilingPoint);
        }
        return compatibleProfilingPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProfilingInProgress() {
        ProfilingPointsManager profilingPointsManager = this;
        synchronized (profilingPointsManager) {
            return this.profilingInProgress;
        }
    }

    public ProfilingPointFactory[] getProfilingPointFactories() {
        return this.profilingPointFactories;
    }

    public List<ProfilingPoint> getProfilingPoints(Lookup.Provider project, boolean inclSubprojects, boolean inclUnavailable) {
        return this.getProfilingPoints(ProfilingPoint.class, project, inclSubprojects, inclUnavailable);
    }

    public <T extends ProfilingPoint> List<T> getProfilingPoints(Class<T> ppClass, Lookup.Provider project, boolean inclSubprojects) {
        return this.getProfilingPoints(ppClass, project, inclSubprojects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ProfilingPoint> List<T> getProfilingPoints(Class<T> ppClass, Lookup.Provider project, boolean inclSubprojects, boolean inclUnavailable) {
        HashSet<Lookup.Provider> projects = new HashSet<Lookup.Provider>();
        if (project == null) {
            Collection<Lookup.Provider> collection = this.openedProjects;
            synchronized (collection) {
                projects.addAll(this.openedProjects);
            }
        } else {
            projects.add(project);
            if (inclSubprojects) {
                projects.addAll(this.getOpenSubprojects(project));
            }
        }
        ArrayList<ProfilingPoint> filteredProfilingPoints = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : this.profilingPoints) {
            ProfilingPointFactory factory = profilingPoint.getFactory();
            if (factory == null || !ppClass.isInstance(profilingPoint) || !ProfilingPointsManager.containsProject(projects, profilingPoint.getProject()) || !inclUnavailable && !factory.isAvailable()) continue;
            filteredProfilingPoints.add(profilingPoint);
        }
        return filteredProfilingPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProfilingSessionInProgress() {
        ProfilingPointsManager profilingPointsManager = this;
        synchronized (profilingPointsManager) {
            return this.profilingSessionInProgress;
        }
    }

    public List<ProfilingPoint> getSortedProfilingPoints(Lookup.Provider project, int sortBy, boolean sortOrder) {
        List<ProfilingPoint> sortedProfilingPoints = this.getProfilingPoints(project, ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies(), false);
        Collections.sort(sortedProfilingPoints, new ProfilingPointsComparator(sortBy, sortOrder));
        return sortedProfilingPoints;
    }

    public void addProfilingPoint(ProfilingPoint profilingPoint) {
        this.addProfilingPoints(new ProfilingPoint[]{profilingPoint});
    }

    public void addProfilingPoints(ProfilingPoint[] profilingPointsArr) {
        this.addProfilingPoints(profilingPointsArr, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public RuntimeProfilingPoint[] createCodeProfilingConfiguration(Lookup.Provider project, ProfilingSettings profilingSettings) {
        this.checkProfilingPoints();
        this.nextUniqueRPPIdentificator = 0;
        ArrayList<RuntimeProfilingPoint> runtimeProfilingPoints = new ArrayList<RuntimeProfilingPoint>();
        List<ProfilingPoint> compatibleProfilingPoints = this.getCompatibleProfilingPoints(project, profilingSettings, false);
        for (ProfilingPoint compatibleProfilingPoint : compatibleProfilingPoints) {
            if (!compatibleProfilingPoint.isEnabled() || !(compatibleProfilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint compatibleCodeProfilingPoint = (CodeProfilingPoint)compatibleProfilingPoint;
            RuntimeProfilingPoint[] rpps = compatibleCodeProfilingPoint.createRuntimeProfilingPoints();
            if (rpps.length == 0) {
                ErrorManager.getDefault().log(256, "Cannot resolve RuntimeProfilingPoint(s) for " + compatibleCodeProfilingPoint.getName() + ", check location");
            }
            for (int i = 0; i < rpps.length; ++i) {
                runtimeProfilingPoints.add(rpps[i]);
                this.activeCodeProfilingPoints.put(rpps[i].getId(), new RuntimeProfilingPointMapper(compatibleCodeProfilingPoint, i));
            }
        }
        return runtimeProfilingPoints.toArray(new RuntimeProfilingPoint[runtimeProfilingPoints.size()]);
    }

    public GlobalProfilingPoint[] createGlobalProfilingConfiguration(Lookup.Provider project, ProfilingSettings profilingSettings) {
        this.checkProfilingPoints();
        List<ProfilingPoint> compatibleProfilingPoints = this.getCompatibleProfilingPoints(project, profilingSettings, false);
        for (ProfilingPoint compatibleProfilingPoint : compatibleProfilingPoints) {
            if (!compatibleProfilingPoint.isEnabled() || !(compatibleProfilingPoint instanceof GlobalProfilingPoint)) continue;
            this.activeGlobalProfilingPoints.add((GlobalProfilingPoint)compatibleProfilingPoint);
        }
        return this.activeGlobalProfilingPoints.toArray(new GlobalProfilingPoint[this.activeGlobalProfilingPoints.size()]);
    }

    public synchronized int createUniqueRuntimeProfilingPointIdentificator() {
        return this.nextUniqueRPPIdentificator++;
    }

    public void firePropertyChanged(String property) {
        this.propertyChangeSupport.firePropertyChange(property, false, true);
    }

    public void ideClosing() {
        this.storeDirtyProfilingPoints();
    }

    public void instrumentationChanged(int i, int i0) {
    }

    public void profilingPointHit(RuntimeProfilingPoint.HitEvent hitEvent) {
        RuntimeProfilingPointMapper mapper = this.activeCodeProfilingPoints.get(hitEvent.getId());
        if (mapper != null) {
            mapper.getOwner().hit(hitEvent, mapper.getIndex());
        } else {
            ErrorManager.getDefault().log(65536, "Cannot resolve ProfilingPoint for event: " + hitEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Object project) {
        ProfilingSettings ps = Profiler.getDefault().getLastProfilingSettings();
        TargetAppRunner tar = Profiler.getDefault().getTargetAppRunner();
        if (ps.useProfilingPoints() && project != null) {
            Object object = this.pointsLock;
            synchronized (object) {
                this.points = this.createCodeProfilingConfiguration((Lookup.Provider)project, ps);
                this.processesProfilingPoints = this.points.length > 0;
                tar.getProfilerEngineSettings().setRuntimeProfilingPoints(this.points);
            }
        }
        Object object = this.pointsLock;
        synchronized (object) {
            this.points = new RuntimeProfilingPoint[0];
        }
        this.processesProfilingPoints = false;
        tar.getProfilerEngineSettings().setRuntimeProfilingPoints(this.points);
        if (this.processesProfilingPoints) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProfilingPointsWindow.getDefault().isOpened()) {
                        ProfilingPointsWindow.getDefault().open();
                        ProfilingPointsWindow.getDefault().requestVisible();
                    }
                }
            });
        }
    }

    public RuntimeProfilingPoint[] getSupportedProfilingPoints() {
        return this.points != null ? this.points : new RuntimeProfilingPoint[]{};
    }

    public void profilingStateChanged(final ProfilingStateEvent profilingStateEvent) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean wasProfilingInProgress = ProfilingPointsManager.this.profilingInProgress;
                boolean wasProfilingSessionInProgres = ProfilingPointsManager.this.profilingSessionInProgress;
                ProfilingPointsManager profilingPointsManager = ProfilingPointsManager.this;
                synchronized (profilingPointsManager) {
                    switch (profilingStateEvent.getNewState()) {
                        case 1: 
                        case 16: {
                            ProfilingPointsManager.this.profilingInProgress = false;
                            ProfilingPointsManager.this.profilingSessionInProgress = false;
                            break;
                        }
                        case 2: 
                        case 128: {
                            ProfilingPointsManager.this.reset();
                            ProfilingPointsManager.this.profilingInProgress = false;
                            ProfilingPointsManager.this.profilingSessionInProgress = true;
                            break;
                        }
                        default: {
                            ProfilingPointsManager.this.profilingInProgress = true;
                            ProfilingPointsManager.this.profilingSessionInProgress = true;
                        }
                    }
                }
                if (wasProfilingInProgress != ProfilingPointsManager.this.profilingInProgress || wasProfilingSessionInProgres != ProfilingPointsManager.this.profilingSessionInProgress) {
                    GlobalProfilingPointsProcessor.getDefault().notifyProfilingStateChanged();
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfilingPointsWindow.getDefault().notifyProfilingStateChanged();
                        }
                    });
                }
            }
        });
    }

    public void updateLocation(CodeProfilingPoint cpp, int oldLine, int newLine) {
        if (cpp instanceof CodeProfilingPoint.Single) {
            CodeProfilingPoint.Single cpps = (CodeProfilingPoint.Single)cpp;
            CodeProfilingPoint.Location loc = cpps.getLocation();
            if (loc.getLine() == oldLine) {
                this.updateLocation((CodeProfilingPoint)cpps, newLine, cpps.getAnnotation());
            }
        } else if (cpp instanceof CodeProfilingPoint.Paired) {
            CodeProfilingPoint.Paired cppp = (CodeProfilingPoint.Paired)cpp;
            CodeProfilingPoint.Annotation ann = null;
            CodeProfilingPoint.Location loc = cppp.getStartLocation();
            if (loc.getLine() == oldLine) {
                ann = cppp.getStartAnnotation();
            } else {
                loc = cppp.getEndLocation();
                if (loc.getLine() == oldLine) {
                    ann = cppp.getEndAnnotation();
                }
            }
            if (ann != null) {
                this.updateLocation((CodeProfilingPoint)cppp, newLine, ann);
            }
        }
    }

    private void updateLocation(CodeProfilingPoint cpp, int line, CodeProfilingPoint.Annotation cppa) {
        cpp.internalUpdateLocation(cppa, line);
        this.dirtyProfilingPoints.add(cpp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Line && "lineNumber".equals(evt.getPropertyName())) {
            final Line line = (Line)evt.getSource();
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (ProfilingPoint pp : ProfilingPointsManager.this.profilingPoints) {
                        if (!(pp instanceof CodeProfilingPoint)) continue;
                        CodeProfilingPoint cpp = (CodeProfilingPoint)pp;
                        for (CodeProfilingPoint.Annotation cppa : cpp.getAnnotations()) {
                            if (!line.equals(cppa.getAttachedAnnotatable())) continue;
                            cpp.internalUpdateLocation(cppa, line.getLineNumber() + 1);
                        }
                        ProfilingPointsManager.this.dirtyProfilingPoints.add(cpp);
                    }
                }
            });
        } else if (evt.getSource() instanceof ProfilingPoint) {
            ProfilingPoint profilingPoint = (ProfilingPoint)evt.getSource();
            if (!evt.getPropertyName().equals("p_results")) {
                this.storeProfilingPoints(new ProfilingPoint[]{profilingPoint});
            }
            if (this.isAnnotationChange(evt)) {
                ProfilingPointAnnotator.get().annotationChanged(evt);
            }
            if (this.isLocationChange(evt)) {
                CodeProfilingPoint.Location newLocation;
                ProfilingPointAnnotator.get().locationChanged(evt);
                CodeProfilingPoint.Location oldLocation = (CodeProfilingPoint.Location)evt.getOldValue();
                if (oldLocation != null && !CodeProfilingPoint.Location.EMPTY.equals(oldLocation)) {
                    this.removeFileWatch(new File(oldLocation.getFile()));
                }
                if ((newLocation = (CodeProfilingPoint.Location)evt.getNewValue()) != null && !CodeProfilingPoint.Location.EMPTY.equals(newLocation)) {
                    this.addFileWatch(new File(newLocation.getFile()));
                }
            }
            if (this.isAppearanceChange(evt)) {
                ProfilingPointAnnotator.get().appearanceChanged(evt);
                this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilingPointsManager.this.processOpenedProjectsChanged();
            }
        });
    }

    public void removeProfilingPoint(ProfilingPoint profilingPoint) {
        this.removeProfilingPoints(new ProfilingPoint[]{profilingPoint});
    }

    public synchronized void removeProfilingPoints(ProfilingPoint[] profilingPointsArr) {
        this.removeProfilingPoints(profilingPointsArr, false);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void reset() {
        LinkedList<ProfilingPoint> profilingPointsToReset = new LinkedList<ProfilingPoint>();
        Collection<RuntimeProfilingPointMapper> mappersToReset = this.activeCodeProfilingPoints.values();
        for (RuntimeProfilingPointMapper mapper : mappersToReset) {
            profilingPointsToReset.add(mapper.getOwner());
        }
        this.activeCodeProfilingPoints.clear();
        profilingPointsToReset.addAll(this.activeGlobalProfilingPoints);
        this.activeGlobalProfilingPoints.clear();
        for (ProfilingPoint ppoint : profilingPointsToReset) {
            ppoint.reset();
        }
        profilingPointsToReset.clear();
    }

    public void threadsMonitoringChanged() {
    }

    public void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        Iterator<RuntimeProfilingPointMapper> it = this.activeCodeProfilingPoints.values().iterator();
        HashSet<CodeProfilingPoint> uniqueSet = new HashSet<CodeProfilingPoint>();
        while (it.hasNext()) {
            CodeProfilingPoint cpp = it.next().getOwner();
            if (!(cpp instanceof CodeProfilingPoint.Paired) || !uniqueSet.add(cpp)) continue;
            ((CodeProfilingPoint.Paired)cpp).timeAdjust(threadId, timeDiff0, timeDiff1);
        }
    }

    boolean isAnyCustomizerShowing() {
        return this.getShowingCustomizer() != null;
    }

    ValidityAwarePanel getShowingCustomizer() {
        for (ValidityAwarePanel vaPanel : this.customizers) {
            if (!vaPanel.isShowing()) continue;
            return vaPanel;
        }
        return null;
    }

    boolean customize(final ValidityAwarePanel customizer, Runnable updater, boolean focusToEditor) {
        ValidityAwarePanel showingCustomizer = this.getShowingCustomizer();
        if (showingCustomizer != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ANOTHER_PP_EDITED_MSG, 2));
            SwingUtilities.getWindowAncestor(showingCustomizer).requestFocus();
            showingCustomizer.requestFocusInWindow();
        } else {
            CustomizerButton cb = this.getCustomizerButton();
            customizer.addValidityListener(cb);
            cb.setEnabled(customizer.areSettingsValid());
            JPanel customizerContainer = new JPanel(new BorderLayout());
            JPanel customizerSpacer = new JPanel(new BorderLayout());
            customizerSpacer.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            customizerSpacer.add((Component)customizer, "Center");
            customizerContainer.add((Component)customizerSpacer, "Center");
            customizerContainer.add((Component)new JSeparator(), "South");
            HelpCtx helpCtx = null;
            if (customizer instanceof HelpCtx.Provider) {
                helpCtx = ((HelpCtx.Provider)customizer).getHelpCtx();
            }
            DialogDescriptor dd = new DialogDescriptor((Object)customizerContainer, PP_CUSTOMIZER_CAPTION, false, new Object[]{cb, DialogDescriptor.CANCEL_OPTION}, (Object)cb, 0, helpCtx, null);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.addWindowListener(new CustomizerListener(d, dd, updater));
            d.setModal(true);
            d.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (customizer.getInitialFocusTarget() != null) {
                        customizer.getInitialFocusTarget().requestFocusInWindow();
                    }
                }
            });
            if (focusToEditor) {
                Dimension dim = d.getPreferredSize();
                TopComponent masterComponent = WindowManager.getDefault().getRegistry().getActivated();
                if (masterComponent != null) {
                    Rectangle b = masterComponent.getBounds();
                    Point location = new Point(b.x + b.width / 2 - dim.width / 2, b.y + b.height / 2 - dim.height / 2);
                    SwingUtilities.convertPointToScreen(location, (Component)masterComponent);
                    d.setLocation(location);
                }
            }
            d.setVisible(true);
            if (dd.getValue() == cb) {
                return true;
            }
        }
        return false;
    }

    void documentOpened(Line.Set lineSet, FileObject fileObject) {
        block0: for (ProfilingPoint profilingPoint : this.profilingPoints) {
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint cpp = (CodeProfilingPoint)profilingPoint;
            for (CodeProfilingPoint.Annotation cppa : cpp.getAnnotations()) {
                File adeptFile;
                File annotationFile = new File(cpp.getLocation(cppa).getFile());
                if (annotationFile == null || fileObject == null || (adeptFile = FileUtil.toFile((FileObject)fileObject)) == null || !adeptFile.equals(annotationFile)) continue;
                this.deannotateProfilingPoint(cpp);
                this.annotateProfilingPoint(cpp);
                continue block0;
            }
        }
    }

    ValidityAwarePanel safeGetCustomizer(ValidityAwarePanel customizer) {
        if (!this.customizers.contains(customizer)) {
            this.customizers.add(customizer);
        }
        return this.isAnyCustomizerShowing() ? null : customizer;
    }

    private boolean isAnnotationChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        return propertyName.equals("p_annotation");
    }

    private boolean isLocationChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        return propertyName.equals("p_location");
    }

    private boolean isAppearanceChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        return propertyName.equals("p_name") || propertyName.equals("p_enabled") || propertyName.equals("p_project") || propertyName.equals("p_results");
    }

    private static boolean containsProject(Collection<Lookup.Provider> c, Lookup.Provider p) {
        if (p != null) {
            FileObject projectDir = ProjectUtilities.getProjectDirectory((Lookup.Provider)p);
            for (Lookup.Provider in : c) {
                if (!ProjectUtilities.getProjectDirectory((Lookup.Provider)in).equals(projectDir)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Lookup.Provider> getOpenSubprojects(Lookup.Provider project) {
        HashSet<Lookup.Provider> subprojects = new HashSet<Lookup.Provider>();
        ProjectUtilities.fetchSubprojects((Lookup.Provider)project, subprojects);
        if (subprojects.isEmpty()) {
            return subprojects;
        }
        HashSet<Lookup.Provider> openSubprojects = new HashSet<Lookup.Provider>();
        Collection<Lookup.Provider> collection = this.openedProjects;
        synchronized (collection) {
            for (Lookup.Provider openProject : this.openedProjects) {
                if (!ProfilingPointsManager.containsProject(subprojects, openProject)) continue;
                openSubprojects.add(openProject);
            }
        }
        return openSubprojects;
    }

    private ProfilingPoint[] getValidProfilingPoints(ProfilingPoint[] profilingPointsArr) {
        ArrayList<ProfilingPoint> validProfilingPoints = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : profilingPointsArr) {
            if (!profilingPoint.isValid()) continue;
            validProfilingPoints.add(profilingPoint);
        }
        return validProfilingPoints.toArray(new ProfilingPoint[validProfilingPoints.size()]);
    }

    private ProfilingPoint[] getInvalidProfilingPoints(ProfilingPoint[] profilingPointsArr) {
        ArrayList<ProfilingPoint> invalidProfilingPoints = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : profilingPointsArr) {
            if (profilingPoint.isValid()) continue;
            invalidProfilingPoints.add(profilingPoint);
        }
        return invalidProfilingPoints.toArray(new ProfilingPoint[invalidProfilingPoints.size()]);
    }

    private void checkProfilingPoints() {
        ProfilingPoint[] invalidProfilingPoints = this.getInvalidProfilingPoints(this.profilingPoints.toArray(new ProfilingPoint[this.profilingPoints.size()]));
        if (invalidProfilingPoints.length > 0) {
            this.removeProfilingPoints(invalidProfilingPoints);
        }
    }

    private void addFileWatch(File file) {
        FileObject fileo = null;
        if (file.isFile()) {
            fileo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileo != null) {
            FileWatch fileWatch = this.profilingPointsFiles.get(file);
            if (fileWatch == null) {
                LocationFileListener listener = new LocationFileListener(file);
                fileWatch = new FileWatch(listener);
                fileo.addFileChangeListener((FileChangeListener)listener);
                this.profilingPointsFiles.put(file, fileWatch);
            }
            fileWatch.increaseReferences();
        }
    }

    private void removeFileWatch(File file) {
        FileObject fileo = null;
        if (file.isFile()) {
            fileo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileo != null) {
            FileWatch fileWatch = this.profilingPointsFiles.get(file);
            if (fileWatch != null) {
                fileWatch.decreaseReferences();
                if (!fileWatch.hasReferences()) {
                    fileo.removeFileChangeListener((FileChangeListener)this.profilingPointsFiles.remove(file).getListener());
                }
            }
        } else {
            this.profilingPointsFiles.remove(file);
        }
    }

    private void addProfilingPointFileWatch(CodeProfilingPoint cpp) {
        CodeProfilingPoint.Annotation[] annotations;
        for (CodeProfilingPoint.Annotation annotation : annotations = cpp.getAnnotations()) {
            CodeProfilingPoint.Location location = cpp.getLocation(annotation);
            String filename = location.getFile();
            this.addFileWatch(new File(filename));
        }
    }

    private void removeProfilingPointFileWatch(CodeProfilingPoint cpp) {
        CodeProfilingPoint.Annotation[] annotations;
        for (CodeProfilingPoint.Annotation annotation : annotations = cpp.getAnnotations()) {
            CodeProfilingPoint.Location location = cpp.getLocation(annotation);
            String filename = location.getFile();
            this.removeFileWatch(new File(filename));
        }
    }

    private CodeProfilingPoint[] getProfilingPointsForFile(File file) {
        ArrayList<CodeProfilingPoint> profilingPointsForFile = new ArrayList<CodeProfilingPoint>();
        block0: for (ProfilingPoint profilingPoint : this.profilingPoints) {
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint cpp = (CodeProfilingPoint)profilingPoint;
            for (CodeProfilingPoint.Annotation annotation : cpp.getAnnotations()) {
                CodeProfilingPoint.Location location = cpp.getLocation(annotation);
                File ppFile = new File(location.getFile());
                if (!file.equals(ppFile)) continue;
                profilingPointsForFile.add(cpp);
                continue block0;
            }
        }
        return profilingPointsForFile.toArray(new CodeProfilingPoint[profilingPointsForFile.size()]);
    }

    private void deleteProfilingPointsForFile(File file) {
        this.removeProfilingPoints(this.getProfilingPointsForFile(file));
    }

    private void updateProfilingPointsFile(File oldFile, File newFile) {
        String newFilename = newFile.getAbsolutePath();
        ProfilingPoint[] cppa = this.getProfilingPointsForFile(oldFile);
        this.ignoreStoreProfilingPoints = true;
        for (CodeProfilingPoint codeProfilingPoint : cppa) {
            for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location location = codeProfilingPoint.getLocation(annotation);
                File ppFile = new File(location.getFile());
                if (!oldFile.equals(ppFile)) continue;
                CodeProfilingPoint.Location newLocation = new CodeProfilingPoint.Location(newFilename, location.getLine(), location.getOffset());
                codeProfilingPoint.setLocation(annotation, newLocation);
            }
        }
        this.ignoreStoreProfilingPoints = false;
        this.storeProfilingPoints(cppa);
    }

    private synchronized void addProfilingPoints(ProfilingPoint[] profilingPointsArr, boolean internalChange) {
        for (ProfilingPoint profilingPoint : profilingPointsArr = this.getValidProfilingPoints(profilingPointsArr)) {
            this.profilingPoints.add(profilingPoint);
            profilingPoint.addPropertyChangeListener(this);
            if (!(profilingPoint instanceof CodeProfilingPoint)) continue;
            CodeProfilingPoint cpp = (CodeProfilingPoint)profilingPoint;
            this.annotateProfilingPoint(cpp);
            this.addProfilingPointFileWatch(cpp);
        }
        if (!internalChange) {
            this.storeProfilingPoints(profilingPointsArr);
            this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
        }
    }

    private void annotateProfilingPoint(CodeProfilingPoint profilingPoint) {
        ProfilingPointAnnotator.get().annotate(profilingPoint);
    }

    private void deannotateProfilingPoint(CodeProfilingPoint profilingPoint) {
        ProfilingPointAnnotator.get().deannotate(profilingPoint);
    }

    private void loadProfilingPoints(Lookup.Provider project) {
        for (ProfilingPointFactory factory : this.profilingPointFactories) {
            try {
                this.addProfilingPoints(factory.loadProfilingPoints(project), true);
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(65536, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processOpenedProjectsChanged() {
        ArrayList<Lookup.Provider> lastOpenedProjects = new ArrayList<Lookup.Provider>();
        Collection<Lookup.Provider> collection = this.openedProjects;
        synchronized (collection) {
            lastOpenedProjects.addAll(this.openedProjects);
        }
        this.refreshOpenedProjects();
        for (Lookup.Provider project : lastOpenedProjects) {
            if (ProfilingPointsManager.containsProject(this.openedProjects, project)) continue;
            this.projectClosed(project);
        }
        for (Lookup.Provider openProject : this.openedProjects) {
            if (ProfilingPointsManager.containsProject(lastOpenedProjects, openProject)) continue;
            this.projectOpened(openProject);
        }
        this.firePropertyChanged(PROPERTY_PROJECTS_CHANGED);
    }

    private void projectClosed(Lookup.Provider project) {
        this.unloadProfilingPoints(project);
    }

    private void projectOpened(Lookup.Provider project) {
        this.loadProfilingPoints(project);
    }

    private void refreshOpenedProjects() {
        this.openedProjects.clear();
        Lookup.Provider[] openProjects = ProjectUtilities.getOpenedProjects();
        this.openedProjects.addAll(Arrays.asList(openProjects));
    }

    private void refreshProfilingPointFactories() {
        Collection factories = Lookup.getDefault().lookupAll(ProfilingPointFactory.class);
        ArrayList<ProfilingPointFactory> cleansedFactories = new ArrayList<ProfilingPointFactory>();
        for (ProfilingPointFactory factory : factories) {
            if (factory.isAvailable()) {
                cleansedFactories.add(factory);
            }
            factory.addPropertyChangeListener(ProfilingPointFactory.AVAILABILITY_PROPERTY, WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)factory));
        }
        this.profilingPointFactories = new ProfilingPointFactory[cleansedFactories.size()];
        cleansedFactories.toArray(this.profilingPointFactories);
    }

    private synchronized void removeProfilingPoints(ProfilingPoint[] profilingPointsArr, boolean internalChange) {
        for (ProfilingPoint profilingPoint : profilingPointsArr) {
            if (profilingPoint instanceof CodeProfilingPoint) {
                CodeProfilingPoint cpp = (CodeProfilingPoint)profilingPoint;
                this.removeProfilingPointFileWatch(cpp);
                this.deannotateProfilingPoint(cpp);
            }
            profilingPoint.removePropertyChangeListener(this);
            profilingPoint.hideResults();
            profilingPoint.reset();
            this.profilingPoints.remove(profilingPoint);
        }
        if (!internalChange) {
            this.storeProfilingPoints(profilingPointsArr);
            this.firePropertyChanged(PROPERTY_PROFILING_POINTS_CHANGED);
        }
    }

    private void storeDirtyProfilingPoints() {
        ProfilingPoint[] dirtyProfilingPointsArr = new ProfilingPoint[this.dirtyProfilingPoints.size()];
        this.dirtyProfilingPoints.toArray(dirtyProfilingPointsArr);
        this.storeProfilingPoints(dirtyProfilingPointsArr);
    }

    private synchronized void storeProfilingPoints(ProfilingPoint[] profilingPointsArr) {
        if (this.ignoreStoreProfilingPoints) {
            return;
        }
        HashSet<Lookup.Provider> projects = new HashSet<Lookup.Provider>();
        HashSet<ProfilingPointFactory> factories = new HashSet<ProfilingPointFactory>();
        for (ProfilingPoint profilingPoint : profilingPointsArr) {
            projects.add(profilingPoint.getProject());
            factories.add(profilingPoint.getFactory());
            this.dirtyProfilingPoints.remove(profilingPoint);
        }
        for (ProfilingPointFactory factory : factories) {
            if (factory == null) continue;
            for (Lookup.Provider project : projects) {
                try {
                    factory.saveProfilingPoints(project);
                }
                catch (IOException ex) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CANNOT_STORE_PP_MSG, factory.getType(), ProjectUtilities.getDisplayName((Lookup.Provider)project)), 0));
                }
            }
        }
    }

    private void unloadProfilingPoints(Lookup.Provider project) {
        List<ProfilingPoint> closedProfilingPoints = this.getProfilingPoints(project, false, true);
        ArrayList<ProfilingPoint> dirtyClosedProfilingPoints = new ArrayList<ProfilingPoint>();
        for (ProfilingPoint profilingPoint : closedProfilingPoints) {
            if (!this.dirtyProfilingPoints.contains(profilingPoint)) continue;
            dirtyClosedProfilingPoints.add(profilingPoint);
        }
        if (!dirtyClosedProfilingPoints.isEmpty()) {
            this.storeProfilingPoints(dirtyClosedProfilingPoints.toArray(new ProfilingPoint[0]));
        }
        for (ProfilingPoint closedProfilingPoint : closedProfilingPoints) {
            if (closedProfilingPoint instanceof CodeProfilingPoint) {
                CodeProfilingPoint cpp = (CodeProfilingPoint)closedProfilingPoint;
                this.removeProfilingPointFileWatch(cpp);
                this.deannotateProfilingPoint(cpp);
            }
            closedProfilingPoint.hideResults();
            closedProfilingPoint.reset();
            this.profilingPoints.remove(closedProfilingPoint);
        }
    }

    private CustomizerButton getCustomizerButton() {
        if (this.customizerButton == null) {
            this.customizerButton = new CustomizerButton();
        }
        return this.customizerButton;
    }

    private class LocationFileListener
    implements FileChangeListener {
        private File file;

        public LocationFileListener(File file) {
            this.file = file;
        }

        public void fileDeleted(FileEvent fe) {
            Runnable processor = new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsManager.this.deleteProfilingPointsForFile(LocationFileListener.this.file);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)processor);
            } else {
                processor.run();
            }
        }

        public void fileRenamed(final FileRenameEvent fe) {
            Runnable processor = new Runnable(){

                @Override
                public void run() {
                    FileObject renamedFileO = fe.getFile();
                    File renamedFile = FileUtil.toFile((FileObject)renamedFileO);
                    if (renamedFile != null && renamedFile.exists() && renamedFile.isFile()) {
                        ProfilingPointsManager.this.updateProfilingPointsFile(LocationFileListener.this.file, renamedFile);
                    } else {
                        ProfilingPointsManager.this.deleteProfilingPointsForFile(LocationFileListener.this.file);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)processor);
            } else {
                processor.run();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private static class FileWatch {
        private int references = 0;
        private LocationFileListener listener;

        public FileWatch(LocationFileListener listener) {
            this.listener = listener;
        }

        public boolean hasReferences() {
            return this.references > 0;
        }

        public LocationFileListener getListener() {
            return this.listener;
        }

        public void increaseReferences() {
            ++this.references;
        }

        public void decreaseReferences() {
            --this.references;
        }
    }

    private static class RuntimeProfilingPointMapper {
        private final CodeProfilingPoint owner;
        private final int index;

        public RuntimeProfilingPointMapper(CodeProfilingPoint owner, int index) {
            this.owner = owner;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public CodeProfilingPoint getOwner() {
            return this.owner;
        }
    }

    private class CustomizerListener
    extends WindowAdapter {
        private Dialog d;
        private DialogDescriptor dd;
        private Runnable updater;

        public CustomizerListener(Dialog d, DialogDescriptor dd, Runnable updater) {
            this.d = d;
            this.dd = dd;
            this.updater = updater;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.dd.getValue() == ProfilingPointsManager.this.getCustomizerButton()) {
                this.updater.run();
            }
            this.d.removeWindowListener(this);
            this.d = null;
            this.dd = null;
            this.updater = null;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.d.requestFocus();
        }
    }

    private static class CustomizerButton
    extends JButton
    implements ValidityListener {
        public CustomizerButton() {
            super(OK_BUTTON_TEXT);
        }

        @Override
        public void validityChanged(boolean isValid) {
            this.setEnabled(isValid);
        }
    }

    private static class ProfilingPointsComparator
    implements Comparator {
        private boolean sortOrder;
        private int sortBy;

        public ProfilingPointsComparator(int sortBy, boolean sortOrder) {
            this.sortBy = sortBy;
            this.sortOrder = sortOrder;
        }

        public int compare(Object o1, Object o2) {
            ProfilingPoint pp1 = this.sortOrder ? (ProfilingPoint)o1 : (ProfilingPoint)o2;
            ProfilingPoint pp2 = this.sortOrder ? (ProfilingPoint)o2 : (ProfilingPoint)o1;
            switch (this.sortBy) {
                case -1: 
                case 1: {
                    return ProjectUtilities.getDisplayName((Lookup.Provider)pp1.getProject()).compareTo(ProjectUtilities.getDisplayName((Lookup.Provider)pp2.getProject()));
                }
                case 2: {
                    int v1 = pp1.getFactory().getScope();
                    int v2 = pp2.getFactory().getScope();
                    return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
                }
                case 3: {
                    return pp1.getName().compareTo(pp2.getName());
                }
                case 4: {
                    return pp1.getResultsText().compareTo(pp2.getResultsText());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + o1 + ", " + o2);
        }
    }
}

