/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.LoadGenProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.LoadGeneratorCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LoadGenProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpDefaultName");
    private static final String LOADGEN_PP_TYPE = PP_TYPE;
    private static final String LOADGEN_PP_DESCR = PP_DESCR;
    private static final String START_LOCATION_PREFIX = "start_";
    private static final String END_LOCATION_PREFIX = "end_";
    private static LoadGenProfilingPointFactory defaultInstance = null;
    private final Lookup.Result loadGenResult;
    private final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            LoadGenProfilingPointFactory.this.available = ((Lookup.Result)lookupEvent.getSource()).allInstances().size() > 0;
            LoadGenProfilingPointFactory.this.firePropertyChange(new PropertyChangeEvent(LoadGenProfilingPointFactory.this, ProfilingPointFactory.AVAILABILITY_PROPERTY, false, true));
        }
    };
    private boolean available = false;

    public LoadGenProfilingPointFactory() {
        this.loadGenResult = Lookup.getDefault().lookupResult(LoadGenPlugin.class);
        this.loadGenResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)this.loadGenResult));
        this.available = this.loadGenResult.allInstances().size() > 0;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public String getDescription() {
        return LOADGEN_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.LoadGenerator");
    }

    @Override
    public Icon getDisabledIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.LoadGeneratorDisabled");
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return LOADGEN_PP_TYPE;
    }

    @Override
    public ProfilingPoint create(Lookup.Provider project) {
        CodeProfilingPoint.Location[] selectionLocations;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((selectionLocations = Utils.getCurrentSelectionLocations()).length != 2) {
            CodeProfilingPoint.Location location = Utils.getCurrentLocation(Integer.MIN_VALUE);
            if (location.equals(CodeProfilingPoint.Location.EMPTY)) {
                String filename = "";
                String name = Utils.getUniqueName(this.getType(), "", project);
                return new LoadGenProfilingPoint(name, location, null, project, this);
            }
            File file = FileUtil.normalizeFile((File)new File(location.getFile()));
            String filename = FileUtil.toFileObject((File)file).getName();
            String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", filename, location.getLine()), project);
            return new LoadGenProfilingPoint(name, location, null, project, this);
        }
        CodeProfilingPoint.Location startLocation = selectionLocations[0];
        CodeProfilingPoint.Location endLocation = selectionLocations[1];
        File file = FileUtil.normalizeFile((File)new File(startLocation.getFile()));
        String filename = FileUtil.toFileObject((File)file).getName();
        String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", filename, startLocation.getLine()), project);
        return new LoadGenProfilingPoint(name, startLocation, endLocation, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return LoadGenProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.global.ProfilingPointServerHandler";
    }

    @Override
    protected ValidityAwarePanel createCustomizer() {
        return new LoadGeneratorCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Lookup.Provider project, Properties properties, int index) {
        String name = properties.getProperty(index + "_" + "p_name", null);
        String enabledStr = properties.getProperty(index + "_" + "p_enabled", null);
        String scriptFile = properties.getProperty(index + "_" + "p_ScriptName", null);
        CodeProfilingPoint.Location startLocation = CodeProfilingPoint.Location.load(project, index, START_LOCATION_PREFIX, properties);
        CodeProfilingPoint.Location endLocation = CodeProfilingPoint.Location.load(project, index, END_LOCATION_PREFIX, properties);
        if (name == null || enabledStr == null || startLocation == null) {
            return null;
        }
        LoadGenProfilingPoint profilingPoint = null;
        try {
            profilingPoint = new LoadGenProfilingPoint(name, startLocation, endLocation, project, this);
            profilingPoint.setEnabled(Boolean.parseBoolean(enabledStr));
            profilingPoint.setSriptFileName(scriptFile);
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        return profilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int index, Properties properties) {
        LoadGenProfilingPoint loadgen = (LoadGenProfilingPoint)profilingPoint;
        properties.put(index + "_" + "p_name", loadgen.getName());
        properties.put(index + "_" + "p_enabled", Boolean.toString(loadgen.isEnabled()));
        properties.put(index + "_" + "p_ScriptName", loadgen.getScriptFileName());
        loadgen.getStartLocation().store(loadgen.getProject(), index, START_LOCATION_PREFIX, properties);
        if (loadgen.usesEndLocation()) {
            loadgen.getEndLocation().store(loadgen.getProject(), index, END_LOCATION_PREFIX, properties);
        }
    }
}

