/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.completion.spi.dynhelp.CompletionDocumentationProvider;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CsmIncludeCompletionItem
implements CompletionItem {
    protected static final String QUOTE = "\"";
    protected static final String SYS_OPEN = "<";
    protected static final String SYS_CLOSE = ">";
    protected static final String SLASH = "/";
    protected static final String PARENT_COLOR_TAG = "<font color=\"#557755\">";
    private final int substitutionOffset;
    private final int priority;
    private final String item;
    private final String parentFolder;
    private final String childSubdir;
    private final boolean isSysInclude;
    private final boolean isFolder;
    private final boolean supportInstantSubst;
    private static final int FOLDER_PRIORITY = 30;
    private static final int FILE_PRIORITY = 10;
    private static final int SYS_VS_USR = 5;

    protected CsmIncludeCompletionItem(int substitutionOffset, int priority, String parentFolder, String childSubdir, String item, boolean sysInclude, boolean isFolder, boolean supportInstantSubst) {
        this.substitutionOffset = substitutionOffset;
        this.priority = priority;
        this.parentFolder = parentFolder == null ? "" : parentFolder;
        this.childSubdir = childSubdir == null ? "" : childSubdir;
        this.isSysInclude = sysInclude;
        this.isFolder = isFolder;
        assert (item != null);
        this.item = item;
        this.supportInstantSubst = supportInstantSubst;
    }

    public static CsmIncludeCompletionItem createItem(int substitutionOffset, String relFileName, String dirPrefix, String childSubdir, boolean sysInclude, boolean highPriority, boolean isFolder, boolean supportInstantSubst) {
        int priority = isFolder ? (highPriority ? 25 : 35) : (highPriority ? 5 : 15);
        String item = relFileName;
        return new CsmIncludeCompletionItem(substitutionOffset, priority, dirPrefix, childSubdir, item, sysInclude, isFolder, supportInstantSubst);
    }

    public String getItemText() {
        return this.item;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            boolean folder = this.isFolder();
            if (!folder) {
                Completion.get().hideCompletion();
            }
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, this.isFolder() ? SLASH : null);
            if (folder) {
                Completion.get().showCompletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processKeyEvent(KeyEvent evt) {
        block12: {
            if (evt.getID() != 400) break block12;
            JTextComponent component = (JTextComponent)evt.getSource();
            BaseDocument doc = (BaseDocument)component.getDocument();
            int caretOffset = component.getSelectionEnd();
            int len = caretOffset - this.substitutionOffset;
            if (len < 0) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            switch (evt.getKeyChar()) {
                case '>': {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    break;
                }
                case '\"': {
                    doc.readLock();
                    boolean hide = false;
                    try {
                        String toReplace;
                        if (len > 0 && (toReplace = doc.getText(this.substitutionOffset, len)).startsWith(QUOTE) && len > 1) {
                            hide = true;
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        doc.readUnlock();
                    }
                    if (!hide) break;
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    break;
                }
                case '/': {
                    if (len <= 1 || !this.isFolder()) break;
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    this.substituteText(component, this.substitutionOffset, len, SLASH);
                    evt.consume();
                    Completion.get().showCompletion();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (this.supportInstantSubst) {
            this.defaultAction(component);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        CompletionDocumentationProvider p = (CompletionDocumentationProvider)Lookup.getDefault().lookup(CompletionDocumentationProvider.class);
        return p != null ? p.createDocumentationTask(this) : null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightText(false, File.separator), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)(PARENT_COLOR_TAG + this.getRightText(true, File.separator)), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.isFolder() ? "[D] " : "[F] ");
        out.append(this.isSysInclude() ? SYS_OPEN : QUOTE);
        out.append(this.getLeftHtmlText(false));
        out.append(this.isSysInclude() ? SYS_CLOSE : QUOTE);
        out.append(" : ");
        out.append(this.getRightText(false, SLASH));
        return out.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.item;
    }

    public CharSequence getInsertPrefix() {
        return this.item;
    }

    protected ImageIcon getIcon() {
        return CsmImageLoader.getIncludeImageIcon((boolean)this.isSysInclude(), (boolean)this.isFolder());
    }

    protected String getLeftHtmlText(boolean html) {
        return (html ? (this.isFolder() ? "<i>" : "") : "") + this.getItemText();
    }

    protected String getRightText(boolean shrink, String separator) {
        return CsmDisplayUtilities.shrinkPath((CharSequence)(this.getParentFolder() + separator + this.getChildSubdir()), (boolean)shrink, (String)separator, (int)35, (int)2, (int)2);
    }

    protected void substituteText(final JTextComponent c, final int offset, final int origLen, final String toAdd) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final String itemText = this.getItemText();
        if (itemText != null) {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String parent;
                        int len = origLen;
                        String text = itemText;
                        if (toAdd != null) {
                            text = text + toAdd;
                        }
                        TokenItem token = CndTokenUtilities.getToken((Document)doc, (int)offset, (boolean)true);
                        String pref = CsmIncludeCompletionItem.QUOTE;
                        String post = CsmIncludeCompletionItem.QUOTE;
                        if (token != null) {
                            boolean changeLength = false;
                            TokenId id = token.id();
                            if (id instanceof CppTokenId) {
                                switch ((CppTokenId)id) {
                                    case WHITESPACE: 
                                    case PREPROCESSOR_IDENTIFIER: {
                                        pref = CsmIncludeCompletionItem.this.isSysInclude ? CsmIncludeCompletionItem.SYS_OPEN : CsmIncludeCompletionItem.QUOTE;
                                        post = CsmIncludeCompletionItem.this.isSysInclude ? CsmIncludeCompletionItem.SYS_CLOSE : CsmIncludeCompletionItem.QUOTE;
                                        break;
                                    }
                                    case PREPROCESSOR_USER_INCLUDE: {
                                        pref = CsmIncludeCompletionItem.QUOTE;
                                        post = CsmIncludeCompletionItem.QUOTE;
                                        changeLength = true;
                                        break;
                                    }
                                    case PREPROCESSOR_SYS_INCLUDE: {
                                        pref = CsmIncludeCompletionItem.SYS_OPEN;
                                        post = CsmIncludeCompletionItem.SYS_CLOSE;
                                        changeLength = true;
                                    }
                                }
                            }
                            if (changeLength) {
                                len = token.offset() + token.length() - offset - (token.partType() == PartType.COMPLETE ? 0 : 1);
                            }
                        }
                        if ((parent = CsmIncludeCompletionItem.this.getChildSubdir()).length() > 0 && !parent.endsWith(CsmIncludeCompletionItem.SLASH)) {
                            parent = parent + CsmIncludeCompletionItem.SLASH;
                        }
                        text = pref + parent + text + post;
                        Position position = doc.createPosition(offset);
                        Position lastPosition = doc.createPosition(offset + len);
                        doc.remove(offset, len);
                        doc.insertString(position.getOffset(), text, null);
                        if (c != null && CsmIncludeCompletionItem.this.isFolder()) {
                            c.setCaretPosition(lastPosition.getOffset() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected boolean isFolder() {
        return this.isFolder;
    }

    protected String getParentFolder() {
        return this.parentFolder;
    }

    protected String getChildSubdir() {
        return this.childSubdir;
    }

    protected boolean isSysInclude() {
        return this.isSysInclude;
    }
}

