/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public abstract class CsmAbstractHyperlinkProvider
implements HyperlinkProviderExt {
    private TokenItem<TokenId> jumpToken = null;
    private Cancellable hyperLinkTask;

    protected CsmAbstractHyperlinkProvider() {
        DefaultCaret caret = new DefaultCaret();
        caret.setMagicCaretPosition(null);
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION, HyperlinkType.ALT_HYPERLINK);
    }

    protected abstract void performAction(Document var1, JTextComponent var2, int var3, HyperlinkType var4);

    public void performClickAction(Document originalDoc, final int offset, final HyperlinkType type) {
        if (originalDoc == null) {
            return;
        }
        final Document doc = originalDoc;
        final JTextComponent target = Utilities.getFocusedComponent();
        if (target == null || target.getDocument() != doc) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                int[] span = CsmMacroExpansion.getMacroExpansionSpan((Document)doc, (int)offset, (boolean)false);
                if (type == HyperlinkType.ALT_HYPERLINK && span != null && span[0] != span[1]) {
                    CsmMacroExpansion.showMacroExpansionView((Document)doc, (int)offset);
                } else {
                    CsmAbstractHyperlinkProvider.this.performAction(doc, target, offset, type);
                }
            }
        };
        if (this.hyperLinkTask != null) {
            this.hyperLinkTask.cancel();
        }
        this.hyperLinkTask = CsmModelAccessor.getModel().enqueue(run, (CharSequence)"Following hyperlink");
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        TokenItem<TokenId> token = CsmAbstractHyperlinkProvider.getToken(doc, offset);
        return this.isValidToken(token, type);
    }

    protected abstract boolean isValidToken(TokenItem<TokenId> var1, HyperlinkType var2);

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        int[] span;
        TokenItem<TokenId> token = CsmAbstractHyperlinkProvider.getToken(doc, offset);
        if (type == HyperlinkType.ALT_HYPERLINK && (span = CsmMacroExpansion.getMacroExpansionSpan((Document)doc, (int)offset, (boolean)false)) != null && span[0] != span[1]) {
            return span;
        }
        if (this.isValidToken(token, type)) {
            this.jumpToken = token;
            return new int[]{token.offset(), token.offset() + token.length()};
        }
        return null;
    }

    protected boolean preJump(Document doc, JTextComponent target, int offset, String msgKey, HyperlinkType type) {
        if (doc == null || target == null || offset < 0 || offset > doc.getLength()) {
            return false;
        }
        this.jumpToken = CsmAbstractHyperlinkProvider.getToken(doc, offset);
        if (!this.isValidToken(this.jumpToken, type)) {
            return false;
        }
        StringBuilder buf = new StringBuilder(this.jumpToken.text());
        String name = buf.toString();
        String msg = NbBundle.getBundle(CsmCompletionUtils.class).getString(msgKey);
        msg = MessageFormat.format(msg, name);
        StatusDisplayer.getDefault().setStatusText(msg);
        return true;
    }

    protected boolean postJump(CsmOffsetable item, String existItemKey, String noItemKey) {
        if (this.jumpToken == null) {
            return false;
        }
        if (item == null || !CsmUtilities.openSource((CsmObject)item)) {
            String name;
            String key;
            Toolkit.getDefaultToolkit().beep();
            String itemDesc = CsmUtilities.getElementJumpName((CsmObject)item);
            if (itemDesc != null && itemDesc.length() > 0) {
                key = "goto_source_source_not_found";
                name = itemDesc;
            } else {
                key = "cannot-open-csm-element";
                StringBuilder buf = new StringBuilder(this.jumpToken.text());
                name = buf.toString();
            }
            String msg = NbBundle.getBundle(CsmCompletionUtils.class).getString(key);
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, name));
            return false;
        }
        return true;
    }

    protected TokenItem<TokenId> getJumpToken() {
        return this.jumpToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TokenItem<TokenId> getToken(Document doc, int offset) {
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            TokenItem tokenItem = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            return tokenItem;
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        int[] span;
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        if (type == HyperlinkType.ALT_HYPERLINK && (span = CsmMacroExpansion.getMacroExpansionSpan((Document)doc, (int)offset, (boolean)true)) != null && span[0] != span[1]) {
            return this.getMacroExpandedText(doc, span[0], span[1]);
        }
        TokenItem<TokenId> token = this.jumpToken;
        if (token == null || token.offset() > offset || token.offset() + token.length() < offset) {
            token = CsmAbstractHyperlinkProvider.getToken(doc, offset);
        }
        if (!this.isValidToken(token, type)) {
            return null;
        }
        return this.getTooltipText(doc, token, offset, type);
    }

    protected abstract String getTooltipText(Document var1, TokenItem<TokenId> var2, int var3, HyperlinkType var4);

    private String getMacroExpandedText(final Document doc, final int start, final int end) {
        String expandedText = CsmMacroExpansion.expand((Document)doc, (int)start, (int)end);
        final StringBuilder docText = new StringBuilder();
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    docText.append(doc.getText(start, end - start));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return NbBundle.getMessage(CsmAbstractHyperlinkProvider.class, (String)"MacroExpansion", (Object)CsmDisplayUtilities.htmlize((CharSequence)docText), (Object)CsmDisplayUtilities.htmlize((CharSequence)expandedText));
    }

    protected final CharSequence getAlternativeHyperlinkTip(Document doc, String altTextKey, CharSequence tooltip) {
        UIGesturesSupport.submit((String)"USG_CND_HYPERLINK_TOOLTIP", (Object[])new Object[]{altTextKey});
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)NbEditorUtilities.getMimeType((Document)doc)).lookup(Preferences.class);
        int shortCut = prefs.getInt("alt-hyperlink-activation-modifiers", 640);
        return NbBundle.getMessage(CsmAbstractHyperlinkProvider.class, (String)altTextKey, (Object)tooltip, (Object)InputEvent.getModifiersExText(shortCut));
    }
}

