/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;

public class GlobalRepositoryTreeAdapter
implements TreeModel,
GlobalRepositoryListener,
SceneListener,
PropertyChangeListener {
    private static final boolean DEBUG = false;
    private EventListenerList listenerList;
    private GlobalRepository globalRepository;

    public GlobalRepositoryTreeAdapter(GlobalRepository globalRepository) {
        this.globalRepository = globalRepository;
        this.listenerList = new EventListenerList();
        this.registerListeners();
    }

    private void registerListeners() {
        this.globalRepository.addGlobalRepositoryListener(this);
        for (Scene scene : this.globalRepository.getScenes()) {
            scene.addSceneListener(this);
            scene.addPropertyChangeListener(this);
            for (Layer layer : scene.getLayers()) {
                layer.addPropertyChangeListener(this);
            }
        }
    }

    @Override
    public Object getRoot() {
        return this.globalRepository;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.globalRepository) {
            int numScenes = this.globalRepository.getScenes().size();
            if (index >= numScenes) {
                return null;
            }
            return this.globalRepository.getScenes().get(index);
        }
        if (parent instanceof Scene) {
            return ((Scene)parent).getLayerAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.globalRepository) {
            return this.globalRepository.getScenes().size();
        }
        if (parent instanceof Scene) {
            return ((Scene)parent).getLayers().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node != this.globalRepository && !(node instanceof Scene);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.globalRepository) {
            return this.globalRepository.getScenes().indexOf((Scene)child);
        }
        if (parent instanceof Scene) {
            return ((Scene)parent).indexOf((Layer)child);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerList.add(TreeModelListener.class, listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listenerList.remove(TreeModelListener.class, listener);
    }

    @Override
    public void sceneAdded(Scene scene, int index) {
        scene.addPropertyChangeListener(this);
        scene.addSceneListener(this);
        TreePath path = new TreePath(this.getRoot());
        this.fireNodeInserted(path, index, scene);
    }

    @Override
    public void sceneRemoved(Scene scene, int index) {
        scene.removePropertyChangeListener(this);
        scene.removeSceneListener(this);
        TreePath path = new TreePath(this.getRoot());
        this.fireNodeRemoved(path, index, scene);
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int index) {
        tiledLayer.addPropertyChangeListener(this);
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int index) {
        tiledLayer.removePropertyChangeListener(this);
    }

    @Override
    public void spriteAdded(Sprite sprite, int index) {
        sprite.addPropertyChangeListener(this);
    }

    @Override
    public void spriteRemoved(Sprite sprite, int index) {
        sprite.removePropertyChangeListener(this);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    private void fireNodeInserted(TreePath path, int index, Object object) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{object});
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    private void fireNodeRemoved(TreePath path, int index, Object object) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{object});
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    private void fireNodeChanged(TreePath path, int index, Object object) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{object});
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    @Override
    public void layerAdded(Scene sourceScene, Layer layer, int index) {
        TreePath path = new TreePath(new Object[]{this.getRoot(), sourceScene});
        this.fireNodeInserted(path, index, layer);
    }

    @Override
    public void layerRemoved(Scene sourceScene, Layer layer, Scene.LayerInfo info, int index) {
        TreePath path = new TreePath(new Object[]{this.getRoot(), sourceScene});
        this.fireNodeRemoved(path, index, layer);
    }

    @Override
    public void layerMoved(Scene sourceScene, Layer layer, int indexOld, int indexNew) {
        this.layerRemoved(sourceScene, layer, null, indexOld);
        this.layerAdded(sourceScene, layer, indexNew);
    }

    @Override
    public void layerPositionChanged(Scene sourceScene, Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
    }

    @Override
    public void layerLockChanged(Scene sourceScene, Layer layer, boolean locked) {
    }

    @Override
    public void layerVisibilityChanged(Scene sourceScene, Layer layer, boolean visible) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object src = e.getSource();
        if (e.getPropertyName().equals("editable.prop.name")) {
            if (src instanceof Scene) {
                Scene scene = (Scene)src;
                TreePath path = new TreePath(this.getRoot());
                this.fireNodeChanged(path, this.globalRepository.getScenes().indexOf(scene), scene);
            } else if (src instanceof Layer) {
                Layer layer = (Layer)src;
                for (Scene scene : this.globalRepository.getScenes()) {
                    if (!scene.getLayers().contains(layer)) continue;
                    TreePath path = new TreePath(new Object[]{this.getRoot(), scene});
                    this.fireNodeChanged(path, scene.getLayers().indexOf(layer), layer);
                }
            }
        }
    }
}

