/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import javax.swing.AbstractListModel;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.openide.util.NbBundle;

public class GlobalRepositoryListAdapter
extends AbstractListModel
implements GlobalRepositoryListener {
    private static final int ADDITIONAL_LIST_ITEM_COUNT = 4;
    private static final String ADDITIONAL_LIST_ITEM_SCENES_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelScenes");
    private static final String ADDITIONAL_LIST_ITEM_TILEDLAYERS_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelTiledLayers");
    private static final String ADDITIONAL_LIST_ITEM_SPRITES_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelSprites");
    private GlobalRepository gameDesign;

    public void setGameDesign(GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
        this.gameDesign.addGlobalRepositoryListener(this);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        if (this.gameDesign == null) {
            return 0;
        }
        int sceneCount = this.gameDesign.getScenes().size();
        int tiledLayerCount = this.gameDesign.getTiledLayers().size();
        int spriteCount = this.gameDesign.getSprites().size();
        return sceneCount + tiledLayerCount + spriteCount + 4;
    }

    @Override
    public Object getElementAt(int index) {
        int sceneCount = this.gameDesign.getScenes().size();
        int tiledLayerCount = this.gameDesign.getTiledLayers().size();
        int spriteCount = this.gameDesign.getSprites().size();
        int offset = 0;
        if (index == 0) {
            return this.gameDesign;
        }
        ++offset;
        if (index == 1) {
            return ADDITIONAL_LIST_ITEM_SCENES_LABEL;
        }
        if (index < sceneCount + ++offset) {
            return this.gameDesign.getScenes().get(index - offset);
        }
        if (index == (offset += sceneCount)) {
            return ADDITIONAL_LIST_ITEM_TILEDLAYERS_LABEL;
        }
        if (index < tiledLayerCount + ++offset) {
            return this.gameDesign.getTiledLayers().get(index - offset);
        }
        if (index == (offset += tiledLayerCount)) {
            return ADDITIONAL_LIST_ITEM_SPRITES_LABEL;
        }
        if (index < spriteCount + ++offset) {
            return this.gameDesign.getSprites().get(index - offset);
        }
        return null;
    }

    @Override
    public void sceneAdded(Scene scene, int index) {
        int offset = 2;
        this.fireIntervalAdded(this, index + offset, index + offset);
    }

    @Override
    public void sceneRemoved(Scene scene, int index) {
        int offset = 2;
        this.fireIntervalRemoved(this, index + offset, index + offset);
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int index) {
        int offset = 2 + this.gameDesign.getScenes().size() + 1;
        this.fireIntervalAdded(this, index + offset, index + offset);
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int index) {
        int offset = 2 + this.gameDesign.getScenes().size() + 1;
        this.fireIntervalRemoved(this, index + offset, index + offset);
    }

    @Override
    public void spriteAdded(Sprite sprite, int index) {
        int offset = 2 + this.gameDesign.getScenes().size() + 1 + this.gameDesign.getTiledLayers().size() + 1;
        this.fireIntervalAdded(this, index + offset, index + offset);
    }

    @Override
    public void spriteRemoved(Sprite sprite, int index) {
        int offset = 2 + this.gameDesign.getScenes().size() + 1 + this.gameDesign.getTiledLayers().size() + 1;
        this.fireIntervalRemoved(this, index + offset, index + offset);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }
}

