/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.SceneSelectionListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ScenePanel
extends JPanel
implements TiledLayerListener,
PropertyChangeListener,
MouseMotionListener,
MouseListener {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GRID_X = 20;
    private static final int DEFAULT_GRID_Y = 20;
    private static final int GRID_MINORS_IN_A_MAJOR = 5;
    private static final Color COLOR_BG = Color.WHITE;
    private static final Color COLOR_GRID_MINOR = Color.GRAY;
    private static final Color COLOR_GRID_MAJOR = Color.BLACK;
    private static final Color COLOR_GRID_QUADRANT = Color.LIGHT_GRAY;
    private Scene scene;
    private Ruler horizontalRuler = new Ruler(0);
    private Ruler verticalRuler = new Ruler(1);
    private GridButton gridButton = new GridButton();
    private boolean showGrid = true;
    private boolean snapGrid = false;
    private int gridX = 20;
    private int gridY = 20;
    private boolean animated;
    private static final int DECOR_TOP_W = 0;
    private static final int DECOR_TOP_H = 25;
    private static final int DECOR_SIDE_W = 5;
    private static final int DECOR_BOTTOM_W = 5;
    private static final int DECOR_BOTTOM_H = 5;
    private Layer topHilitedLayer;
    private Map<Layer, Color> hilitedLayers = new HashMap<Layer, Color>();
    private Color colorSelection = new Color(0, 0, 255, 170);
    private Color colorSelectionLocked = new Color(255, 0, 0, 170);
    private Color colorHilitePrimary = new Color(0, 0, 0, 120);
    private Color colorHiliteSecondary = new Color(0, 0, 0, 50);
    private Map<Layer, Point> dragLayerStartPoints = new HashMap<Layer, Point>();
    private Point startDragPoint = null;
    private Point lastDragPoint = null;
    private Layer snapToGridReferenceLayer = null;
    private String dragDirectionVertical = "North";
    private String dragDirectionHorizontal = "West";
    private boolean mouseDragging;
    private Layer lastAddedLayerByMousePress = null;

    public ScenePanel(Scene scene) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.scene = scene;
        this.scene.addSceneListener(new SceneListenerImpl());
        this.scene.addSceneListener(new SceneSelectionListenerImpl());
        this.scene.addPropertyChangeListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.accessible.description"));
        for (Layer layer : this.scene.getLayers()) {
            this.registerLayerListeners(layer);
        }
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    private void registerLayerListeners(Layer layer) {
        layer.addPropertyChangeListener(this);
        if (layer instanceof TiledLayer) {
            TiledLayer tl = (TiledLayer)layer;
            tl.addTiledLayerListener(this);
        }
        if (layer instanceof Sprite) {
            Sprite sprite = (Sprite)layer;
        }
    }

    private void unregisterLayerListeners(Layer layer) {
        layer.removePropertyChangeListener(this);
        if (layer instanceof TiledLayer) {
            TiledLayer tl = (TiledLayer)layer;
            tl.removeTiledLayerListener(this);
        }
        if (layer instanceof Sprite) {
            Sprite sprite = (Sprite)layer;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle bounds = this.scene.getAllLayersBounds();
        bounds.add(0, 0);
        return bounds.getSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.clearBackground(g);
        this.drawQuadrants(g);
        if (this.isShowGrid()) {
            this.drawGrid(g);
        }
        this.drawSceneItems(g);
    }

    private void clearBackground(Graphics g) {
        Rectangle rect = g.getClipBounds();
        g.setColor(COLOR_BG);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    private void drawGrid(Graphics g) {
        Point quadrantOrigin = this.adjustFromOriginShift(new Point(0, 0));
        Rectangle rect = g.getClipBounds();
        int colMin = (int)(rect.getX() / (double)this.gridX);
        int colMax = (int)((rect.getX() + rect.getWidth()) / (double)this.gridX);
        int rowMin = (int)(rect.getY() / (double)this.gridY);
        int rowMax = (int)((rect.getY() + rect.getHeight()) / (double)this.gridY);
        for (int r = rowMin; r <= rowMax; ++r) {
            for (int c = colMin; c <= colMax; ++c) {
                if (0 == c % 5 || 0 == r % 5) {
                    g.setColor(COLOR_GRID_MAJOR);
                } else {
                    g.setColor(COLOR_GRID_MINOR);
                }
                int x = c * this.gridX + quadrantOrigin.x % this.gridX;
                int y = r * this.gridY + quadrantOrigin.y % this.gridY;
                g.drawLine(x, y, x, y);
            }
        }
    }

    private void drawQuadrants(Graphics g) {
        Point quadrantOrigin = this.adjustFromOriginShift(new Point(0, 0));
        Rectangle clip = g.getClipBounds();
        g.setColor(COLOR_GRID_QUADRANT);
        if (clip.intersectsLine(quadrantOrigin.x, 2.147483647E9, quadrantOrigin.x, -2.147483648E9)) {
            g.drawLine(quadrantOrigin.x, clip.y, quadrantOrigin.x, clip.y + clip.height);
        }
        if (clip.intersectsLine(2.147483647E9, quadrantOrigin.y, -2.147483648E9, quadrantOrigin.y)) {
            g.drawLine(clip.x, quadrantOrigin.y, clip.x + clip.width, quadrantOrigin.y);
        }
    }

    private void drawSceneItems(Graphics g) {
        this.drawLayers(g);
        for (int i = 0; i < this.scene.getLayerCount(); ++i) {
            Layer layer = this.scene.getLayerAt(i);
            this.drawLayerDecorations((Graphics2D)g, layer);
        }
    }

    void drawLayers(Graphics g) {
        for (int i = this.scene.getLayerCount() - 1; i >= 0; --i) {
            Layer layer = this.scene.getLayerAt(i);
            if (!this.scene.isLayerVisible(layer)) continue;
            this.drawLayer(g, layer);
        }
    }

    private void drawLayer(Graphics g, Layer layer) {
        Rectangle origClipBounds = g.getClipBounds();
        Point layerPos = this.scene.getLayerPosition(layer);
        this.adjustFromOriginShift(layerPos);
        Rectangle layerRect = new Rectangle(layerPos.x, layerPos.y, layer.getWidth(), layer.getHeight());
        Rectangle intersection = layerRect.intersection(origClipBounds);
        if (intersection.isEmpty()) {
            return;
        }
        g.setClip(intersection);
        g.translate(layerPos.x, layerPos.y);
        layer.paint((Graphics2D)g);
        g.translate(-layerPos.x, -layerPos.y);
        g.setClip(origClipBounds);
    }

    private void drawLayerDecorations(Graphics2D g, Layer layer) {
        if (!this.hilitedLayers.containsKey(layer) && !this.scene.isLayerSelected(layer)) {
            return;
        }
        if (this.scene.isLayerSelected(layer)) {
            if (this.scene.isLayerLocked(layer)) {
                g.setColor(this.colorSelectionLocked);
            } else {
                g.setColor(this.colorSelection);
            }
        } else if (this.hilitedLayers.containsKey(layer)) {
            g.setColor(this.hilitedLayers.get(layer));
        } else {
            return;
        }
        Rectangle r = null;
        r = this.getDecorationRectangleForLayerBottom(layer);
        r.translate(0, -layer.getHeight() - 5);
        g.fillRect(r.x, r.y, r.width, r.height);
        r = this.getDecorationRectangleForLayerBottom(layer);
        g.fillRect(r.x, r.y, r.width, r.height);
        r = this.getDecorationRectangleForLayerLeft(layer);
        g.fillRect(r.x, r.y, r.width, r.height);
        r = this.getDecorationRectangleForLayerRight(layer);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    private Rectangle getDecorationRectangleForLayerTop(Layer layer) {
        Point pos = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerTop(pos, layer);
    }

    private Rectangle getDecorationRectangleForLayerBottom(Layer layer) {
        Point pos = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerBottom(pos, layer);
    }

    private Rectangle getDecorationRectangleForLayerLeft(Layer layer) {
        Point pos = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerLeft(pos, layer);
    }

    private Rectangle getDecorationRectangleForLayerRight(Layer layer) {
        Point pos = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        return this.getDecorationRectangleForLayerRight(pos, layer);
    }

    private Rectangle getDecorationRectangleForLayerTop(Point pos, Layer layer) {
        return new Rectangle(pos.x - 0, pos.y - 25, 0 + layer.getWidth() + 0, 25);
    }

    private Rectangle getDecorationRectangleForLayerBottom(Point pos, Layer layer) {
        return new Rectangle(pos.x - 5, pos.y + layer.getHeight(), 5 + layer.getWidth() + 5, 5);
    }

    private Rectangle getDecorationRectangleForLayerLeft(Point pos, Layer layer) {
        return new Rectangle(pos.x - 5, pos.y, 5, layer.getHeight());
    }

    private Rectangle getDecorationRectangleForLayerRight(Point pos, Layer layer) {
        return new Rectangle(pos.x + layer.getWidth(), pos.y, 5, layer.getHeight());
    }

    private void repaintLayerWithDecorations(Layer layer) {
        Point p = this.scene.getLayerPosition(layer);
        this.repaintLayerWithDecorations(p, layer);
    }

    private void repaintLayerWithDecorations(Point posUnadjusted, Layer layer) {
        Point pos = this.adjustFromOriginShift(posUnadjusted);
        this.repaintLayer(pos, layer);
        this.repaintLayerDecorations(pos, layer);
    }

    private void repaintLayer(Layer layer) {
        Point p = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        this.repaintLayer(p, layer);
    }

    private void repaintLayer(Point pos, Layer layer) {
        this.repaint(pos.x, pos.y, layer.getWidth(), layer.getHeight());
    }

    private void repaintLayerDecorations(Point pos, Layer layer) {
        this.repaint(this.getDecorationRectangleForLayerTop(pos, layer));
        this.repaint(this.getDecorationRectangleForLayerBottom(pos, layer));
        this.repaint(this.getDecorationRectangleForLayerLeft(pos, layer));
        this.repaint(this.getDecorationRectangleForLayerRight(pos, layer));
    }

    private void repaintLayerDecorations(Layer layer) {
        if (layer == null) {
            return;
        }
        Point p = this.adjustFromOriginShift(this.scene.getLayerPosition(layer));
        this.repaintLayerDecorations(p, layer);
    }

    private void repaintAllLayerDecorations() {
        List<Layer> layers = this.scene.getLayers();
        for (Layer layer : layers) {
            this.repaintLayerDecorations(layer);
        }
    }

    private Point adjustFromOriginShift(Point p) {
        Rectangle layersBox = this.scene.getAllLayersBounds();
        layersBox.add(0, 0);
        p.translate(-layersBox.x, -layersBox.y);
        return p;
    }

    private Point adjustToOriginShift(Point p) {
        Rectangle layersBox = this.scene.getAllLayersBounds();
        layersBox.add(0, 0);
        p.translate(layersBox.x, layersBox.y);
        return p;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.scene) {
            if (e.getPropertyName().equals("prop.layers.bounds")) {
                this.revalidate();
                this.repaint();
                this.horizontalRuler.repaint();
                this.verticalRuler.repaint();
            }
        } else if (e.getSource() instanceof TiledLayer) {
            TiledLayer tl = (TiledLayer)e.getSource();
        } else if (e.getSource() instanceof Sprite) {
            Sprite s = (Sprite)e.getSource();
            if (e.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
                this.repaintLayerWithDecorations(s);
            } else if (e.getPropertyName().equals("editable.prop.name")) {
                // empty if block
            }
        }
    }

    @Override
    public void columnsInserted(TiledLayer source, int index, int count) {
        this.repaintLayerWithDecorations(source);
    }

    @Override
    public void columnsRemoved(TiledLayer source, int index, int count) {
        this.repaintLayerWithDecorations(source);
    }

    @Override
    public void rowsInserted(TiledLayer source, int index, int count) {
        this.repaintLayerWithDecorations(source);
    }

    @Override
    public void rowsRemoved(TiledLayer source, int index, int count) {
        this.repaintLayerWithDecorations(source);
    }

    @Override
    public void tilesStructureChanged(TiledLayer source) {
        this.repaintLayerWithDecorations(source);
    }

    @Override
    public void tileChanged(TiledLayer source, int row, int col) {
        int w = source.getTileWidth();
        int h = source.getTileHeight();
        Point p = this.scene.getLayerPosition(source);
        p.translate(col * w, row * h);
        this.adjustFromOriginShift(p);
        this.repaint(p.x, p.y, w, h);
    }

    @Override
    public void tilesChanged(TiledLayer source, Set positions) {
        for (Object object : positions) {
            Position pos = (Position)object;
            this.tileChanged(source, pos.getRow(), pos.getCol());
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        StringBuffer sb = new StringBuffer();
        Point p = this.adjustToOriginShift(e.getPoint());
        List<Layer> layers = this.scene.getLayersAtPoint(p);
        if (layers.isEmpty()) {
            return null;
        }
        for (Layer layer : layers) {
            sb.append(layer.getName());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = this.adjustToOriginShift(e.getPoint());
        List<Layer> layers = this.scene.getLayersAtPoint(p);
        if (layers.size() == 0) {
            return;
        }
        for (Layer layer : layers) {
            if (this.hilitedLayers.containsKey(layer)) continue;
            this.hilitedLayers.put(layer, this.colorHiliteSecondary);
            this.repaintLayerDecorations(layer);
        }
        Layer oldTop = this.topHilitedLayer;
        Layer top = layers.get(0);
        if (oldTop != top) {
            this.hilitedLayers.put(top, this.colorHilitePrimary);
            this.hilitedLayers.put(oldTop, this.colorHiliteSecondary);
            this.topHilitedLayer = top;
            this.repaintLayerDecorations(oldTop);
            this.repaintLayerDecorations(top);
        }
        Iterator<Layer> iter = this.hilitedLayers.keySet().iterator();
        while (iter.hasNext()) {
            Layer layer = iter.next();
            if (layers.contains(layer)) continue;
            this.repaintLayerDecorations(layer);
            iter.remove();
        }
    }

    private void clearSelectedLayers() {
        for (Layer layer : this.scene.getLayers()) {
            if (!this.scene.isLayerSelected(layer)) continue;
            this.scene.setLayerSelected(layer, false);
        }
        this.dragLayerStartPoints.clear();
        this.lastDragPoint = null;
        this.startDragPoint = null;
        this.snapToGridReferenceLayer = null;
        this.dragDirectionHorizontal = "West";
        this.dragDirectionVertical = "North";
    }

    private void addSelectedLayer(Layer layer, boolean toogleSelection) {
        if (toogleSelection) {
            this.scene.setLayerSelected(layer, !this.scene.isLayerSelected(layer));
        } else {
            this.scene.setLayerSelected(layer, true);
        }
        this.horizontalRuler.repaint();
        this.verticalRuler.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = this.adjustToOriginShift(e.getPoint());
        if (!this.mouseDragging) {
            if (this.scene.getLayersAtPoint(p).isEmpty()) {
                return;
            }
            boolean dragStartPointOK = false;
            for (Layer layer : this.scene.getLayers()) {
                if (!this.scene.isLayerSelected(layer) || !this.scene.getLayerBounds(layer).contains(p)) continue;
                dragStartPointOK = true;
                break;
            }
            if (!dragStartPointOK) {
                return;
            }
            for (Layer tmp : this.scene.getLayersAtPoint(p)) {
                if (!this.scene.isLayerSelected(tmp)) continue;
                this.snapToGridReferenceLayer = tmp;
                break;
            }
            for (Layer layer : this.scene.getLayers()) {
                if (!this.scene.isLayerSelected(layer)) continue;
                this.dragLayerStartPoints.put(layer, this.scene.getLayerPosition(layer));
            }
            this.startDragPoint = p;
            this.mouseDragging = true;
            return;
        }
        int dx = p.x - this.startDragPoint.x;
        int dy = p.y - this.startDragPoint.y;
        if (this.lastDragPoint != null) {
            if (p.x < this.lastDragPoint.x) {
                this.dragDirectionHorizontal = "West";
            } else if (p.x > this.lastDragPoint.x) {
                this.dragDirectionHorizontal = "East";
            }
            if (p.y < this.lastDragPoint.y) {
                this.dragDirectionVertical = "North";
            } else if (p.y > this.lastDragPoint.y) {
                this.dragDirectionVertical = "South";
            }
        }
        if (this.isSnapGrid() && this.lastDragPoint != null) {
            Point delta = this.findSnapToGridDelta(p, dx, dy);
            this.translateSelectedLayers(delta.x, delta.y, true);
        } else {
            this.translateSelectedLayers(dx, dy, true);
        }
        this.lastDragPoint = p;
        this.horizontalRuler.repaint();
        this.verticalRuler.repaint();
        this.scrollRectToVisible(new Rectangle(e.getPoint()));
    }

    private Point findSnapToGridDelta(Point p, int dx, int dy) {
        Point s = new Point(this.dragLayerStartPoints.get(this.snapToGridReferenceLayer));
        Point ref = new Point(s);
        ref.translate(dx, dy);
        if (p.x >= this.lastDragPoint.x) {
            if (p.x > this.lastDragPoint.x) {
                ref.translate(this.snapToGridReferenceLayer.getWidth(), 0);
            } else if (this.dragDirectionHorizontal == "East") {
                ref.translate(this.snapToGridReferenceLayer.getWidth(), 0);
            }
        }
        if (p.y >= this.lastDragPoint.y) {
            if (p.y > this.lastDragPoint.y) {
                ref.translate(0, this.snapToGridReferenceLayer.getHeight());
            } else if (this.dragDirectionVertical == "South") {
                ref.translate(0, this.snapToGridReferenceLayer.getHeight());
            }
        }
        Point nearest = this.findNearestGridPoint(ref);
        if (this.dragDirectionHorizontal == "East") {
            nearest.translate(-this.snapToGridReferenceLayer.getWidth(), 0);
        }
        if (this.dragDirectionVertical == "South") {
            nearest.translate(0, -this.snapToGridReferenceLayer.getHeight());
        }
        dx = nearest.x - s.x;
        dy = nearest.y - s.y;
        return new Point(dx, dy);
    }

    private Point findNearestGridPoint(Point p) {
        Point nearest = new Point(p);
        int offX = p.x % this.gridX;
        int offY = p.y % this.gridY;
        if (offX == 0 && offY == 0) {
            return nearest;
        }
        if (offX != 0) {
            int gx1 = p.x / this.gridX;
            int gx2 = p.x >= 0 ? gx1 + 1 : gx1 - 1;
            nearest.x = Math.abs(p.x - (gx1 *= this.gridX)) < Math.abs(p.x - (gx2 *= this.gridX)) ? gx1 : gx2;
        }
        if (offY != 0) {
            int gy1 = p.y / this.gridY;
            int gy2 = p.y >= 0 ? gy1 + 1 : gy1 - 1;
            nearest.y = Math.abs(p.y - (gy1 *= this.gridY)) < Math.abs(p.y - (gy2 *= this.gridY)) ? gy1 : gy2;
        }
        return nearest;
    }

    private void translateSelectedLayers(int dx, int dy, boolean inTransition) {
        for (Layer dragLayer : this.dragLayerStartPoints.keySet()) {
            Point slp = new Point(this.dragLayerStartPoints.get(dragLayer));
            slp.translate(dx, dy);
            if (this.scene.isLayerLocked(dragLayer)) continue;
            this.scene.setLayerPosition(dragLayer, slp, inTransition);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopUp(e);
            return;
        }
        Point p = this.adjustToOriginShift(e.getPoint());
        List<Layer> layers = this.scene.getLayersAtPoint(p);
        if (!layers.isEmpty()) {
            Layer layer = layers.get(0);
            if (!this.mouseDragging && this.lastAddedLayerByMousePress != layer && !this.isMultiSelect(e)) {
                this.clearSelectedLayers();
            }
            if (this.mouseDragging && this.lastDragPoint != null && this.startDragPoint != null) {
                int dx = this.lastDragPoint.x - this.startDragPoint.x;
                int dy = this.lastDragPoint.y - this.startDragPoint.y;
                if (this.isSnapGrid()) {
                    Point delta = this.findSnapToGridDelta(this.lastDragPoint, dx, dy);
                    this.translateSelectedLayers(delta.x, delta.y, false);
                } else {
                    this.translateSelectedLayers(dx, dy, false);
                }
            }
        }
        this.mouseDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDragging = false;
        this.lastAddedLayerByMousePress = null;
        if (e.isPopupTrigger()) {
            this.handlePopUp(e);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Point p = this.adjustToOriginShift(e.getPoint());
        List<Layer> layers = this.scene.getLayersAtPoint(p);
        if (!this.isMultiSelect(e)) {
            for (Layer layer : layers) {
                if (!this.scene.isLayerSelected(layer)) continue;
                return;
            }
            this.clearSelectedLayers();
        }
        if (layers.isEmpty()) {
            Layer tmp = this.topHilitedLayer;
            this.topHilitedLayer = null;
            this.hilitedLayers.remove(tmp);
            this.repaintLayerDecorations(tmp);
            return;
        }
        Layer layer = layers.get(0);
        if (!this.scene.isLayerSelected(layer)) {
            this.addSelectedLayer(layer, false);
            this.lastAddedLayerByMousePress = layer;
        } else if (this.isMultiSelect(e)) {
            this.addSelectedLayer(layer, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p;
        List<Layer> layers;
        this.mouseDragging = false;
        if (e.getClickCount() >= 2 && !(layers = this.scene.getLayersAtPoint(p = this.adjustToOriginShift(e.getPoint()))).isEmpty()) {
            this.scene.getGameDesign().getMainView().requestEditing(layers.get(0));
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private void handlePopUp(MouseEvent e) {
        int i;
        DuplicateSceneAction ds = new DuplicateSceneAction();
        Scene.RenameSceneAction rs = new Scene.RenameSceneAction(this.scene);
        Scene.RemoveSceneAction rsa = new Scene.RemoveSceneAction(this.scene);
        Scene.CreateTiledLayerAction ctl = new Scene.CreateTiledLayerAction(this.scene);
        Scene.CreateSpriteAction csp = new Scene.CreateSpriteAction(this.scene);
        JMenu sub2MenuTiledLayers = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAddTiledLayer.txt"));
        List<TiledLayer> tiledLayers = this.scene.getGameDesign().getTiledLayers();
        for (TiledLayer layer : tiledLayers) {
            if (this.scene.contains(layer)) continue;
            AddLayerAction al = new AddLayerAction();
            al.putValue("Name", layer.getName());
            al.putValue("PROP_LAYER", layer);
            al.putValue("PROP_POSITION", this.adjustToOriginShift(e.getPoint()));
            sub2MenuTiledLayers.add(al);
        }
        if (sub2MenuTiledLayers.getItemCount() == 0) {
            sub2MenuTiledLayers.setEnabled(false);
        }
        JMenu sub2MenuSprites = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAddSprite.txt"));
        List<Sprite> sprites = this.scene.getGameDesign().getSprites();
        for (Sprite layer : sprites) {
            if (this.scene.contains(layer)) continue;
            AddLayerAction al = new AddLayerAction();
            al.putValue("Name", layer.getName());
            al.putValue("PROP_LAYER", layer);
            al.putValue("PROP_POSITION", this.adjustToOriginShift(e.getPoint()));
            sub2MenuSprites.add(al);
        }
        if (sub2MenuSprites.getItemCount() == 0) {
            sub2MenuSprites.setEnabled(false);
        }
        JMenu sub2MenuPushUp = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuPushUp.txt"));
        JMenu sub2MenuPushDown = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuPushDown.txt"));
        JMenu sub2MenuToTop = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLayerToTop.txt"));
        JMenu sub2MenuToBottom = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLayerToBottom.txt"));
        Point poitAdjusted = this.adjustToOriginShift(e.getPoint());
        List<Layer> layersUnderCursor = this.scene.getLayersAtPoint(poitAdjusted);
        if (layersUnderCursor.size() < 2) {
            sub2MenuPushUp.setEnabled(false);
            sub2MenuPushDown.setEnabled(false);
        } else {
            for (i = 0; i < layersUnderCursor.size(); ++i) {
                PushUpLayerAction pul = new PushUpLayerAction();
                sub2MenuPushUp.add(pul);
                pul.putValue("Name", layersUnderCursor.get(i).getName());
                if (i == 0) {
                    pul.setEnabled(false);
                    continue;
                }
                pul.putValue("PROP_LAYER", layersUnderCursor.get(i));
                pul.putValue("PROP_LAYER_TO_TOP", layersUnderCursor.get(i - 1));
            }
            for (i = 0; i < layersUnderCursor.size(); ++i) {
                PushDownLayerAction pdl = new PushDownLayerAction();
                sub2MenuPushDown.add(pdl);
                pdl.putValue("Name", layersUnderCursor.get(i).getName());
                if (i == layersUnderCursor.size() - 1) {
                    pdl.setEnabled(false);
                    continue;
                }
                pdl.putValue("PROP_LAYER", layersUnderCursor.get(i));
                pdl.putValue("PROP_LAYER_TO_BELOW", layersUnderCursor.get(i + 1));
            }
        }
        for (i = 0; i < layersUnderCursor.size(); ++i) {
            LayerToTopAction ltt = new LayerToTopAction();
            sub2MenuToTop.add(ltt);
            ltt.putValue("Name", layersUnderCursor.get(i).getName());
            if (this.scene.getLayerAt(0) == layersUnderCursor.get(i)) {
                ltt.setEnabled(false);
                continue;
            }
            ltt.putValue("PROP_LAYER", layersUnderCursor.get(i));
        }
        if (layersUnderCursor.isEmpty()) {
            sub2MenuToTop.setEnabled(false);
        }
        for (i = 0; i < layersUnderCursor.size(); ++i) {
            LayerToBottomAction ltb = new LayerToBottomAction();
            sub2MenuToBottom.add(ltb);
            ltb.putValue("Name", layersUnderCursor.get(i).getName());
            if (this.scene.getLayerAt(this.scene.getLayerCount() - 1) == layersUnderCursor.get(i)) {
                ltb.setEnabled(false);
                continue;
            }
            ltb.putValue("PROP_LAYER", layersUnderCursor.get(i));
        }
        if (layersUnderCursor.isEmpty()) {
            sub2MenuToBottom.setEnabled(false);
        }
        JMenu sub1MenuEditLayers = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuEdit.txt"));
        if (layersUnderCursor.isEmpty()) {
            sub1MenuEditLayers.setEnabled(false);
        } else {
            for (int i2 = 0; i2 < layersUnderCursor.size(); ++i2) {
                EditLayerAction rl = new EditLayerAction();
                sub1MenuEditLayers.add(rl);
                rl.putValue("PROP_LAYER", layersUnderCursor.get(i2));
                rl.putValue("Name", layersUnderCursor.get(i2).getName());
            }
        }
        JMenu sub1MenuViewLayers = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuView.txt"));
        if (layersUnderCursor.isEmpty()) {
            sub1MenuViewLayers.setEnabled(false);
        } else {
            for (int i3 = 0; i3 < layersUnderCursor.size(); ++i3) {
                Layer layer = layersUnderCursor.get(i3);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(layer.getName(), this.scene.isLayerVisible(layer));
                sub1MenuViewLayers.add(item);
                item.addItemListener(new VisibilityListener(layer));
            }
        }
        JMenu sub1MenuViewLocks = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLock.txt"));
        if (layersUnderCursor.isEmpty()) {
            sub1MenuViewLocks.setEnabled(false);
        } else {
            for (int i4 = 0; i4 < layersUnderCursor.size(); ++i4) {
                Layer layer = layersUnderCursor.get(i4);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(layer.getName(), this.scene.isLayerLocked(layer));
                sub1MenuViewLocks.add(item);
                item.addItemListener(new LockListener(layer));
            }
        }
        HashSet<Layer> selectedNotLockedLayers = new HashSet<Layer>();
        for (Layer layer : this.scene.getLayers()) {
            if (!this.scene.isLayerSelected(layer) || this.scene.isLayerLocked(layer)) continue;
            selectedNotLockedLayers.add(layer);
        }
        JMenu sub1MenuAlign = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuAlign.txt"));
        if (selectedNotLockedLayers.size() < 2) {
            sub1MenuAlign.setEnabled(false);
        } else {
            AlignLayersTopAction alt = new AlignLayersTopAction();
            alt.putValue("PROP_LAYERS", selectedNotLockedLayers);
            AlignLayersLeftAction all = new AlignLayersLeftAction();
            all.putValue("PROP_LAYERS", selectedNotLockedLayers);
            AlignLayersBottomAction alb = new AlignLayersBottomAction();
            alb.putValue("PROP_LAYERS", selectedNotLockedLayers);
            AlignLayersRightAction alr = new AlignLayersRightAction();
            alr.putValue("PROP_LAYERS", selectedNotLockedLayers);
            sub1MenuAlign.add(alt);
            sub1MenuAlign.add(all);
            sub1MenuAlign.add(alb);
            sub1MenuAlign.add(alr);
        }
        JMenu sub1MenuSelectLayers = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelect.txt"));
        if (!layersUnderCursor.isEmpty()) {
            for (int i5 = 0; i5 < layersUnderCursor.size(); ++i5) {
                Layer layer = layersUnderCursor.get(i5);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(layer.getName(), this.scene.isLayerSelected(layer));
                sub1MenuSelectLayers.add(item);
                item.addItemListener(new SelectListener(layer));
            }
            sub1MenuSelectLayers.addSeparator();
            SelectLayersUnderCursorAction slc = new SelectLayersUnderCursorAction();
            poitAdjusted = this.adjustToOriginShift(e.getPoint());
            slc.putValue("PROP_POINT", poitAdjusted);
            sub1MenuSelectLayers.add(slc);
        }
        SelectAllLayersAction sal = new SelectAllLayersAction();
        sub1MenuSelectLayers.add(sal);
        JMenu sub1MenuRemoveLayers = new JMenu(NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRemove.txt"));
        if (layersUnderCursor.isEmpty()) {
            sub1MenuRemoveLayers.setEnabled(false);
        } else {
            for (int i6 = 0; i6 < layersUnderCursor.size(); ++i6) {
                RemoveLayerAction rl = new RemoveLayerAction();
                sub1MenuRemoveLayers.add(rl);
                rl.putValue("PROP_LAYER", layersUnderCursor.get(i6));
                rl.putValue("Name", layersUnderCursor.get(i6).getName());
            }
        }
        RemoveSelectedLayersAction rsl = new RemoveSelectedLayersAction();
        if (selectedNotLockedLayers.isEmpty()) {
            rsl.setEnabled(false);
        } else {
            rsl.putValue("PROP_LAYERS", selectedNotLockedLayers);
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(ds);
        menu.add(rs);
        menu.add(rsa);
        menu.addSeparator();
        menu.add(ctl);
        menu.add(csp);
        menu.add(sub2MenuTiledLayers);
        menu.add(sub2MenuSprites);
        menu.addSeparator();
        menu.add(sub2MenuPushUp);
        menu.add(sub2MenuPushDown);
        menu.add(sub2MenuToTop);
        menu.add(sub2MenuToBottom);
        menu.addSeparator();
        menu.add(sub1MenuEditLayers);
        menu.add(sub1MenuViewLayers);
        menu.add(sub1MenuViewLocks);
        menu.add(sub1MenuAlign);
        menu.addSeparator();
        menu.add(sub1MenuSelectLayers);
        menu.addSeparator();
        menu.add(sub1MenuRemoveLayers);
        menu.add(rsl);
        menu.show(this, e.getX(), e.getY());
    }

    private boolean isMultiSelect(MouseEvent e) {
        return e.isControlDown() || e.isMetaDown();
    }

    public JComponent getGridButton() {
        return this.gridButton;
    }

    public Ruler getRulerHorizontal() {
        return this.horizontalRuler;
    }

    public Ruler getRulerVertical() {
        return this.verticalRuler;
    }

    public boolean isSnapGrid() {
        return this.snapGrid;
    }

    public void setSnapGrid(boolean snapGrid) {
        if (this.snapGrid == snapGrid) {
            return;
        }
        this.snapGrid = snapGrid;
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        if (this.showGrid == showGrid) {
            return;
        }
        this.showGrid = showGrid;
        this.repaint();
    }

    public void setGridSizeHorizontal(int unitSize) {
        this.gridX = unitSize;
        this.repaint();
    }

    public void setGridSizeVertical(int unitSize) {
        this.gridY = unitSize;
        this.repaint();
    }

    class Ruler
    extends JComponent {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private static final int SIZE_H = 24;
        private static final int SIZE_W = 37;
        private static final int TICK_MAJOR = 6;
        private static final int TICK_MINOR = 3;
        private static final int LOC_INSET = 2;
        private static final int SHADOW_OFF = 3;
        public final Color locFgColor = Color.WHITE;
        public final Color locBgColor = new Color(0, 0, 255, 200);
        public final Color locOutlineColor = Color.WHITE;
        public final Color locShadowColor = new Color(0, 0, 255, 64);
        public final Color locFgColorSecondary = Color.WHITE;
        public final Color locBgColorSecondary = new Color(128, 128, 255, 200);
        public final Color locOutlineColorSecondary = this.locFgColorSecondary;
        public final Color locShadowColorSecondary = new Color(128, 128, 255, 64);
        private final Color COLOR_MAJOR = Color.BLACK;
        private final Color COLOR_MINOR = Color.GRAY;
        private final Font FONT = new Font("SansSerif", 0, 9);
        public final Color RulerColor = UIManager.getColor("Panel.background");
        public int orientation;
        private int increment = 10;
        private int units = 50;

        public Ruler(int orientation) {
            this.orientation = orientation;
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle bounds = ScenePanel.this.scene.getAllLayersBounds();
            bounds.add(0, 0);
            if (this.orientation == 0) {
                return new Dimension(bounds.width, 24);
            }
            return new Dimension(37, bounds.height);
        }

        public int getIncrement() {
            return this.increment;
        }

        @Override
        protected void paintComponent(Graphics graph) {
            int end;
            int start;
            Graphics2D g = (Graphics2D)graph;
            Rectangle clip = g.getClipBounds();
            Rectangle sceneBounds = ScenePanel.this.scene.getAllLayersBounds();
            sceneBounds.add(0, 0);
            int offX = sceneBounds.x;
            int offY = sceneBounds.y;
            g.setColor(this.RulerColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setFont(this.FONT);
            int tickLength = 0;
            String text = null;
            if (this.orientation == 0) {
                start = (clip.x + offX) / this.increment * this.increment;
                end = ((clip.x + offX + clip.width) / this.increment + 1) * this.increment;
            } else {
                start = (clip.y + offY) / this.increment * this.increment;
                end = ((clip.y + offY + clip.height) / this.increment + 1) * this.increment;
            }
            for (int i = start; i < end; i += this.increment) {
                int y;
                if (i % this.units == 0) {
                    g.setColor(this.COLOR_MAJOR);
                    tickLength = 6;
                    text = i == 0 ? " " + Integer.toString(i) : Integer.toString(i);
                } else {
                    g.setColor(this.COLOR_MINOR);
                    tickLength = 3;
                    text = null;
                }
                if (tickLength == 0) continue;
                if (this.orientation == 0) {
                    g.drawLine(i - offX, 23, i - offX, 24 - tickLength - 1);
                    if (text == null) continue;
                    y = 24 - tickLength - this.FONT.getSize() / 2;
                    int x = (int)((double)(i - offX) - this.FONT.getStringBounds(text, g.getFontRenderContext()).getWidth() / 2.0);
                    g.drawString(text, x, y);
                    continue;
                }
                g.drawLine(36, i - offY, 37 - tickLength - 1, i - offY);
                if (text == null) continue;
                y = i - offY + this.FONT.getSize() / 2;
                g.drawString(text, 1, y);
            }
            ArrayList<Layer> tmp = new ArrayList<Layer>();
            for (Layer layer : ScenePanel.this.scene.getLayers()) {
                if (!ScenePanel.this.scene.isLayerSelected(layer) || ScenePanel.this.scene.isLayerLocked(layer)) continue;
                tmp.add(layer);
            }
            if (ScenePanel.this.snapToGridReferenceLayer != null) {
                tmp.remove(ScenePanel.this.snapToGridReferenceLayer);
                tmp.add(ScenePanel.this.snapToGridReferenceLayer);
            }
            for (Layer layer : tmp) {
                String strPosY;
                Rectangle strOutline;
                float ascend;
                LineMetrics lm;
                Rectangle2D strBounds;
                Color bgColor = null;
                Color fgColor = null;
                Color shadowColor = null;
                Color outlineColor = null;
                if (ScenePanel.this.snapToGridReferenceLayer == null || layer == ScenePanel.this.snapToGridReferenceLayer) {
                    bgColor = this.locBgColor;
                    fgColor = this.locFgColor;
                    shadowColor = this.locShadowColor;
                    outlineColor = this.locOutlineColor;
                } else {
                    bgColor = this.locBgColorSecondary;
                    fgColor = this.locFgColorSecondary;
                    shadowColor = this.locShadowColorSecondary;
                    outlineColor = this.locOutlineColorSecondary;
                }
                Rectangle bounds = ScenePanel.this.scene.getLayerBounds(layer);
                if (this.orientation == 0) {
                    String strPosX;
                    int leftLim = clip.x + offX;
                    int rightLim = clip.x + offX + clip.width;
                    if (leftLim <= bounds.x + bounds.width && bounds.x + bounds.width < rightLim) {
                        g.setColor(ScenePanel.this.colorSelection);
                        g.drawLine(bounds.x + bounds.width - offX, 0, bounds.x + bounds.width - offX, 24);
                        strPosX = Integer.toString(bounds.x + bounds.width);
                        strBounds = this.FONT.getStringBounds(strPosX, g.getFontRenderContext());
                        lm = this.FONT.getLineMetrics(strPosX, g.getFontRenderContext());
                        ascend = lm.getAscent();
                        strOutline = new Rectangle((int)strBounds.getX() - 2, (int)strBounds.getY() - 2, (int)strBounds.getWidth() + 4, (int)strBounds.getHeight() + 4);
                        g.setColor(bgColor);
                        g.fillRoundRect((int)((double)(bounds.x + bounds.width - offX) - strOutline.getWidth() / 2.0), 0, (int)strOutline.getWidth(), (int)strOutline.getHeight(), 4, 4);
                        g.setColor(shadowColor);
                        g.fillRoundRect((int)((double)(bounds.x + bounds.width - offX) - strOutline.getWidth() / 2.0) + 3, 3, (int)strOutline.getWidth(), (int)strOutline.getHeight(), 4, 4);
                        g.setColor(fgColor);
                        g.drawString(strPosX, (float)((int)((double)(bounds.x + bounds.width - offX) - strBounds.getWidth() / 2.0)), 2.0f + ascend);
                        if (layer == ScenePanel.this.snapToGridReferenceLayer) {
                            g.setColor(outlineColor);
                            g.drawRoundRect((int)((double)(bounds.x + bounds.width - offX - 1) - strOutline.getWidth() / 2.0), 0, (int)strOutline.getWidth() + 1, (int)strOutline.getHeight(), 4, 4);
                        }
                    }
                    if (leftLim > bounds.x || bounds.x >= rightLim) continue;
                    g.setColor(ScenePanel.this.colorSelection);
                    g.drawLine(bounds.x - offX, 0, bounds.x - offX, 24);
                    strPosX = Integer.toString(bounds.x);
                    strBounds = this.FONT.getStringBounds(strPosX, g.getFontRenderContext());
                    lm = this.FONT.getLineMetrics(strPosX, g.getFontRenderContext());
                    ascend = lm.getAscent();
                    strOutline = new Rectangle((int)strBounds.getX() - 2, (int)strBounds.getY() - 2, (int)strBounds.getWidth() + 4, (int)strBounds.getHeight() + 4);
                    g.setColor(bgColor);
                    g.fillRoundRect((int)((double)(bounds.x - offX) - strOutline.getWidth() / 2.0), 0, (int)strOutline.getWidth(), (int)strOutline.getHeight(), 4, 4);
                    g.setColor(shadowColor);
                    g.fillRoundRect((int)((double)(bounds.x - offX) - strOutline.getWidth() / 2.0) + 3, 3, (int)strOutline.getWidth(), (int)strOutline.getHeight(), 4, 4);
                    g.setColor(fgColor);
                    g.drawString(strPosX, (float)((int)((double)(bounds.x - offX) - strBounds.getWidth() / 2.0)), 2.0f + ascend);
                    if (layer != ScenePanel.this.snapToGridReferenceLayer) continue;
                    g.setColor(outlineColor);
                    g.drawRoundRect((int)((double)(bounds.x - offX - 1) - strOutline.getWidth() / 2.0), 0, (int)strOutline.getWidth() + 1, (int)strOutline.getHeight(), 4, 4);
                    continue;
                }
                int topLim = clip.y + offY;
                int bottomLim = clip.y + offY + clip.height;
                if (topLim <= bounds.y + bounds.height && bounds.y + bounds.height < bottomLim) {
                    g.setColor(ScenePanel.this.colorSelection);
                    g.drawLine(0, bounds.y + bounds.height - offY, 37, bounds.y + bounds.height - offY);
                    strPosY = Integer.toString(bounds.y + bounds.height);
                    strBounds = this.FONT.getStringBounds(strPosY, g.getFontRenderContext());
                    lm = this.FONT.getLineMetrics(strPosY, g.getFontRenderContext());
                    ascend = lm.getAscent();
                    strOutline = new Rectangle((int)strBounds.getX() - 2, (int)strBounds.getY() - 2, (int)strBounds.getWidth() + 4, (int)strBounds.getHeight() + 4);
                    g.setColor(bgColor);
                    g.fillRoundRect(1, bounds.y + bounds.height - offY - strOutline.height / 2, strOutline.width, strOutline.height, 4, 4);
                    g.setColor(shadowColor);
                    g.fillRoundRect(4, bounds.y + bounds.height - offY - strOutline.height / 2 + 3, strOutline.width, strOutline.height, 4, 4);
                    g.setColor(fgColor);
                    g.drawString(strPosY, 3.0f, (float)(bounds.y + bounds.height - offY - strOutline.height / 2) + ascend + 2.0f);
                    if (layer == ScenePanel.this.snapToGridReferenceLayer) {
                        g.setColor(outlineColor);
                        g.drawRoundRect(0, bounds.y + bounds.height - offY - strOutline.height / 2, strOutline.width + 1, strOutline.height, 4, 4);
                    }
                }
                if (topLim > bounds.y || bounds.y >= bottomLim) continue;
                g.setColor(ScenePanel.this.colorSelection);
                g.drawLine(0, bounds.y - offY, 37, bounds.y - offY);
                strPosY = Integer.toString(bounds.y);
                strBounds = this.FONT.getStringBounds(strPosY, g.getFontRenderContext());
                lm = this.FONT.getLineMetrics(strPosY, g.getFontRenderContext());
                ascend = lm.getAscent();
                strOutline = new Rectangle((int)strBounds.getX() - 2, (int)strBounds.getY() - 2, (int)strBounds.getWidth() + 4, (int)strBounds.getHeight() + 4);
                g.setColor(bgColor);
                g.fillRoundRect(1, bounds.y - offY - strOutline.height / 2, strOutline.width, strOutline.height, 4, 4);
                g.setColor(shadowColor);
                g.fillRoundRect(4, bounds.y - offY - strOutline.height / 2 + 3, strOutline.width, strOutline.height, 4, 4);
                g.setColor(fgColor);
                g.drawString(strPosY, 3.0f, (float)(bounds.y - offY - strOutline.height / 2) + ascend + 2.0f);
                if (layer != ScenePanel.this.snapToGridReferenceLayer) continue;
                g.setColor(outlineColor);
                g.drawRoundRect(0, bounds.y - offY - strOutline.height / 2, strOutline.width + 1, strOutline.height, 4, 4);
            }
        }
    }

    private class GridButton
    extends JComponent
    implements MouseListener {
        private static final int BORDER = 4;

        public GridButton() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
        }

        @Override
        public String getToolTipText() {
            return NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.gridButton.tooltip");
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.BLACK);
            int startx = 4;
            int starty = 4;
            int x = 4;
            int y = 4;
            int w = this.getWidth() - 12;
            int h = this.getHeight() - 12;
            if (ScenePanel.this.isShowGrid()) {
                if (ScenePanel.this.isSnapGrid()) {
                    g.setColor(Color.RED);
                }
                int offX = w / 3;
                int offY = h / 3;
                g.drawLine(x += offX, starty, x, starty + h);
                g.drawLine(x += offX, starty, x, starty + h);
                g.drawLine(startx, y += offY, startx + w, y);
                g.drawLine(startx, y += offY, startx + w, y);
            }
            g.setColor(Color.BLACK);
            g.drawRoundRect(startx, starty, w, h, 4, 4);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ScenePanel.this.isShowGrid()) {
                if (ScenePanel.this.isSnapGrid()) {
                    ScenePanel.this.setShowGrid(false);
                    ScenePanel.this.setSnapGrid(false);
                } else {
                    ScenePanel.this.setSnapGrid(true);
                }
            } else {
                ScenePanel.this.setShowGrid(true);
                ScenePanel.this.setSnapGrid(false);
            }
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public class AddLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_POSITION = "PROP_POSITION";

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Point position = (Point)this.getValue(PROP_POSITION);
            ScenePanel.this.scene.insert(layer, 0);
            ScenePanel.this.scene.setLayerPosition(layer, position, false);
        }
    }

    public class AddNewSpriteAction
    extends AbstractAction {
        public AddNewSpriteAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewSprite.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpriteDialog nld = new SpriteDialog(ScenePanel.this.scene);
            DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewSprite.txt"));
            dd.setButtonListener((ActionListener)nld);
            dd.setValid(false);
            nld.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class AddNewTiledLayerAction
    extends AbstractAction {
        public AddNewTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewTiledLayer.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TiledLayerDialog nld = new TiledLayerDialog(ScenePanel.this.scene);
            DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionNewTiledLayer.txt"));
            dd.setButtonListener((ActionListener)nld);
            dd.setValid(false);
            nld.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class DuplicateSceneAction
    extends AbstractAction {
        public DuplicateSceneAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionDuplicateScene.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewSceneDialog dialog = new NewSceneDialog(ScenePanel.this.scene);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.actionDuplicateScene.txt"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    private class LayerToBottomAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private LayerToBottomAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.getLayerCount() - 1);
        }
    }

    private class LayerToTopAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private LayerToTopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.insert(layer, 0);
        }
    }

    private class PushDownLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_LAYER_TO_BELOW = "PROP_LAYER_TO_BELOW";

        private PushDownLayerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Layer toBelow = (Layer)this.getValue(PROP_LAYER_TO_BELOW);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.indexOf(toBelow));
        }
    }

    private class PushUpLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";
        public static final String PROP_LAYER_TO_TOP = "PROP_LAYER_TO_TOP";

        private PushUpLayerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            Layer toTop = (Layer)this.getValue(PROP_LAYER_TO_TOP);
            ScenePanel.this.scene.insert(layer, ScenePanel.this.scene.indexOf(toTop));
        }
    }

    private class SelectAllLayersAction
    extends AbstractAction {
        private SelectAllLayersAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelectAll.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Layer> layers = ScenePanel.this.scene.getLayers();
            for (Layer layer : layers) {
                ScenePanel.this.addSelectedLayer(layer, false);
            }
        }
    }

    private class SelectLayersUnderCursorAction
    extends AbstractAction {
        public static final String PROP_POINT = "PROP_POINT";

        private SelectLayersUnderCursorAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuSelectUnder.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point p = (Point)this.getValue(PROP_POINT);
            List<Layer> layers = ScenePanel.this.scene.getLayersAtPoint(p);
            for (Layer layer : layers) {
                ScenePanel.this.addSelectedLayer(layer, false);
            }
        }
    }

    private class RemoveSelectedLayersAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private RemoveSelectedLayersAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRemoveSelected.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set layers = (Set)this.getValue(PROP_LAYERS);
            for (Layer layer : layers) {
                ScenePanel.this.scene.remove(layer);
            }
        }
    }

    private class RemoveLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private RemoveLayerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.remove(layer);
        }
    }

    private class AlignLayersRightAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersRightAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuRight.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set layers = (Set)this.getValue(PROP_LAYERS);
            int right = Integer.MIN_VALUE;
            for (Layer layer : layers) {
                right = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x + layer.getWidth() > right ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x + layer.getWidth() : right;
            }
            for (Layer layer : layers) {
                ScenePanel.this.scene.setLayerPositionX(layer, right - layer.getWidth(), false);
            }
        }
    }

    private class AlignLayersBottomAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersBottomAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuBottom.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set layers = (Set)this.getValue(PROP_LAYERS);
            int bottom = Integer.MIN_VALUE;
            for (Layer layer : layers) {
                bottom = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y + layer.getHeight() > bottom ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y + layer.getHeight() : bottom;
            }
            for (Layer layer : layers) {
                ScenePanel.this.scene.setLayerPositionY(layer, bottom - layer.getHeight(), false);
            }
        }
    }

    private class AlignLayersLeftAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersLeftAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuLeft.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set layers = (Set)this.getValue(PROP_LAYERS);
            int top = Integer.MAX_VALUE;
            for (Layer layer : layers) {
                top = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x < top ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).x : top;
            }
            for (Layer layer : layers) {
                ScenePanel.this.scene.setLayerPositionX(layer, top, false);
            }
        }
    }

    private class AlignLayersTopAction
    extends AbstractAction {
        public static final String PROP_LAYERS = "PROP_LAYERS";

        private AlignLayersTopAction() {
            this.putValue("Name", NbBundle.getMessage(ScenePanel.class, (String)"ScenePanel.menuTop.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set layers = (Set)this.getValue(PROP_LAYERS);
            int top = Integer.MAX_VALUE;
            for (Layer layer : layers) {
                top = ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y < top ? ((ScenePanel)ScenePanel.this).scene.getLayerPosition((Layer)layer).y : top;
            }
            for (Layer layer : layers) {
                ScenePanel.this.scene.setLayerPositionY(layer, top, false);
            }
        }
    }

    private class EditLayerAction
    extends AbstractAction {
        public static final String PROP_LAYER = "PROP_LAYER";

        private EditLayerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer layer = (Layer)this.getValue(PROP_LAYER);
            ScenePanel.this.scene.getGameDesign().getMainView().requestEditing(layer);
        }
    }

    private class SelectListener
    implements ItemListener {
        private Layer layer;

        public SelectListener(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ScenePanel.this.addSelectedLayer(this.layer, true);
        }
    }

    private class LockListener
    implements ItemListener {
        private Layer layer;

        public LockListener(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean locked = e.getStateChange() == 1;
            ScenePanel.this.scene.setLayerLocked(this.layer, locked);
        }
    }

    private class VisibilityListener
    implements ItemListener {
        private Layer layer;

        public VisibilityListener(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean visible = e.getStateChange() == 1;
            ScenePanel.this.scene.setLayerVisible(this.layer, visible);
        }
    }

    private class SceneSelectionListenerImpl
    implements SceneSelectionListener {
        private SceneSelectionListenerImpl() {
        }

        @Override
        public void layerSelectionChanged(Scene sourceScene, Layer layer, boolean selected) {
            ScenePanel.this.repaintLayerDecorations(layer);
        }
    }

    private class SceneListenerImpl
    implements SceneListener {
        private SceneListenerImpl() {
        }

        @Override
        public void layerAdded(Scene sourceScene, Layer layer, int index) {
            ScenePanel.this.registerLayerListeners(layer);
            ScenePanel.this.repaintAllLayerDecorations();
        }

        @Override
        public void layerMoved(Scene sourceScene, Layer layer, int indexOld, int indexNew) {
            ScenePanel.this.repaintAllLayerDecorations();
        }

        @Override
        public void layerRemoved(Scene sourceScene, Layer layer, Scene.LayerInfo info, int index) {
            ScenePanel.this.unregisterLayerListeners(layer);
            ScenePanel.this.repaintAllLayerDecorations();
        }

        @Override
        public void layerLockChanged(Scene sourceScene, Layer layer, boolean locked) {
            ScenePanel.this.repaintAllLayerDecorations();
        }

        @Override
        public void layerPositionChanged(Scene sourceScene, Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
            ScenePanel.this.repaintLayerWithDecorations(oldPosition, layer);
            ScenePanel.this.repaintLayerWithDecorations(newPosition, layer);
        }

        @Override
        public void layerVisibilityChanged(Scene sourceScene, Layer layer, boolean visible) {
            ScenePanel.this.repaintLayerWithDecorations(layer);
        }
    }
}

