/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public abstract class RemoteCommand
extends Command {
    private static final char SEP_CHAR = '=';
    private static final int MAX_TYPE_SIZE = RemoteCommand.getFileTypeLabelMaxSize() + 2;
    private static final Color COLOR_SUCCESS = Color.GREEN.darker().darker();
    private static final Color COLOR_IGNORE = Color.ORANGE.darker();
    private static final Comparator<TransferFile> TRANSFER_FILE_COMPARATOR = new TransferFileComparator();
    private static final RequestProcessor RP = new RequestProcessor("Remote connection", 1);
    private static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            Runnable toRun = (Runnable)RUNNABLES.poll();
            while (toRun != null) {
                toRun.run();
                toRun = (Runnable)RUNNABLES.poll();
            }
        }
    }, true);

    public RemoteCommand(PhpProject project) {
        super(project);
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    public final void invokeAction(Lookup context) {
        if (!this.getConfigAction().isValid(false)) {
            return;
        }
        RUNNABLES.add(this.getContextRunnable(context));
        TASK.schedule(0);
    }

    @Override
    public final boolean isActionEnabled(Lookup context) {
        return this.isRemoteConfigSelected() && TASK.isFinished();
    }

    protected abstract Runnable getContextRunnable(Lookup var1);

    @Override
    public final boolean asyncCallRequired() {
        return false;
    }

    public static InputOutput getRemoteLog(String displayName) {
        return RemoteCommand.getRemoteLog(displayName, true);
    }

    public static InputOutput getRemoteLog(String displayName, boolean select) {
        InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(Command.class, (String)"LBL_RemoteLog", (Object)displayName), false);
        if (select) {
            io.select();
        }
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return io;
    }

    protected RemoteClient getRemoteClient(InputOutput io) {
        return new RemoteClient(this.getRemoteConfiguration(), new RemoteClient.AdvancedProperties().setInputOutput(io).setAdditionalInitialSubdirectory(this.getRemoteDirectory()).setPreservePermissions(ProjectPropertiesSupport.areRemotePermissionsPreserved(this.getProject())).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(this.getProject())).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(this.getProject())));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String configName = this.getRemoteConfigurationName();
        assert (configName != null && configName.length() > 0) : "Remote configuration name must be selected";
        return RemoteConnections.get().remoteConfigurationForName(configName);
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAs = ProjectPropertiesSupport.getRunAs(this.getProject());
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAs);
    }

    protected String getRemoteConfigurationName() {
        return ProjectPropertiesSupport.getRemoteConnection(this.getProject());
    }

    protected String getRemoteDirectory() {
        return ProjectPropertiesSupport.getRemoteDirectory(this.getProject());
    }

    /*
     * WARNING - void declaration
     */
    protected static void processTransferInfo(TransferInfo transferInfo, InputOutput io) {
        void var11_18;
        Cloneable sorted;
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        out.println();
        out.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSummary"));
        StringBuilder sep = new StringBuilder(20);
        for (int i = 0; i < sep.capacity(); ++i) {
            sep.append('=');
        }
        out.println(sep.toString());
        int maxRelativePath = RemoteCommand.getRelativePathMaxSize(transferInfo);
        long size = 0L;
        int files = 0;
        if (transferInfo.hasAnyTransfered()) {
            RemoteCommand.printSuccess(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSucceeded"));
            sorted = new ArrayList<TransferFile>(transferInfo.getTransfered());
            Collections.sort(sorted, TRANSFER_FILE_COMPARATOR);
            Iterator<Object> i$ = ((ArrayList)sorted).iterator();
            while (i$.hasNext()) {
                TransferFile transferFile = (TransferFile)i$.next();
                RemoteCommand.printSuccess(io, maxRelativePath, transferFile);
                if (!transferFile.isFile()) continue;
                size += transferFile.getSize();
                ++files;
            }
        }
        if (transferInfo.hasAnyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteFailed"));
            sorted = new TreeMap(TRANSFER_FILE_COMPARATOR);
            sorted.putAll(transferInfo.getFailed());
            for (Map.Entry entry : sorted.entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyPartiallyFailed()) {
            err.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemotePartiallyFailed"));
            sorted = new TreeMap(TRANSFER_FILE_COMPARATOR);
            sorted.putAll(transferInfo.getPartiallyFailed());
            for (Map.Entry entry : sorted.entrySet()) {
                RemoteCommand.printError(err, maxRelativePath, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyIgnored()) {
            RemoteCommand.printIgnore(io, NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteIgnored"));
            for (Map.Entry<TransferFile, String> entry : transferInfo.getIgnored().entrySet()) {
                RemoteCommand.printIgnore(io, maxRelativePath, entry.getKey(), entry.getValue());
            }
        }
        long runtime = transferInfo.getRuntime();
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitMilisecond");
        if (runtime > 1000L) {
            runtime /= 1000L;
            String string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitSecond");
        }
        double s = (double)size / 1024.0;
        String sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitKilobyte");
        if (s > 1024.0) {
            s /= 1024.0;
            sizeUnit = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitMegabyte");
        }
        Object[] params = new Object[]{runtime, var11_18, files, s, sizeUnit};
        out.println(NbBundle.getMessage(RemoteCommand.class, (String)"MSG_RemoteRuntimeAndSize", (Object[])params));
    }

    private static void print(InputOutput io, String message, Color color) {
        try {
            IOColorLines.println((InputOutput)io, (CharSequence)message, (Color)color);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void printSuccess(InputOutput io, String message) {
        RemoteCommand.print(io, message.trim(), COLOR_SUCCESS);
    }

    private static void printSuccess(InputOutput io, int maxRelativePath, TransferFile file) {
        String message = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath());
        RemoteCommand.printSuccess(io, message);
    }

    private static void printError(OutputWriter writer, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath(), reason);
        writer.println(msg);
    }

    private static void printIgnore(InputOutput io, String message) {
        RemoteCommand.print(io, message, COLOR_IGNORE);
    }

    private static void printIgnore(InputOutput io, int maxRelativePath, TransferFile file, String reason) {
        String msg = String.format("%-" + MAX_TYPE_SIZE + "s %-" + maxRelativePath + "s   %s", RemoteCommand.getFileTypeLabel(file), file.getRemotePath(), reason);
        RemoteCommand.printIgnore(io, msg);
    }

    private static String getFileTypeLabel(TransferFile file) {
        String type = null;
        type = file.isDirectory() ? "LBL_TypeDirectory" : (file.isFile() ? "LBL_TypeFile" : (file.isLink() ? "LBL_TypeLink" : "LBL_TypeUnknown"));
        return NbBundle.getMessage(RemoteCommand.class, (String)type);
    }

    private static int getFileTypeLabelMaxSize() {
        int max = 0;
        for (String label : Arrays.asList("LBL_TypeDirectory", "LBL_TypeFile", "LBL_TypeLink", "LBL_TypeUnknown")) {
            int length = NbBundle.getMessage(RemoteCommand.class, (String)label).length();
            if (max >= length) continue;
            max = length;
        }
        return max;
    }

    private static int getRelativePathMaxSize(TransferInfo transferInfo) {
        int max = RemoteCommand.getRelativePathMaxSize(transferInfo.getTransfered());
        int size = RemoteCommand.getRelativePathMaxSize(transferInfo.getFailed().keySet());
        if (size > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getPartiallyFailed().keySet())) > max) {
            max = size;
        }
        if ((size = RemoteCommand.getRelativePathMaxSize(transferInfo.getIgnored().keySet())) > max) {
            max = size;
        }
        return max + 2;
    }

    private static int getRelativePathMaxSize(Collection<TransferFile> files) {
        int max = 0;
        for (TransferFile file : files) {
            int length = file.getRemotePath().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    protected final boolean sourcesFilesOnly(FileObject sources, FileObject[] selectedFiles) {
        for (FileObject file : selectedFiles) {
            if (FileUtil.isParentOf((FileObject)sources, (FileObject)file) || sources.equals(file)) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteCommand.class, (String)"MSG_TransferSourcesOnly"), 0));
            return false;
        }
        return true;
    }

    private static final class TransferFileComparator
    implements Comparator<TransferFile> {
        private TransferFileComparator() {
        }

        @Override
        public int compare(TransferFile file1, TransferFile file2) {
            return file1.getRemotePath().compareToIgnoreCase(file2.getRemotePath());
        }
    }

    public static final class DefaultOperationMonitor
    implements RemoteClient.OperationMonitor {
        private final Deque<RemoteClient.Operation> operations = new ArrayDeque<RemoteClient.Operation>();
        private final ProgressHandle progressHandle;
        private int workUnits = 0;
        private int workUnit = 0;

        public DefaultOperationMonitor(ProgressHandle progressHandle, Set<TransferFile> forFiles) {
            if (progressHandle == null) {
                throw new IllegalStateException("Progress handle must be set");
            }
            this.progressHandle = progressHandle;
            this.workUnits = this.getWorkUnits(forFiles);
        }

        @Override
        public void operationStart(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
            if (this.operations.isEmpty()) {
                this.progressHandle.start(this.workUnits);
            }
            this.operations.offerFirst(operation);
            if (operation == RemoteClient.Operation.LIST) {
                this.progressHandle.progress(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_ListingFiles", (Object)forFiles.iterator().next().getName()));
                this.progressHandle.switchToIndeterminate();
            }
        }

        @Override
        public void operationProcess(RemoteClient.Operation operation, TransferFile forFile) {
            long size = forFile.getSize();
            switch (operation) {
                case LIST: {
                    if (size <= 0L) break;
                    this.workUnits = (int)((long)this.workUnits + size / 1024L);
                    break;
                }
                case UPLOAD: 
                case DOWNLOAD: {
                    if (size <= 0L) break;
                    String processMessageKey = operation == RemoteClient.Operation.DOWNLOAD ? "LBL_Downloading" : "LBL_Uploading";
                    this.progressHandle.progress(NbBundle.getMessage(DefaultOperationMonitor.class, (String)processMessageKey, (Object)forFile.getName()), this.workUnit);
                    this.workUnit = (int)((long)this.workUnit + size / 1024L);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported operation: " + (Object)((Object)operation));
                }
            }
        }

        @Override
        public void operationFinish(RemoteClient.Operation operation, Collection<TransferFile> forFiles) {
            this.operations.pollFirst();
            if (operation == RemoteClient.Operation.LIST) {
                this.progressHandle.switchToDeterminate(this.workUnits);
                this.progressHandle.progress(this.workUnit);
            }
            if (this.operations.isEmpty()) {
                this.progressHandle.finish();
            }
        }

        private int getWorkUnits(Set<TransferFile> forFiles) {
            int size = 0;
            for (TransferFile file : forFiles) {
                size = (int)((long)size + file.getSize());
            }
            return size / 1024;
        }
    }
}

