/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.actions.GoToActionAction;
import org.netbeans.modules.php.spi.actions.GoToViewAction;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleActionsExtender;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GoToActionOrViewAction
extends TextAction
implements ContextAwareAction {
    private static final long serialVersionUID = -28799856213215454L;
    private static final GoToActionOrViewAction INSTANCE = new GoToActionOrViewAction();
    private static final int DEFAULT_OFFSET = 0;

    private GoToActionOrViewAction() {
        super(GoToActionOrViewAction.getFullName());
        this.putValue("noIconInMenu", true);
        this.putValue("Name", GoToActionOrViewAction.getFullName());
        this.putValue("ShortDescription", GoToActionOrViewAction.getFullName());
        this.putValue("menuText", GoToActionOrViewAction.getPureName());
    }

    public static GoToActionOrViewAction getInstance() {
        return INSTANCE;
    }

    private static String getFullName() {
        return NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_PhpPrefix", (Object)GoToActionOrViewAction.getPureName());
    }

    private static String getPureName() {
        return NbBundle.getMessage(GoToActionOrViewAction.class, (String)"LBL_GoToActionOrView");
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        FileObject fo = FileUtils.getFileObject((Lookup)actionContext);
        return this.getGoToAction(fo, this.getOffset(actionContext));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileObject fo = NbEditorUtilities.getFileObject((Document)this.getTextComponent(e).getDocument());
        Action action = this.getGoToAction(fo, this.getTextComponent(e).getCaretPosition());
        if (action != null) {
            action.actionPerformed(e);
        }
    }

    private Action getGoToAction(FileObject fo, int offset) {
        if (fo == null) {
            return null;
        }
        PhpProject phpProject = PhpProjectUtils.getPhpProject(fo);
        if (phpProject == null) {
            return null;
        }
        PhpModule phpModule = phpProject.getPhpModule();
        for (PhpFrameworkProvider frameworkProvider : phpProject.getFrameworks()) {
            PhpModuleActionsExtender actionsExtender = frameworkProvider.getActionsExtender(phpModule);
            if (actionsExtender == null) continue;
            if (actionsExtender.isActionWithView(fo)) {
                GoToViewAction goToViewAction = actionsExtender.getGoToViewAction(fo, offset);
                if (goToViewAction == null) {
                    throw new IllegalStateException(fo.getPath() + " is action with view so GoToView instance must be returned by " + frameworkProvider.getIdentifier());
                }
                return goToViewAction;
            }
            if (!actionsExtender.isViewWithAction(fo)) continue;
            GoToActionAction goToActionAction = actionsExtender.getGoToActionAction(fo, offset);
            if (goToActionAction == null) {
                throw new IllegalStateException(fo.getPath() + " is view with action so GoToAction instance must be returned by " + frameworkProvider.getIdentifier());
            }
            return goToActionAction;
        }
        return null;
    }

    private int getOffset(Lookup context) {
        EditorCookie editorCookie = (EditorCookie)context.lookup(EditorCookie.class);
        if (editorCookie != null) {
            return this.getOffset(editorCookie);
        }
        FileObject fo = FileUtils.getFileObject((Lookup)context);
        if (fo == null) {
            return 0;
        }
        try {
            editorCookie = (EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class);
            return this.getOffset(editorCookie);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    private int getOffset(EditorCookie editorCookie) {
        if (editorCookie == null) {
            return 0;
        }
        JEditorPane[] openedPanes = editorCookie.getOpenedPanes();
        if (openedPanes == null || openedPanes.length == 0) {
            return 0;
        }
        return openedPanes[0].getCaretPosition();
    }
}

