/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

abstract class FileOperationFactory {
    protected final PhpProject project;
    private final PhpVisibilityQuery phpVisibilityQuery;
    private volatile boolean factoryError = false;

    public FileOperationFactory(PhpProject project) {
        assert (project != null);
        this.project = project;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(project);
    }

    final Callable<Boolean> createInitHandler(FileObject source) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No INIT handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createInitHandlerInternal(source);
    }

    final Callable<Boolean> createCopyHandler(FileObject source, FileEvent fileEvent) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No CREATE handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        if (!this.isValid(fileEvent)) {
            this.getLogger().log(Level.FINE, "No CREATE handler, File Event invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createCopyHandlerInternal(source, fileEvent);
    }

    final Callable<Boolean> createRenameHandler(FileObject source, String oldName, FileRenameEvent fileRenameEvent) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No RENAME handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        if (!this.isValid((FileEvent)fileRenameEvent)) {
            this.getLogger().log(Level.FINE, "No RENAME handler, File Event invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createRenameHandlerInternal(source, oldName, fileRenameEvent);
    }

    final Callable<Boolean> createDeleteHandler(FileObject source, FileEvent fileEvent) {
        if (this.isInvalid()) {
            this.getLogger().log(Level.FINE, "No DELETE handler, File Operation Factory invalid for project {0}", this.project.getName());
            return null;
        }
        if (!this.isValid(fileEvent)) {
            this.getLogger().log(Level.FINE, "No DELETE handler, File Event invalid for project {0}", this.project.getName());
            return null;
        }
        return this.createDeleteHandlerInternal(source, fileEvent);
    }

    abstract Logger getLogger();

    protected abstract boolean isEnabled();

    protected abstract boolean isValid(FileEvent var1);

    protected abstract Callable<Boolean> createInitHandlerInternal(FileObject var1);

    protected abstract Callable<Boolean> createCopyHandlerInternal(FileObject var1, FileEvent var2);

    protected abstract Callable<Boolean> createRenameHandlerInternal(FileObject var1, String var2, FileRenameEvent var3);

    protected abstract Callable<Boolean> createDeleteHandlerInternal(FileObject var1, FileEvent var2);

    final void reset() {
        this.factoryError = false;
        this.resetInternal();
    }

    protected void resetInternal() {
    }

    final void invalidate() {
        this.factoryError = true;
    }

    final boolean isInvalid() {
        return this.factoryError;
    }

    protected final boolean isSourceFileValid(FileObject source) {
        assert (CommandUtils.isUnderSources(this.project, source)) : String.format("File %s not underneath sources of project %s", FileOperationFactory.getPath(source), this.project.getName());
        return !this.isNbProjectMetadata(source) && PhpProjectUtils.isVisible(this.phpVisibilityQuery, source);
    }

    boolean isNbProjectMetadata(FileObject fo) {
        FileObject nbprojectDir = this.project.getProjectDirectory().getFileObject("nbproject");
        return FileUtil.isParentOf((FileObject)nbprojectDir, (FileObject)fo) || nbprojectDir.equals(fo);
    }

    protected FileObject getSources() {
        return ProjectPropertiesSupport.getSourcesDirectory(this.project);
    }

    protected static String getPath(FileObject fo) {
        return FileUtil.getFileDisplayName((FileObject)fo);
    }

    protected boolean askUser(String message) {
        Object openProperties = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, this.project.getName(), 0));
        return openProperties.equals(0);
    }

    protected void showCustomizer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((CustomizerProviderImpl)FileOperationFactory.this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Sources");
            }
        });
    }
}

