/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

final class RemoteTransferFile
extends TransferFile {
    private static final Logger LOGGER = Logger.getLogger(RemoteTransferFile.class.getName());
    private final RemoteFile file;
    private final RemoteClientImplementation remoteClient;

    public RemoteTransferFile(RemoteFile file, TransferFile parent, RemoteClientImplementation remoteClient) {
        super(parent, remoteClient.getBaseRemoteDirectory());
        this.file = file;
        this.remoteClient = remoteClient;
        if (file == null) {
            throw new NullPointerException("Remote file cannot be null");
        }
        if (remoteClient == null) {
            throw new NullPointerException("Remote client cannot be null");
        }
        if (!this.baseDirectory.startsWith("/")) {
            throw new IllegalArgumentException("Base directory '" + this.baseDirectory + "' must start with '" + "/" + "'");
        }
        String parentDirectory = file.getParentDirectory();
        if (!parentDirectory.startsWith("/")) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must start with '" + "/" + "'");
        }
        if (!parentDirectory.startsWith(this.baseDirectory)) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must be underneath base directory '" + this.baseDirectory + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRemotePath() {
        String absolutePath;
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            absolutePath = this.file.getParentDirectory() + "/" + this.getName();
        }
        if (absolutePath.equals(this.baseDirectory)) {
            return ".";
        }
        return absolutePath.substring(this.baseDirectory.length() + "/".length());
    }

    @Override
    protected Collection<TransferFile> fetchChildren() {
        try {
            return this.remoteClient.listFiles(this);
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.WARNING, "Error while getting children for " + this, ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getSizeImpl() {
        if (this.isFile()) {
            RemoteFile remoteFile = this.file;
            synchronized (remoteFile) {
                return this.file.getSize();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFile() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLink() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getTimestampImpl() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getTimestamp();
        }
    }
}

