/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.util.logging.Logger;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.sftp.SftpConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;

public final class SftpConfiguration
extends RemoteConfiguration {
    private static final Logger LOGGER = Logger.getLogger(SftpConfiguration.class.getName());
    private static final String PATH_SEPARATOR = "/";
    private final String host;
    private final int port;
    private final String userName;
    private final String knownHostsFile;
    private final String identityFile;
    private final String initialDirectory;
    private final int timeout;
    private final int keepAliveInterval;
    private String password;

    public SftpConfiguration(ConfigManager.Configuration cfg) {
        super(cfg);
        this.host = cfg.getValue("host");
        this.port = Integer.parseInt(cfg.getValue("port"));
        this.userName = cfg.getValue("user");
        this.knownHostsFile = cfg.getValue("knownHostsFile");
        this.identityFile = cfg.getValue("identityFile");
        this.initialDirectory = cfg.getValue("initialDirectory");
        this.timeout = this.readNumber("timeout", 30);
        this.keepAliveInterval = this.readNumber("keepAliveInterval", 30);
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized String getPassword() {
        if (this.password == null) {
            this.password = this.readPassword("password");
        }
        if (this.password == null) {
            this.password = "";
        }
        return this.password;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public String getIdentityFile() {
        return this.identityFile;
    }

    @Override
    public String getUrl(String directory) {
        assert (directory != null);
        String path = this.initialDirectory;
        if (directory.trim().length() > 0) {
            path = path + directory;
        }
        return "sftp://" + this.host + path.replaceAll("/{2,}", PATH_SEPARATOR);
    }

    @Override
    public boolean saveProperty(String key, String value) {
        if ("password".equals(key)) {
            this.savePassword(ConfigManager.decode(value), SftpConnectionProvider.get().getDisplayName());
            return true;
        }
        return false;
    }

    @Override
    public void notifyDeleted() {
        this.deletePassword();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SftpConfiguration other = (SftpConfiguration)obj;
        if (!(this.host == other.host || this.host != null && this.host.equals(other.host))) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!(this.userName == other.userName || this.userName != null && this.userName.equals(other.userName))) {
            return false;
        }
        if (!(this.password == other.password || this.password != null && this.password.equals(other.password))) {
            return false;
        }
        return this.identityFile == other.identityFile || this.identityFile != null && this.identityFile.equals(other.identityFile);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 97 * hash + this.port;
        hash = 97 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash = 97 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash = 97 * hash + (this.identityFile != null ? this.identityFile.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.getDisplayName());
        sb.append(", name: ");
        sb.append(this.getName());
        sb.append(", host: ");
        sb.append(this.host);
        sb.append(", port: ");
        sb.append(this.port);
        sb.append(", userName: ");
        sb.append(this.getUserName());
        sb.append(", password: *****");
        sb.append(", knownHostsFile: ");
        sb.append(this.knownHostsFile);
        sb.append(", identityFile: ");
        sb.append(this.identityFile);
        sb.append(", initialDirectory: ");
        sb.append(this.initialDirectory);
        sb.append(", timeout: ");
        sb.append(this.timeout);
        sb.append("]");
        return sb.toString();
    }
}

