/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaEvaluator
implements Evaluator<JavaExpression> {
    private final JPDADebuggerImpl debugger;

    public JavaEvaluator(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Evaluator.Result evaluate(Evaluator.Expression<JavaExpression> expression, final Evaluator.Context context) throws InvalidExpressionException {
        JavaExpression expr = (JavaExpression)expression.getPreprocessedObject();
        if (expr == null) {
            expr = JavaExpression.parse(expression.getExpression(), "1.5.0");
            expression.setPreprocessedObject((Object)expr);
        }
        Value v = this.evaluateIn(expr, context.getCallStackFrame(), context.getStackFrame(), context.getStackDepth(), context.getContextObject(), this.debugger.methodCallsUnsupportedExc == null, new Runnable(){

            @Override
            public void run() {
                context.notifyMethodToBeInvoked();
            }
        });
        return new Evaluator.Result(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evaluateIn(JavaExpression expression, CallStackFrame csf, StackFrame frame, int frameDepth, ObjectReference var, boolean canInvokeMethods, Runnable methodInvokePreprocessor) throws InvalidExpressionException {
        Value value;
        block12: {
            if (frame == null) {
                throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContext"));
            }
            ArrayList<String> imports = new ArrayList<String>();
            ArrayList<String> staticImports = new ArrayList<String>();
            imports.add("java.lang.*");
            imports.addAll(Arrays.asList(EditorContextBridge.getContext().getImports(this.debugger.getEngineContext().getURL(frame, "Java"))));
            ThreadReference tr = StackFrameWrapper.thread(frame);
            JPDAThreadImpl trImpl = this.debugger.getThread(tr);
            EvaluationContext context = new EvaluationContext(trImpl, frame, frameDepth, var, imports, staticImports, canInvokeMethods, methodInvokePreprocessor, this.debugger);
            TreeEvaluator evaluator = expression.evaluator(context);
            try {
                value = evaluator.evaluate();
                if (this.debugger.methodCallsUnsupportedExc != null || context.canInvokeMethods()) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (this.debugger.methodCallsUnsupportedExc == null && !context.canInvokeMethods()) {
                        this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                    }
                    throw throwable;
                }
                catch (InternalExceptionWrapper e) {
                    throw new InvalidExpressionException(e.getLocalizedMessage());
                }
                catch (ObjectCollectedExceptionWrapper e) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
                }
                catch (VMDisconnectedExceptionWrapper e) {
                    throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_disconnected"));
                }
                catch (InvalidStackFrameExceptionWrapper e) {
                    JPDAThreadImpl t = (JPDAThreadImpl)csf.getThread();
                    String msg = "Thread " + t + ", isSuspended = " + t.isSuspended() + ", isSuspendedNoFire = " + t.isSuspendedNoFire() + ", isThreadSuspended = " + t.isThreadSuspended() + ", isInStep = " + t.isInStep() + ", isMethodInvoking = " + t.isMethodInvoking();
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)msg));
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"));
                }
                catch (EvaluationException e) {
                    InvalidExpressionException iee = new InvalidExpressionException((Throwable)e);
                    iee.initCause((Throwable)e);
                    Exceptions.attachMessage((Throwable)iee, (String)("Expression = '" + expression.getExpression() + "'"));
                    throw iee;
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException isex = new InvalidExpressionException(itsex.getLocalizedMessage());
                    isex.initCause((Throwable)itsex);
                    throw isex;
                }
            }
            this.debugger.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
        }
        return value;
    }
}

