/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEBaseVersion;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.impl.RootInterfaceImpl;
import org.netbeans.modules.j2ee.sun.ddloaders.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.DDType;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataLoader;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataNode;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.appclient.SunAppClientOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.EnvironmentMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.SecurityRoleMappingMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.EjbMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.SunEjbOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.jms.JmsMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.ServletMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.SunWebOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice.WebServiceMultiViewElement;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SunDescriptorDataObject
extends DDMultiViewDataObject {
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private static final long serialVersionUID = 8957663189355029479L;
    private final Object proxyMonitor = new Object();
    private volatile RootInterfaceImpl ddRootProxy;
    private PropertyChangeListener ddRootChangeListener;
    private DDType descriptorType;

    public SunDescriptorDataObject(FileObject pf, SunDescriptorDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.descriptorType = DDType.getDDType(pf.getNameExt());
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        CookieSet set = this.getCookieSet();
        set.add((Node.Cookie)validateCookie);
    }

    public J2eeModule.Type getModuleType() {
        return this.descriptorType.getEditorModuleType();
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
    }

    public FileObject getProjectDirectory() {
        Project project = this.getProject();
        return project == null ? null : project.getProjectDirectory();
    }

    public ASDDVersion getASDDVersion() {
        return DDProvider.getASDDVersion((RootInterface)this.getDDModel(), (ASDDVersion)ASDDVersion.SUN_APPSERVER_8_1);
    }

    public J2EEBaseVersion getJ2eeModuleVersion() {
        GlassfishConfiguration config;
        File fileKey = FileUtil.toFile((FileObject)this.getPrimaryFile());
        if (fileKey != null && "sun-cmp-mappings.xml".equals(fileKey.getName())) {
            fileKey = new File(fileKey.getParentFile(), "sun-ejb-jar.xml");
        }
        return (config = GlassfishConfiguration.getConfiguration((File)fileKey)) != null ? config.getJ2eeVersion() : null;
    }

    public RootInterface getDDRoot() {
        return this.getDDRootImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootInterface getDDRootImpl(boolean notify) {
        RootInterface localProxy = null;
        Object object = this.proxyMonitor;
        synchronized (object) {
            if (this.ddRootProxy == null) {
                try {
                    this.parseDocument();
                }
                catch (IOException ex) {
                    if (notify) {
                        this.notifyError(ex);
                    }
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            localProxy = this.ddRootProxy != null ? this.ddRootProxy.getRootInterface() : null;
        }
        return localProxy;
    }

    protected Node createNodeDelegate() {
        return new SunDescriptorDataNode(this);
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject dataObject = super.handleCopy(f);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseDocument() throws IOException {
        DDProvider ddProvider = DDProvider.getDefault();
        SAXParseException saxEx = null;
        Object object = this.proxyMonitor;
        synchronized (object) {
            if (this.ddRootProxy == null || !this.ddRootProxy.hasOriginal()) {
                try {
                    RootInterfaceImpl newDDRoot = (RootInterfaceImpl)ddProvider.getDDRoot(this.getPrimaryFile());
                    if (this.ddRootProxy != null && this.ddRootChangeListener != null) {
                        this.ddRootProxy.removePropertyChangeListener(this.ddRootChangeListener);
                    }
                    this.ddRootProxy = newDDRoot;
                    if (this.ddRootProxy != null) {
                        if (this.ddRootChangeListener == null) {
                            this.ddRootChangeListener = new SunDDPropertyChangeListener();
                        }
                        this.ddRootProxy.addPropertyChangeListener(this.ddRootChangeListener);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            } else {
                ddProvider.merge(this.ddRootProxy.getRootInterface(), this.createReader());
            }
            saxEx = this.ddRootProxy != null ? this.ddRootProxy.getError() : new SAXParseException("No proxy object found created by parser.", null);
        }
        this.setSaxError(saxEx);
    }

    @Override
    protected void validateDocument() throws IOException {
        try {
            RootInterfaceImpl proxyImpl = (RootInterfaceImpl)DDProvider.getDefault().getDDRoot(this.createReader());
            if (null != proxyImpl) {
                this.setSaxError(proxyImpl.getError());
            }
        }
        catch (Schema2BeansException ex) {
            this.setSaxError(new SAXException((Exception)((Object)ex)));
        }
        catch (Schema2BeansRuntimeException ex) {
            this.setSaxError(new SAXException((Exception)((Object)ex)));
        }
        catch (SAXException ex) {
            this.setSaxError(ex);
        }
    }

    @Override
    protected RootInterface getDDModel() {
        return this.getDDRootImpl(false);
    }

    @Override
    public boolean isDocumentParseable() {
        RootInterface ddRoot = this.getDDRoot();
        return ddRoot != null ? ddRoot.getStatus() != 2 : false;
    }

    protected String getPrefixMark() {
        return "<notused";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isModelCreated() {
        boolean result = false;
        Object object = this.proxyMonitor;
        synchronized (object) {
            result = this.ddRootProxy != null && this.ddRootProxy.hasOriginal();
        }
        return result;
    }

    public void showElement(final Object element) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SectionNodeView sectionView = (SectionNodeView)SunDescriptorDataObject.this.getActiveMVElement().getSectionView();
                Node root = sectionView.getRoot();
                SectionNode node = ((SectionNode)root.getChildren().getNodes()[0]).getNodeForElement(element);
                if (node != null) {
                    sectionView.openPanel((Object)node);
                    ((SectionNodeInnerPanel)node.getSectionNodePanel().getInnerPanel()).focusData(element);
                }
            }
        });
    }

    public ToolBarMultiViewElement getActiveMVElement() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    private boolean fireEvent(String oldResourceName, String resourceName, int eventType) {
        return false;
    }

    protected String getEditorMimeType() {
        String mimeTypePrefix = "text/x-dd-iplanet";
        ASDDVersion asDDVersion = this.getASDDVersion();
        if (ASDDVersion.SUN_APPSERVER_7_0.compareTo((Object)asDDVersion) < 0) {
            mimeTypePrefix = "text/x-dd-sun";
        }
        if (ASDDVersion.SUN_APPSERVER_9_0.compareTo((Object)asDDVersion) < 0 && (this.descriptorType.equals(DDType.DD_SUN_APP_CLIENT) || this.descriptorType.equals(DDType.DD_GF_APP_CLIENT))) {
            mimeTypePrefix = "text/x-dd-glassfish";
        }
        Logger.getLogger("glassfish-ddui").log(Level.FINE, "{0}{1}", new Object[]{mimeTypePrefix, this.descriptorType.getDescriptorMimeTypeSuffix()});
        return mimeTypePrefix + this.descriptorType.getDescriptorMimeTypeSuffix();
    }

    public static MultiViewElement createWebOverviewMultiViewElement(Lookup lookup) {
        return new SunWebOverviewMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createServletsMultiViewElement(Lookup lookup) {
        return new ServletMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createEjbOveriewMultiViewElement(Lookup lookup) {
        return new SunEjbOverviewMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createEjbMultiViewElement(Lookup lookup) {
        return new EjbMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createAppCliOverviewViewElement(Lookup lookup) {
        return new SunAppClientOverviewMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createSecurityMultiViewSecurityElement(Lookup lookup) {
        return new SecurityRoleMappingMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createServicesMultiViewElement(Lookup lookup) {
        return new WebServiceMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createJmsMultiViewElement(Lookup lookup) {
        return new JmsMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static MultiViewElement createEnvMultiViewEnvironmentElement(Lookup lookup) {
        return new EnvironmentMultiViewElement((SunDescriptorDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    public static XmlMultiViewElement createXmlMultiViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(SunDescriptorDataObject.class));
    }

    private static class SunDDPropertyChangeListener
    implements PropertyChangeListener {
        private SunDDPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

