/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.awt.CloseButtonFactory;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SearchBar
extends JPanel {
    private static SearchBar searchbarInstance = null;
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final boolean CLOSE_ON_ENTER = Boolean.getBoolean("org.netbeans.modules.editor.search.closeOnEnter");
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = Color.RED.darker();
    private static final Color INVALID_REGEXP = Color.red;
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private static final int defaultIncremantalSearchComboWidth = 200;
    private static final int maxIncremantalSearchComboWidth = 350;
    private WeakReference<JTextComponent> actualTextComponent;
    private List<PropertyChangeListener> actualComponentListeners = new LinkedList<PropertyChangeListener>();
    private FocusAdapter focusAdapterForComponent;
    private PropertyChangeListener propertyChangeListenerForComponent;
    private final JButton expandButton;
    private final JPopupMenu expandPopup;
    private final JLabel findLabel;
    private final JComboBox incSearchComboBox;
    private final JTextField incSearchTextField;
    private final DocumentListener incSearchTextFieldListener;
    private boolean hadFocusOnIncSearchTextField = false;
    private final JButton findNextButton;
    private final JButton findPreviousButton;
    private final JCheckBox matchCaseCheckBox;
    private final JCheckBox wholeWordsCheckBox;
    private final JCheckBox regexpCheckBox;
    private final JCheckBox highlightCheckBox;
    private final JCheckBox wrapAroundCheckBox;
    private final JPanel padding;
    private final JButton closeButton;
    private Map<String, Object> findProps = EditorFindSupport.getInstance().getFindProperties();
    private boolean searched = false;
    private final List<Component> inBar = new ArrayList<Component>();
    private final LinkedList<Component> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupGoingToShow = false;
    private boolean isPopupShown = false;
    private static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String KEYMAPS_FOLDER = "Keymaps";

    public static SearchBar getInstance() {
        if (searchbarInstance == null) {
            searchbarInstance = new SearchBar();
        }
        return searchbarInstance;
    }

    public static SearchBar getInstance(JTextComponent component) {
        SearchBar searchbarIns = SearchBar.getInstance();
        if (searchbarIns.getActualTextComponent() != component) {
            searchbarIns.setActualTextComponent(component);
        }
        return searchbarIns;
    }

    private SearchBar() {
        this.addEscapeKeystrokeFocusBackTo(this);
        this.addKeystrokeFindActionTo(this);
        this.addKeystrokeReplaceActionTo(this);
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        Color bgColor = this.getBackground();
        this.setBackground(new Color(Math.max(0, bgColor.getRed() - 20), Math.max(0, bgColor.getGreen() - 20), Math.max(0, bgColor.getBlue() - 20)));
        this.setForeground(UIManager.getColor("textText"));
        this.add(Box.createHorizontalStrut(8));
        this.incSearchComboBox = this.createIncSearchComboBox();
        this.incSearchTextField = this.createIncSearchTextField(this.incSearchComboBox);
        this.incSearchTextFieldListener = this.createIncSearchTextFieldListener(this.incSearchTextField);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
        this.addEnterKeystrokeFindNextTo(this.incSearchTextField);
        this.addShiftEnterKeystrokeFindPreviousTo(this.incSearchTextField);
        this.incSearchTextField.getActionMap().remove("toggle-componentOrientation");
        this.incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(72, 128), "none");
        if (this.getCurrentKeyMapProfile().startsWith("Emacs")) {
            this.emacsProfileFix(this.incSearchTextField);
        }
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.findLabel.setLabelFor(this.incSearchComboBox);
        this.add(this.findLabel);
        this.add(this.incSearchComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.findPreviousButton = this.createFindButton("org/netbeans/modules/editor/resources/find_previous.png", "CTL_FindPrevious");
        this.findPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.add(this.findPreviousButton);
        this.findNextButton = this.createFindButton("org/netbeans/modules/editor/resources/find_next.png", "CTL_FindNext");
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.add(this.findNextButton);
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.matchCaseCheckBox = this.createCheckBox("CTL_MatchCase", "find-match-case");
        this.add(this.matchCaseCheckBox);
        this.wholeWordsCheckBox = this.createCheckBox("CTL_WholeWords", "find-whole-words");
        this.add(this.wholeWordsCheckBox);
        this.regexpCheckBox = this.createRegExpCheckBox("CTL_Regexp", "find-reg-exp");
        this.add(this.regexpCheckBox);
        this.highlightCheckBox = this.createCheckBox("CTL_Highlight", "find-highlight-search");
        this.add(this.highlightCheckBox);
        this.wrapAroundCheckBox = this.createCheckBox("CTL_WrapAround", "find-wrap-search");
        this.add(this.wrapAroundCheckBox);
        this.selectCheckBoxes();
        this.expandButton = this.createExpandButton();
        this.expandPopup = this.createExpandPopup(this.expandButton);
        this.add(this.expandButton);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
        this.add(this.padding);
        this.closeButton = this.createCloseButton();
        this.add(this.closeButton);
        this.makeBarExpandable();
        this.setVisible(false);
    }

    void updateIncSearchComboBoxHistory(String incrementalSearchText) {
        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
        for (int i = this.incSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = (String)this.incSearchComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.incSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incSearchComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.incSearchComboBox.setSelectedIndex(0);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
    }

    private FocusAdapter createFocusAdapterForComponent() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() instanceof JRootPane) {
                    return;
                }
                SearchBar.this.hadFocusOnIncSearchTextField = false;
            }
        };
    }

    private PropertyChangeListener createPropertyChangeListenerForComponent() {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"keymap".equals(evt.getPropertyName())) {
                    return;
                }
                JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
                if (lastFocusedComponent == null) {
                    return;
                }
                Keymap keymap = lastFocusedComponent.getKeymap();
                if (keymap instanceof MultiKeymap) {
                    Action[] actions;
                    MultiKeymap multiKeymap = (MultiKeymap)keymap;
                    for (Action action : actions = lastFocusedComponent.getActions()) {
                        String actionName = (String)action.getValue("Name");
                        if (actionName == null) {
                            LOG.log(Level.WARNING, "SearchBar: Null Action.NAME property of action: {0}\n", action);
                            continue;
                        }
                        if (actionName.equals("incremental-search-forward") || actionName.equals("find-next")) {
                            this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SearchBar.this.findNext();
                                }
                            });
                            continue;
                        }
                        if (!actionName.equals("incremental-search-backward") && !actionName.equals("find-previous")) continue;
                        this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SearchBar.this.findPrevious();
                            }
                        });
                    }
                }
            }

            private void keystrokeForSearchAction(MultiKeymap multiKeymap, Action searchAction, AbstractAction newSearchAction) {
                KeyStroke[] keyStrokes = multiKeymap.getKeyStrokesForAction(searchAction);
                if (keyStrokes != null) {
                    InputMap inputMap = SearchBar.this.getInputMap(1);
                    for (KeyStroke ks : keyStrokes) {
                        LOG.log(Level.FINE, "found {1} search action, {0}", new Object[]{ks, searchAction.getValue("Name")});
                        inputMap.put(ks, (String)searchAction.getValue("Name"));
                    }
                    SearchBar.this.getActionMap().put((String)searchAction.getValue("Name"), newSearchAction);
                }
            }
        };
        pcl.propertyChange(new PropertyChangeEvent(this, "keymap", null, null));
        return pcl;
    }

    private void addShiftEnterKeystrokeFindPreviousTo(JTextField incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        incSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
                if (CLOSE_ON_ENTER) {
                    SearchBar.this.looseFocus();
                }
            }
        });
    }

    private void addEnterKeystrokeFindNextTo(JTextField incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "incremental-find-next");
        incSearchTextField.getActionMap().put("incremental-find-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
                if (CLOSE_ON_ENTER) {
                    SearchBar.this.looseFocus();
                }
            }
        });
    }

    private JTextField createIncSearchTextField(JComboBox incSearchComboBox) throws MissingResourceException {
        JTextField incrementalSearchTextField = (JTextField)incSearchComboBox.getEditor().getEditorComponent();
        incrementalSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        ActionMap origActionMap = incrementalSearchTextField.getActionMap();
        ActionMap newActionMap = new ActionMap();
        for (Object key : origActionMap.allKeys()) {
            newActionMap.put(key, origActionMap.get(key));
        }
        incrementalSearchTextField.setActionMap(newActionMap);
        incrementalSearchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchBar.this.hadFocusOnIncSearchTextField = true;
            }
        });
        return incrementalSearchTextField;
    }

    private DocumentListener createIncSearchTextFieldListener(final JTextField incSearchTextField) {
        final Timer searchDelayTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.incrementalSearch();
            }
        });
        searchDelayTimer.setRepeats(false);
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
                if (incSearchTextField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(20);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
                if (incSearchTextField.getText().length() <= 3) {
                    searchDelayTimer.setInitialDelay(300);
                }
                searchDelayTimer.restart();
            }
        };
    }

    private JButton createCloseButton() throws MissingResourceException {
        JButton button = CloseButtonFactory.createBigCloseButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        button.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        return button;
    }

    private JCheckBox createRegExpCheckBox(String resName, final String findConstant) throws MissingResourceException {
        JCheckBox regExpCheckBox = new JCheckBox();
        regExpCheckBox.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)regExpCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        regExpCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
                SearchBar.this.incrementalSearch();
            }
        });
        regExpCheckBox.setMargin(BUTTON_INSETS);
        return regExpCheckBox;
    }

    JCheckBox createCheckBox(String resName, final String findConstant) throws MissingResourceException {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.incrementalSearch();
            }
        });
        checkBox.setMargin(BUTTON_INSETS);
        return checkBox;
    }

    private void selectCheckBoxes() {
        this.wholeWordsCheckBox.setSelected(this.getFindSupportValue("find-whole-words"));
        this.wholeWordsCheckBox.setEnabled(!this.getRegExp());
        this.matchCaseCheckBox.setSelected(this.getFindSupportValue("find-match-case"));
        this.regexpCheckBox.setSelected(this.getRegExp());
        this.highlightCheckBox.setSelected(this.getFindSupportValue("find-highlight-search"));
        this.wrapAroundCheckBox.setSelected(this.getFindSupportValue("find-wrap-search"));
    }

    private JPopupMenu createExpandPopup(final JButton expButton) {
        JPopupMenu expPopup = new JPopupMenu();
        expPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (expButton.getMousePosition() == null) {
                    expButton.setContentAreaFilled(false);
                    expButton.setBorderPainted(false);
                    SearchBar.this.isPopupShown = false;
                }
            }
        });
        return expPopup;
    }

    private JButton createFindButton(String imageIcon, String resName) {
        JButton button = new JButton(ImageUtilities.loadImageIcon((String)imageIcon, (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)button, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        button.setMargin(BUTTON_INSETS);
        return button;
    }

    private JButton createExpandButton() throws MissingResourceException {
        JButton expButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_expand.png", (boolean)false));
        expButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ExpandButton_Mnemonic").charAt(0));
        expButton.setMargin(BUTTON_INSETS);
        expButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = !SearchBar.this.isPopupShown;
                SearchBar.this.isPopupShown = state;
                if (state) {
                    SearchBar.this.showExpandedMenu();
                } else {
                    SearchBar.this.hideExpandedMenu();
                }
            }
        });
        return expButton;
    }

    private JComboBox createIncSearchComboBox() {
        JComboBox incrementalSearchComboBox = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                int editsize = this.getEditor().getEditorComponent().getPreferredSize().width + 10;
                int width = editsize > 200 && editsize < 350 ? editsize : (editsize >= 350 ? 350 : 200);
                return new Dimension(width, super.getPreferredSize().height);
            }
        };
        incrementalSearchComboBox.setEditable(true);
        return incrementalSearchComboBox;
    }

    private void emacsProfileFix(JTextField incSearchTextField) {
        String actionName = "caret-begin-line";
        class JumpOutOfSearchAction
        extends AbstractAction {
            private String actionName;

            public JumpOutOfSearchAction(String n) {
                this.actionName = n;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
                if (SearchBar.this.getActualTextComponent() != null) {
                    ActionEvent ev = new ActionEvent(SearchBar.this.getActualTextComponent(), e.getID(), e.getActionCommand(), e.getModifiers());
                    Action action = SearchBar.this.getActualTextComponent().getActionMap().get(this.actionName);
                    action.actionPerformed(ev);
                }
            }
        }
        JumpOutOfSearchAction a1 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a1);
        actionName = "caret-end-line";
        JumpOutOfSearchAction a2 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a2);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(80, 2, false), "caret-up-alt");
        actionName = "caret-up";
        JumpOutOfSearchAction a3 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-up-alt", a3);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(78, 2, false), "caret-down-alt");
        actionName = "caret-down";
        JumpOutOfSearchAction a4 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-down-alt", a4);
    }

    private String getCurrentKeyMapProfile() {
        Object o;
        String currentKeyMapProfile = null;
        FileObject fo = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
            currentKeyMapProfile = (String)o;
        }
        if (currentKeyMapProfile == null) {
            currentKeyMapProfile = DEFAULT_PROFILE;
        }
        return currentKeyMapProfile;
    }

    private void makeBarExpandable() {
        this.inBar.add(this.matchCaseCheckBox);
        this.inBar.add(this.wholeWordsCheckBox);
        this.inBar.add(this.regexpCheckBox);
        this.inBar.add(this.highlightCheckBox);
        this.inBar.add(this.wrapAroundCheckBox);
        this.barOrder.addAll(Arrays.asList(this.getComponents()));
        this.remove(this.expandButton);
    }

    @Override
    public Dimension getPreferredSize() {
        this.computeLayout();
        return super.getPreferredSize();
    }

    void computeLayout() {
        int parentWidth = this.getParent().getWidth();
        int totalWidth = 0;
        for (Component c : this.getComponents()) {
            if (c == this.padding) continue;
            totalWidth += c.getPreferredSize().width;
        }
        boolean change = false;
        if (totalWidth <= parentWidth) {
            while (!this.inPopup.isEmpty()) {
                Component c = this.inPopup.getFirst();
                if ((totalWidth += c.getPreferredSize().width) <= parentWidth) {
                    this.inPopup.removeFirst();
                    this.inBar.add(c);
                    this.expandPopup.remove(c);
                    this.add(c, this.barOrder.indexOf(c));
                    change = true;
                    continue;
                }
                break;
            }
        } else {
            while (totalWidth > parentWidth && !this.inBar.isEmpty()) {
                Component c = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst(c);
                this.remove(c);
                this.expandPopup.add(c, 0);
                totalWidth -= c.getPreferredSize().width;
                change = true;
            }
        }
        if (change) {
            if (this.inPopup.isEmpty()) {
                this.remove(this.expandButton);
            } else if (this.getComponentIndex(this.expandButton) < 0) {
                this.add((Component)this.expandButton, this.getComponentIndex(this.padding));
            }
            this.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private int getComponentIndex(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (c != comps[i]) continue;
            return i;
        }
        return -1;
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            this.isPopupGoingToShow = true;
            Insets ins = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.matchCaseCheckBox.getHeight() * this.inPopup.size() + ins.top + ins.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
            this.incrementalSearch();
            this.incSearchTextField.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    void addEscapeKeystrokeFocusBackTo(JComponent component) {
        component.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        component.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CLOSE_ON_ENTER && !SearchBar.this.searched) {
                    SearchBar.this.findNext();
                }
                SearchBar.this.looseFocus();
            }
        });
    }

    void addKeystrokeReplaceActionTo(JComponent component) {
        JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
        if (lastFocusedComponent == null) {
            return;
        }
        Keymap keymap = lastFocusedComponent.getKeymap();
        if (keymap instanceof MultiKeymap) {
            KeyStroke[] keyStrokesForReplaceAction;
            MultiKeymap multiKeymap = (MultiKeymap)keymap;
            for (KeyStroke ks : keyStrokesForReplaceAction = multiKeymap.getKeyStrokesForAction(lastFocusedComponent.getActionMap().get("replace"))) {
                component.getInputMap(1).put(KeyStroke.getKeyStroke(ks.getKeyCode(), ks.getModifiers(), true), "replace-from-component");
            }
            component.getActionMap().put("replace-from-component", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
                    if (lastFocusedComponent == null) {
                        return;
                    }
                    BaseAction replaceAction = (BaseAction)lastFocusedComponent.getActionMap().get("replace");
                    replaceAction.actionPerformed(e, lastFocusedComponent);
                }
            });
        }
    }

    void addKeystrokeFindActionTo(JComponent component) {
        JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
        if (lastFocusedComponent == null) {
            return;
        }
        Keymap keymap = lastFocusedComponent.getKeymap();
        if (keymap instanceof MultiKeymap) {
            KeyStroke[] keyStrokesForReplaceAction;
            MultiKeymap multiKeymap = (MultiKeymap)keymap;
            for (KeyStroke ks : keyStrokesForReplaceAction = multiKeymap.getKeyStrokesForAction(lastFocusedComponent.getActionMap().get("incremental-search-forward"))) {
                component.getInputMap(1).put(KeyStroke.getKeyStroke(ks.getKeyCode(), ks.getModifiers(), true), "find-from-component");
            }
            component.getActionMap().put("find-from-component", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
                    if (lastFocusedComponent == null) {
                        return;
                    }
                    BaseAction findAction = (BaseAction)lastFocusedComponent.getActionMap().get("incremental-search-forward");
                    findAction.actionPerformed(e, lastFocusedComponent);
                }
            });
        }
    }

    void gainFocus() {
        this.hadFocusOnIncSearchTextField = true;
        this.isPopupShown = false;
        this.setVisible(true);
        this.initBlockSearch();
        this.incSearchTextField.requestFocusInWindow();
        if (this.incSearchTextField.getText().length() > 0) {
            this.incSearchTextField.selectAll();
            this.findPreviousButton.setEnabled(true);
            this.findNextButton.setEnabled(true);
        } else {
            this.findPreviousButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
        this.selectCheckBoxes();
        this.searched = false;
    }

    void looseFocus() {
        this.hadFocusOnIncSearchTextField = false;
        if (!this.isVisible()) {
            return;
        }
        if (this.isPopupGoingToShow) {
            this.isPopupGoingToShow = false;
            return;
        }
        EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
        EditorFindSupport.getInstance().incSearchReset();
        if (this.getActualTextComponent() != null) {
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"");
            this.getActualTextComponent().requestFocusInWindow();
        }
        this.setVisible(false);
    }

    private void incrementalSearch() {
        if (this.getActualTextComponent() == null) {
            return;
        }
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.findPreviousButton.setEnabled(!empty);
        this.findNextButton.setEnabled(!empty);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        this.findProps.put("find-what", incrementalSearchText);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-highlight-search", !empty && this.highlightCheckBox.isSelected());
        this.findProps.put("find-backward-search", false);
        this.findProps.put("find-inc-search", true);
        findSupport.putFindProperties(this.findProps);
        int caretPosition = this.getActualTextComponent().getCaretPosition();
        if (this.regexpCheckBox.isSelected()) {
            Pattern pattern;
            String patternErrorMsg = null;
            try {
                pattern = Pattern.compile(incrementalSearchText);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                patternErrorMsg = e.getDescription();
            }
            if (pattern != null) {
                this.incSearchTextField.setForeground(UIManager.getColor("textText"));
                Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"", (int)900);
            } else {
                this.incSearchTextField.setForeground(INVALID_REGEXP);
                Utilities.setStatusBoldText((JTextComponent)this.getActualTextComponent(), (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-invalid-regexp", (Object)patternErrorMsg));
            }
        } else if (findSupport.incSearch(this.findProps, caretPosition) || empty) {
            this.incSearchTextField.setForeground(UIManager.getColor("textText"));
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"", (int)900);
            this.searched = true;
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-not-found", (Object)incrementalSearchText), (int)900);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void findNext() {
        this.find(true);
    }

    void findPrevious() {
        this.find(false);
    }

    private void find(boolean next) {
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.updateIncSearchComboBoxHistory(incrementalSearchText);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        Map<String, Object> actualfindProps = this.getFindProps();
        findSupport.putFindProperties(actualfindProps);
        if (findSupport.find(actualfindProps, !next) || empty) {
            this.incSearchTextField.setForeground(UIManager.getColor("textText"));
            this.searched = true;
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void initBlockSearch() {
        JTextComponent c = EditorRegistry.lastFocusedComponent();
        String selText = null;
        int startSelection = 0;
        int endSelection = 0;
        boolean blockSearchVisible = false;
        if (c != null) {
            startSelection = c.getSelectionStart();
            endSelection = c.getSelectionEnd();
            Document doc = c.getDocument();
            if (doc instanceof BaseDocument) {
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    int startLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)startSelection);
                    int endLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)endSelection);
                    if (endLine > startLine) {
                        blockSearchVisible = true;
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            if (!blockSearchVisible) {
                selText = c.getSelectedText();
                if (selText != null && selText.length() > 0) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.incSearchTextField.setText(selText);
                } else {
                    String findWhat = (String)EditorFindSupport.getInstance().getFindProperty("find-what");
                    if (findWhat != null && findWhat.length() > 0) {
                        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
                        this.incSearchTextField.setText(findWhat);
                        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
                    }
                }
            }
            int blockSearchStartOffset = blockSearchVisible ? startSelection : 0;
            int blockSearchEndOffset = blockSearchVisible ? endSelection : 0;
            try {
                this.findProps.put("find-block-search", blockSearchVisible);
                this.findProps.put("find-block-search-start", doc.createPosition(blockSearchStartOffset));
                this.findProps.put("find-block-search-end", doc.createPosition(blockSearchEndOffset));
                EditorFindSupport.getInstance().setBlockSearchHighlight(blockSearchStartOffset, blockSearchEndOffset);
            }
            catch (BadLocationException ble) {
                this.findProps.put("find-block-search", Boolean.FALSE);
                this.findProps.put("find-block-search-start", null);
                this.findProps.put("find-block-search-end", null);
            }
            EditorFindSupport.getInstance().putFindProperties(this.findProps);
        }
    }

    boolean getFindSupportValue(String findConstant) {
        Boolean b = (Boolean)this.findProps.get(findConstant);
        return b != null ? b : false;
    }

    private void switchFindSupportValue(String findConstant) {
        this.findProps.put(findConstant, !this.getFindSupportValue(findConstant));
    }

    boolean getRegExp() {
        return this.getFindSupportValue("find-reg-exp");
    }

    boolean hadFocusOnTextField() {
        return this.hadFocusOnIncSearchTextField;
    }

    void lostFocusOnTextField() {
        this.hadFocusOnIncSearchTextField = false;
    }

    void setActualTextComponent(JTextComponent component) {
        if (this.getActualTextComponent() != null) {
            this.getActualTextComponent().removeFocusListener(this.focusAdapterForComponent);
            this.getActualTextComponent().removePropertyChangeListener(this.propertyChangeListenerForComponent);
        }
        if (this.focusAdapterForComponent == null) {
            this.focusAdapterForComponent = this.createFocusAdapterForComponent();
        }
        if (this.propertyChangeListenerForComponent == null) {
            this.propertyChangeListenerForComponent = this.createPropertyChangeListenerForComponent();
        }
        component.addFocusListener(this.focusAdapterForComponent);
        component.addPropertyChangeListener(this.propertyChangeListenerForComponent);
        for (PropertyChangeListener pcl : this.actualComponentListeners) {
            pcl.propertyChange(new PropertyChangeEvent(this, "actualTextComponent", this.getActualTextComponent(), component));
        }
        this.actualTextComponent = new WeakReference<JTextComponent>(component);
    }

    void addActualComponentListener(PropertyChangeListener propertyChangeListener) {
        this.actualComponentListeners.add(propertyChangeListener);
    }

    JTextComponent getActualTextComponent() {
        return this.actualTextComponent != null ? (JTextComponent)this.actualTextComponent.get() : null;
    }

    JTextField getIncSearchTextField() {
        return this.incSearchTextField;
    }

    JButton getCloseButton() {
        return this.closeButton;
    }

    JLabel getFindLabel() {
        return this.findLabel;
    }

    JButton getFindNextButton() {
        return this.findNextButton;
    }

    JButton getFindPreviousButton() {
        return this.findPreviousButton;
    }

    Map<String, Object> getFindProps() {
        this.findProps.put("find-what", this.incSearchTextField.getText());
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.TRUE);
        this.findProps.put("find-highlight-search", !this.incSearchTextField.getText().isEmpty() && this.highlightCheckBox.isSelected());
        this.findProps.put("find-wrap-search", this.wrapAroundCheckBox.isSelected());
        return this.findProps;
    }

    JCheckBox getMatchCaseCheckBox() {
        return this.matchCaseCheckBox;
    }

    JCheckBox getRegexpCheckBox() {
        return this.regexpCheckBox;
    }

    boolean isSearched() {
        return this.searched;
    }

    void setSearched(boolean searched) {
        this.searched = searched;
    }
}

