/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.impl.ReplaceBar;
import org.netbeans.modules.editor.impl.SearchBar;
import org.openide.util.NbBundle;

public abstract class SearchAndReplaceBarHandler {
    public static final String INCREMENTAL_SEARCH_FORWARD = "incremental-search-forward";
    public static final String INCREMENTAL_SEARCH_BACKWARD = "incremental-search-backward";
    public static final String REPLACE_ACTION = "replace";
    private static final ExtKit.FindAction dialogFindAction = new ExtKit.FindAction();
    private static final ExtKit.ReplaceAction dialogReplaceAction = new ExtKit.ReplaceAction();
    private static PropertyChangeListener searchAndReplaceBarPersistentListener = null;

    private static <T> T findComponent(Container container, Class<T> componentClass, int depth) {
        if (depth > 0) {
            for (Component c : container.getComponents()) {
                Component target;
                if (componentClass.isAssignableFrom(c.getClass())) {
                    target = c;
                    return (T)target;
                }
                if (!(c instanceof Container) || (target = SearchAndReplaceBarHandler.findComponent((Container)c, componentClass, depth - 1)) == null) continue;
                return (T)target;
            }
        }
        return null;
    }

    private static void makeSearchAndReplaceBarPersistent() {
        if (searchAndReplaceBarPersistentListener == null) {
            searchAndReplaceBarPersistentListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    EditorUI eui;
                    if (evt.getPropertyName().equals("focusGained") && SearchBar.getInstance().getActualTextComponent() != EditorRegistry.lastFocusedComponent() && SearchBar.getInstance().isVisible() && (eui = Utilities.getEditorUI((JTextComponent)EditorRegistry.lastFocusedComponent())) != null) {
                        JPanel jp;
                        JComponent comp;
                        JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                        if (comp != null && (jp = (JPanel)SearchAndReplaceBarHandler.findComponent(comp, SearchJPanel.class, 5)) != null) {
                            SearchBar searchBarInstance = SearchBar.getInstance(eui.getComponent());
                            ReplaceBar replaceBarInstance = ReplaceBar.getInstance(searchBarInstance);
                            jp.add(searchBarInstance);
                            if (replaceBarInstance.isVisible()) {
                                jp.add(replaceBarInstance);
                                if (replaceBarInstance.hadFocusOnTextField()) {
                                    replaceBarInstance.gainFocus();
                                }
                            }
                            jp.revalidate();
                            if (searchBarInstance.hadFocusOnTextField()) {
                                searchBarInstance.gainFocus();
                            }
                        }
                    }
                }
            };
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)searchAndReplaceBarPersistentListener);
        }
    }

    public static class ReplaceAction
    extends BaseAction {
        static final long serialVersionUID = -1L;

        public ReplaceAction() {
            super(SearchAndReplaceBarHandler.REPLACE_ACTION, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(ReplaceAction.class, (String)SearchAndReplaceBarHandler.REPLACE_ACTION));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            EditorUI eui;
            if (target != null && (eui = Utilities.getEditorUI((JTextComponent)target)) != null) {
                JPanel jp;
                JComponent comp;
                JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                if (comp != null && (jp = (JPanel)SearchAndReplaceBarHandler.findComponent(comp, SearchJPanel.class, 5)) != null) {
                    SearchBar searchBar = SearchBar.getInstance(eui.getComponent());
                    jp.add(searchBar);
                    jp.add(ReplaceBar.getInstance(searchBar));
                    ReplaceBar.getInstance(searchBar).gainFocus();
                    SearchAndReplaceBarHandler.makeSearchAndReplaceBarPersistent();
                    return;
                }
                if (target.isEditable()) {
                    dialogReplaceAction.actionPerformed(evt, target);
                }
            }
        }
    }

    public static class IncrementalSearchBackwardAction
    extends SearchAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchBackwardAction() {
            super(SearchAndReplaceBarHandler.INCREMENTAL_SEARCH_BACKWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchBackwardAction.class, (String)SearchAndReplaceBarHandler.INCREMENTAL_SEARCH_BACKWARD));
        }
    }

    public static class IncrementalSearchForwardAction
    extends SearchAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchForwardAction() {
            super(SearchAndReplaceBarHandler.INCREMENTAL_SEARCH_FORWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchForwardAction.class, (String)SearchAndReplaceBarHandler.INCREMENTAL_SEARCH_FORWARD));
        }
    }

    public static class SearchAction
    extends BaseAction {
        public SearchAction(String name, int updateMask) {
            super(name, updateMask);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            EditorUI eui;
            if (target != null && (eui = Utilities.getEditorUI((JTextComponent)target)) != null) {
                JPanel jp;
                JComponent comp;
                JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                if (comp != null && (jp = (JPanel)SearchAndReplaceBarHandler.findComponent(comp, SearchJPanel.class, 5)) != null) {
                    SearchBar searchBarInstance = SearchBar.getInstance(eui.getComponent());
                    jp.add(searchBarInstance);
                    ReplaceBar replaceBarInstance = ReplaceBar.getInstance(searchBarInstance);
                    if (replaceBarInstance.isVisible()) {
                        replaceBarInstance.looseFocus();
                    }
                    searchBarInstance.gainFocus();
                    SearchAndReplaceBarHandler.makeSearchAndReplaceBarPersistent();
                    return;
                }
                dialogFindAction.actionPerformed(evt, target);
            }
        }
    }

    private static class SearchJPanel
    extends JPanel {
        private SearchJPanel() {
        }
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            SearchJPanel searchJPanel = new SearchJPanel();
            searchJPanel.setLayout(new BoxLayout(searchJPanel, 1));
            return searchJPanel;
        }
    }
}

