/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.AbstractSaveAction;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.SVGImageRasterizerPanel;
import org.netbeans.modules.mobility.svgcore.export.SaveAnimationAsImageAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class SaveAsImageAction
extends AbstractSaveAction {
    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] n) {
        SVGDataObject doj = (SVGDataObject)((Object)n[0].getLookup().lookup(SVGDataObject.class));
        if (doj != null) {
            int state = this.getAnimatorState(doj);
            float time = this.stopAnimator(doj);
            try {
                final SVGImageRasterizerPanel panel = new SVGImageRasterizerPanel(doj, null);
                final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SaveAnimationAsImageAction.class, (String)"TITLE_ImageExport"));
                panel.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        dd.setValid(panel.isDialogValid());
                    }
                });
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                SaveAnimationAsImageAction.setDialogMinimumSize(dlg);
                dd.setValid(panel.isDialogValid());
                dlg.setVisible(true);
                if (dd.getValue() == DialogDescriptor.OK_OPTION && panel.isExportConfirmed()) {
                    AnimationRasterizer.export(doj, panel);
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            this.resumeAnimatorState(doj, state, time);
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAsImageAction.class, (String)"LBL_ExportAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return 1;
    }

    protected Class[] cookieClasses() {
        return new Class[]{SVGDataObject.class};
    }

    protected boolean asynchronous() {
        return false;
    }
}

