/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.io.Driver;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeFactory;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ParseException;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.editor.ext.html.parser.spi.DefaultHtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HelpResolver;
import org.netbeans.editor.ext.html.parser.spi.HtmlModel;
import org.netbeans.editor.ext.html.parser.spi.HtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlParser;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.editor.ext.html.parser.spi.NamedCharRef;
import org.netbeans.modules.html.parser.AstNodeTreeBuilder;
import org.netbeans.modules.html.parser.HtmlDocumentation;
import org.netbeans.modules.html.parser.HtmlTagProvider;
import org.netbeans.modules.html.parser.model.ElementDescriptor;
import org.netbeans.modules.html.parser.model.NamedCharacterReference;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Html5Parser
implements HtmlParser {
    private static final String PARSER_NAME = String.format("validator.nu html5 parser (%s).", Html5Parser.class);
    private static final HtmlModel HTML5MODEL = new Html5Model();
    private static final Pattern TEMPLATING_MARKS_PATTERN = Pattern.compile("@@@");
    private static final String TEMPLATING_MARKS_MASK = "   ";

    public HtmlParseResult parse(HtmlSource source, HtmlVersion preferedVersion, Lookup lookup) throws ParseException {
        String code = Html5Parser.maskTemplatingMarks(((Object)source.getSourceCode()).toString());
        try {
            InputSource is = new InputSource(new StringReader(code));
            AstNodeTreeBuilder treeBuilder = new AstNodeTreeBuilder(AstNodeFactory.shared().createRootNode(0, code.length()));
            ErrorReportingTokenizer tokenizer = new ErrorReportingTokenizer(treeBuilder);
            Driver driver = new Driver(tokenizer);
            driver.setTransitionHandler(treeBuilder);
            driver.tokenize(is);
            AstNode root = treeBuilder.getRoot();
            return new Html5ParserResult(source, root, Collections.<ProblemDescription>emptyList(), preferedVersion);
        }
        catch (SAXException ex) {
            throw new ParseException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ParseException((Throwable)ex);
        }
        catch (AssertionError e) {
            StringBuilder msg = new StringBuilder();
            msg.append("An internal parser error occured");
            if (source.getSourceFileObject() != null) {
                msg.append(" when parsing ");
                msg.append(source.getSourceFileObject().getPath());
            }
            Logger.getAnonymousLogger().log(Level.INFO, msg.toString(), (Throwable)((Object)e));
            return new Html5ParserResult(source, AstNodeFactory.shared().createRootNode(0, code.length()), Collections.<ProblemDescription>emptyList(), preferedVersion);
        }
    }

    public boolean canParse(HtmlVersion version) {
        return version == HtmlVersion.HTML5 || version == HtmlVersion.XHTML5 || version == HtmlVersion.HTML32 || version == HtmlVersion.HTML41_STRICT || version == HtmlVersion.HTML41_TRANSATIONAL || version == HtmlVersion.HTML41_FRAMESET || version == HtmlVersion.HTML40_STRICT || version == HtmlVersion.HTML40_TRANSATIONAL || version == HtmlVersion.HTML40_FRAMESET || version == HtmlVersion.XHTML10_STICT || version == HtmlVersion.XHTML10_TRANSATIONAL || version == HtmlVersion.XHTML10_FRAMESET || version == HtmlVersion.XHTML11;
    }

    public HtmlModel getModel(HtmlVersion version) {
        assert (version == HtmlVersion.HTML5 || version == HtmlVersion.XHTML5);
        return HTML5MODEL;
    }

    public String getName() {
        return PARSER_NAME;
    }

    static String maskTemplatingMarks(String code) {
        return TEMPLATING_MARKS_PATTERN.matcher(code).replaceAll(TEMPLATING_MARKS_MASK);
    }

    private static final class Html5Model
    implements HtmlModel {
        private static Collection<HtmlTag> ALL_TAGS;

        private Html5Model() {
        }

        public synchronized Collection<HtmlTag> getAllTags() {
            if (ALL_TAGS == null) {
                ALL_TAGS = new ArrayList<HtmlTag>();
                for (ElementDescriptor element : ElementDescriptor.values()) {
                    ALL_TAGS.add(HtmlTagProvider.getTagForElement(element.getName()));
                }
            }
            return Collections.unmodifiableCollection(ALL_TAGS);
        }

        public HtmlTag getTag(String tagName) {
            return HtmlTagProvider.getTagForElement(tagName);
        }

        public Collection<? extends NamedCharRef> getNamedCharacterReferences() {
            return EnumSet.allOf(NamedCharacterReference.class);
        }

        public HelpResolver getHelpResolver() {
            return HtmlDocumentation.getDefault();
        }

        public String getModelId() {
            return "html5model";
        }
    }

    private static class Html5ParserResult
    extends DefaultHtmlParseResult {
        public Html5ParserResult(HtmlSource source, AstNode root, Collection<ProblemDescription> problems, HtmlVersion version) {
            super(source, root, problems, version);
        }

        public HtmlModel model() {
            return HTML5MODEL;
        }

        public Collection<HtmlTag> getPossibleTagsInContext(AstNode afterNode, boolean openTags) {
            HtmlTag tag = this.model().getTag(afterNode.getNameWithoutPrefix());
            if (tag == null) {
                return Collections.emptyList();
            }
            if (openTags) {
                while (tag != null && tag.isEmpty()) {
                    if ((afterNode = afterNode.parent()) == null) {
                        return Collections.emptyList();
                    }
                    tag = this.model().getTag(afterNode.getNameWithoutPrefix());
                }
                if (tag == null) {
                    return Collections.emptyList();
                }
                LinkedHashSet<HtmlTag> possibleChildren = new LinkedHashSet<HtmlTag>();
                this.addPossibleTags(tag, possibleChildren);
                return possibleChildren;
            }
            return this.completeEndTags(afterNode);
        }

        public void addPossibleTags(HtmlTag tag, Collection<HtmlTag> possible) {
            Collection children = tag.getChildren();
            possible.addAll(children);
            for (HtmlTag child : children) {
                if (!child.hasOptionalOpenTag()) continue;
                this.addPossibleTags(child, possible);
            }
        }

        private Collection<HtmlTag> completeEndTags(AstNode node) {
            LinkedHashSet<HtmlTag> possible = new LinkedHashSet<HtmlTag>();
            do {
                if (node.isVirtual()) continue;
                HtmlTag tag = HtmlTagProvider.getTagForElement(node.name());
                if (!tag.isEmpty()) {
                    possible.add(tag);
                }
                if (!tag.hasOptionalEndTag()) break;
            } while ((node = node.parent()) != null && !node.isRootNode());
            return possible;
        }
    }
}

