/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import nu.validator.htmlparser.common.TransitionHandler;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeFactory;
import org.netbeans.modules.html.parser.Util;
import org.xml.sax.SAXException;

public class AstNodeTreeBuilder
extends CoalescingTreeBuilder<AstNode>
implements TransitionHandler {
    static final Logger LOGGER = Logger.getLogger(AstNodeTreeBuilder.class.getName());
    static boolean LOG;
    static boolean LOG_FINER;
    private final AstNodeFactory factory;
    private AstNode root;
    private int offset;
    private int tag_lt_offset;
    private boolean self_closing_starttag;
    private Stack<AstNode> stack = new Stack();
    LinkedList<AstNode> physicalEndTagsQueue = new LinkedList();
    private ElementName startTag;
    private Stack<AttrInfo> attrs = new Stack();
    private AstNode currentTag;

    private static void initLogLevels() {
        LOG = LOGGER.isLoggable(Level.FINE);
        LOG_FINER = LOGGER.isLoggable(Level.FINER);
    }

    public AstNodeTreeBuilder(AstNode rootNode) {
        this.root = rootNode;
        this.factory = AstNodeFactory.instance();
    }

    public AstNode getRoot() {
        return this.root;
    }

    public AstNode getCurrentNode() {
        return this.stack.peek();
    }

    @Override
    protected void elementPopped(String namespace, String name, AstNode t) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("- %s %s; stack: %s", t, t.isVirtual() ? "[virtual]" : "", this.dumpStack()));
        }
        AstNode top = null;
        Stack<AstNode> removedFromStack = new Stack<AstNode>();
        while (!this.stack.isEmpty()) {
            top = this.stack.pop();
            removedFromStack.push(top);
            if (top != t) continue;
        }
        if (t != top) {
            LOGGER.info(String.format("The node %s has been popped but not previously pushed!", t));
            while (!removedFromStack.isEmpty()) {
                this.stack.push((AstNode)removedFromStack.pop());
            }
        }
        assert (!this.stack.isEmpty());
        AstNode match = null;
        for (AstNode n : this.physicalEndTagsQueue) {
            if (!n.name().equals(t.name())) continue;
            match = n;
            break;
        }
        if (match != null) {
            List toremove = this.physicalEndTagsQueue.subList(0, this.physicalEndTagsQueue.indexOf(match) + 1);
            if (toremove.size() > 1) {
                for (AstNode n : toremove.subList(0, toremove.size() - 1)) {
                    t.addChild(n);
                }
            }
            toremove.clear();
            if (!this.stack.isEmpty()) {
                this.stack.peek().addChild(match);
            }
            t.setMatchingNode(match);
            match.setMatchingNode(t);
            t.setLogicalEndOffset(match.endOffset());
        } else {
            AstNode latestEndTag = this.physicalEndTagsQueue.peek();
            if (latestEndTag != null) {
                t.setLogicalEndOffset(latestEndTag.startOffset());
            } else if (this.startTag != null) {
                t.setLogicalEndOffset(this.tag_lt_offset);
            } else {
                t.setLogicalEndOffset(this.offset);
            }
        }
        if (this.stack.size() == 1 && !this.physicalEndTagsQueue.isEmpty()) {
            if (LOG) {
                LOGGER.fine(String.format("LEFT in stack of end tags: %s", this.dumpEndTags()));
            }
            ListIterator leftEndTags = this.physicalEndTagsQueue.listIterator();
            while (leftEndTags.hasNext()) {
                AstNode left = (AstNode)leftEndTags.next();
                t.addChild(left);
                leftEndTags.remove();
            }
        }
        super.elementPopped(namespace, name, t);
    }

    @Override
    protected void elementPushed(String namespace, String name, AstNode t) throws SAXException {
        AstNode head;
        if (LOG) {
            LOGGER.fine(String.format("+ %s %s; stack: %s", t, t.isVirtual() ? "[virtual]" : "", this.dumpStack()));
        }
        this.stack.push(t);
        while ((head = this.physicalEndTagsQueue.poll()) != null) {
            this.stack.peek().addChild(head);
        }
        super.elementPushed(namespace, name, t);
    }

    private String dumpStack() {
        return this.collectionOfNodesToString(this.stack);
    }

    private String dumpEndTags() {
        return this.collectionOfNodesToString(this.physicalEndTagsQueue);
    }

    private String collectionOfNodesToString(Collection<AstNode> col) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (AstNode en : col) {
            b.append(en.name());
            b.append(", ");
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public void transition(int from, int to, boolean reconsume, int offset) throws SAXException {
        if (LOG_FINER) {
            LOGGER.finer(String.format("%s -> %s at %s", Util.TOKENIZER_STATE_NAMES[from], Util.TOKENIZER_STATE_NAMES[to], offset));
        }
        this.offset = offset;
        int tag_gt_offset = -1;
        switch (to) {
            case 9: {
                this.tag_lt_offset = offset;
                break;
            }
            case 39: {
                if (from != 66 && from != 60) break;
                this.tag_lt_offset = offset - 1;
                break;
            }
            case 3: {
                if (from != 16) break;
                tag_gt_offset = offset;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                switch (from) {
                    case 55: {
                        this.self_closing_starttag = true;
                    }
                    case 7: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 39: {
                        tag_gt_offset = offset + 1;
                    }
                }
                break;
            }
            case 13: {
                switch (from) {
                    case 12: {
                        AttrInfo ainfo = new AttrInfo();
                        this.attrs.push(ainfo);
                        ainfo.nameOffset = offset;
                    }
                }
                break;
            }
            case 15: {
                switch (from) {
                    case 13: {
                        this.attrs.peek().equalSignOffset = offset;
                    }
                }
                break;
            }
            case 5: {
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.DOUBLE;
                this.attrs.peek().valueOffset = offset;
                break;
            }
            case 6: {
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.SINGLE;
                this.attrs.peek().valueOffset = offset;
                break;
            }
            case 7: {
                this.attrs.peek().valueQuotationType = AttrInfo.ValueQuotation.NONE;
                this.attrs.peek().valueOffset = offset;
            }
        }
        if (tag_gt_offset != -1 && this.currentTag != null) {
            AstNode pair;
            this.currentTag.setEndOffset(tag_gt_offset);
            this.currentTag.setLogicalEndOffset(tag_gt_offset);
            if (this.currentTag.type() == AstNode.NodeType.ENDTAG && (pair = this.currentTag.getMatchingTag()) != null) {
                pair.setLogicalEndOffset(tag_gt_offset);
            }
            this.currentTag = null;
            tag_gt_offset = -1;
        }
    }

    @Override
    public void startTag(ElementName en, HtmlAttributes ha, boolean bln) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("open tag %s at %s", en.name, this.tag_lt_offset));
        }
        this.startTag = en;
        super.startTag(en, ha, bln);
        this.startTag = null;
    }

    @Override
    public void endTag(ElementName en) throws SAXException {
        if (LOG) {
            LOGGER.fine(String.format("close tag %s at %s", en.name, this.tag_lt_offset));
        }
        this.currentTag = this.factory.createEndTag(en.name, this.tag_lt_offset, -1);
        this.physicalEndTagsQueue.add(this.currentTag);
        if (LOG) {
            LOGGER.fine(String.format("end tags: %s", this.dumpEndTags()));
        }
        super.endTag(en);
    }

    private void resetIntenallPositions() {
        this.tag_lt_offset = -1;
        this.self_closing_starttag = false;
        this.attrs.clear();
    }

    @Override
    protected void appendCharacters(AstNode t, String string) throws SAXException {
    }

    @Override
    protected void appendComment(AstNode t, String string) throws SAXException {
    }

    @Override
    protected void appendCommentToDocument(String string) throws SAXException {
    }

    @Override
    protected void insertFosterParentedCharacters(String string, AstNode t, AstNode t1) throws SAXException {
    }

    @Override
    protected AstNode createElement(String namespace, String name, HtmlAttributes attributes) throws SAXException {
        AstNode node;
        if (LOG) {
            LOGGER.fine(String.format("createElement(%s)", name));
        }
        if (this.startTag != null && this.startTag.name.equals(name)) {
            this.currentTag = node = this.factory.createOpenTag(name, this.tag_lt_offset, -1, this.self_closing_starttag);
            this.addAttributesToElement(node, attributes);
            this.resetIntenallPositions();
        } else {
            node = this.factory.createOpenTag(name, -1, -1, false);
            this.addAttributesToElement(node, attributes);
        }
        return node;
    }

    @Override
    protected AstNode createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        if (LOG) {
            LOGGER.fine("createHtmlElementSetAsRoot()");
        }
        AstNode rootTag = this.createElement("http://www.w3.org/1999/xhtml", "html", attributes);
        this.stack.push(this.root);
        this.root.addChild(rootTag);
        return rootTag;
    }

    @Override
    protected void detachFromParent(AstNode node) throws SAXException {
        node.detachFromParent();
    }

    @Override
    protected boolean hasChildren(AstNode node) throws SAXException {
        return !node.children().isEmpty();
    }

    @Override
    protected void appendElement(AstNode child, AstNode parent) throws SAXException {
        parent.addChild(child);
    }

    @Override
    protected void appendChildrenToNewParent(AstNode from, AstNode to) throws SAXException {
        List children = from.children();
        from.removeChildren(children);
        to.addChildren(children);
    }

    @Override
    protected void insertFosterParentedChild(AstNode child, AstNode table, AstNode stackParent) throws SAXException {
        AstNode parent = table.parent();
        if (parent != null) {
            parent.insertBefore(child, table);
        } else {
            stackParent.addChild(child);
        }
    }

    @Override
    protected void addAttributesToElement(AstNode node, HtmlAttributes attributes) throws SAXException {
        int attrs_count = Math.min(attributes.getLength(), this.attrs.size());
        for (int i = 0; i < attrs_count; ++i) {
            AttrInfo attrInfo = (AttrInfo)this.attrs.elementAt(i);
            StringBuilder value = new StringBuilder();
            this.appendQuotation(value, attrInfo.valueQuotationType);
            value.append(attributes.getValue(i));
            this.appendQuotation(value, attrInfo.valueQuotationType);
            AstNode.Attribute attr = this.factory.createAttribute(attributes.getLocalName(i), value.toString(), attrInfo.nameOffset, attrInfo.valueOffset);
            node.setAttribute(attr);
        }
    }

    private void appendQuotation(StringBuilder builder, AttrInfo.ValueQuotation kind) {
        if (kind == null) {
            return;
        }
        switch (kind) {
            case DOUBLE: {
                builder.append('\"');
                break;
            }
            case SINGLE: {
                builder.append('\'');
            }
        }
    }

    static void setLoggerLevel(Level level) {
        LOGGER.setLevel(level);
        LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        AstNodeTreeBuilder.initLogLevels();
    }

    static {
        AstNodeTreeBuilder.initLogLevels();
    }

    private static class AttrInfo {
        public int nameOffset;
        public int equalSignOffset;
        public int valueOffset;
        public ValueQuotation valueQuotationType;

        private AttrInfo() {
        }

        private static enum ValueQuotation {
            NONE,
            SINGLE,
            DOUBLE;

        }
    }
}

