/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryImplementation;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibraryManager;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibrarySupport;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;

class JaxRsStackSupportImpl
implements JaxRsStackSupportImplementation {
    private static final String API = "api";
    private static final String JAX_RS = "jax-rs";
    private static final String JERSEY = "jersey";
    private static final String JSON = "json";
    private static final String JETTISON = "jettison";
    private static final String ROME = "rome";
    private final WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl;

    JaxRsStackSupportImpl(WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl) {
        this.platformImpl = platformImpl;
    }

    public boolean addJsr311Api(Project project) {
        WLServerLibrarySupport support = this.getLibrarySupport();
        Set<WLServerLibrarySupport.WLServerLibrary> libraries = support.getDeployedLibraries();
        for (WLServerLibrarySupport.WLServerLibrary library : libraries) {
            String title = library.getImplementationTitle();
            if (title == null || !title.toLowerCase(Locale.ENGLISH).contains(JAX_RS) || !title.toLowerCase(Locale.ENGLISH).contains(API)) continue;
            ServerLibrary apiLib = ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)library);
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            try {
                provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)apiLib.getName(), (Version)apiLib.getSpecificationVersion(), (Version)apiLib.getImplementationVersion()));
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean extendsJerseyProjectClasspath(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Collection<ServerLibrary> serverLibraries = this.getServerJerseyLibraries();
        if (provider != null && serverLibraries.size() > 0) {
            try {
                for (ServerLibrary serverLibrary : serverLibraries) {
                    provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)serverLibrary.getName(), (Version)serverLibrary.getSpecificationVersion(), (Version)serverLibrary.getImplementationVersion()));
                }
                Preferences prefs = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
                prefs.put(BrokenServerLibrarySupport.OFFER_LIBRARY_DEPLOYMENT, Boolean.TRUE.toString());
                return true;
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, "Exception during extending an web project", ex);
                return false;
            }
        }
        return false;
    }

    public void removeJaxRsLibraries(Project project) {
    }

    private Collection<ServerLibrary> getServerJerseyLibraries() {
        WLServerLibraryManager manager = this.getLibraryManager();
        LinkedList<ServerLibrary> libraries = new LinkedList<ServerLibrary>();
        libraries.addAll(this.findJerseyLibraries(manager.getDeployableLibraries()));
        libraries.addAll(this.findJerseyLibraries(manager.getDeployedLibraries()));
        return libraries;
    }

    private Collection<ServerLibrary> findJerseyLibraries(Collection<ServerLibrary> collection) {
        ArrayList<ServerLibrary> result = new ArrayList<ServerLibrary>(collection.size());
        for (ServerLibrary library : collection) {
            String title = library.getImplementationTitle();
            if (title == null || !(title = title.toLowerCase(Locale.ENGLISH)).contains(JERSEY) && !title.contains(JSON) && !title.contains(ROME) && !title.contains(JETTISON)) continue;
            result.add(library);
        }
        return result;
    }

    private WLServerLibraryManager getLibraryManager() {
        return new WLServerLibraryManager(this.platformImpl.getDeploymentManager());
    }

    private WLServerLibrarySupport getLibrarySupport() {
        return new WLServerLibrarySupport(this.platformImpl.getDeploymentManager());
    }
}

