/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WLIncrementalDeployment
extends IncrementalDeployment
implements IncrementalDeployment2 {
    private static final Logger LOGGER = Logger.getLogger(WLIncrementalDeployment.class.getName());
    private static RequestProcessor DEPLOYMENT_RP = new RequestProcessor("Weblogic Incremental Deployment", 5);
    private static final boolean FORBID_DIRECTORY_DEPLOYMENT = Boolean.getBoolean(WLIncrementalDeployment.class.getName() + ".forbidDirectoryDeployment");
    private static final int FAST_SWAP_TIMEOUT = 3000;
    private static final int FAST_SWAP_POLLING = 100;
    private final WLDeploymentManager dm;

    public WLIncrementalDeployment(WLDeploymentManager dm) {
        this.dm = dm;
    }

    public boolean canFileDeploy(Target target, J2eeModule deployable) {
        if (FORBID_DIRECTORY_DEPLOYMENT || this.dm.isRemote()) {
            return false;
        }
        return deployable != null && !J2eeModule.Type.CAR.equals(deployable.getType()) && !J2eeModule.Type.RAR.equals(deployable.getType());
    }

    public File getDirectoryForModule(TargetModuleID module) {
        return null;
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule app, ModuleConfiguration configuration) {
        return null;
    }

    public File getDirectoryForNewModule(File appDir, String uri, J2eeModule module, ModuleConfiguration configuration) {
        return null;
    }

    public ProgressObject incrementalDeploy(TargetModuleID module, AppChangeDescriptor changes) {
        boolean redeploy;
        boolean bl = redeploy = changes.classesChanged() || changes.descriptorChanged() || changes.ejbsChanged() || changes.manifestChanged() || changes.serverDescriptorChanged();
        if (changes instanceof DeploymentChangeDescriptor) {
            DeploymentChangeDescriptor deploymentChanges = (DeploymentChangeDescriptor)changes;
            boolean bl2 = redeploy = redeploy || deploymentChanges.serverResourcesChanged();
        }
        if (!redeploy) {
            WLProgressObject progress = new WLProgressObject(module);
            progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(WLIncrementalDeployment.class, (String)"MSG_Deployment_Completed")));
            return progress;
        }
        return this.dm.redeploy(new TargetModuleID[]{module});
    }

    public ProgressObject initialDeploy(Target target, J2eeModule app, ModuleConfiguration configuration, File dir) {
        String name = dir.getName();
        try {
            Project project;
            FileObject content = app.getContentDirectory();
            if (content != null && (project = FileOwnerQuery.getOwner((FileObject)content)) != null) {
                name = ProjectUtils.getInformation((Project)project).getName();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        CommandBasedDeployer deployer = new CommandBasedDeployer(this.dm);
        return deployer.directoryDeploy(target, name, dir, this.dm.getHost(), this.dm.getPort(), app.getType());
    }

    public ProgressObject incrementalDeploy(TargetModuleID module, DeploymentContext context) {
        this.dm.deployOptionalPackages(context.getRequiredLibraries());
        return this.incrementalDeploy(module, context.getChanges());
    }

    public ProgressObject initialDeploy(Target target, DeploymentContext context) {
        this.dm.deployOptionalPackages(context.getRequiredLibraries());
        return this.initialDeploy(target, context.getModule(), null, context.getModuleFile());
    }

    public boolean isDeployOnSaveSupported() {
        return true;
    }

    public ProgressObject deployOnSave(final TargetModuleID module, final DeploymentChangeDescriptor desc) {
        if (!(!desc.classesChanged() || desc.descriptorChanged() || desc.ejbsChanged() || desc.manifestChanged() || desc.serverDescriptorChanged() || desc.serverResourcesChanged())) {
            final BridgingProgressObject progress = new BridgingProgressObject(module);
            progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Started")));
            DEPLOYMENT_RP.submit(new Runnable(){

                @Override
                public void run() {
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeploying", (Object)module.getModuleID())));
                    if (WLIncrementalDeployment.this.deployFastSwap(module)) {
                        LOGGER.log(Level.FINE, "Fast swap sucessfull");
                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.REDEPLOY, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Completed")));
                        return;
                    }
                    LOGGER.log(Level.FINE, "Fast swap failed doing incremental deploy");
                    progress.startListening(module, WLIncrementalDeployment.this.incrementalDeploy(module, (AppChangeDescriptor)desc));
                }
            });
            return progress;
        }
        return this.incrementalDeploy(module, (AppChangeDescriptor)desc);
    }

    public String getModuleUrl(TargetModuleID module) {
        assert (module != null);
        if (module.getWebURL() == null) {
            String url = module.getModuleID();
            return url.startsWith("/") ? url : "/" + url;
        }
        final String id = module.getModuleID();
        WLConnectionSupport support = new WLConnectionSupport(this.dm);
        String url = null;
        try {
            url = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<String>(){

                @Override
                public String call(MBeanServerConnection con, ObjectName service) throws Exception {
                    ObjectName pattern = new ObjectName("com.bea:Type=WebAppComponentRuntime,*");
                    Set<ObjectName> runtimes = con.queryNames(pattern, null);
                    for (ObjectName runtime : runtimes) {
                        String moduleId = (String)con.getAttribute(runtime, "ModuleId");
                        if (!id.equals(moduleId)) continue;
                        return (String)con.getAttribute(runtime, "ModuleURI");
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (url != null) {
            return url.startsWith("/") ? url : "/" + url;
        }
        return id.startsWith("/") ? id : "/" + id;
    }

    private boolean deployFastSwap(TargetModuleID module) {
        final String server = module.getTarget().getName();
        final String application = module.getModuleID();
        WLConnectionSupport support = new WLConnectionSupport(this.dm);
        try {
            Boolean ret = support.executeAction(new WLConnectionSupport.JMXAction<Boolean>(){

                @Override
                public Boolean call(MBeanServerConnection connection) throws Exception {
                    ObjectName appRuntime = new ObjectName("com.bea:ServerRuntime=" + server + ",Name=" + application + ",Type=ApplicationRuntime");
                    ObjectName redefinitionRuntime = (ObjectName)connection.getAttribute(appRuntime, "ClassRedefinitionRuntime");
                    if (redefinitionRuntime == null) {
                        return false;
                    }
                    ObjectName redef = (ObjectName)connection.invoke(redefinitionRuntime, "redefineClasses", new Object[]{null, null}, new String[]{String.class.getName(), String[].class.getName()});
                    long start = System.currentTimeMillis();
                    String str = (String)connection.getAttribute(redef, "Status");
                    while (System.currentTimeMillis() - start < 3000L && WLIncrementalDeployment.isRunning(str)) {
                        Thread.sleep(100L);
                        str = (String)connection.getAttribute(redef, "Status");
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        Integer candidates = (Integer)connection.getAttribute(redef, "CandidateClassesCount");
                        Integer processed = (Integer)connection.getAttribute(redef, "ProcessedClassesCount");
                        LOGGER.log(Level.FINE, "Processed {0} from {1} candidate classes", new Object[]{processed, candidates});
                    }
                    if (WLIncrementalDeployment.isRunning(str)) {
                        connection.invoke(redef, "cancel", new Object[0], new String[0]);
                        return false;
                    }
                    if (!"FINISHED".equals(str)) {
                        return false;
                    }
                    return true;
                }

                @Override
                public String getPath() {
                    return "/jndi/weblogic.management.mbeanservers.runtime";
                }
            });
            return ret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }

    private static boolean isRunning(String status) {
        return "RUNNING".equals(status) || "SCHEDULED".equals(status);
    }

    private static class BridgingProgressObject
    extends WLProgressObject
    implements ProgressListener {
        public BridgingProgressObject(TargetModuleID ... moduleIds) {
            super(moduleIds);
        }

        public void startListening(TargetModuleID moduleID, ProgressObject po) {
            po.addProgressListener((ProgressListener)this);
            if (!po.getDeploymentStatus().isRunning()) {
                po.removeProgressListener((ProgressListener)this);
            }
            this.fireProgressEvent(moduleID, po.getDeploymentStatus());
        }

        public void handleProgressEvent(ProgressEvent pe) {
            if (!this.getDeploymentStatus().isRunning() && pe.getDeploymentStatus().isRunning()) {
                return;
            }
            this.fireProgressEvent(pe.getTargetModuleID(), pe.getDeploymentStatus());
        }
    }
}

