/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentDescriptorConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ServerLibraryConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.ConfigurationModifier;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WebApplicationModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
extends WLDeploymentConfiguration
implements ServerLibraryConfiguration,
ModuleConfiguration,
ContextRootConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener,
DeploymentDescriptorConfiguration {
    private static final Logger LOGGER = Logger.getLogger(WarDeploymentConfiguration.class.getName());
    private final ChangeSupport serverLibraryChangeSupport = new ChangeSupport((Object)this);
    private final ConfigurationModifier<WebApplicationModel> modifier = new ConfigurationModifier();
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private final FileChangeListener weblogicXmlListener = new WeblogicXmlListener();
    private final Version serverVersion;
    private WebApplicationModel webLogicWebApp;
    private Set<ServerLibraryDependency> originalDeps;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null);
    }

    public WarDeploymentConfiguration(J2eeModule j2eeModule, Version serverVersion) {
        super(j2eeModule, serverVersion);
        this.j2eeModule = j2eeModule;
        this.serverVersion = serverVersion;
        this.file = j2eeModule.getDeploymentConfigurationFile("WEB-INF/weblogic.xml");
        FileUtil.addFileChangeListener((FileChangeListener)this.weblogicXmlListener, (File)this.file);
        this.getWeblogicWebApp();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public boolean isDescriptorRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.webLogicWebApp = null;
            }
        }
    }

    public final synchronized WebApplicationModel getWeblogicWebApp() {
        if (this.webLogicWebApp == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.webLogicWebApp = WebApplicationModel.forFile(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {
                        LOGGER.log(Level.INFO, null, re);
                    }
                } else {
                    this.webLogicWebApp = this.generateWeblogicWebApp();
                    this.webLogicWebApp.write(this.file);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.webLogicWebApp;
    }

    public void save(OutputStream os) throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            webLogicWebApp.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private WebApplicationModel generateWeblogicWebApp() {
        WebApplicationModel webApp = WebApplicationModel.generate(this.serverVersion);
        webApp.setContextRoot("");
        webApp.setKeepJspGenerated(true);
        webApp.setDebug(true);
        webApp.setFastSwap(true);
        return webApp;
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    public String getContextRoot() throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getContextRoot();
    }

    public void setContextRoot(String contextRoot) throws ConfigurationException {
        if (!this.isCorrectCP(contextRoot)) {
            String ctxRoot = contextRoot;
            StringTokenizer tok = new StringTokenizer(contextRoot, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)contextRoot), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextRoot = ctxRoot;
        }
        final String newContextPath = contextRoot;
        this.modifier.modify(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.setContextRoot(newContextPath);
            }
        }, this.dataObject, this.file);
    }

    @Override
    public void bindDatasourceReference(final String referenceName, final String jndiName) throws ConfigurationException {
        if (referenceName == null || referenceName.length() == 0 || jndiName == null || jndiName.length() == 0) {
            return;
        }
        this.modifier.modify(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.setReference(referenceName, jndiName);
            }
        }, this.dataObject, this.file);
    }

    @Override
    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadReferenceName", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getReferenceJndiName(referenceName);
    }

    @Override
    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
    }

    public void configureLibrary(final @NonNull ServerLibraryDependency library) throws ConfigurationException {
        assert (library != null);
        this.modifier.modify(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.addLibrary(library);
            }
        }, this.dataObject, this.file);
    }

    public Set<ServerLibraryDependency> getLibraries() throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadServerLibraries", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getLibraries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibraryChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        boolean load = false;
        WarDeploymentConfiguration warDeploymentConfiguration = this;
        synchronized (warDeploymentConfiguration) {
            load = this.originalDeps == null;
        }
        if (load) {
            Set<Object> deps = null;
            try {
                deps = this.getLibraries();
            }
            catch (ConfigurationException ex) {
                deps = Collections.emptySet();
            }
            WarDeploymentConfiguration warDeploymentConfiguration2 = this;
            synchronized (warDeploymentConfiguration2) {
                if (this.originalDeps == null) {
                    this.originalDeps = deps;
                }
            }
        }
        this.serverLibraryChangeSupport.addChangeListener(listener);
    }

    public void removeLibraryChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.serverLibraryChangeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        HashSet<ServerLibraryDependency> oldDeps = null;
        WarDeploymentConfiguration warDeploymentConfiguration = this;
        synchronized (warDeploymentConfiguration) {
            if (this.originalDeps == null) {
                return;
            }
            oldDeps = new HashSet<ServerLibraryDependency>(this.originalDeps);
        }
        HashSet<ServerLibraryDependency> deps = new HashSet<ServerLibraryDependency>();
        try {
            deps.addAll(this.getLibraries());
        }
        catch (ConfigurationException ex) {
            // empty catch block
        }
        boolean fire = false;
        for (ServerLibraryDependency old : oldDeps) {
            if (deps.remove(old)) continue;
            fire = true;
            break;
        }
        if (!deps.isEmpty()) {
            fire = true;
        }
        if (fire) {
            this.serverLibraryChangeSupport.fireChange();
        }
    }

    private abstract class WeblogicWebAppModifier
    implements ConfigurationModifier.DescriptorModifier<WebApplicationModel> {
        private WeblogicWebAppModifier() {
        }

        @Override
        public WebApplicationModel load() {
            return WarDeploymentConfiguration.this.getWeblogicWebApp();
        }

        @Override
        public WebApplicationModel load(byte[] source) throws IOException {
            return WebApplicationModel.forInputStream(new ByteArrayInputStream(source));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save(WebApplicationModel context) {
            WarDeploymentConfiguration warDeploymentConfiguration = WarDeploymentConfiguration.this;
            synchronized (warDeploymentConfiguration) {
                WarDeploymentConfiguration.this.webLogicWebApp = context;
            }
        }
    }

    private class WeblogicXmlListener
    implements FileChangeListener {
        private WeblogicXmlListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

