/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificSecurity;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AdvancedRMPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AdvancedSecurityPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KerberosConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.STSConfigServicePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ValidatorsPanel;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AddressingModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BindingPanel
extends SectionInnerPanel {
    private WSDLModel model;
    private Node node;
    private Binding binding;
    private UndoManager undoManager;
    private Project project;
    private Service service;
    private JaxWsModel jaxwsmodel;
    private WsitProvider wsitProvider;
    private String oldProfile;
    private boolean doNotSync = false;
    private boolean inSync = false;
    private boolean isFromJava = true;
    private boolean jsr109 = false;
    private final Color RED = new Color(255, 0, 0);
    private final Color REGULAR;
    private boolean updateServiceUrl = true;
    private SortedSet<ConfigVersion> supportedConfigVersions = new TreeSet<ConfigVersion>();
    private JCheckBox addrChBox;
    private JComboBox cfgVersionCombo;
    private JLabel cfgVersionLabel;
    private JCheckBox devDefaultsChBox;
    private JCheckBox fiChBox;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JButton kerberosCfgButton;
    private JButton keyButton;
    private JCheckBox mtomChBox;
    private JCheckBox orderedChBox;
    private JButton profConfigButton;
    private JComboBox profileCombo;
    private JLabel profileComboLabel;
    private JTextArea profileInfoField;
    private JButton rmAdvanced;
    private JCheckBox rmChBox;
    private JButton secAdvancedButton;
    private JCheckBox securityChBox;
    private JCheckBox stsChBox;
    private JButton stsConfigButton;
    private JCheckBox tcpChBox;
    private JButton trustButton;
    private JButton validatorsButton;

    public BindingPanel(SectionView sectionView, Node node, Project project, Binding binding, UndoManager undoManager, JaxWsModel jaxWsModel) {
        super(sectionView);
        ConfigVersion configVersion2;
        this.model = binding.getModel();
        this.project = project;
        this.node = node;
        this.undoManager = undoManager;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.wsitProvider = (WsitProvider)this.project.getLookup().lookup(WsitProvider.class);
        if (this.wsitProvider != null) {
            this.jsr109 = this.wsitProvider.isJsr109Project();
        }
        this.initComponents();
        this.REGULAR = this.profileInfoField.getForeground();
        if (node != null) {
            this.service = (Service)node.getLookup().lookup(Service.class);
            this.isFromJava = !WSITModelSupport.isServiceFromWsdl(node);
        } else {
            this.isFromJava = false;
        }
        this.mtomChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.orderedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.securityChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileComboLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileInfoField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileInfoField.setFont(this.mtomChBox.getFont());
        this.stsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.tcpChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.fiChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.devDefaultsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator1.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator2.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator3.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator4.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cfgVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cfgVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addrChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        WSStackVersion wSStackVersion = WSITConfigProvider.getDefault().getHighestWSStackVersion(this.project);
        this.inSync = true;
        for (ConfigVersion configVersion2 : ConfigVersion.values()) {
            if (wSStackVersion == null || !configVersion2.isSupported(wSStackVersion) || !configVersion2.isVisible()) continue;
            this.supportedConfigVersions.add(configVersion2);
            this.cfgVersionCombo.addItem(configVersion2);
        }
        if (this.supportedConfigVersions.isEmpty()) {
            this.supportedConfigVersions.add(ConfigVersion.CONFIG_1_0);
            this.cfgVersionCombo.addItem(ConfigVersion.CONFIG_1_0);
        }
        this.inSync = false;
        String string = NbBundle.getMessage(BindingPanel.class, (String)"LBL_Convert");
        String string2 = NbBundle.getMessage(BindingPanel.class, (String)"LBL_LeaveIntact");
        Object[] objectArray = new String[]{string, string2};
        configVersion2 = PolicyModelHelper.getWrittenConfigVersion((WSDLComponent)binding);
        if (configVersion2 != null && !this.supportedConfigVersions.contains(configVersion2)) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(BindingPanel.class, (String)"TXT_UnsupportedProfileDetected"), new NotifyDescriptor.Confirmation((Object)"test").getTitle(), -1, 3, objectArray, (Object)string2);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (string.equals(notifyDescriptor.getValue())) {
                PolicyModelHelper.setConfigVersion(binding, (ConfigVersion)this.supportedConfigVersions.toArray()[this.supportedConfigVersions.size() - 1], this.project);
            } else if (string2.equals(notifyDescriptor.getValue())) {
                this.cfgVersionCombo.addItem(configVersion2);
                this.supportedConfigVersions.add(configVersion2);
                this.enableDisable();
            } else {
                this.setVisible(false);
            }
        } else if (configVersion2 == null) {
            if (this.supportedConfigVersions != null && this.supportedConfigVersions.size() > 0) {
                PolicyModelHelper.setConfigVersion(binding, (ConfigVersion)this.supportedConfigVersions.toArray()[this.supportedConfigVersions.size() - 1], this.project);
            } else {
                ConfigVersion configVersion3 = ConfigVersion.CONFIG_1_0;
                PolicyModelHelper.setConfigVersion(binding, configVersion3, this.project);
                this.supportedConfigVersions.add(configVersion3);
                this.cfgVersionCombo.addItem(configVersion3);
            }
        }
        this.addImmediateModifier(this.cfgVersionCombo);
        this.addImmediateModifier(this.mtomChBox);
        this.addImmediateModifier(this.rmChBox);
        this.addImmediateModifier(this.orderedChBox);
        this.addImmediateModifier(this.securityChBox);
        this.addImmediateModifier(this.profileCombo);
        this.addImmediateModifier(this.stsChBox);
        this.addImmediateModifier(this.tcpChBox);
        this.addImmediateModifier(this.fiChBox);
        this.addImmediateModifier(this.devDefaultsChBox);
        this.addImmediateModifier(this.addrChBox);
        this.sync();
        if (!this.isFromJava && PolicyModelHelper.getPolicyUriForElement((WSDLComponent)binding) == null && ProfilesModelHelper.isServiceUrlHttps(binding)) {
            this.updateServiceUrl = false;
        }
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent componentEvent) {
                if (!BindingPanel.this.doNotSync) {
                    BindingPanel.this.sync();
                }
            }

            public void childrenAdded(ComponentEvent componentEvent) {
                if (!BindingPanel.this.doNotSync) {
                    BindingPanel.this.sync();
                }
            }

            public void childrenDeleted(ComponentEvent componentEvent) {
                if (!BindingPanel.this.doNotSync) {
                    BindingPanel.this.sync();
                }
            }
        });
    }

    private void fillProfileCombo(boolean bl) {
        this.profileCombo.removeAllItems();
        Set<SecurityProfile> set = SecurityProfileRegistry.getDefault().getSecurityProfiles();
        for (SecurityProfile securityProfile : set) {
            if (!securityProfile.isProfileSupported(this.project, (WSDLComponent)this.binding, bl)) continue;
            this.profileCombo.addItem(securityProfile.getDisplayName());
        }
    }

    private ConfigVersion getUserExpectedConfigVersion() {
        return (ConfigVersion)this.cfgVersionCombo.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        this.inSync = true;
        this.doNotSync = true;
        try {
            ConfigVersion configVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding);
            this.cfgVersionCombo.setSelectedItem(configVersion);
            boolean bl = AddressingModelHelper.isAddressingEnabled(this.binding);
            this.setChBox(this.addrChBox, bl);
            boolean bl2 = TransportModelHelper.isMtomEnabled(this.binding);
            this.setChBox(this.mtomChBox, bl2);
            boolean bl3 = TransportModelHelper.isFIEnabled(this.binding);
            this.setChBox(this.fiChBox, !bl3);
            boolean bl4 = TransportModelHelper.isTCPEnabled(this.binding);
            this.setChBox(this.tcpChBox, bl4);
            boolean bl5 = RMModelHelper.getInstance(configVersion).isRMEnabled((WSDLComponent)this.binding);
            this.setChBox(this.rmChBox, bl5);
            this.setChBox(this.orderedChBox, RMModelHelper.getInstance(configVersion).isOrderedEnabled(this.binding));
            boolean bl6 = ProprietarySecurityPolicyModelHelper.isSTSEnabled(this.binding);
            this.setChBox(this.stsChBox, bl6);
            this.fillProfileCombo(bl6);
            boolean bl7 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
            this.setChBox(this.securityChBox, bl7);
            if (bl7) {
                String string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
                this.setSecurityProfile(string);
                boolean bl8 = ProfilesModelHelper.isServiceDefaultSetupUsed(string, this.binding, this.project);
                this.setChBox(this.devDefaultsChBox, bl8);
                this.oldProfile = string;
            } else {
                this.setSecurityProfile(ComboConstants.PROF_USERNAME);
                this.setChBox(this.devDefaultsChBox, true);
            }
            this.enableDisable();
        }
        finally {
            this.inSync = false;
            this.doNotSync = false;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        Object object2;
        String string;
        boolean bl;
        if (this.inSync) {
            return;
        }
        Util.checkMetroLibrary(this.project);
        ConfigVersion configVersion = this.getUserExpectedConfigVersion();
        if (jComponent.equals(this.cfgVersionCombo)) {
            this.doNotSync = true;
            try {
                PolicyModelHelper.setConfigVersion(this.binding, configVersion, this.project);
                try {
                    this.inSync = true;
                    this.fillProfileCombo(this.stsChBox.isSelected());
                }
                finally {
                    this.inSync = false;
                }
            }
            finally {
                this.doNotSync = false;
            }
            this.sync();
        }
        RMModelHelper rMModelHelper = RMModelHelper.getInstance(configVersion);
        if (jComponent.equals(this.rmChBox)) {
            bl = rMModelHelper.isRMEnabled((WSDLComponent)this.binding);
            if (this.rmChBox.isSelected() != bl) {
                rMModelHelper.enableRM(this.binding, this.rmChBox.isSelected());
                if (this.securityChBox.isSelected()) {
                    if (!ProfilesModelHelper.isSCEnabled((WSDLComponent)this.binding)) {
                        ProfilesModelHelper.getInstance(configVersion).setSecureConversation((WSDLComponent)this.binding, true);
                    }
                    if (!ConfigVersion.CONFIG_1_0.equals((Object)configVersion) && this.rmChBox.isSelected()) {
                        string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
                        if (ProfilesModelHelper.isSSLProfile(string)) {
                            RMSequenceBinding.SECURED_TRANSPORT.set(configVersion, this.binding);
                        } else {
                            RMSequenceBinding.SECURED_TOKEN.set(configVersion, this.binding);
                        }
                    }
                }
            }
        }
        if (jComponent.equals(this.orderedChBox)) {
            bl = rMModelHelper.isOrderedEnabled(this.binding);
            if (this.orderedChBox.isSelected() != bl) {
                rMModelHelper.enableOrdered(this.binding, this.orderedChBox.isSelected());
            }
        }
        if (jComponent.equals(this.mtomChBox)) {
            bl = TransportModelHelper.isMtomEnabled(this.binding);
            if (this.mtomChBox.isSelected() != bl) {
                TransportModelHelper.enableMtom(this.binding, this.mtomChBox.isSelected());
            }
        }
        if (jComponent.equals(this.fiChBox)) {
            bl = TransportModelHelper.isFIEnabled(this.binding);
            if (!this.fiChBox.isSelected() != bl) {
                TransportModelHelper.enableFI(this.binding, !this.fiChBox.isSelected());
            }
        }
        if (jComponent.equals(this.tcpChBox)) {
            bl = TransportModelHelper.isTCPEnabled(this.binding);
            if (this.tcpChBox.isSelected() != bl) {
                string = null;
                object2 = null;
                String string2 = null;
                if (this.service != null) {
                    string = this.service.getName();
                    object2 = this.service.getServiceName();
                    string2 = this.service.getImplementationClass();
                }
                TransportModelHelper.enableTCP(string, (String)object2, string2, this.isFromJava, this.binding, this.project, this.tcpChBox.isSelected());
            }
        }
        if (jComponent.equals(this.addrChBox)) {
            bl = AddressingModelHelper.isAddressingEnabled(this.binding);
            if (this.addrChBox.isSelected() != bl) {
                if (this.addrChBox.isSelected()) {
                    AddressingModelHelper.getInstance(this.getUserExpectedConfigVersion()).enableAddressing((WSDLComponent)this.binding, true);
                } else {
                    AddressingModelHelper.disableAddressing(this.binding);
                }
            }
        }
        ProjectSpecificSecurity projectSpecificSecurity = null;
        if (this.wsitProvider != null) {
            projectSpecificSecurity = this.wsitProvider.getProjectSecurityUpdater();
        }
        if (jComponent.equals(this.securityChBox)) {
            string = (String)this.profileCombo.getSelectedItem();
            if (this.securityChBox.isSelected()) {
                Util.checkMetroRtLibrary(this.project, true);
                this.profileCombo.setSelectedItem(string);
                if (this.devDefaultsChBox.isSelected()) {
                    DefaultSettings.fillDefaults(this.project, false, true);
                    ProfilesModelHelper.setServiceDefaults((String)this.profileCombo.getSelectedItem(), this.binding, this.project);
                    if (ProfilesModelHelper.isSSLProfile(string) && projectSpecificSecurity != null) {
                        projectSpecificSecurity.setSSLAttributes((WSDLComponent)this.binding);
                    }
                }
            } else {
                if (this.devDefaultsChBox.isSelected() && ProfilesModelHelper.isSSLProfile(string) && projectSpecificSecurity != null) {
                    projectSpecificSecurity.unsetSSLAttributes((WSDLComponent)this.binding);
                }
                DefaultSettings.unfillDefaults(this.project);
                object2 = SecurityPolicyModelHelper.getInstance(this.getUserExpectedConfigVersion());
                ((SecurityPolicyModelHelper)object2).disableSecurity((WSDLComponent)this.binding, true);
            }
            this.oldProfile = string;
        }
        if (jComponent.equals(this.devDefaultsChBox)) {
            if (this.devDefaultsChBox.isSelected()) {
                DefaultSettings.fillDefaults(this.project, false, true);
                ProfilesModelHelper.setServiceDefaults((String)this.profileCombo.getSelectedItem(), this.binding, this.project);
            } else {
                DefaultSettings.unfillDefaults(this.project);
            }
        }
        if (jComponent.equals(this.stsChBox) && this.stsChBox.isSelected() != ProprietarySecurityPolicyModelHelper.isSTSEnabled(this.binding)) {
            ProprietarySecurityPolicyModelHelper.getInstance(this.getUserExpectedConfigVersion()).enableSTS(this.binding, this.stsChBox.isSelected());
            this.inSync = true;
            this.fillProfileCombo(true);
            this.inSync = false;
        }
        if (jComponent.equals(this.profileCombo)) {
            this.doNotSync = true;
            try {
                string = (String)this.profileCombo.getSelectedItem();
                ProfilesModelHelper.getInstance(this.getUserExpectedConfigVersion()).setSecurityProfile((WSDLComponent)this.binding, string, this.oldProfile, this.updateServiceUrl);
                if (this.devDefaultsChBox.isSelected()) {
                    ProfilesModelHelper.setServiceDefaults(string, this.binding, this.project);
                    if (ProfilesModelHelper.isSSLProfile(string) && !ProfilesModelHelper.isSSLProfile(this.oldProfile) && projectSpecificSecurity != null) {
                        projectSpecificSecurity.setSSLAttributes((WSDLComponent)this.binding);
                    }
                    if (!ProfilesModelHelper.isSSLProfile(string) && ProfilesModelHelper.isSSLProfile(this.oldProfile) && projectSpecificSecurity != null) {
                        projectSpecificSecurity.unsetSSLAttributes((WSDLComponent)this.binding);
                    }
                }
                boolean bl2 = ProfilesModelHelper.isServiceDefaultSetupUsed(string, this.binding, this.project);
                this.inSync = true;
                this.devDefaultsChBox.setSelected(bl2);
                this.inSync = false;
                this.profileInfoField.setText(SecurityProfileRegistry.getDefault().getProfile(string).getDescription());
                this.oldProfile = string;
            }
            finally {
                this.doNotSync = false;
            }
        }
        this.enableDisable();
    }

    public Boolean getChBox(JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void setSecurityProfile(String string) {
        this.profileCombo.setSelectedItem(string);
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (!ComboConstants.PROF_NOTRECOGNIZED.equals(string)) {
            this.profileInfoField.setText(securityProfile.getDescription());
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        SectionView sectionView = this.getSectionView();
        this.enableDisable();
        if (sectionView != null) {
            sectionView.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    private void enableDisable() {
        this.cfgVersionCombo.setEnabled(this.cfgVersionCombo.getItemCount() > 1);
        this.cfgVersionLabel.setEnabled(this.cfgVersionCombo.getItemCount() > 1);
        boolean bl = this.rmChBox.isSelected();
        this.orderedChBox.setEnabled(bl);
        this.rmAdvanced.setEnabled(bl);
        this.tcpChBox.setEnabled(true);
        boolean bl2 = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        if (!bl2) {
            boolean bl3 = ServerUtils.isGlassfish(this.project);
            this.securityChBox.setEnabled(true);
            this.profileInfoField.setForeground(this.REGULAR);
            boolean bl4 = this.securityChBox.isSelected();
            this.profileComboLabel.setEnabled(bl4);
            this.profileCombo.setEnabled(bl4);
            this.profileInfoField.setEnabled(bl4);
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = false;
            boolean bl8 = true;
            boolean bl9 = this.devDefaultsChBox.isSelected();
            this.profConfigButton.setEnabled(bl4);
            boolean bl10 = false;
            boolean bl11 = false;
            if (bl4) {
                String string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
                bl10 = ProfilesModelHelper.isValidatorsSupported(string);
                bl11 = ProfilesModelHelper.isAdvancedSecuritySupported(string);
                boolean bl12 = ProfilesModelHelper.isServiceDefaultSetupSupported(string);
                if (!bl12) {
                    bl9 = false;
                }
                this.devDefaultsChBox.setEnabled(bl12);
                boolean bl13 = ProfilesModelHelper.isSSLProfile(string);
                if (bl13) {
                    bl5 = false;
                }
                bl6 = ProfilesModelHelper.isTruststoreRequired(string, (WSDLComponent)this.binding, false);
                if (ComboConstants.PROF_KERBEROS.equals(string)) {
                    bl5 = false;
                    bl6 = false;
                    bl7 = true;
                }
                if (bl8 && (ComboConstants.PROF_SAMLHOLDER.equals(string) || ComboConstants.PROF_SAMLSENDER.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string))) {
                    bl8 = false;
                }
                if (bl6 && bl3 && ComboConstants.PROF_USERNAME.equals(string)) {
                    bl6 = false;
                }
            } else {
                this.devDefaultsChBox.setEnabled(false);
            }
            this.secAdvancedButton.setEnabled(bl4 && !bl9 && bl11);
            this.stsChBox.setEnabled(bl4 && !this.isFromJava && bl8);
            boolean bl14 = this.stsChBox.isSelected();
            this.stsConfigButton.setEnabled(bl14);
            if (bl14) {
                bl6 = true;
                bl5 = true;
                bl10 = true;
            }
            this.validatorsButton.setEnabled(bl4 && (!ConfigVersion.CONFIG_1_0.equals((Object)this.getUserExpectedConfigVersion()) || !bl3) && !bl9 && bl10);
            this.keyButton.setEnabled(bl4 && bl5 && !bl9);
            this.trustButton.setEnabled(bl4 && bl6 && !bl9);
            this.kerberosCfgButton.setEnabled(bl4 && bl7 && !bl9);
            this.addrChBox.setEnabled(!bl && !bl4);
        } else {
            this.profileComboLabel.setEnabled(false);
            this.profileCombo.setEnabled(false);
            this.profileInfoField.setEnabled(false);
            this.profConfigButton.setEnabled(false);
            this.stsChBox.setEnabled(false);
            this.devDefaultsChBox.setEnabled(false);
            this.stsConfigButton.setEnabled(false);
            this.securityChBox.setEnabled(false);
            this.validatorsButton.setEnabled(false);
            this.secAdvancedButton.setEnabled(false);
            this.keyButton.setEnabled(false);
            this.trustButton.setEnabled(false);
            this.profileInfoField.setEnabled(true);
            this.profileInfoField.setForeground(this.RED);
            this.profileInfoField.setText(NbBundle.getMessage(BindingPanel.class, (String)"TXT_AMSecSelected"));
            this.addrChBox.setEnabled(false);
            this.cfgVersionLabel.setEnabled(false);
            this.cfgVersionCombo.setEnabled(false);
        }
    }

    private void initComponents() {
        this.mtomChBox = new JCheckBox();
        this.rmChBox = new JCheckBox();
        this.securityChBox = new JCheckBox();
        this.orderedChBox = new JCheckBox();
        this.profileComboLabel = new JLabel();
        this.profileCombo = new JComboBox();
        this.rmAdvanced = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.stsChBox = new JCheckBox();
        this.tcpChBox = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.keyButton = new JButton();
        this.trustButton = new JButton();
        this.stsConfigButton = new JButton();
        this.profConfigButton = new JButton();
        this.fiChBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.profileInfoField = new JTextArea();
        this.validatorsButton = new JButton();
        this.devDefaultsChBox = new JCheckBox();
        this.secAdvancedButton = new JButton();
        this.kerberosCfgButton = new JButton();
        this.cfgVersionLabel = new JLabel();
        this.cfgVersionCombo = new JComboBox();
        this.jSeparator4 = new JSeparator();
        this.addrChBox = new JCheckBox();
        this.jSeparator5 = new JSeparator();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BindingPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                BindingPanel.this.formAncestorAdded(ancestorEvent);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mtomChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_mtomChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.rmChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_rmChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.securityChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_securityChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.orderedChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_OrderedChBox"));
        this.profileComboLabel.setLabelFor(this.profileCombo);
        Mnemonics.setLocalizedText((JLabel)this.profileComboLabel, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_profileComboLabel"));
        this.profileCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SAML Sender Vouches With Certificates", "Anonymous with Bilateral Certificates"}));
        Mnemonics.setLocalizedText((AbstractButton)this.rmAdvanced, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Advanced"));
        this.rmAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.rmAdvancedActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.stsChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.tcpChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_tcpChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.keyButton, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_keystoreButton"));
        this.keyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.keyButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.trustButton, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_truststoreButton"));
        this.trustButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.trustButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.stsConfigButton, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsConfigButton"));
        this.stsConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.stsConfigButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.profConfigButton, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_keyConfigButton"));
        this.profConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.profConfigButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.fiChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_fiChBox"));
        this.profileInfoField.setEditable(false);
        this.profileInfoField.setLineWrap(true);
        this.profileInfoField.setText("This is a text This is a text This is a text This is a text This is a text This is a text This is");
        this.profileInfoField.setWrapStyleWord(true);
        this.profileInfoField.setAutoscrolls(false);
        this.profileInfoField.setOpaque(false);
        this.jScrollPane1.setViewportView(this.profileInfoField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/wsitconf/ui/service/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.validatorsButton, (String)resourceBundle.getString("LBL_validatorsButton"));
        this.validatorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.validatorsButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.devDefaultsChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Defaults"));
        Mnemonics.setLocalizedText((AbstractButton)this.secAdvancedButton, (String)resourceBundle.getString("LBL_Section_Service_Advanced"));
        this.secAdvancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.secAdvancedButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.kerberosCfgButton, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_kerberosCfgButton"));
        this.kerberosCfgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BindingPanel.this.kerberosCfgButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.cfgVersionLabel, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_versionChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.addrChBox, (String)NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_addrChBox"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addrChBox).addComponent(this.jSeparator4, -1, 536, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.cfgVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cfgVersionCombo, 0, 366, Short.MAX_VALUE)).addComponent(this.jSeparator1, -1, 536, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 536, Short.MAX_VALUE).addComponent(this.mtomChBox).addComponent(this.rmChBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rmAdvanced).addComponent(this.orderedChBox)).addGap(79, 79, 79)).addComponent(this.securityChBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jScrollPane1)).addGroup(groupLayout.createSequentialGroup().addComponent(this.profileComboLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profileCombo, 0, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profConfigButton, -1, -1, Short.MAX_VALUE)))).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.devDefaultsChBox)).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.validatorsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secAdvancedButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.keyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton))).addGap(109, 109, 109)).addComponent(this.jSeparator3, -1, 536, Short.MAX_VALUE).addComponent(this.tcpChBox).addGroup(groupLayout.createSequentialGroup().addComponent(this.stsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stsConfigButton)).addComponent(this.fiChBox).addComponent(this.jSeparator5, GroupLayout.Alignment.TRAILING, -1, 536, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.kerberosCfgButton, this.keyButton, this.secAdvancedButton, this.trustButton, this.validatorsButton);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cfgVersionLabel).addComponent(this.cfgVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mtomChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rmChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderedChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rmAdvanced).addGap(8, 8, 8).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.securityChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileComboLabel).addComponent(this.profileCombo, -2, -1, -2).addComponent(this.profConfigButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trustButton).addComponent(this.keyButton).addComponent(this.kerberosCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secAdvancedButton).addComponent(this.validatorsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stsChBox).addComponent(this.stsConfigButton)).addGap(11, 11, 11).addComponent(this.jSeparator3, -2, -1, -2).addGap(8, 8, 8).addComponent(this.tcpChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fiChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addrChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.kerberosCfgButton, this.keyButton, this.secAdvancedButton, this.trustButton, this.validatorsButton);
        this.mtomChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_mtomChBox_ACSN"));
        this.mtomChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_mtomChBox_ACSD"));
        this.rmChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_rmChBox_ACSN"));
        this.rmChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_rmChBox_ACSD"));
        this.securityChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_securityChBox_ACSN"));
        this.securityChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_securityChBox_ACSD"));
        this.orderedChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSN"));
        this.orderedChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSD"));
        this.profileComboLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_profileComboLabel_ACSN"));
        this.profileComboLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_profileComboLabel_ACSD"));
        this.rmAdvanced.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Advanced_ACSN"));
        this.rmAdvanced.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Advanced_ACSD"));
        this.stsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsChBox_ACSN"));
        this.stsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsChBox_ACSD"));
        this.tcpChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_tcpChBox_ACSN"));
        this.tcpChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_tcpChBox_ACSD"));
        this.keyButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keystoreButton_ACSN"));
        this.keyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keystoreButton_ACSD"));
        this.trustButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_truststoreButton_ACSN"));
        this.trustButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_truststoreButton_ACSD"));
        this.stsConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSN"));
        this.stsConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSD"));
        this.profConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keyConfigButton_ACSN"));
        this.profConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keyConfigButton_ACSD"));
        this.fiChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_fiChBox_ACSN"));
        this.fiChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_fiChBox_ACSD"));
        this.validatorsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_validatorsButton_ACSN"));
        this.validatorsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_validatorsButton_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Defaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Defaults_ACSD"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"Panel_ACSN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"Panel_ACSD"));
        this.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
    }

    private void refresh() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addrChBox).addComponent(this.jSeparator4, -1, 489, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.cfgVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cfgVersionCombo, 0, 344, Short.MAX_VALUE)).addComponent(this.jSeparator1, -1, 489, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 489, Short.MAX_VALUE).addComponent(this.mtomChBox).addComponent(this.rmChBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rmAdvanced).addComponent(this.orderedChBox)).addGap(79, 79, 79)).addComponent(this.securityChBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jScrollPane1)).addGroup(groupLayout.createSequentialGroup().addComponent(this.profileComboLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profileCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profConfigButton, -2, -1, Short.MAX_VALUE)))).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.devDefaultsChBox)).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validatorsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secAdvancedButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.keyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton))).addGap(109, 109, 109)).addComponent(this.jSeparator3, -1, 489, Short.MAX_VALUE).addComponent(this.tcpChBox).addGroup(groupLayout.createSequentialGroup().addComponent(this.stsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stsConfigButton)).addComponent(this.fiChBox).addComponent(this.jSeparator5, GroupLayout.Alignment.TRAILING, -1, 489, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.kerberosCfgButton, this.keyButton, this.secAdvancedButton, this.trustButton, this.validatorsButton);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cfgVersionLabel).addComponent(this.cfgVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mtomChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rmChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderedChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rmAdvanced).addGap(8, 8, 8).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.securityChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileComboLabel).addComponent(this.profileCombo, 0, -1, Short.MAX_VALUE).addComponent(this.profConfigButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trustButton).addComponent(this.keyButton).addComponent(this.kerberosCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secAdvancedButton).addComponent(this.validatorsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stsChBox).addComponent(this.stsConfigButton)).addGap(11, 11, 11).addComponent(this.jSeparator3, -2, -1, -2).addGap(8, 8, 8).addComponent(this.tcpChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fiChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addrChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.kerberosCfgButton, this.keyButton, this.secAdvancedButton, this.trustButton, this.validatorsButton);
        this.mtomChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_mtomChBox_ACSN"));
        this.mtomChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_mtomChBox_ACSD"));
        this.rmChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_rmChBox_ACSN"));
        this.rmChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_rmChBox_ACSD"));
        this.securityChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_securityChBox_ACSN"));
        this.securityChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_securityChBox_ACSD"));
        this.orderedChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSN"));
        this.orderedChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSD"));
        this.profileComboLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_profileComboLabel_ACSN"));
        this.profileComboLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_profileComboLabel_ACSD"));
        this.rmAdvanced.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Advanced_ACSN"));
        this.rmAdvanced.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Advanced_ACSD"));
        this.stsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsChBox_ACSN"));
        this.stsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsChBox_ACSD"));
        this.tcpChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_tcpChBox_ACSN"));
        this.tcpChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_tcpChBox_ACSD"));
        this.keyButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keystoreButton_ACSN"));
        this.keyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keystoreButton_ACSD"));
        this.trustButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_truststoreButton_ACSN"));
        this.trustButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_truststoreButton_ACSD"));
        this.stsConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSN"));
        this.stsConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSD"));
        this.profConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keyConfigButton_ACSN"));
        this.profConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_keyConfigButton_ACSD"));
        this.fiChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_fiChBox_ACSN"));
        this.fiChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_fiChBox_ACSD"));
        this.validatorsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_validatorsButton_ACSN"));
        this.validatorsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_validatorsButton_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Defaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"LBL_Section_Service_Defaults_ACSD"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BindingPanel.class, (String)"Panel_ACSN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingPanel.class, (String)"Panel_ACSD"));
        this.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }

    private void validatorsButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.profileCombo.getSelectedItem();
        ValidatorsPanel validatorsPanel = new ValidatorsPanel((WSDLComponent)this.binding, this.project, string, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)validatorsPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Validators_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            validatorsPanel.storeState();
        }
    }

    private void profConfigButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.profileCombo.getSelectedItem();
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        securityProfile.displayConfig((WSDLComponent)this.binding, this.undoManager);
    }

    private void stsConfigButtonActionPerformed(ActionEvent actionEvent) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        STSConfigServicePanel sTSConfigServicePanel = new STSConfigServicePanel(this.project, this.binding, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sTSConfigServicePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_STSConfig_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    private void trustButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.profileCombo.getSelectedItem();
        TruststorePanel truststorePanel = new TruststorePanel((WSDLComponent)this.binding, this.project, this.jsr109, string, false, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)truststorePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Truststore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            truststorePanel.storeState();
        }
    }

    private void keyButtonActionPerformed(ActionEvent actionEvent) {
        KeystorePanel keystorePanel = new KeystorePanel((WSDLComponent)this.binding, this.project, this.jsr109, false, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)keystorePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Keystore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            keystorePanel.storeState();
        }
    }

    private void rmAdvancedActionPerformed(ActionEvent actionEvent) {
        AdvancedRMPanel advancedRMPanel = new AdvancedRMPanel(this.binding, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedRMPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_AdvancedRM_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            advancedRMPanel.storeState();
        }
    }

    private void secAdvancedButtonActionPerformed(ActionEvent actionEvent) {
        AdvancedSecurityPanel advancedSecurityPanel = new AdvancedSecurityPanel(this.binding, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedSecurityPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_AdvancedSec_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            advancedSecurityPanel.storeState();
        }
    }

    private void kerberosCfgButtonActionPerformed(ActionEvent actionEvent) {
        KerberosConfigPanel kerberosConfigPanel = new KerberosConfigPanel((WSDLComponent)this.binding, this.project, this.getUserExpectedConfigVersion());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)kerberosConfigPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_KerberosConfig_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            kerberosConfigPanel.storeState();
        }
    }
}

