/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.javafx2.platform.PlatformPropertiesHandler;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.spi.project.support.ant.EditableProperties;

public final class JavaFXPlatformUtils {
    public static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String PROPERTY_JAVAFX_RUNTIME = "javafx.runtime";
    public static final String PROPERTY_JAVAFX_SDK = "javafx.sdk";
    public static final String PROPERTY_JAVA_FX = "javafx";
    public static final String[] KNOWN_JFX_LOCATIONS = new String[]{"C:\\Program Files\\Oracle", "C:\\Program Files (x86)\\Oracle"};

    private JavaFXPlatformUtils() {
    }

    public static boolean isJavaFXEnabled(@NullAllowed JavaPlatform platform) {
        if (platform == null) {
            return false;
        }
        EditableProperties properties = PlatformPropertiesHandler.getGlobalProperties();
        String sdkPath = properties.get((Object)Utils.getSDKPropertyKey(platform));
        String runtimePath = properties.get((Object)Utils.getRuntimePropertyKey(platform));
        return sdkPath != null && runtimePath != null;
    }

    @CheckForNull
    public static String getJavaFXRuntimePath(@NonNull String platformName) {
        return PlatformPropertiesHandler.getGlobalProperties().get((Object)Utils.getRuntimePropertyKey(platformName));
    }

    @CheckForNull
    public static String getJavaFXSDKPath(@NonNull String platformName) {
        return PlatformPropertiesHandler.getGlobalProperties().get((Object)Utils.getSDKPropertyKey(platformName));
    }

    @NonNull
    public static String[] getJavaFXClassPath() {
        return new String[]{"${javafx.runtime}/lib/jfxrt.jar:", "${javafx.runtime}/lib/deploy.jar:", "${javafx.runtime}/lib/javaws.jar:", "${javafx.runtime}/lib/plugin.jar"};
    }

    public static boolean areJFXLocationsCorrect(@NonNull String sdkPath, @NonNull String runtimePath) {
        return JavaFXPlatformUtils.isSdkPathCorrect(sdkPath) && JavaFXPlatformUtils.isRuntimePathCorrect(runtimePath);
    }

    @CheckForNull
    public static JavaPlatform createDefaultJavaFXPlatform() {
        String sdkPath = null;
        String runtimePath = null;
        String javadocPath = null;
        String srcPath = null;
        for (String path : KNOWN_JFX_LOCATIONS) {
            if (sdkPath == null) {
                sdkPath = JavaFXPlatformUtils.predictSDKLocation(path);
            }
            if (runtimePath == null) {
                runtimePath = JavaFXPlatformUtils.predictRuntimeLocation(path);
            }
            if (javadocPath == null) {
                javadocPath = JavaFXPlatformUtils.predictJavadocLocation(path);
            }
            if (srcPath == null) {
                srcPath = JavaFXPlatformUtils.predictSourcesLocation(path);
            }
            if (sdkPath != null && runtimePath != null) break;
        }
        if (sdkPath != null && runtimePath != null) {
            return Utils.createJavaFXPlatform("Default JFX Platform", sdkPath, runtimePath, javadocPath, srcPath);
        }
        return null;
    }

    @CheckForNull
    public static String predictSDKLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            File[] children;
            for (File child : children = location.listFiles()) {
                File toolsJar = new File(child.getAbsolutePath() + File.separatorChar + "tools" + File.separatorChar + "ant-javafx.jar");
                if (!toolsJar.exists()) continue;
                return child.getAbsolutePath();
            }
        }
        return null;
    }

    @CheckForNull
    public static String predictRuntimeLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            File[] children;
            ArrayList<File> files = new ArrayList<File>();
            files.add(location);
            for (File child : children = location.listFiles()) {
                files.add(child);
                files.addAll(Arrays.asList(child.listFiles()));
            }
            for (File file : files) {
                File rtJar = new File(file.getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "jfxrt.jar");
                if (!rtJar.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    @CheckForNull
    public static String predictJavadocLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            File[] children;
            for (File child : children = location.listFiles()) {
                File docs = new File(child.getAbsolutePath() + File.separatorChar + "docs");
                if (!docs.exists()) continue;
                return docs.getAbsolutePath();
            }
        }
        return null;
    }

    @CheckForNull
    public static String predictSourcesLocation(@NonNull String path) {
        return null;
    }

    private static boolean isSdkPathCorrect(@NonNull String sdkPath) {
        if (sdkPath.isEmpty()) {
            return false;
        }
        File file = new File(sdkPath);
        if (!file.exists()) {
            return false;
        }
        File toolsJar = new File(file.getAbsolutePath() + File.separatorChar + "tools" + File.separatorChar + "ant-javafx.jar");
        return toolsJar.exists();
    }

    private static boolean isRuntimePathCorrect(@NonNull String runtimePath) {
        if (runtimePath.isEmpty()) {
            return false;
        }
        File file = new File(runtimePath);
        if (!file.exists()) {
            return false;
        }
        File rtJar = new File(file.getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "jfxrt.jar");
        return rtJar.exists();
    }
}

