/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.api.J2SEPlatformCreator;
import org.netbeans.modules.javafx2.platform.PlatformPropertiesHandler;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class Utils {
    public static final String DEFAULT_FX_PLATFORM_NAME = "Default JFX Platform";
    public static final String NO_PLATFORM_CHECK_PROPERTY = "org.netbeans.modules.javafx2.platform.NoPlatformCheck";
    private static final String PLATFORM_PREFIX = "platforms";
    private static final String JAVAFX_SDK_PREFIX = "javafx.sdk.home";
    private static final String JAVAFX_RUNTIME_PREFIX = "javafx.runtime.home";
    private static final String JAVAFX_SOURCES_PREFIX = "javafx.src";
    private static final String JAVAFX_JAVADOC_PREFIX = "javafx.javadoc";
    private static final Logger LOGGER = Logger.getLogger("javafx");

    private Utils() {
    }

    @NonNull
    public static String getSDKPropertyKey(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        String platformName = (String)platform.getProperties().get("platform.ant.name");
        return "platforms." + platformName + '.' + JAVAFX_SDK_PREFIX;
    }

    @NonNull
    public static String getRuntimePropertyKey(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        String platformName = (String)platform.getProperties().get("platform.ant.name");
        return "platforms." + platformName + '.' + JAVAFX_RUNTIME_PREFIX;
    }

    @NonNull
    public static String getSDKPropertyKey(@NonNull String platformName) {
        return "platforms." + platformName + '.' + JAVAFX_SDK_PREFIX;
    }

    @NonNull
    public static String getRuntimePropertyKey(@NonNull String platformName) {
        return "platforms." + platformName + '.' + JAVAFX_RUNTIME_PREFIX;
    }

    @NonNull
    public static String getJavadocPropertyKey(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        String platformName = (String)platform.getProperties().get("platform.ant.name");
        return "platforms." + platformName + '.' + JAVAFX_JAVADOC_PREFIX;
    }

    @NonNull
    public static String getSourcesPropertyKey(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        String platformName = (String)platform.getProperties().get("platform.ant.name");
        return "platforms." + platformName + '.' + JAVAFX_SOURCES_PREFIX;
    }

    @CheckForNull
    public static JavaPlatform createJavaFXPlatform(@NonNull String platformName, @NonNull String sdkPath, @NonNull String runtimePath, @NullAllowed String javadocPath, @NullAllowed String srcPath) {
        Parameters.notNull((CharSequence)"platformName", (Object)platformName);
        Parameters.notNull((CharSequence)"sdkPath", (Object)sdkPath);
        Parameters.notNull((CharSequence)"runtimePath", (Object)runtimePath);
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        if (!Utils.isArchitechtureCorrect(runtimePath)) {
            return null;
        }
        FileObject platformFolder = (FileObject)defaultPlatform.getInstallFolders().iterator().next();
        JavaPlatform platform = null;
        try {
            platform = J2SEPlatformCreator.createJ2SEPlatform((FileObject)platformFolder, (String)platformName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
        }
        if (platform != null) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(Utils.getSDKPropertyKey(platform), sdkPath);
            map.put(Utils.getRuntimePropertyKey(platform), runtimePath);
            if (javadocPath != null) {
                map.put(Utils.getJavadocPropertyKey(platform), javadocPath);
            }
            if (srcPath != null) {
                map.put(Utils.getSourcesPropertyKey(platform), srcPath);
            }
            PlatformPropertiesHandler.saveGlobalProperties(map);
        }
        return platform;
    }

    public static boolean isArchitechtureCorrect(@NonNull String runtimePath) {
        Parameters.notNull((CharSequence)"runtimePath", (Object)runtimePath);
        if (Boolean.getBoolean(NO_PLATFORM_CHECK_PROPERTY)) {
            return true;
        }
        return true;
    }
}

