/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.WritingQueue;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class RemoteFileSystemProvider
implements FileSystemProviderImplementation {
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env);
    }

    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env).normalizeAbsolutePath(absPath);
    }

    public String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem);
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).normalizeAbsolutePath(absPath);
        }
        return absPath;
    }

    public boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        if (baseFileObject instanceof RemoteFileObjectBase) {
            ExecutionEnvironment execEnv = ((RemoteFileObjectBase)baseFileObject).getExecutionEnvironment();
            if (RemoteFileSystemProvider.isPathAbsolute(relativeOrAbsolutePath)) {
                relativeOrAbsolutePath = RemoteFileSystemManager.getInstance().getFileSystem(execEnv).normalizeAbsolutePath(relativeOrAbsolutePath);
                try {
                    return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                return baseFileObject.getFileObject(relativeOrAbsolutePath);
            }
        }
        return null;
    }

    private static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) > 0;
    }

    public boolean isMine(ExecutionEnvironment env) {
        return env.isRemote();
    }

    public boolean isMine(FileObject fileObject) {
        return fileObject instanceof RemoteFileObjectBase;
    }

    public boolean isMine(FileSystem fileSystem) {
        return fileSystem instanceof RemoteFileSystem;
    }

    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject);
    }

    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject).getPath();
    }

    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        FileObject fo = fs.findResource(absPath);
        if (fo != null) {
            try {
                return this.getCanonicalFileObject(fo).getPath();
            }
            catch (FileNotFoundException e) {
                RemoteLogger.finest(e);
            }
        }
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    public String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        RemoteLogger.assertTrueInConsole(env.isRemote(), this.getClass().getSimpleName() + ".getCanonicalPath is called for LOCAL env: " + env);
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return this.getCanonicalPath(fs, absPath);
    }

    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public boolean isMine(String absoluteURL) {
        return absoluteURL.startsWith("rfs:");
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        if (env.isRemote()) {
            return WritingQueue.getInstance(env).waitFinished(failedFiles);
        }
        return true;
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        if (env.isRemote()) {
            return WritingQueue.getInstance(env).waitFinished(filesToWait, failedFiles);
        }
        return true;
    }

    public FileObject urlToFileObject(String path) {
        if (path.startsWith("rfs:")) {
            ExecutionEnvironment env;
            int port = 0;
            StringBuilder hostName = new StringBuilder();
            String userName = null;
            CharSequence remotePath = "";
            boolean insideHostOrUser = true;
            for (int i = "rfs:".length(); i < path.length(); ++i) {
                char c = path.charAt(i);
                if (insideHostOrUser) {
                    if (c == '@') {
                        userName = hostName.toString();
                        hostName = new StringBuilder();
                        continue;
                    }
                    if (c == ':') {
                        insideHostOrUser = false;
                        continue;
                    }
                    hostName.append(c);
                    continue;
                }
                if (Character.isDigit(c)) {
                    int digit = c - 48;
                    port = port * 10 + digit;
                    continue;
                }
                remotePath = path.subSequence(i + 1, path.length());
                break;
            }
            if (hostName.length() == 0) {
                throw new IllegalArgumentException("Invalid path: " + path);
            }
            if (port == 0) {
                port = 22;
            }
            RemoteFileObjectBase fo = null;
            RemoteFileSystem fs = null;
            if (userName == null) {
                RemoteLogger.assertTrueInConsole(false, "Trying to access remote file system without user name");
                env = RemoteFileSystemUtils.getExecutionEnvironment(hostName.toString(), 0);
                if (env == null) {
                    env = ExecutionEnvironmentFactory.createNew((String)System.getProperty("user.name"), (String)hostName.toString());
                }
            } else {
                env = ExecutionEnvironmentFactory.createNew((String)userName, (String)hostName.toString(), (int)port);
            }
            fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
            fo = fs.findResource(remotePath.toString());
            return fo;
        }
        return null;
    }

    public String toURL(FileObject fileObject) {
        if (fileObject instanceof RemoteFileObjectBase) {
            ExecutionEnvironment env = ((RemoteFileObjectBase)fileObject).getExecutionEnvironment();
            return this.getUrlPrefix(env) + fileObject.getPath();
        }
        return null;
    }

    private String getUrlPrefix(ExecutionEnvironment env) {
        return "rfs:" + env.getUser() + '@' + env.getHost() + ':' + env.getSSHPort();
    }

    public String toURL(FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(RemoteFileSystemUtils.isPathAbsolute(absPath), "Path must be absolute: " + absPath);
        if (fileSystem instanceof RemoteFileSystem) {
            ExecutionEnvironment env = ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
            return this.getUrlPrefix(env) + absPath;
        }
        throw new IllegalArgumentException("File system should be an istance of " + RemoteFileSystem.class.getName());
    }

    public FileObject fileToFileObject(File file) {
        if (file instanceof FileObjectBasedFile) {
            return ((FileObjectBasedFile)file).getFileObject();
        }
        return null;
    }

    public boolean isMine(File file) {
        return file instanceof FileObjectBasedFile;
    }

    public void scheduleRefresh(FileObject fileObject) {
        if (fileObject instanceof RemoteFileObjectBase) {
            RemoteFileObjectBase fo = (RemoteFileObjectBase)fileObject;
            fo.getFileSystem().getRefreshManager().scheduleRefresh(Arrays.asList(fo));
        } else {
            RemoteLogger.getInstance().log(Level.WARNING, "Unexpected fileObject class: {0}", fileObject.getClass());
        }
    }

    public void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        fs.getRefreshManager().scheduleRefreshExistent(paths);
    }

    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.addRecursiveListener(listener);
        }
    }

    public void removeRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.removeRecursiveListener(listener);
        }
    }

    public void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem);
        ((RemoteFileSystem)fileSystem).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener, ExecutionEnvironment env, String path) {
        RemoteLogger.assertTrue(env.isRemote(), "Unexpected ExecutionEnvironment: should be remote");
        RemoteFileSystemManager.getInstance().getFileSystem(env).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().addFileChangeListener(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().removeFileChangeListener(listener);
    }

    public boolean canExecute(FileObject fileObject) {
        RemoteLogger.assertTrue(fileObject instanceof RemoteFileObjectBase, "Unexpected file object class: " + fileObject);
        if (fileObject instanceof RemoteFileObjectBase) {
            return ((RemoteFileObjectBase)fileObject).canExecute();
        }
        return false;
    }

    public char getFileSeparatorChar() {
        return '/';
    }

    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).addFileSystemProblemListener(listener);
    }

    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).removeFileSystemProblemListener(listener);
    }
}

