/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.openide.filesystems.FileChangeListener;
import org.openide.util.RequestProcessor;

public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final Object lock = new Object();
    private final Map<String, List<FileChangeListener>> pendingListeners = new HashMap<String, List<FileChangeListener>>();
    private final RequestProcessor.Task cleaningTask;
    private static RequestProcessor RP = new RequestProcessor("File objects cache dead entries cleanup", 1);
    private static final int CLEAN_INTERVAL = Integer.getInteger("rfs.cache.cleanup.interval", 10000);
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
        this.cleaningTask = RP.create(new Runnable(){

            @Override
            public void run() {
                RemoteFileObjectFactory.this.cleanDeadEntries();
            }
        });
        this.scheduleCleanDeadEntries();
    }

    Collection<RemoteFileObjectBase> getCachedFileObjects() {
        return this.fileObjectsCache.values();
    }

    public RemoteFileObjectBase getCachedFileObject(String path) {
        return this.fileObjectsCache.get(path);
    }

    private void scheduleCleanDeadEntries() {
        this.cleaningTask.schedule(CLEAN_INTERVAL);
    }

    private void cleanDeadEntries() {
        int size;
        boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
        if (trace) {
            size = this.fileObjectsCache.size();
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries and {2}% ({3} of {4}) hits so far", new Object[]{this.env, size, this.cacheRequests == 0 ? 0 : this.cacheHits * 100 / this.cacheRequests, this.cacheHits, this.cacheRequests});
            }
        }
        this.fileObjectsCache.cleanDeadEntries();
        if (trace) {
            size = this.fileObjectsCache.size();
            RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries left", new Object[]{this.env, size});
        }
        if (this.fileObjectsCache.size() > 0) {
            this.scheduleCleanDeadEntries();
        }
    }

    public RemoteDirectory createRemoteDirectory(RemoteFileObjectBase parent, String remotePath, File cacheFile) {
        RemoteFileObjectBase result;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemoteDirectory && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemoteDirectory)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(remotePath, fo);
        }
        if ((fo = RemoteDirectory.createNew(this.fileSystem, this.env, parent, remotePath, cacheFile)).isValid() && (result = this.putIfAbsent(remotePath, fo)) instanceof RemoteDirectory && result.getParent() == parent) {
            return (RemoteDirectory)result;
        }
        return (RemoteDirectory)fo;
    }

    public RemotePlainFile createRemotePlainFile(RemoteDirectory parent, String remotePath, File cacheFile, FileType fileType) {
        RemoteFileObjectBase result;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemotePlainFile && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemotePlainFile)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(remotePath, fo);
        }
        if ((fo = RemotePlainFile.createNew(this.fileSystem, this.env, parent, remotePath, cacheFile, fileType)).isValid() && (result = this.putIfAbsent(remotePath, fo)) instanceof RemotePlainFile && result.getParent() == parent) {
            return (RemotePlainFile)result;
        }
        return (RemotePlainFile)fo;
    }

    public RemoteLink createRemoteLink(RemoteFileObjectBase parent, String remotePath, String link) {
        RemoteLink fo = RemoteLink.createNew(this.fileSystem, this.env, parent, remotePath, link);
        RemoteFileObjectBase result = this.putIfAbsent(remotePath, fo);
        if (result instanceof RemoteLink && result == fo) {
            ((RemoteLink)result).initListeners();
        }
        return (RemoteLink)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileObjectBase putIfAbsent(String remotePath, RemoteFileObjectBase fo) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase prev = this.fileObjectsCache.get(remotePath);
            if (prev == null) {
                List<FileChangeListener> listeners = this.pendingListeners.remove(remotePath);
                if (listeners != null) {
                    for (FileChangeListener l : listeners) {
                        fo.addFileChangeListener(l);
                    }
                }
                this.fileObjectsCache.put(remotePath, fo);
                return fo;
            }
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(String path, FileChangeListener listener) {
        RemoteFileObjectBase fo = this.getCachedFileObject(path);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                fo = this.getCachedFileObject(path);
                if (fo != null) {
                    List<FileChangeListener> listeners = this.pendingListeners.get(path);
                    if (listeners == null) {
                        listeners = new ArrayList<FileChangeListener>();
                        this.pendingListeners.put(path, listeners);
                    }
                    listeners.add(listener);
                }
            }
        } else {
            fo.addFileChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteFileChangeListener(String path, FileChangeListener listener) {
        RemoteFileObjectBase fo = this.getCachedFileObject(path);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                List<FileChangeListener> listeners;
                fo = this.getCachedFileObject(path);
                if (fo != null && (listeners = this.pendingListeners.get(path)) != null) {
                    listeners.remove(listener);
                }
            }
        } else {
            fo.removeFileChangeListener(listener);
        }
    }

    public RemoteFileObjectBase invalidate(String remotePath) {
        RemoteFileObjectBase fo = this.fileObjectsCache.remove(remotePath);
        if (fo != null) {
            fo.invalidate();
        }
        return fo;
    }

    public void rename(String path2Rename, String newPath, RemoteFileObjectBase fo2Rename) {
        HashSet<RemoteFileObjectBase> toRename = new HashSet<RemoteFileObjectBase>();
        this.addAllExistingChildren(fo2Rename, toRename);
        for (RemoteFileObjectBase fo : toRename) {
            String curPath = fo.getPath();
            String changedPath = curPath.replaceFirst(path2Rename, newPath);
            this.fileObjectsCache.remove(curPath, fo);
            fo.renamePath(changedPath);
            this.putIfAbsent(changedPath, fo);
        }
    }

    private void addAllExistingChildren(RemoteFileObjectBase fo, Collection<RemoteFileObjectBase> bag) {
        bag.add(fo);
        if (fo.isFolder()) {
            for (RemoteFileObjectBase child : fo.getExistentChildren()) {
                this.addAllExistingChildren(child, bag);
            }
        }
    }

    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        RemoteFileObjectBase fo = this.fileObjectsCache.get(linkRemotePath);
        if (fo != null) {
            if (fo instanceof RemoteLink) {
                ((RemoteLink)fo).setLink(linkTarget, parent);
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                fo.invalidate();
            }
        }
    }
}

