/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Parameters;

final class RecursiveListener
extends WeakReference<FileObject>
implements FileChangeListener {
    private final FileChangeListener fcl;
    private final Set<FileObject> kept;

    public RecursiveListener(FileObject source, FileChangeListener fcl, boolean keep) {
        super(source);
        this.fcl = fcl;
        this.kept = keep ? new HashSet() : null;
        this.addAll(source);
    }

    private void addAll(FileObject folder) {
        if (this.kept != null) {
            this.kept.add(folder);
            Enumeration en = folder.getChildren(true);
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                this.kept.add(fo);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        if (thisFo != null && this.isParentOf(thisFo, fe.getFile())) {
            this.fcl.fileRenamed(fe);
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        FileObject file = fe.getFile();
        if (thisFo != null && this.isParentOf(thisFo, file)) {
            this.fcl.fileFolderCreated(fe);
            this.addAll(file);
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        FileObject file = fe.getFile();
        if (thisFo != null && this.isParentOf(thisFo, file)) {
            this.fcl.fileDeleted(fe);
            if (this.kept != null) {
                this.kept.remove(file);
            }
        }
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        FileObject file = fe.getFile();
        if (thisFo != null && this.isParentOf(thisFo, file)) {
            this.fcl.fileDataCreated(fe);
            if (this.kept != null) {
                this.kept.add(file);
            }
        }
    }

    public void fileChanged(FileEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        if (thisFo != null && this.isParentOf(thisFo, fe.getFile())) {
            this.fcl.fileChanged(fe);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        FileObject thisFo = (FileObject)this.get();
        if (thisFo != null && this.isParentOf(thisFo, fe.getFile())) {
            this.fcl.fileAttributeChanged(fe);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecursiveListener other = (RecursiveListener)obj;
        if (!(this.fcl == other.fcl || this.fcl != null && this.fcl.equals(other.fcl))) {
            return false;
        }
        FileObject otherFo = (FileObject)other.get();
        FileObject thisFo = (FileObject)this.get();
        return thisFo == otherFo || thisFo != null && thisFo.equals(otherFo);
    }

    public int hashCode() {
        FileObject thisFo = (FileObject)this.get();
        int hash = 3;
        hash = 37 * hash + (this.fcl != null ? this.fcl.hashCode() : 0);
        hash = 13 * hash + (thisFo != null ? thisFo.hashCode() : 0);
        return hash;
    }

    private boolean isParentOf(FileObject folder, FileObject fo) {
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        Parameters.notNull((CharSequence)"fileObject", (Object)fo);
        if (folder.isFolder()) {
            try {
                if (folder.getFileSystem() != fo.getFileSystem()) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            for (FileObject parent = fo.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.equals(folder)) continue;
                return true;
            }
        }
        return false;
    }
}

